/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.debug;

import com.biglybt.core.Core;
import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.platform.PlatformManagerFactory;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.debug.ObfuscateImage;
import com.biglybt.ui.swt.debug.ObfuscateShell;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.util.DataSourceUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class UIDebugGenerator {
    public static void generate(String sourceRef, String additionalText) {
        final GeneratedResults gr = UIDebugGenerator.generate(null, new DebugPrompterListener(){

            @Override
            public boolean promptUser(GeneratedResults gr) {
                UIDebugGenerator.promptUser(false, gr);
                return gr.message != null;
            }
        });
        if (gr != null) {
            MessageBoxShell mb = new MessageBoxShell(65826, "UIDebugGenerator.complete", new String[]{gr.file.toString()});
            mb.open(new UserPrompterResultListener(){

                @Override
                public void prompterClosed(int result) {
                    if (result == 32) {
                        try {
                            PlatformManagerFactory.getPlatformManager().showFile(gr.file.getAbsolutePath());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    public static List<Image> getShellImages() {
        Shell[] shells;
        ArrayList<Image> result = new ArrayList<Image>();
        Display display = Display.getCurrent();
        if (display == null) {
            return null;
        }
        Shell activeShell = display.getActiveShell();
        if (activeShell != null) {
            activeShell.setCursor(display.getSystemCursor(1));
        }
        if ((shells = display.getShells()) == null || shells.length == 0) {
            return null;
        }
        int i = 0;
        while (i < shells.length) {
            block15: {
                try {
                    Shell shell = shells[i];
                    Image image = null;
                    if (shell.isDisposed() || !shell.isVisible()) break block15;
                    shell.moveAbove(null);
                    Utils.ensureDisplayUpdated();
                    if (shell.getData("class") instanceof ObfuscateShell) {
                        ObfuscateShell shellClass = (ObfuscateShell)shell.getData("class");
                        try {
                            image = shellClass.generateObfuscatedImage();
                        }
                        catch (Exception e) {
                            Debug.out("Obfuscating shell " + shell, e);
                        }
                    } else {
                        Rectangle clientArea = shell.getClientArea();
                        image = new Image((Device)display, clientArea.width, clientArea.height);
                        GC gc = new GC((Drawable)shell);
                        try {
                            gc.copyArea(image, clientArea.x, clientArea.y);
                        }
                        finally {
                            gc.dispose();
                        }
                    }
                    if (image != null) {
                        result.add(image);
                    }
                }
                catch (Throwable e) {
                    Logger.log(new LogEvent(LogIDs.GUI, "Creating Obfuscated Image", e));
                }
            }
            ++i;
        }
        if (activeShell != null) {
            activeShell.setCursor(null);
        }
        return result;
    }

    public static Image generateObfuscatedImage(Shell shell) {
        Control[] children;
        Rectangle shellBounds = shell.getBounds();
        Rectangle shellClientArea = shell.getClientArea();
        Display display = shell.getDisplay();
        if (display.isDisposed()) {
            return null;
        }
        Image fullImage = new Image((Device)display, shellBounds.width, shellBounds.height);
        Image subImage = new Image((Device)display, shellClientArea.width, shellClientArea.height);
        GC gc = new GC((Drawable)display);
        try {
            gc.copyArea(fullImage, shellBounds.x, shellBounds.y);
        }
        finally {
            gc.dispose();
        }
        GC gcShell = new GC((Drawable)shell);
        try {
            gcShell.copyArea(subImage, 0, 0);
        }
        finally {
            gcShell.dispose();
        }
        GC gcFullImage = new GC((Drawable)fullImage);
        try {
            Point location = shell.toDisplay(0, 0);
            gcFullImage.drawImage(subImage, location.x - shellBounds.x, location.y - shellBounds.y);
        }
        finally {
            gcFullImage.dispose();
        }
        subImage.dispose();
        Control[] controlArray = children = shell.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            SWTSkinObject so = (SWTSkinObject)control.getData("SkinObject");
            if (so instanceof ObfuscateImage) {
                ObfuscateImage oi = (ObfuscateImage)((Object)so);
                oi.obfuscatedImage(fullImage);
            }
            ++n2;
        }
        Rectangle monitorClientArea = shell.getMonitor().getClientArea();
        Rectangle trimmedShellBounds = shellBounds.intersection(monitorClientArea);
        if (!trimmedShellBounds.equals((Object)shellBounds)) {
            subImage = new Image((Device)display, trimmedShellBounds.width, trimmedShellBounds.height);
            GC gcCrop = new GC((Drawable)subImage);
            try {
                gcCrop.drawImage(fullImage, shellBounds.x - trimmedShellBounds.x, shellBounds.y - trimmedShellBounds.y);
            }
            finally {
                gcCrop.dispose();
                fullImage.dispose();
                fullImage = subImage;
            }
        }
        return fullImage;
    }

    public static GeneratedResults generate(File[] extraLogDirs, DebugPrompterListener debugPrompterListener) {
        int i;
        final File path = new File(SystemProperties.getUserPath(), "debug");
        if (!path.isDirectory()) {
            path.mkdir();
        } else {
            try {
                File[] files = path.listFiles();
                i = 0;
                while (i < files.length) {
                    files[i].delete();
                    ++i;
                }
            }
            catch (Exception files) {
                // empty catch block
            }
        }
        List<Image> shell_images = UIDebugGenerator.getShellImages();
        i = 0;
        while (i < shell_images.size()) {
            Image image = shell_images.get(i);
            File file = new File(path, "image-" + i + ".vpg");
            String sFileName = file.getAbsolutePath();
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{image.getImageData()};
            imageLoader.save(sFileName, 4);
            ++i;
        }
        GeneratedResults gr = new GeneratedResults();
        if (debugPrompterListener != null && !debugPrompterListener.promptUser(gr)) {
            return null;
        }
        OutputStreamWriter fw = null;
        try {
            File fUserMessage = new File(path, "usermessage.txt");
            fw = new FileWriter(fUserMessage);
            fw.write(String.valueOf(gr.message) + "\n" + gr.email);
            fw.close();
            fw = null;
        }
        catch (Throwable e) {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Throwable sFileName) {
                    // empty catch block
                }
            }
            e.printStackTrace();
        }
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.ANY_THREAD, new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                core.executeOperation(3, new CoreOperationTask(){

                    @Override
                    public String getName() {
                        return null;
                    }

                    @Override
                    public DownloadManager getDownload() {
                        return null;
                    }

                    @Override
                    public void run(CoreOperation operation) {
                        try {
                            File fEvidence = new File(path, "evidence.log");
                            PrintWriter pw = new PrintWriter(fEvidence, "UTF-8");
                            AEDiagnostics.generateEvidence(pw);
                            pw.close();
                        }
                        catch (IOException e) {
                            Debug.printStackTrace(e);
                        }
                    }

                    @Override
                    public CoreOperationTask.ProgressCallback getProgressCallback() {
                        return null;
                    }
                });
            }
        });
        try {
            File loggingFile;
            File diagReportspath;
            File outFile = new File(SystemProperties.getUserPath(), "debug.zip");
            if (outFile.exists()) {
                outFile.delete();
            }
            AEDiagnostics.flushPendingLogs();
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFile));
            File logPath = new File(SystemProperties.getUserPath(), "logs");
            File[] files = logPath.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".log");
                }
            });
            UIDebugGenerator.addFilesToZip(out, files);
            File userPath = new File(SystemProperties.getUserPath());
            files = userPath.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".log");
                }
            });
            UIDebugGenerator.addFilesToZip(out, files);
            files = path.listFiles();
            UIDebugGenerator.addFilesToZip(out, files);
            final long ago = SystemTime.getCurrentTime() - 7776000000L;
            File appPath = new File(SystemProperties.getApplicationPath());
            files = appPath.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().startsWith("hs_err") && pathname.lastModified() > ago;
                }
            });
            UIDebugGenerator.addFilesToZip(out, files);
            try {
                File temp_file = File.createTempFile("AZU", "tmp");
                files = temp_file.getParentFile().listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().startsWith("hs_err") && pathname.lastModified() > ago;
                    }
                });
                UIDebugGenerator.addFilesToZip(out, files);
                temp_file.delete();
            }
            catch (Throwable temp_file) {
                // empty catch block
            }
            File javaLogPath = new File(System.getProperty("user.home"), "Library" + File.separator + "Logs" + File.separator + "Java");
            if (javaLogPath.isDirectory()) {
                files = javaLogPath.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith("log") && pathname.lastModified() > ago;
                    }
                });
                UIDebugGenerator.addFilesToZip(out, files);
            }
            if ((diagReportspath = new File(System.getProperty("user.home"), "Library" + File.separator + "Logs" + File.separator + "DiagnosticReports")).isDirectory()) {
                files = diagReportspath.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith("crash") && pathname.lastModified() > ago;
                    }
                });
                UIDebugGenerator.addFilesToZip(out, files);
            }
            boolean bLogToFile = COConfigurationManager.getBooleanParameter("Logging Enable");
            String sLogDir = COConfigurationManager.getStringParameter("Logging Dir", "");
            if (bLogToFile && sLogDir != null && (loggingFile = new File(sLogDir, "biglybt.log")).isFile()) {
                UIDebugGenerator.addFilesToZip(out, new File[]{loggingFile});
            }
            if (extraLogDirs != null) {
                File[] fileArray = extraLogDirs;
                int n = extraLogDirs.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isDirectory()) {
                        files = file.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File pathname) {
                                return pathname.getName().endsWith("stackdump") || pathname.getName().endsWith("log");
                            }
                        });
                        UIDebugGenerator.addFilesToZip(out, files);
                    }
                    ++n2;
                }
            }
            out.close();
            if (outFile.exists()) {
                gr.file = outFile;
                return gr;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void promptUser(final boolean allowEmpty, GeneratedResults gr) {
        final Shell shell = ShellFactory.createShell(Utils.findAnyShell(), 1264);
        final String[] text = new String[2];
        final int[] sendMode = new int[]{-1};
        Utils.setShellIcon(shell);
        Messages.setLanguageText((Widget)shell, "UIDebugGenerator.messageask.title");
        shell.setLayout((Layout)new FormLayout());
        Label lblText = new Label((Composite)shell, 0);
        Messages.setLanguageText((Widget)lblText, "UIDebugGenerator.messageask.text");
        final Text textMessage = new Text((Composite)shell, 2114);
        final Text textEmail = new Text((Composite)shell, 2048);
        textEmail.setMessage("optional@email.here");
        Composite cButtonsSuper = new Composite((Composite)shell, 0);
        GridLayout gl = new GridLayout();
        cButtonsSuper.setLayout((Layout)gl);
        Composite cButtons = new Composite(cButtonsSuper, 0);
        cButtons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        cButtons.setLayout((Layout)new RowLayout());
        Button btnSendLater = new Button(cButtons, 8);
        btnSendLater.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                if (UIDebugGenerator.emptyCheck(textMessage, allowEmpty)) {
                    text[0] = textMessage.getText();
                    text[1] = textEmail.getText();
                    sendMode[0] = 1;
                }
                shell.dispose();
            }
        });
        Button btnCancel = new Button(cButtons, 8);
        btnCancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                shell.dispose();
            }
        });
        if (Constants.isOSX) {
            btnCancel.moveAbove(null);
        }
        Messages.setLanguageText((Widget)btnCancel, "Button.cancel");
        Messages.setLanguageText((Widget)btnSendLater, "Button.sendManual");
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        lblText.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)lblText, 10);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment((Control)textEmail, -10);
        textMessage.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment((Control)cButtonsSuper, -2);
        textEmail.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        fd.bottom = new FormAttachment(100, -1);
        cButtonsSuper.setLayoutData((Object)fd);
        textMessage.setFocus();
        shell.setSize(500, 300);
        shell.layout();
        Utils.centreWindow(shell);
        shell.open();
        Utils.readAndDispatchLoop((Control)shell);
        if (sendMode[0] != -1) {
            gr.message = text[0];
            gr.email = text[1];
        }
    }

    protected static boolean emptyCheck(Text textMessage, boolean allowEmpty) {
        if (allowEmpty) {
            return true;
        }
        if (textMessage.getText().length() > 0) {
            return true;
        }
        new MessageBoxShell(32, "UIDebugGenerator.message.cancel", null).open(null);
        return false;
    }

    private static void addFilesToZip(ZipOutputStream out, File[] files) {
        byte[] buf = new byte[1024];
        if (files == null) {
            return;
        }
        int j = 0;
        while (j < files.length) {
            block9: {
                FileInputStream in;
                File file = files[j];
                try {
                    in = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    break block9;
                }
                try {
                    int len;
                    ZipEntry entry = new ZipEntry(file.getName());
                    entry.setTime(file.lastModified());
                    out.putNextEntry(entry);
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++j;
        }
    }

    public static void obfuscateArea(Image image, Rectangle bounds) {
        GC gc = new GC((Drawable)image);
        try {
            gc.setBackground(image.getDevice().getSystemColor(1));
            gc.setForeground(image.getDevice().getSystemColor(3));
            gc.fillRectangle(bounds);
            gc.drawRectangle(bounds);
            int x2 = bounds.x + bounds.width;
            int y2 = bounds.y + bounds.height;
            gc.drawLine(bounds.x, bounds.y, x2, y2);
            gc.drawLine(x2, bounds.y, bounds.x, y2);
        }
        finally {
            gc.dispose();
        }
    }

    public static void obfuscateArea(Image image, Rectangle bounds, String text) {
        if (bounds.isEmpty()) {
            return;
        }
        if (text == null || text.length() == 0) {
            UIDebugGenerator.obfuscateArea(image, bounds);
            return;
        }
        GC gc = new GC((Drawable)image);
        try {
            Device device = image.getDevice();
            gc.setBackground(Colors.getSystemColor(device, 1));
            gc.setForeground(Colors.getSystemColor(device, 3));
            gc.fillRectangle(bounds);
            gc.drawRectangle(bounds);
            Utils.setClipping(gc, bounds);
            gc.drawText(text, bounds.x + 2, bounds.y + 1);
        }
        finally {
            gc.dispose();
        }
    }

    public static void obfuscateArea(Image image, Control control, String text) {
        if (control.isDisposed()) {
            return;
        }
        Rectangle bounds = control.getBounds();
        Point location = Utils.getLocationRelativeToShell(control);
        bounds.x = location.x;
        bounds.y = location.y;
        UIDebugGenerator.obfuscateArea(image, bounds, text);
    }

    public static String obfuscateDownloadName(Object ds) {
        return UIDebugGenerator.obfuscateDownloadName(DataSourceUtils.getDM(ds));
    }

    public static String obfuscateDownloadName(PEPeer peer) {
        if (peer == null) {
            return "";
        }
        PEPeerManager manager = peer.getManager();
        if (manager == null) {
            return "";
        }
        String name = manager.getDisplayName();
        if (name.length() > 3) {
            return name.substring(0, 3);
        }
        return name;
    }

    public static String obfuscateDownloadName(PEPiece piece) {
        if (piece == null) {
            return "";
        }
        PEPeerManager manager = piece.getManager();
        if (manager == null) {
            return "";
        }
        String name = manager.getDisplayName();
        if (name.length() > 3) {
            return name.substring(0, 3);
        }
        return name;
    }

    public static String obfuscateDownloadName(DownloadManager dm) {
        int i;
        String name = null;
        if (dm != null && (i = (name = dm.toString()).indexOf(35)) > 0) {
            name = name.substring(i + 1);
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    public static String obfuscateFileName(DiskManagerFileInfo fileInfo2) {
        return String.valueOf(fileInfo2.getIndex()) + ": " + Debug.secretFileName(fileInfo2.getFile(true).getName());
    }

    public static interface DebugPrompterListener {
        public boolean promptUser(GeneratedResults var1);
    }

    public static class GeneratedResults {
        public File file;
        public String message;
        public String email;
    }
}

