/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.devices;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.devices.DeviceManager;
import com.biglybt.core.devices.DeviceManagerFactory;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.installer.InstallablePlugin;
import com.biglybt.pif.installer.PluginInstallationListener;
import com.biglybt.pif.installer.PluginInstaller;
import com.biglybt.pif.installer.StandardPlugin;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryVitalityImage;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.devices.DeviceManagerUI;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DevicesFTUX {
    public static DevicesFTUX instance;
    private Shell shell;
    private Button checkITunes;
    private StyledText text_area;
    private Composite install_area;
    private Composite install_area_parent;
    final List<Runnable> to_fire_on_complete = new ArrayList<Runnable>();

    boolean isDisposed() {
        return this.shell.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFocus(Runnable fire_on_install) {
        List<Runnable> list = this.to_fire_on_complete;
        synchronized (list) {
            this.to_fire_on_complete.add(fire_on_install);
        }
        this.shell.forceActive();
        this.shell.forceFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open(Runnable fire_on_install) {
        List<Runnable> list = this.to_fire_on_complete;
        synchronized (list) {
            this.to_fire_on_complete.add(fire_on_install);
        }
        this.shell = ShellFactory.createMainShell(2144);
        this.shell.setText(MessageText.getString("devices.turnon.title"));
        Utils.setShellIcon(this.shell);
        this.text_area = new StyledText((Composite)this.shell, 2048);
        this.text_area.setEditable(false);
        this.text_area.setLeftMargin(5);
        String blurb = MessageText.getString("devices.turnon.info");
        this.text_area.setText("\n" + blurb + "\n");
        this.checkITunes = new Button((Composite)this.shell, 32);
        this.checkITunes.setSelection(true);
        Messages.setLanguageText((Widget)this.checkITunes, "devices.turnon.itunes");
        PluginInterface itunes_plugin = null;
        try {
            itunes_plugin = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azitunes", true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (itunes_plugin != null && itunes_plugin.getPluginState().isOperational()) {
            this.checkITunes.setEnabled(false);
        }
        Link lblLearnMore = new Link((Composite)this.shell, 0);
        lblLearnMore.setText("<A HREF=\"https://wiki.biglybt.com/w/FAQ_Devices\">" + MessageText.getString("label.learnmore") + "</A>");
        lblLearnMore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Utils.launch("https://wiki.biglybt.com/w/FAQ_Devices");
            }
        });
        Button btnInstall = new Button((Composite)this.shell, 0);
        Messages.setLanguageText((Widget)btnInstall, "Button.turnon");
        btnInstall.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                DevicesFTUX.this.doInstall(DevicesFTUX.this.checkITunes.getSelection());
            }
        });
        this.shell.setDefaultButton(btnInstall);
        Button btnCancel = new Button((Composite)this.shell, 0);
        Messages.setLanguageText((Widget)btnCancel, "Button.cancel");
        btnCancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                DevicesFTUX.this.shell.dispose();
            }
        });
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    DevicesFTUX.this.shell.dispose();
                }
            }
        });
        this.install_area_parent = new Composite((Composite)this.shell, 0);
        this.install_area_parent.setLayout((Layout)new FormLayout());
        this.install_area_parent.setVisible(false);
        this.install_area = new Composite(this.install_area_parent, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        this.shell.setLayout((Layout)formLayout);
        FormData fd = Utils.getFilledFormData();
        fd.top = new FormAttachment(0, 5);
        fd.bottom = new FormAttachment((Control)btnInstall, -5, 128);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        this.text_area.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -10);
        fd.right = new FormAttachment(100, -10);
        btnCancel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -10);
        fd.right = new FormAttachment((Control)btnCancel, -12);
        fd.left = new FormAttachment((Control)lblLearnMore, 12);
        btnInstall.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -5);
        fd.left = new FormAttachment(0, 10);
        fd.right = new FormAttachment((Control)btnInstall, -12);
        this.checkITunes.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.checkITunes, 0, 0x1000000);
        fd.left = new FormAttachment((Control)this.checkITunes, 5);
        lblLearnMore.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.text_area, 0);
        fd.bottom = new FormAttachment(100, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.install_area_parent.setLayoutData((Object)fd);
        fd = new FormData();
        fd.height = btnInstall.computeSize((int)-1, (int)-1).y;
        fd.bottom = new FormAttachment(100, -5);
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -12);
        this.install_area.setLayoutData((Object)fd);
        Utils.makeButtonsEqualWidth(Arrays.asList(btnInstall, btnCancel));
        this.shell.pack();
        Utils.centreWindow(this.shell);
        btnInstall.setFocus();
        this.shell.open();
    }

    protected void doInstall(final boolean itunes) {
        CoreWaiterSWT.waitForCoreRunning(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                DevicesFTUX.this._doInstall(core, itunes);
            }
        });
    }

    protected void _doInstall(Core core, boolean itunes) {
        ArrayList<StandardPlugin> plugins = new ArrayList<StandardPlugin>(2);
        PluginInstaller installer = core.getPluginManager().getPluginInstaller();
        StandardPlugin vuze_plugin = null;
        try {
            vuze_plugin = installer.getStandardPlugin("vuzexcode");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (vuze_plugin != null && !vuze_plugin.isAlreadyInstalled()) {
            plugins.add(vuze_plugin);
        }
        if (itunes) {
            StandardPlugin itunes_plugin = null;
            try {
                itunes_plugin = installer.getStandardPlugin("azitunes");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (itunes_plugin != null && !itunes_plugin.isAlreadyInstalled()) {
                plugins.add(itunes_plugin);
            }
        }
        if (plugins.size() == 0) {
            this.close();
            return;
        }
        InstallablePlugin[] installablePlugins = plugins.toArray(new InstallablePlugin[0]);
        try {
            this.install_area_parent.setVisible(true);
            this.install_area_parent.moveAbove(null);
            HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
            properties.put(1, 2);
            properties.put(2, this.install_area);
            properties.put(3, true);
            installer.install(installablePlugins, false, properties, new PluginInstallationListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void completed() {
                    ArrayList<Runnable> arrayList;
                    DevicesFTUX.this.close();
                    MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                    MdiEntry entry = mdi.getEntry("header.devices");
                    List<? extends MdiEntryVitalityImage> vitalityImages = entry.getVitalityImages();
                    for (MdiEntryVitalityImage mdiEntryVitalityImage : vitalityImages) {
                        if (!mdiEntryVitalityImage.getImageID().contains("turnon")) continue;
                        mdiEntryVitalityImage.setVisible(false);
                    }
                    List<Runnable> list = DevicesFTUX.this.to_fire_on_complete;
                    synchronized (list) {
                        arrayList = new ArrayList<Runnable>(DevicesFTUX.this.to_fire_on_complete);
                        DevicesFTUX.this.to_fire_on_complete.clear();
                    }
                    for (Runnable r : arrayList) {
                        if (r == null) continue;
                        try {
                            Utils.execSWTThread(r);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }

                @Override
                public void cancelled() {
                    DevicesFTUX.this.close();
                }

                @Override
                public void failed(PluginException e) {
                    Debug.out(e);
                    DevicesFTUX.this.close();
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected void close() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (DevicesFTUX.this.shell != null && !DevicesFTUX.this.shell.isDisposed()) {
                    DevicesFTUX.this.shell.dispose();
                }
            }
        });
    }

    public static boolean ensureInstalled(final Runnable fire_on_install) {
        DeviceManager device_manager = DeviceManagerFactory.getSingleton();
        if (device_manager == null) {
            return false;
        }
        if (device_manager.getTranscodeManager().getProviders().length == 0 && !DeviceManagerUI.DISABLED_TRANSCODING) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (instance == null || instance.isDisposed()) {
                        instance = new DevicesFTUX();
                        instance.open(fire_on_install);
                    } else {
                        instance.setFocus(fire_on_install);
                    }
                }
            });
            return false;
        }
        return true;
    }

    public static void showForDebug() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (instance == null || instance.isDisposed()) {
                    instance = new DevicesFTUX();
                    instance.open(null);
                } else {
                    instance.setFocus(null);
                }
            }
        });
    }
}

