/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.devices;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryManager;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.devices.Device;
import com.biglybt.core.devices.DeviceListener;
import com.biglybt.core.devices.DeviceManager;
import com.biglybt.core.devices.DeviceManagerFactory;
import com.biglybt.core.devices.DeviceMediaRenderer;
import com.biglybt.core.devices.TranscodeActionVetoException;
import com.biglybt.core.devices.TranscodeException;
import com.biglybt.core.devices.TranscodeFile;
import com.biglybt.core.devices.TranscodeJob;
import com.biglybt.core.devices.TranscodeManager;
import com.biglybt.core.devices.TranscodeProvider;
import com.biglybt.core.devices.TranscodeQueue;
import com.biglybt.core.devices.TranscodeQueueListener;
import com.biglybt.core.devices.TranscodeTarget;
import com.biglybt.core.devices.TranscodeTargetListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnCreationListener;
import com.biglybt.pif.ui.tables.TableManager;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableLifeCycleListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableSelectionListener;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.common.updater.UIUpdatable;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.FixedHTMLTransfer;
import com.biglybt.ui.swt.FixedURLTransfer;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.columns.torrent.ColumnThumbnail;
import com.biglybt.ui.swt.devices.DeviceManagerUI;
import com.biglybt.ui.swt.devices.columns.ColumnTJ_Category;
import com.biglybt.ui.swt.devices.columns.ColumnTJ_Completion;
import com.biglybt.ui.swt.devices.columns.ColumnTJ_CopiedToDevice;
import com.biglybt.ui.swt.devices.columns.ColumnTJ_Device;
import com.biglybt.ui.swt.devices.columns.ColumnTJ_Duration;
import com.biglybt.ui.swt.devices.columns.ColumnTJ_Name;
import com.biglybt.ui.swt.devices.columns.ColumnTJ_Profile;
import com.biglybt.ui.swt.devices.columns.ColumnTJ_Rank;
import com.biglybt.ui.swt.devices.columns.ColumnTJ_Resolution;
import com.biglybt.ui.swt.devices.columns.ColumnTJ_Status;
import com.biglybt.ui.swt.devices.columns.ColumnTJ_Tags;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.skin.SWTSkinButtonUtility;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectText;
import com.biglybt.ui.swt.utils.TagUIUtilsV3;
import com.biglybt.ui.swt.views.skin.InfoBarUtil;
import com.biglybt.ui.swt.views.skin.SkinView;
import com.biglybt.ui.swt.views.skin.TorrentListViewsUtils;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.TableViewSWTMenuFillListener;
import com.biglybt.ui.swt.views.table.impl.TableViewFactory;
import com.biglybt.ui.swt.views.utils.CategoryUIUtils;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import com.biglybt.ui.swt.views.utils.TagUIUtils;
import com.biglybt.util.PlayUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class SBC_DevicesView
extends SkinView
implements TranscodeQueueListener,
UIUpdatable,
TranscodeTargetListener,
DeviceListener,
UIPluginViewToolBarListener {
    public static final String TABLE_DEVICES = "Devices";
    public static final String TABLE_TRANSCODE_QUEUE = "TranscodeQueue";
    public static final String TABLE_DEVICE_LIBRARY = "DeviceLibrary";
    private static boolean columnsAdded = false;
    private DeviceManager device_manager;
    private TranscodeManager transcode_manager;
    private TranscodeQueue transcode_queue;
    private TableViewSWT<?> tvDevices;
    private int drag_drop_line_start = -1;
    private TableRowCore[] drag_drop_rows;
    private TableViewSWT<TranscodeFile> tvFiles;
    private MdiEntrySWT mdiEntry;
    private Composite tableJobsParent;
    private Device device;
    private String device_name;
    private TranscodeTarget transTarget;

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                SBC_DevicesView.this.initColumns(core);
            }
        });
        this.device_manager = DeviceManagerFactory.getSingleton();
        this.transcode_manager = this.device_manager.getTranscodeManager();
        this.transcode_queue = this.transcode_manager.getQueue();
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null) {
            this.mdiEntry = mdi.getCurrentEntry();
            Object ds = this.mdiEntry.getDataSource();
            if (!(ds instanceof Device)) {
                return null;
            }
            this.device = (Device)ds;
        }
        if (this.device instanceof TranscodeTarget) {
            this.transTarget = (TranscodeTarget)((Object)this.device);
        }
        if (this.device == null) {
            new InfoBarUtil(skinObject, "devicesview.infobar", false, "DeviceView.infobar", "v3.deviceview.infobar"){

                @Override
                public boolean allowShow() {
                    return true;
                }
            };
        } else if (this.device instanceof DeviceMediaRenderer) {
            DeviceMediaRenderer renderer = (DeviceMediaRenderer)this.device;
            int species = renderer.getRendererSpecies();
            String speciesID = null;
            switch (species) {
                case 3: {
                    speciesID = "itunes";
                    break;
                }
                case 1: {
                    speciesID = "ps3";
                    break;
                }
                case 2: {
                    speciesID = "xbox";
                    break;
                }
                case 6: {
                    String classification = renderer.getClassification();
                    if (classification.equals("sony.PSP")) {
                        speciesID = "psp";
                        break;
                    }
                    if (classification.startsWith("tivo.")) {
                        speciesID = "tivo";
                        break;
                    }
                    if (!classification.toLowerCase().contains("android")) break;
                    speciesID = "android";
                }
            }
            if (speciesID != null) {
                final String fSpeciesID = speciesID;
                new InfoBarUtil(skinObject, "devicesview.infobar", false, "DeviceView.infobar." + speciesID, "v3.deviceview.infobar"){

                    @Override
                    public boolean allowShow() {
                        return true;
                    }

                    @Override
                    protected void created(SWTSkinObject parent) {
                        SWTSkinObjectText soLine1 = (SWTSkinObjectText)SBC_DevicesView.this.skin.getSkinObject("line1", parent);
                        soLine1.setTextID("v3.deviceview.infobar.line1.generic", new String[]{SBC_DevicesView.this.device.getName()});
                        SWTSkinObjectText soLine2 = (SWTSkinObjectText)SBC_DevicesView.this.skin.getSkinObject("line2", parent);
                        soLine2.setTextID("v3.deviceview.infobar.line2." + fSpeciesID);
                    }
                };
            }
        }
        SWTSkinObject soAdvInfo = this.getSkinObject("advinfo");
        if (soAdvInfo != null) {
            this.initAdvInfo(soAdvInfo);
        }
        if (this.device != null) {
            this.device_name = this.device.getName();
            SWTSkinObject soTitle = this.getSkinObject("title");
            if (soTitle instanceof SWTSkinObjectText) {
                ((SWTSkinObjectText)soTitle).setTextID("device.view.heading", new String[]{this.device_name});
            }
        }
        return null;
    }

    private void initColumns(Core core) {
        if (columnsAdded) {
            return;
        }
        columnsAdded = true;
        UIManager uiManager = PluginInitializer.getDefaultInterface().getUIManager();
        TableManager tableManager = uiManager.getTableManager();
        tableManager.registerColumn(TranscodeFile.class, "trancode_qpos", new TableColumnCreationListener(){

            @Override
            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Rank(column);
                if (!column.getTableID().equals(SBC_DevicesView.TABLE_TRANSCODE_QUEUE)) {
                    column.setVisible(false);
                }
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "Thumbnail", new TableColumnCreationListener(){

            @Override
            public void tableColumnCreated(TableColumn column) {
                new ColumnThumbnail(column);
                column.setWidth(70);
                column.setVisible(false);
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "transcode_name", new TableColumnCreationListener(){

            @Override
            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Name(column);
                if (column.getTableID().equals(SBC_DevicesView.TABLE_TRANSCODE_QUEUE)) {
                    column.setWidth(200);
                } else if (!column.getTableID().endsWith(":type=1")) {
                    column.setWidth(140);
                }
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "duration", new TableColumnCreationListener(){

            @Override
            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Duration(column);
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "device", new TableColumnCreationListener(){

            @Override
            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Device(column);
                column.setVisible(false);
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "profile", new TableColumnCreationListener(){

            @Override
            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Profile(column);
                if (column.getTableID().equals(SBC_DevicesView.TABLE_TRANSCODE_QUEUE)) {
                    column.setWidth(70);
                }
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "resolution", new TableColumnCreationListener(){

            @Override
            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Resolution(column);
                column.setVisible(false);
                if (column.getTableID().equals(SBC_DevicesView.TABLE_TRANSCODE_QUEUE)) {
                    column.setWidth(95);
                }
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "transcode_status", new TableColumnCreationListener(){

            @Override
            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Status(column);
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "trancode_completion", new TableColumnCreationListener(){

            @Override
            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Completion(column);
                column.setWidth(145);
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "copied", new TableColumnCreationListener(){

            @Override
            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_CopiedToDevice(column);
                if (column.getTableID().endsWith(":type=1") || column.getTableID().equals(SBC_DevicesView.TABLE_TRANSCODE_QUEUE)) {
                    column.setVisible(false);
                }
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "category", new TableColumnCreationListener(){

            @Override
            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Category(column);
            }
        });
        tableManager.registerColumn(TranscodeFile.class, "tags", new TableColumnCreationListener(){

            @Override
            public void tableColumnCreated(TableColumn column) {
                new ColumnTJ_Tags(column);
            }
        });
        TableColumnManager tcm = TableColumnManager.getInstance();
        String[] defaultLibraryColumns = new String[]{"trancode_qpos", "transcode_name", "duration", "device", "transcode_status", "trancode_completion"};
        tcm.setDefaultColumnNames(TABLE_TRANSCODE_QUEUE, defaultLibraryColumns);
        String[] defaultQColumns = new String[]{"transcode_name", "duration", "profile", "transcode_status", "trancode_completion"};
        tcm.setDefaultColumnNames(TABLE_DEVICE_LIBRARY, defaultQColumns);
        tcm.setDefaultColumnNames("DeviceLibrary:type=1", defaultQColumns);
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        SWTSkinObject soTranscodeQueue;
        SWTSkinObject soDeviceList;
        super.skinObjectShown(skinObject, params);
        this.transcode_queue.addListener(this);
        if (this.transTarget != null) {
            this.transTarget.addListener(this);
        }
        if ((soDeviceList = this.getSkinObject("device-list")) != null) {
            this.initDeviceListTable((Composite)soDeviceList.getControl());
        }
        if ((soTranscodeQueue = this.getSkinObject("transcode-queue")) != null) {
            this.initTranscodeQueueTable((Composite)soTranscodeQueue.getControl());
        }
        if (this.device != null) {
            this.device.addListener(this);
        }
        if (this.device instanceof TranscodeTarget) {
            this.createDragDrop(this.tvFiles != null ? this.tvFiles : this.tvDevices);
        }
        this.setAdditionalInfoTitle(false);
        this.updateSelectedContent();
        return null;
    }

    private void initAdvInfo(SWTSkinObject soAdvInfo) {
        SWTSkinButtonUtility btnAdvInfo = new SWTSkinButtonUtility(soAdvInfo);
        btnAdvInfo.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

            @Override
            public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                SWTSkinObject soArea = SBC_DevicesView.this.getSkinObject("advinfo-area");
                if (soArea != null) {
                    boolean newVisibility = !soArea.isVisible();
                    SBC_DevicesView.this.setAdditionalInfoTitle(newVisibility);
                }
            }
        });
        this.setAdditionalInfoTitle(false);
    }

    protected void setAdditionalInfoTitle(boolean newVisibility) {
        SWTSkinObject soText;
        SWTSkinObject soArea = this.getSkinObject("advinfo-area");
        if (soArea != null) {
            soArea.setVisible(newVisibility);
        }
        if ((soText = this.getSkinObject("advinfo-title")) instanceof SWTSkinObjectText) {
            String s = newVisibility ? "[-]" : "[+]";
            s = this.device != null ? String.valueOf(s) + "Additional Device Info and Settings" : String.valueOf(s) + "General Options";
            ((SWTSkinObjectText)soText).setText(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        this.transcode_queue.removeListener(this);
        if (this.transTarget != null) {
            this.transTarget.removeListener(this);
        }
        if (this.device != null) {
            this.device.removeListener(this);
        }
        SBC_DevicesView sBC_DevicesView = this;
        synchronized (sBC_DevicesView) {
            if (this.tvFiles != null) {
                this.tvFiles.delete();
                this.tvFiles = null;
            }
        }
        Utils.disposeSWTObjects(this.tableJobsParent);
        if (this.tvDevices != null) {
            this.tvDevices.delete();
            this.tvDevices = null;
        }
        return super.skinObjectHidden(skinObject, params);
    }

    private void initTranscodeQueueTable(Composite control) {
        String tableID;
        if (this.device == null) {
            tableID = TABLE_TRANSCODE_QUEUE;
        } else {
            DeviceMediaRenderer dmr;
            tableID = TABLE_DEVICE_LIBRARY;
            if (this.device instanceof DeviceMediaRenderer && !(dmr = (DeviceMediaRenderer)this.device).canCopyToDevice() && !dmr.canCopyToFolder()) {
                tableID = String.valueOf(tableID) + ":type=1";
            }
        }
        this.tvFiles = TableViewFactory.createTableViewSWT(TranscodeFile.class, tableID, tableID, new TableColumnCore[]{}, this.device == null ? "trancode_qpos" : "transcode_status", 0x10010002);
        this.tvFiles.setRowDefaultHeightEM(1.5f);
        this.tvFiles.setHeaderVisible(true);
        this.tvFiles.setParentDataSource(this.device);
        this.tableJobsParent = new Composite(control, 0);
        this.tableJobsParent.setLayoutData((Object)Utils.getFilledFormData());
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.tableJobsParent.setLayout((Layout)layout);
        this.tvFiles.addSelectionListener(new TableSelectionListener(){

            @Override
            public void selected(TableRowCore[] row) {
                SBC_DevicesView.this.updateSelectedContent();
            }

            @Override
            public void mouseExit(TableRowCore row) {
            }

            @Override
            public void mouseEnter(TableRowCore row) {
            }

            @Override
            public void focusChanged(TableRowCore focus) {
            }

            @Override
            public void deselected(TableRowCore[] rows) {
                SBC_DevicesView.this.updateSelectedContent();
            }

            @Override
            public void defaultSelected(TableRowCore[] rows, int stateMask) {
            }
        }, false);
        this.tvFiles.addLifeCycleListener(new TableLifeCycleListener(){

            @Override
            public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
                switch (eventType) {
                    case 0: {
                        if (SBC_DevicesView.this.transTarget == null) {
                            TranscodeJob[] jobs;
                            TranscodeJob[] transcodeJobArray = jobs = SBC_DevicesView.this.transcode_queue.getJobs();
                            int n = jobs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TranscodeJob job = transcodeJobArray[n2];
                                TranscodeFile file = job.getTranscodeFile();
                                if (file != null) {
                                    SBC_DevicesView.this.tvFiles.addDataSource(file);
                                }
                                ++n2;
                            }
                        } else {
                            SBC_DevicesView.this.tvFiles.addDataSources(SBC_DevicesView.this.transTarget.getFiles());
                        }
                        SBC_DevicesView.this.updateSelectedContent();
                    }
                }
            }
        });
        this.tvFiles.addMenuFillListener(new TableViewSWTMenuFillListener(){

            @Override
            public void fillMenu(String sColumnName, Menu menu) {
                SBC_DevicesView.this.fillMenu(menu);
            }

            @Override
            public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
            }
        });
        this.tvFiles.addKeyListener(new KeyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 0 && e.keyCode == 127) {
                    TranscodeFile[] selected;
                    20 var3_2 = this;
                    synchronized (var3_2) {
                        if (SBC_DevicesView.this.tvFiles == null) {
                            selected = new TranscodeFile[]{};
                        } else {
                            List<Object> selectedDataSources = SBC_DevicesView.this.tvFiles.getSelectedDataSources();
                            selected = selectedDataSources.toArray(new TranscodeFile[0]);
                        }
                    }
                    if (selected.length > 0) {
                        SBC_DevicesView.this.deleteFiles(selected, 0);
                    }
                    e.doit = false;
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        this.tvFiles.initialize(this.tableJobsParent);
        control.layout(true, true);
    }

    protected void fillMenu(Menu menu) {
        int n;
        DeviceMediaRenderer dmr;
        Object[] _files = this.tvFiles.getSelectedDataSources().toArray();
        final TranscodeFile[] files = new TranscodeFile[_files.length];
        System.arraycopy(_files, 0, files, 0, files.length);
        MenuItem open_item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)open_item, "MyTorrentsView.menu.open");
        Utils.setMenuItemImage(open_item, "run");
        File target_file = null;
        File source_file = null;
        try {
            if (files.length == 1 && !(target_file = files[0].getTargetFile().getFile(true)).exists()) {
                target_file = null;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        try {
            if (files.length == 1 && !(source_file = files[0].getSourceFile().getFile(true)).exists()) {
                source_file = null;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        final File f_target_file = target_file;
        final File f_source_file = source_file;
        open_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                Utils.launch(f_target_file.getAbsolutePath());
            }
        });
        open_item.setEnabled(target_file != null);
        final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
        MenuItem show_item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)show_item, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
        show_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagerUtils.open(f_target_file != null ? f_target_file : f_source_file, use_open_containing_folder);
            }
        });
        show_item.setEnabled(source_file != null && !files[0].isComplete() || target_file != null && files[0].isComplete());
        Menu menu_category = new Menu((Decorations)menu.getShell(), 4);
        MenuItem item_category = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)item_category, "MyTorrentsView.menu.setCategory");
        item_category.setMenu(menu_category);
        this.addCategorySubMenu(menu_category, files);
        Menu menu_tags = new Menu((Decorations)menu.getShell(), 4);
        MenuItem item_tags = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)item_tags, "label.tag");
        item_tags.setMenu(menu_tags);
        this.addTagsSubMenu(menu_tags, files);
        new MenuItem(menu, 2);
        MenuItem pause_item = new MenuItem(menu, 8);
        pause_item.setText(MessageText.getString("v3.MainWindow.button.pause"));
        pause_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < files.length) {
                    TranscodeJob job = files[i].getJob();
                    if (job != null) {
                        job.pause();
                    }
                    ++i;
                }
            }
        });
        MenuItem resume_item = new MenuItem(menu, 8);
        resume_item.setText(MessageText.getString("v3.MainWindow.button.resume"));
        resume_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < files.length) {
                    TranscodeJob job = files[i].getJob();
                    if (job != null) {
                        job.resume();
                    }
                    ++i;
                }
            }
        });
        new MenuItem(menu, 2);
        if (this.device instanceof DeviceMediaRenderer && ((dmr = (DeviceMediaRenderer)this.device).canCopyToDevice() || dmr.canCopyToFolder())) {
            MenuItem retry_item = new MenuItem(menu, 8);
            retry_item.setText(MessageText.getString("device.retry.copy"));
            retry_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int i = 0;
                    while (i < files.length) {
                        TranscodeFile file = files[i];
                        if (file.getCopyToDeviceFails() > 0L || file.isCopiedToDevice()) {
                            file.retryCopyToDevice();
                        }
                        ++i;
                    }
                }
            });
            retry_item.setEnabled(false);
            TranscodeFile[] transcodeFileArray = files;
            n = files.length;
            int n2 = 0;
            while (n2 < n) {
                TranscodeFile file = transcodeFileArray[n2];
                if (file.getCopyToDeviceFails() > 0L || file.isCopiedToDevice()) {
                    retry_item.setEnabled(true);
                }
                ++n2;
            }
            new MenuItem(menu, 2);
        }
        MenuItem sc_item = new MenuItem(menu, 8);
        sc_item.setText(MessageText.getString("devices.copy_url"));
        if (files.length == 1) {
            final URL url = files[0].getStreamURL();
            if (url != null) {
                sc_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ClipboardCopy.copyToClipBoard(url.toExternalForm());
                    }
                });
            } else {
                sc_item.setEnabled(false);
            }
        } else {
            sc_item.setEnabled(false);
        }
        int comp2 = 0;
        int incomp = 0;
        TranscodeFile[] transcodeFileArray = files;
        int n3 = files.length;
        n = 0;
        while (n < n3) {
            TranscodeFile f = transcodeFileArray[n];
            if (f.isComplete()) {
                ++comp2;
            } else {
                ++incomp;
            }
            ++n;
        }
        MenuItem remove_item = new MenuItem(menu, 8);
        String text = comp2 == 0 ? "devices.cancel_xcode" : (incomp == 0 ? "azbuddy.ui.menu.remove" : "devices.cancel_xcode_del");
        remove_item.setText(MessageText.getString(text));
        Utils.setMenuItemImage(remove_item, "delete");
        remove_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SBC_DevicesView.this.deleteFiles(files, 0);
            }
        });
        new MenuItem(menu, 2);
        boolean has_selection = files.length > 0;
        remove_item.setEnabled(has_selection);
        boolean can_pause = has_selection;
        boolean can_resume = has_selection;
        int job_count = 0;
        int i = 0;
        while (i < files.length) {
            TranscodeJob job = files[i].getJob();
            if (job != null) {
                ++job_count;
                int state = job.getState();
                if (state != 1 || !job.canPause()) {
                    can_pause = false;
                }
                if (state != 2) {
                    can_resume = false;
                }
            }
            ++i;
        }
        pause_item.setEnabled(can_pause && job_count > 0);
        resume_item.setEnabled(can_resume && job_count > 0);
    }

    private void addCategorySubMenu(Menu menu_category, final TranscodeFile[] files) {
        MenuItem[] items = menu_category.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            MenuItem itemCategory;
            Category catUncat = CategoryManager.getCategory(2);
            if (catUncat != null) {
                itemCategory = new MenuItem(menu_category, 8);
                Messages.setLanguageText((Widget)itemCategory, catUncat.getName());
                itemCategory.setData("Category", (Object)catUncat);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        MenuItem item = (MenuItem)event2.widget;
                        SBC_DevicesView.this.assignSelectedToCategory((Category)item.getData("Category"), files);
                    }
                });
                new MenuItem(menu_category, 2);
            }
            i = 0;
            while (i < categories.length) {
                if (categories[i].getType() == 0) {
                    itemCategory = new MenuItem(menu_category, 8);
                    itemCategory.setText(categories[i].getName());
                    itemCategory.setData("Category", categories[i]);
                    TagUIUtils.setMenuIcon(itemCategory, (Tag)categories[i]);
                    itemCategory.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            MenuItem item = (MenuItem)event2.widget;
                            SBC_DevicesView.this.assignSelectedToCategory((Category)item.getData("Category"), files);
                        }
                    });
                }
                ++i;
            }
            new MenuItem(menu_category, 2);
        }
        MenuItem itemAddCategory = new MenuItem(menu_category, 8);
        Messages.setLanguageText((Widget)itemAddCategory, "MyTorrentsView.menu.setCategory.add");
        itemAddCategory.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                SBC_DevicesView.this.addCategory(files);
            }
        });
    }

    private void addCategory(final TranscodeFile[] files) {
        CategoryUIUtils.showCreateCategoryDialog(new UIFunctions.TagReturner(){

            @Override
            public void returnedTags(Tag[] tags) {
                if (tags.length == 1 && tags[0] instanceof Category) {
                    SBC_DevicesView.this.assignSelectedToCategory((Category)tags[0], files);
                }
            }
        });
    }

    private void assignSelectedToCategory(Category category, TranscodeFile[] files) {
        String[] cats = category.getType() == 2 ? new String[]{} : new String[]{category.getName()};
        TranscodeFile[] transcodeFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            TranscodeFile file = transcodeFileArray[n2];
            file.setCategories(cats);
            ++n2;
        }
    }

    private void addTagsSubMenu(Menu menu_tags, final TranscodeFile[] files) {
        MenuItem[] items = menu_tags.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        TagManager tm = TagManagerFactory.getTagManager();
        List<Tag> all_tags = tm.getTagType(3).getTags();
        if ((all_tags = TagUtils.sortTags(all_tags)).size() > 0) {
            HashSet<String> shared_tags = null;
            boolean some_tags_assigned = false;
            TranscodeFile[] transcodeFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                TranscodeFile file = transcodeFileArray[n2];
                HashSet<String> file_tags = new HashSet<String>();
                file_tags.addAll(Arrays.asList(file.getTags(true)));
                if (file_tags.size() > 0) {
                    some_tags_assigned = true;
                }
                if (shared_tags == null) {
                    shared_tags = file_tags;
                } else {
                    if (shared_tags.size() != file_tags.size()) {
                        shared_tags.clear();
                        break;
                    }
                    if (!shared_tags.equals(file_tags)) {
                        shared_tags.clear();
                        break;
                    }
                }
                ++n2;
            }
            if (some_tags_assigned) {
                MenuItem mi_no_tag = new MenuItem(menu_tags, 8);
                mi_no_tag.setText(MessageText.getString("label.no.tag"));
                mi_no_tag.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        TranscodeFile[] transcodeFileArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TranscodeFile file = transcodeFileArray[n2];
                            file.setTags(new String[0]);
                            ++n2;
                        }
                    }
                });
                new MenuItem(menu_tags, 2);
            }
            ArrayList<String> menu_names = new ArrayList<String>();
            IdentityHashMap<String, Tag> menu_name_map = new IdentityHashMap<String, Tag>();
            for (Tag t : all_tags) {
                if (t.isTagAuto()[0]) continue;
                String name = t.getTagName(true);
                menu_names.add(name);
                menu_name_map.put(name, t);
            }
            List<Object> menu_structure = MenuBuildUtils.splitLongMenuListIntoHierarchy(menu_names, 20);
            for (Object obj : menu_structure) {
                Menu parent_menu;
                ArrayList<Tag> bucket_tags = new ArrayList<Tag>();
                if (obj instanceof String) {
                    parent_menu = menu_tags;
                    bucket_tags.add((Tag)menu_name_map.get((String)obj));
                } else {
                    Object[] entry = (Object[])obj;
                    List tag_names = (List)entry[1];
                    boolean sub_all_selected = true;
                    boolean sub_some_selected = false;
                    for (String name : tag_names) {
                        Tag sub_tag = (Tag)menu_name_map.get(name);
                        if (shared_tags != null && shared_tags.contains(name)) {
                            sub_some_selected = true;
                        } else {
                            sub_all_selected = false;
                        }
                        bucket_tags.add(sub_tag);
                    }
                    String mod = sub_all_selected ? " (*)" : (sub_some_selected ? " (+)" : "");
                    Menu menu_bucket = new Menu((Decorations)menu_tags.getShell(), 4);
                    MenuItem bucket_item = new MenuItem(menu_tags, 64);
                    bucket_item.setText(String.valueOf((String)entry[0]) + mod);
                    bucket_item.setMenu(menu_bucket);
                    parent_menu = menu_bucket;
                }
                for (final Tag t : bucket_tags) {
                    final MenuItem t_i = new MenuItem(parent_menu, 32);
                    String tag_name = t.getTagName(true);
                    t_i.setText(tag_name);
                    boolean selected = shared_tags != null && shared_tags.contains(tag_name);
                    t_i.setSelection(selected);
                    TagUIUtils.setMenuIcon(t_i, t);
                    t_i.addListener(13, new Listener(){

                        public void handleEvent(Event event2) {
                            boolean selected = t_i.getSelection();
                            String tag_uid = String.valueOf(t.getTagUID());
                            TranscodeFile[] transcodeFileArray = files;
                            int n = files.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TranscodeFile file = transcodeFileArray[n2];
                                TreeSet<String> uids = new TreeSet<String>();
                                uids.addAll(Arrays.asList(file.getTags(false)));
                                boolean update = false;
                                if (selected) {
                                    if (!uids.contains(tag_uid)) {
                                        uids.add(tag_uid);
                                        update = true;
                                    }
                                } else if (uids.contains(tag_uid)) {
                                    uids.remove(tag_uid);
                                    update = true;
                                }
                                if (update) {
                                    file.setTags(uids.toArray(new String[uids.size()]));
                                }
                                ++n2;
                            }
                        }
                    });
                }
            }
        }
        new MenuItem(menu_tags, 2);
        MenuItem item_create = new MenuItem(menu_tags, 8);
        Messages.setLanguageText((Widget)item_create, "label.add.tag");
        item_create.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TagUIUtilsV3.showCreateTagDialog(new UIFunctions.TagReturner(){

                    @Override
                    public void returnedTags(Tag[] tags) {
                        if (tags != null) {
                            Tag[] tagArray = tags;
                            int n = tags.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Tag new_tag = tagArray[n2];
                                if (new_tag != null) {
                                    String[] tagUIDs = new String[]{String.valueOf(new_tag.getTagUID())};
                                    TranscodeFile[] transcodeFileArray = files;
                                    int n3 = files.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        TranscodeFile file = transcodeFileArray[n4];
                                        file.setTags(tagUIDs);
                                        ++n4;
                                    }
                                    COConfigurationManager.setParameter("Library.TagInSideBar", true);
                                }
                                ++n2;
                            }
                        }
                    }
                });
            }
        });
    }

    @Override
    public void deviceChanged(Device device) {
        String name = device.getName();
        if (!name.equals(this.device_name)) {
            this.device_name = name;
            SWTSkinObject soTitle = this.getSkinObject("title");
            if (soTitle instanceof SWTSkinObjectText) {
                ((SWTSkinObjectText)soTitle).setTextID("device.view.heading", new String[]{name});
            }
        }
    }

    private void initDeviceListTable(Composite control) {
        this.tvDevices = TableViewFactory.createTableViewSWT(TranscodeProvider.class, TABLE_DEVICES, TABLE_DEVICES, new TableColumnCore[0], "trancode_qpos", 65540);
        this.tvDevices.setRowDefaultHeightEM(1.5f);
        this.tvDevices.setHeaderVisible(true);
        Composite parent = new Composite(control, 0);
        parent.setLayoutData((Object)Utils.getFilledFormData());
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.tvDevices.initialize(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobAdded(TranscodeJob job) {
        SBC_DevicesView sBC_DevicesView = this;
        synchronized (sBC_DevicesView) {
            TranscodeFile file;
            if (this.tvFiles == null) {
                return;
            }
            if (this.transTarget == null && (file = job.getTranscodeFile()) != null) {
                this.tvFiles.addDataSource(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobChanged(TranscodeJob job) {
        SBC_DevicesView sBC_DevicesView = this;
        synchronized (sBC_DevicesView) {
            if (this.tvFiles == null) {
                return;
            }
            TableRowCore row = this.tvFiles.getRow(this.getFileInTable(job.getTranscodeFile()));
            if (row != null) {
                UIFunctions uiFunctions;
                row.invalidate();
                if (row.isVisible() && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
                    uiFunctions.refreshIconBar();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobRemoved(TranscodeJob job) {
        SBC_DevicesView sBC_DevicesView = this;
        synchronized (sBC_DevicesView) {
            if (this.tvFiles == null) {
                return;
            }
            if (this.transTarget == null) {
                TranscodeFile file = job.getTranscodeFile();
                if (file != null) {
                    this.tvFiles.removeDataSource(this.getFileInTable(file));
                }
            } else {
                TableRowCore row = this.tvFiles.getRow(this.getFileInTable(job.getTranscodeFile()));
                if (row != null) {
                    UIFunctions uiFunctions;
                    row.invalidate();
                    if (row.isVisible() && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
                        uiFunctions.refreshIconBar();
                    }
                }
            }
        }
    }

    private TranscodeFile getFileInTable(TranscodeFile file) {
        if (file == null) {
            return null;
        }
        if (this.tvFiles.getRow(file) == null) {
            HashSet files = this.tvFiles.getDataSources();
            for (TranscodeFile f : files) {
                if (!f.equals(file)) continue;
                return f;
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        TranscodeFile f;
        int size;
        Object[] selectedDS;
        SBC_DevicesView sBC_DevicesView = this;
        synchronized (sBC_DevicesView) {
            if (this.tvFiles == null) {
                return;
            }
            selectedDS = this.tvFiles.getSelectedDataSources().toArray();
            size = this.tvFiles.size(false);
        }
        if (selectedDS.length == 0) {
            return;
        }
        list.put("remove", 1L);
        boolean can_stop = true;
        boolean can_queue = true;
        boolean can_move_up = true;
        boolean can_move_down = true;
        boolean hasJob = false;
        Object[] objectArray = selectedDS;
        int n = selectedDS.length;
        int n2 = 0;
        while (n2 < n) {
            Object ds = objectArray[n2];
            TranscodeJob job = ((TranscodeFile)ds).getJob();
            if (job != null) {
                int state;
                hasJob = true;
                int index = job.getIndex();
                if (index == 1) {
                    can_move_up = false;
                }
                if (index == size) {
                    can_move_down = false;
                }
                if ((state = job.getState()) != 2 && state != 1 && state != 5 && state != 0) {
                    can_stop = false;
                }
                if (state != 2 && state != 6 && state != 5) {
                    can_queue = false;
                }
            }
            ++n2;
        }
        if (!hasJob) {
            can_move_up = false;
            can_move_down = false;
            can_queue = false;
            can_stop = false;
        }
        if (can_queue && can_stop) {
            can_stop = false;
        }
        list.put("stop", can_stop ? 1L : 0L);
        list.put("start", can_queue ? 1L : 0L);
        list.put("up", can_move_up ? 1L : 0L);
        list.put("down", can_move_down ? 1L : 0L);
        if (selectedDS.length == 1 && (f = (TranscodeFile)selectedDS[0]).isComplete() && f.getStreamURL() != null) {
            try {
                if (PlayUtils.canUseEMP(f.getTargetFile())) {
                    list.put("play", 1L);
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        TranscodeFile f;
        if (this.tvFiles == null) {
            return false;
        }
        TranscodeFile[] selectedDS = this.tvFiles.getSelectedDataSources().toArray(new TranscodeFile[0]);
        if (selectedDS.length == 0) {
            return false;
        }
        String itemKey = item.getID();
        if (itemKey.equals("remove")) {
            this.deleteFiles(selectedDS, 0);
            return true;
        }
        if (itemKey.equals("play") && selectedDS.length == 1 && TorrentListViewsUtils.openInEMP((f = selectedDS[0]).getName(), f.getStreamURL()) == 0) {
            return true;
        }
        ArrayList<TranscodeJob> jobs = new ArrayList<TranscodeJob>(selectedDS.length);
        boolean can_stop = true;
        boolean can_queue = true;
        int i = 0;
        while (i < selectedDS.length) {
            TranscodeFile file = selectedDS[i];
            TranscodeJob job = file.getJob();
            if (job != null) {
                jobs.add(job);
                int state = job.getState();
                if (state != 2 && state != 1 && state != 5 && state != 0) {
                    can_stop = false;
                }
                if (state != 2 && state != 6 && state != 5) {
                    can_queue = false;
                }
            }
            ++i;
        }
        if (jobs.size() == 0) {
            return false;
        }
        if (can_queue && can_stop) {
            can_stop = false;
        }
        if (itemKey.equals("up") || itemKey.equals("down")) {
            final String f_itemKey = itemKey;
            Collections.sort(jobs, new Comparator<TranscodeJob>(){

                @Override
                public int compare(TranscodeJob j1, TranscodeJob j2) {
                    return (f_itemKey.equals("up") ? 1 : -1) * (j1.getIndex() - j2.getIndex());
                }
            });
        }
        if (itemKey.equals("startstop")) {
            if (can_queue) {
                itemKey = "start";
            } else if (can_stop) {
                itemKey = "stop";
            }
        }
        boolean didSomething = false;
        boolean forceSort = false;
        for (TranscodeJob job : jobs) {
            TableColumnCore[] sortColumn;
            if (itemKey.equals("stop")) {
                job.stop();
                didSomething = true;
                continue;
            }
            if (itemKey.equals("start")) {
                didSomething = true;
                job.queue();
                continue;
            }
            if (itemKey.equals("up")) {
                didSomething = true;
                job.moveUp();
                sortColumn = this.tvFiles.getSortColumns();
                forceSort = sortColumn.length != 0 && "trancode_qpos".equals(sortColumn[0].getName());
                continue;
            }
            if (!itemKey.equals("down")) continue;
            didSomething = true;
            job.moveDown();
            sortColumn = this.tvFiles.getSortColumns();
            boolean bl = forceSort = sortColumn.length != 0 && "trancode_qpos".equals(sortColumn[0].getName());
        }
        this.tvFiles.refreshTable(forceSort);
        return didSomething;
    }

    @Override
    public String getUpdateUIName() {
        return "DevicesView";
    }

    @Override
    public void updateUI() {
        if (this.tvFiles != null) {
            this.tvFiles.refreshTable(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileAdded(TranscodeFile file) {
        SBC_DevicesView sBC_DevicesView = this;
        synchronized (sBC_DevicesView) {
            if (this.tvFiles != null) {
                this.tvFiles.addDataSource(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(TranscodeFile file, int type, Object data) {
        TableRowCore row;
        SBC_DevicesView sBC_DevicesView = this;
        synchronized (sBC_DevicesView) {
            if (this.tvFiles == null) {
                return;
            }
            row = this.tvFiles.getRow(this.getFileInTable(file));
        }
        if (row != null) {
            UIFunctions uiFunctions;
            row.invalidate();
            if (row.isVisible() && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
                uiFunctions.refreshIconBar();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileRemoved(TranscodeFile file) {
        SBC_DevicesView sBC_DevicesView = this;
        synchronized (sBC_DevicesView) {
            if (this.tvFiles != null) {
                this.tvFiles.removeDataSource(this.getFileInTable(file));
            }
        }
    }

    protected void deleteFiles(final TranscodeFile[] toRemove, final int startIndex) {
        if (toRemove[startIndex] == null) {
            int nextIndex = startIndex + 1;
            if (nextIndex < toRemove.length) {
                this.deleteFiles(toRemove, nextIndex);
            }
            return;
        }
        final TranscodeFile file = toRemove[startIndex];
        try {
            File cache_file = file.getCacheFileIfExists();
            if (cache_file != null && cache_file.exists() && file.isComplete()) {
                String path = cache_file.toString();
                String title = MessageText.getString("xcode.deletedata.title");
                String copy_text = "";
                Device device = file.getDevice();
                if (device instanceof DeviceMediaRenderer) {
                    DeviceMediaRenderer dmr = (DeviceMediaRenderer)device;
                    File copy_to = dmr.getCopyToFolder();
                    if (dmr.canCopyToDevice() || dmr.canCopyToFolder() && copy_to != null && copy_to.exists()) {
                        copy_text = MessageText.getString("xcode.deletedata.message.2", new String[]{device.getName()});
                    }
                }
                String text = MessageText.getString("xcode.deletedata.message", new String[]{file.getName(), file.getProfileName(), copy_text});
                MessageBoxShell mb = new MessageBoxShell(title, text);
                mb.setRemember("xcode.deletedata.noconfirm.key", false, MessageText.getString("deletedata.noprompt"));
                if (startIndex == toRemove.length - 1) {
                    mb.setButtons(0, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, new Integer[]{0, 1});
                    mb.setRememberOnlyIfButton(0);
                } else {
                    mb.setButtons(1, new String[]{MessageText.getString("Button.removeAll"), MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, new Integer[]{2, 0, 1});
                    mb.setRememberOnlyIfButton(1);
                }
                Object dm = null;
                if (dm != null) {
                    mb.setRelatedObject(dm);
                }
                mb.setLeftImage(8);
                mb.open(new UserPrompterResultListener(){

                    @Override
                    public void prompterClosed(int result) {
                        if (result == -1) {
                            return;
                        }
                        if (result == 0) {
                            SBC_DevicesView.this.deleteNoCheck(file);
                        } else if (result == 2) {
                            int i = startIndex;
                            while (i < toRemove.length) {
                                if (toRemove[i] != null) {
                                    SBC_DevicesView.this.deleteNoCheck(toRemove[i]);
                                }
                                ++i;
                            }
                            return;
                        }
                        int nextIndex = startIndex + 1;
                        if (nextIndex < toRemove.length) {
                            SBC_DevicesView.this.deleteFiles(toRemove, nextIndex);
                        }
                    }
                });
            } else {
                this.deleteNoCheck(file);
                int nextIndex = startIndex + 1;
                if (nextIndex < toRemove.length) {
                    this.deleteFiles(toRemove, nextIndex);
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private void deleteNoCheck(TranscodeFile file) {
        TranscodeJob job = file.getJob();
        if (job != null) {
            try {
                job.remove();
            }
            catch (TranscodeActionVetoException e) {
                UIFunctionsManager.getUIFunctions().forceNotify(1, MessageText.getString("globalmanager.download.remove.veto"), e.getMessage(), null, null, -1);
                return;
            }
        }
        try {
            file.delete(file.getCacheFileIfExists() != null);
        }
        catch (TranscodeException e) {
            Debug.out(e);
        }
    }

    private void createDragDrop(final TableViewSWT<?> table) {
        try {
            DropTarget dropTarget;
            Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
            DragSource dragSource = table.createDragSource(3);
            if (dragSource != null) {
                dragSource.setTransfer(types);
                dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){
                    private String eventData;

                    public void dragStart(DragSourceEvent event2) {
                        TableRowCore[] rows = table.getSelectedRows();
                        if (rows.length != 0) {
                            event2.doit = true;
                            SBC_DevicesView.this.drag_drop_line_start = rows[0].getIndex();
                            SBC_DevicesView.this.drag_drop_rows = rows;
                        } else {
                            event2.doit = false;
                            SBC_DevicesView.this.drag_drop_line_start = -1;
                            SBC_DevicesView.this.drag_drop_rows = null;
                        }
                        List<Object> selectedFiles = table.getSelectedDataSources();
                        this.eventData = "TranscodeFile\n";
                        for (Object o : selectedFiles) {
                            TranscodeFile file = (TranscodeFile)o;
                            if (!file.isComplete()) continue;
                            try {
                                this.eventData = String.valueOf(this.eventData) + file.getTargetFile().getFile(true).getAbsolutePath() + "\n";
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }

                    public void dragSetData(DragSourceEvent event2) {
                        event2.data = this.eventData;
                    }
                });
            }
            if ((dropTarget = table.createDropTarget(31)) != null) {
                dropTarget.setTransfer(new Transfer[]{FixedHTMLTransfer.getInstance(), FixedURLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                    public void dropAccept(DropTargetEvent event2) {
                        event2.currentDataType = FixedURLTransfer.pickBestType(event2.dataTypes, event2.currentDataType);
                    }

                    public void dragEnter(DropTargetEvent event2) {
                        if (SBC_DevicesView.this.drag_drop_line_start < 0) {
                            if (event2.detail != 1) {
                                if ((event2.operations & 4) > 0) {
                                    event2.detail = 4;
                                } else if ((event2.operations & 1) > 0) {
                                    event2.detail = 1;
                                }
                            }
                        } else if (TextTransfer.getInstance().isSupportedType(event2.currentDataType)) {
                            event2.detail = event2.item == null ? 0 : 2;
                            event2.feedback = 10;
                        }
                    }

                    public void dragOver(DropTargetEvent event2) {
                        if (SBC_DevicesView.this.drag_drop_line_start >= 0) {
                            event2.detail = event2.item == null ? 0 : 2;
                            event2.feedback = 10;
                        }
                    }

                    public void drop(DropTargetEvent event2) {
                        try {
                            if (event2.data instanceof String && ((String)event2.data).startsWith("TranscodeFile\n")) {
                                return;
                            }
                            event2.detail = 0;
                            DeviceManagerUI.handleDrop((TranscodeTarget)((Object)SBC_DevicesView.this.device), event2.data);
                        }
                        finally {
                            SBC_DevicesView.this.drag_drop_line_start = -1;
                            SBC_DevicesView.this.drag_drop_rows = null;
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            Debug.out("failed to init drag-n-drop", t);
        }
    }

    public void updateSelectedContent() {
        TableViewSWT<TranscodeFile> tv = this.tvFiles != null ? this.tvFiles : this.tvDevices;
        Object[] dataSources = tv.getSelectedDataSources(true);
        ArrayList<SelectedContent> listSelected = new ArrayList<SelectedContent>(dataSources.length);
        Object[] objectArray = dataSources;
        int n = dataSources.length;
        int n2 = 0;
        while (n2 < n) {
            Object ds = objectArray[n2];
            if (ds instanceof DiskManagerFileInfo) {
                DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
                listSelected.add(new SelectedContent(fileInfo2.getDownloadManager(), fileInfo2.getIndex()));
            } else if (ds instanceof TranscodeFile) {
                TranscodeFile tf = (TranscodeFile)ds;
                listSelected.add(new SelectedContent(tf.getName()));
            }
            ++n2;
        }
        ISelectedContent[] sc = listSelected.toArray(new SelectedContent[0]);
        SelectedContentManager.changeCurrentlySelectedContent(tv.getTableID(), sc, tv);
    }
}

