/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.devices.columns;

import com.biglybt.core.devices.Device;
import com.biglybt.core.devices.DeviceMediaRenderer;
import com.biglybt.core.devices.TranscodeFile;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import java.util.Locale;

public class ColumnTJ_CopiedToDevice
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static final String COLUMN_ID = "copied";
    private String na_text;

    public ColumnTJ_CopiedToDevice(final TableColumn column) {
        column.initialize(3, -2, 50);
        column.addListeners(this);
        column.setRefreshInterval(-1);
        column.setType(3);
        MessageText.addAndFireListener(new MessageText.MessageTextListener(){

            @Override
            public void localeChanged(Locale old_locale, Locale new_locale) {
                ColumnTJ_CopiedToDevice.this.na_text = MessageText.getString("general.na.short");
                column.invalidateCells();
            }
        });
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        DeviceMediaRenderer dmr;
        TranscodeFile tf = (TranscodeFile)cell.getDataSource();
        if (tf == null) {
            return;
        }
        Device d = tf.getDevice();
        String value = null;
        if (d instanceof DeviceMediaRenderer && !(dmr = (DeviceMediaRenderer)d).canCopyToDevice() && !dmr.canCopyToFolder()) {
            value = this.na_text;
        }
        if (value == null) {
            value = DisplayFormatters.getYesNo(tf.isCopiedToDevice());
        }
        if (cell.setSortValue((Comparable)((Object)value)) || !cell.isValid()) {
            cell.setText(value);
        }
    }
}

