/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.devices.columns;

import com.biglybt.core.devices.TranscodeFile;
import com.biglybt.core.devices.TranscodeJob;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;

public class ColumnTJ_Rank
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static final String COLUMN_ID = "trancode_qpos";

    public ColumnTJ_Rank(TableColumn column) {
        column.initialize(2, -2, 25);
        column.addListeners(this);
        column.setRefreshInterval(-1);
        column.setType(3);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        long value;
        TranscodeFile tf = (TranscodeFile)cell.getDataSource();
        if (tf == null) {
            return;
        }
        TranscodeJob job = tf.getJob();
        if (job == null) {
            try {
                value = Integer.MAX_VALUE + tf.getCreationDateMillis() + 1L;
            }
            catch (Throwable t) {
                value = 0x80000000L;
            }
        } else {
            value = job.getIndex();
        }
        if (cell.setSortValue(value) || !cell.isValid()) {
            if (value > Integer.MAX_VALUE) {
                cell.setText("");
            } else {
                cell.setText("" + value);
            }
        }
    }
}

