/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.exporttorrent.wizard;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Constants;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.exporttorrent.wizard.ExportTorrentWizard;
import com.biglybt.ui.swt.exporttorrent.wizard.ExportTorrentWizardOutputPanel;
import com.biglybt.ui.swt.wizard.AbstractWizardPanel;
import com.biglybt.ui.swt.wizard.IWizardPanel;
import com.biglybt.ui.swt.wizard.Wizard;
import java.io.File;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ExportTorrentWizardInputPanel
extends AbstractWizardPanel {
    protected boolean file_valid = false;

    public ExportTorrentWizardInputPanel(Wizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    @Override
    public void show() {
        this.wizard.setTitle(MessageText.getString("exportTorrentWizard.torrentfile.title"));
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 64);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.widthHint = 380;
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "exportTorrentWizard.torrentfile.message");
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "exportTorrentWizard.torrentfile.path");
        final Text textPath = new Text(panel, 2048);
        gridData = new GridData(768);
        textPath.setLayoutData((Object)gridData);
        textPath.setText("");
        Button browse = new Button(panel, 8);
        Messages.setLanguageText((Widget)browse, "exportTorrentWizard.torrentfile.browse");
        browse.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                FileDialog fd = new FileDialog(ExportTorrentWizardInputPanel.this.wizard.getWizardWindow());
                fd.setFileName(textPath.getText());
                fd.setFilterExtensions(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                String path = fd.open();
                if (path != null) {
                    textPath.setText(path);
                }
            }
        });
        textPath.addListener(24, new Listener(){

            public void handleEvent(Event event2) {
                String path = textPath.getText();
                ((ExportTorrentWizard)ExportTorrentWizardInputPanel.this.wizard).setTorrentFile(path);
                ExportTorrentWizardInputPanel.this.file_valid = false;
                try {
                    File f = new File(path);
                    if (f.exists()) {
                        if (f.isFile()) {
                            ExportTorrentWizardInputPanel.this.file_valid = true;
                            ExportTorrentWizardInputPanel.this.wizard.setErrorMessage("");
                        } else {
                            ExportTorrentWizardInputPanel.this.wizard.setErrorMessage(MessageText.getString("exportTorrentWizard.torrentfile.invalidPath"));
                        }
                    }
                }
                catch (Exception e) {
                    ExportTorrentWizardInputPanel.this.wizard.setErrorMessage(MessageText.getString("exportTorrentWizard.torrentfile.invalidPath"));
                }
                ExportTorrentWizardInputPanel.this.wizard.setNextEnabled(ExportTorrentWizardInputPanel.this.file_valid);
            }
        });
        textPath.setText(((ExportTorrentWizard)this.wizard).getTorrentFile());
        textPath.setFocus();
    }

    @Override
    public IWizardPanel getNextPanel() {
        return new ExportTorrentWizardOutputPanel(this.wizard, (IWizardPanel)this);
    }

    @Override
    public boolean isNextEnabled() {
        return this.file_valid;
    }
}

