/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.imageloader;

import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.ui.skin.SkinProperties;
import com.biglybt.ui.skin.SkinPropertiesImpl;
import com.biglybt.ui.swt.ImageRepository;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoaderRefInfo;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.utils.ImageBytesDownloader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ImageLoader
implements AEDiagnosticsEvidenceGenerator {
    private static ImageLoader instance;
    private static final boolean DEBUG_UNLOAD = false;
    private static final boolean DEBUG_REFCOUNT = false;
    private static final int GC_INTERVAL = 60000;
    private final String[] sSuffixChecks = new String[]{"-over", "-down", "-disabled", "-selected", "-gray"};
    private final TimerEventPeriodic periodicEvent;
    private Display display;
    public static Image noImage;
    public static Image nullImage;
    private final ConcurrentHashMap<String, ImageLoaderRefInfo> _mapImages;
    private final ArrayList<String> notFound;
    private CopyOnWriteArrayList<SkinProperties> skinProperties;
    private int disabledOpacity;
    private Set<String> cached_resources = new HashSet<String>();
    private File cache_dir = new File(SystemProperties.getUserPath(), "cache");

    public static synchronized ImageLoader getInstance() {
        if (instance == null) {
            if (Utils.isDisplayDisposed()) {
                throw new SWTException("Calling getInstance after display disposed");
            }
            instance = new ImageLoader(Display.getDefault(), null);
            SkinPropertiesImpl skinProperties = new SkinPropertiesImpl(ImageRepository.class.getClassLoader(), "com/biglybt/ui/icons/", "icons.properties");
            instance.addSkinProperties(skinProperties);
        }
        return instance;
    }

    public static void disposeInstance() {
        if (instance != null) {
            instance.dispose();
        }
        instance = null;
        if (noImage != null) {
            noImage.dispose();
            noImage = null;
        }
        if (nullImage != null) {
            nullImage.dispose();
            nullImage = null;
        }
    }

    public void dispose() {
        ArrayList<ImageLoaderRefInfo> values = new ArrayList<ImageLoaderRefInfo>(this._mapImages.values());
        this._mapImages.clear();
        for (ImageLoaderRefInfo value : values) {
            Image[] images = value.getImages();
            if (images == null) continue;
            Image[] imageArray = images;
            int n = images.length;
            int n2 = 0;
            while (n2 < n) {
                Image image = imageArray[n2];
                image.dispose();
                ++n2;
            }
        }
        if (this.periodicEvent != null && !this.periodicEvent.isCancelled()) {
            this.periodicEvent.cancel();
        }
    }

    public ImageLoader(Display display, SkinProperties skinProperties) {
        File[] files = this.cache_dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String name = f.getName();
                if (name.endsWith(".ico")) {
                    this.cached_resources.add(name);
                }
                ++n2;
            }
        }
        this._mapImages = new ConcurrentHashMap();
        this.notFound = new ArrayList();
        this.display = display;
        this.skinProperties = new CopyOnWriteArrayList();
        this.addSkinProperties(skinProperties);
        AEDiagnostics.addWeakEvidenceGenerator(this);
        this.periodicEvent = SimpleTimer.addPeriodicEvent("GC_ImageLoader", 60000L, new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                if (!ImageLoader.this.collectGarbage()) {
                    event2.cancel();
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Image[] findResources(String sKey) {
        if (Collections.binarySearch(this.notFound, sKey) >= 0) {
            return null;
        }
        int i = 0;
        while (i < this.sSuffixChecks.length) {
            String sSuffix = this.sSuffixChecks[i];
            if (sKey.endsWith(sSuffix)) {
                String sParentName = sKey.substring(0, sKey.length() - sSuffix.length());
                String[] sParentFiles = null;
                ClassLoader cl = null;
                for (SkinProperties sp : this.skinProperties) {
                    sParentFiles = sp.getStringArray(sParentName);
                    if (sParentFiles == null) continue;
                    cl = sp.getClassLoader();
                    break;
                }
                if (sParentFiles != null) {
                    boolean bFoundOne = false;
                    Image[] images = this.parseValuesString(cl, sKey, sParentFiles, sSuffix);
                    if (images != null) {
                        Image image;
                        int j = 0;
                        while (j < images.length) {
                            image = images[j];
                            if (ImageLoader.isRealImage(image)) {
                                bFoundOne = true;
                                break;
                            }
                            ++j;
                        }
                        if (bFoundOne) return images;
                        j = 0;
                        while (j < images.length) {
                            image = images[j];
                            if (ImageLoader.isRealImage(image)) {
                                image.dispose();
                            }
                            ++j;
                        }
                    }
                } else {
                    Image[] images = this.findResources(sParentName);
                    if (images != null) {
                        return images;
                    }
                }
            }
            ++i;
        }
        i = Collections.binarySearch(this.notFound, sKey) * -1 - 1;
        if (i < 0) return null;
        this.notFound.add(i, sKey);
        return null;
    }

    private Image[] parseValuesString(ClassLoader cl, String sKey, String[] values, String suffix) {
        if (values.length == 1 && values[0].equals("null")) {
            return new Image[]{this.getNullImage()};
        }
        Image[] images = null;
        boolean scale = true;
        int splitX = 0;
        int locationStart = 0;
        int useIndex = -1;
        if (values.length > 1) {
            if (values[0].equals("multi") && values.length > 2) {
                splitX = Integer.parseInt(values[1]);
                locationStart = 2;
            } else if (values[0].equals("multi-index") && values.length > 3) {
                splitX = Integer.parseInt(values[1]);
                useIndex = Integer.parseInt(values[2]);
                locationStart = 3;
            } else if (values[0].equals("noscale")) {
                scale = false;
                locationStart = 1;
            }
        }
        if (locationStart == 0 || splitX <= 0) {
            images = new Image[values.length - locationStart];
            int i = 0;
            while (i < images.length) {
                String value = values[i + locationStart];
                int index = value.lastIndexOf(46);
                if (index > 0) {
                    String sTryFile = String.valueOf(value.substring(0, index)) + suffix + value.substring(index);
                    images[i] = this.loadImage(this.display, cl, sTryFile, sKey);
                    if (images[i] == null) {
                        sTryFile = String.valueOf(value.substring(0, index)) + suffix.replace('-', '_') + value.substring(index);
                        images[i] = this.loadImage(this.display, cl, sTryFile, sKey);
                    }
                }
                if (images[i] == null) {
                    images[i] = ImageLoader.getNoImage(sKey);
                }
                ++i;
            }
        } else {
            Image image = null;
            String image_key = null;
            String origFile = values[locationStart];
            int index = origFile.lastIndexOf(46);
            if (index > 0) {
                String sTryFile;
                if (useIndex == -1) {
                    sTryFile = String.valueOf(origFile.substring(0, index)) + suffix + origFile.substring(index);
                    image = this.loadImage(this.display, cl, sTryFile, sKey);
                    if (image == null) {
                        sTryFile = String.valueOf(origFile.substring(0, index)) + suffix.replace('-', '_') + origFile.substring(index);
                        image = this.loadImage(this.display, cl, sTryFile, sKey);
                    }
                } else {
                    sTryFile = String.valueOf(origFile.substring(0, index)) + suffix + origFile.substring(index);
                    image = this.getImageFromMap(sTryFile);
                    if (image == null) {
                        image = this.loadImage(this.display, cl, sTryFile, sTryFile);
                        if (ImageLoader.isRealImage(image)) {
                            image_key = sTryFile;
                            this.addImage(image_key, image);
                        } else if (sTryFile.matches(".*[-_]disabled.*")) {
                            String sTryFileNonDisabled = sTryFile.replaceAll("[-_]disabled", "");
                            image = this.getImageFromMap(sTryFileNonDisabled);
                            if (!ImageLoader.isRealImage(image) && ImageLoader.isRealImage(image = this.loadImage(this.display, cl, sTryFileNonDisabled, sTryFileNonDisabled))) {
                                this.addImage(sTryFileNonDisabled, image);
                            }
                            if (ImageLoader.isRealImage(image)) {
                                image = this.fadeImage(image);
                                image_key = sTryFile;
                                this.addImage(image_key, image);
                                this.releaseImage(sTryFileNonDisabled);
                            }
                        }
                    } else {
                        image_key = sTryFile;
                    }
                }
            }
            if (!ImageLoader.isRealImage(image)) {
                String temp_key = String.valueOf(sKey) + "-[multi-load-temp]";
                image = this.getImageFromMap(temp_key);
                if (ImageLoader.isRealImage(image)) {
                    image_key = temp_key;
                } else {
                    image = this.loadImage(this.display, cl, values[locationStart], sKey);
                    if (ImageLoader.isRealImage(image)) {
                        image_key = temp_key;
                        this.addImage(image_key, image);
                    }
                }
            }
            if (ImageLoader.isRealImage(image)) {
                Rectangle bounds = image.getBounds();
                if (useIndex == -1) {
                    images = new Image[(bounds.width + splitX - 1) / splitX];
                    int i = 0;
                    while (i < images.length) {
                        Image imgBG = Utils.createAlphaImage((Device)this.display, splitX, bounds.height, (byte)0);
                        int pos = i * splitX;
                        try {
                            images[i] = Utils.blitImage((Device)this.display, image, new Rectangle(pos, 0, Math.min(splitX, bounds.width - pos), bounds.height), imgBG, new Point(0, 0));
                        }
                        catch (Exception e) {
                            Debug.out(e);
                        }
                        imgBG.dispose();
                        ++i;
                    }
                } else {
                    images = new Image[1];
                    Image imgBG = Utils.createAlphaImage((Device)this.display, splitX, bounds.height, (byte)0);
                    try {
                        int pos = useIndex * splitX;
                        images[0] = Utils.blitImage((Device)this.display, image, new Rectangle(pos, 0, Math.min(splitX, bounds.width - pos), bounds.height), imgBG, new Point(0, 0));
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                    imgBG.dispose();
                }
                if (image_key != null) {
                    this.releaseImage(image_key);
                } else {
                    image.dispose();
                }
            }
        }
        return images;
    }

    private Image loadImage(Display display, ClassLoader cl, String res, String sKey) {
        Image img = null;
        if (res == null) {
            int i = 0;
            while (i < this.sSuffixChecks.length) {
                String sSuffix = this.sSuffixChecks[i];
                if (sKey.endsWith(sSuffix)) {
                    String sTryFile;
                    int index;
                    String sParentName = sKey.substring(0, sKey.length() - sSuffix.length());
                    String sParentFile = null;
                    for (SkinProperties sp : this.skinProperties) {
                        sParentFile = sp.getStringValue(sParentName);
                        if (sParentFile == null) continue;
                        if (cl != null) break;
                        cl = sp.getClassLoader();
                        break;
                    }
                    if (sParentFile != null && (index = sParentFile.lastIndexOf(46)) > 0 && ((img = this.loadImage(display, cl, sTryFile = String.valueOf(sParentFile.substring(0, index)) + sSuffix + sParentFile.substring(index), sKey)) != null || (img = this.loadImage(display, cl, sTryFile = String.valueOf(sParentFile.substring(0, index)) + sSuffix.replace('-', '_') + sParentFile.substring(index), sKey)) != null)) break;
                }
                ++i;
            }
        }
        if (img == null) {
            try {
                if (cl != null && res != null) {
                    int i;
                    int deviceZoom = Utils.getDeviceZoom();
                    InputStream is = cl.getResourceAsStream(res);
                    InputStream is2 = null;
                    if (deviceZoom > 100 && (i = res.lastIndexOf("/")) >= 0) {
                        String bigRes = String.valueOf(res.substring(0, i)) + "/2x" + res.substring(i);
                        is2 = cl.getResourceAsStream(bigRes);
                    }
                    if (is != null) {
                        try {
                            ImageData imageData = new ImageData(is);
                            if (is2 != null) {
                                ImageData imageData2 = new ImageData(is2);
                                img = new Image((Device)display, zoom -> {
                                    if (zoom == 100) {
                                        return imageData;
                                    }
                                    return zoom == 200 ? imageData2 : null;
                                });
                            } else {
                                img = new Image((Device)display, imageData);
                            }
                        }
                        finally {
                            is.close();
                        }
                    }
                }
                if (img == null) {
                    if (res != null && res.contains("_disabled.")) {
                        String id = sKey.substring(0, sKey.length() - 9);
                        Image imgToFade = this.getImage(id);
                        if (ImageLoader.isRealImage(imgToFade)) {
                            img = this.fadeImage(imgToFade);
                        }
                        this.releaseImage(id);
                    } else if (sKey.endsWith("-gray")) {
                        String id = sKey.substring(0, sKey.length() - 5);
                        Image imgToGray = this.getImage(id);
                        if (ImageLoader.isRealImage(imgToGray)) {
                            img = new Image((Device)display, imgToGray, 2);
                        }
                        this.releaseImage(id);
                    }
                }
            }
            catch (Throwable e) {
                System.err.println("ImageRepository:loadImage:: Resource not found: " + res + "\n" + e);
                e.printStackTrace();
            }
        }
        return img;
    }

    private Image fadeImage(Image imgToFade) {
        Image img;
        ImageData imageData = imgToFade.getImageData();
        if (imageData.alphaData != null) {
            if (this.disabledOpacity == -1) {
                int i = 0;
                while (i < imageData.alphaData.length) {
                    imageData.alphaData[i] = (byte)((imageData.alphaData[i] & 0xFF) >> 3);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < imageData.alphaData.length) {
                    imageData.alphaData[i] = (byte)((imageData.alphaData[i] & 0xFF) * this.disabledOpacity / 100);
                    ++i;
                }
            }
            img = new Image((Device)this.display, imageData);
        } else {
            Rectangle bounds = imgToFade.getBounds();
            Image bg = Utils.createAlphaImage((Device)this.display, bounds.width, bounds.height, (byte)0);
            img = Utils.renderTransparency(this.display, bg, imgToFade, new Point(0, 0), this.disabledOpacity == -1 ? 64 : this.disabledOpacity * 255 / 100);
            bg.dispose();
        }
        return img;
    }

    public void unLoadImages() {
        for (ImageLoaderRefInfo imageInfo : this._mapImages.values()) {
            Image[] images = imageInfo.getImages();
            if (images == null) continue;
            int i = 0;
            while (i < images.length) {
                Image image = images[i];
                if (ImageLoader.isRealImage(image)) {
                    image.dispose();
                }
                ++i;
            }
        }
    }

    private ImageLoaderRefInfo getRefInfoFromImageMap(String key) {
        return this._mapImages.get(key);
    }

    private void putRefInfoToImageMap(String key, ImageLoaderRefInfo info) {
        Image[] images;
        ImageLoaderRefInfo existing = this._mapImages.put(key, info);
        if (existing != null && (images = existing.getImages()) != null && images.length > 0) {
            Debug.out("P: existing found! " + key + " -> " + existing.getString());
        }
    }

    private ImageLoaderRefInfo putIfAbsentRefInfoToImageMap(String key, ImageLoaderRefInfo info) {
        Image[] images;
        ImageLoaderRefInfo x = this._mapImages.putIfAbsent(key, info);
        if (x != null && (images = x.getImages()) != null && images.length > 0) {
            Debug.out("PIA: existing found! " + key + " -> " + x.getString());
        }
        return x;
    }

    protected Image getImageFromMap(String sKey) {
        Image[] imagesFromMap = this.getImagesFromMap(sKey);
        if (imagesFromMap.length == 0) {
            return null;
        }
        return imagesFromMap[0];
    }

    protected Image[] getImagesFromMap(String sKey) {
        if (sKey == null) {
            return new Image[0];
        }
        ImageLoaderRefInfo imageInfo = this.getRefInfoFromImageMap(sKey);
        if (imageInfo != null && imageInfo.getImages() != null) {
            imageInfo.addref();
            return imageInfo.getImages();
        }
        return new Image[0];
    }

    public Image[] getImages(String sKey) {
        Image[] images;
        ImageLoaderRefInfo imageInfo;
        if (sKey == null) {
            return new Image[0];
        }
        if (!Utils.isThisThreadSWT()) {
            Debug.out("getImages called on non-SWT thread");
            return new Image[0];
        }
        if (sKey.startsWith("http://") && sKey.endsWith("-gray")) {
            sKey = sKey.substring(0, sKey.length() - 5);
        }
        if ((imageInfo = this.getRefInfoFromImageMap(sKey)) != null && imageInfo.getImages() != null) {
            imageInfo.addref();
            return imageInfo.getImages();
        }
        String[] locations = null;
        ClassLoader cl = null;
        for (SkinProperties sp : this.skinProperties) {
            locations = sp.getStringArray(sKey);
            if (locations == null || locations.length <= 0) continue;
            cl = sp.getClassLoader();
            break;
        }
        if (locations == null || locations.length == 0) {
            images = this.findResources(sKey);
            if (images == null) {
                images = new Image[]{};
            }
            int i = 0;
            while (i < images.length) {
                if (images[i] == null) {
                    images[i] = ImageLoader.getNoImage(sKey);
                }
                ++i;
            }
        } else {
            images = this.parseValuesString(cl, sKey, locations, "");
        }
        ImageLoaderRefInfo info = new ImageLoaderRefInfo(images);
        this.putRefInfoToImageMap(sKey, info);
        return images;
    }

    public Image getImage(String sKey) {
        Image result;
        block24: {
            int pos = sKey.indexOf(35);
            if (pos == -1) {
                Image res = this.getImageSupport(sKey);
                if (res == nullImage) {
                    return null;
                }
                return res;
            }
            ImageLoaderRefInfo existing = this.getRefInfoFromImageMap(sKey);
            if (existing != null) {
                return this.getImageSupport(sKey);
            }
            String basisKey = sKey.substring(0, pos);
            Image basis = this.getImageSupport(basisKey);
            result = null;
            if (ImageLoader.isRealImage(basis)) {
                try {
                    try {
                        long l = Long.parseLong(sKey.substring(pos + 1), 16);
                        int to_red = (int)(l >> 16 & 0xFFL);
                        int to_green = (int)(l >> 8 & 0xFFL);
                        int to_blue = (int)(l & 0xFFL);
                        ImageData original_id = basis.getImageData();
                        Image tempImg = new Image(basis.getDevice(), basis.getBounds());
                        GC tempGC = new GC((Drawable)tempImg);
                        tempGC.drawImage(basis, 0, 0);
                        tempGC.dispose();
                        ImageData id = tempImg.getImageData();
                        tempImg.dispose();
                        int[] pixels = new int[id.width * id.height];
                        id.getPixels(0, 0, pixels.length, pixels, 0);
                        PaletteData palette = id.palette;
                        if (palette.isDirect) {
                            int redMask = palette.redMask;
                            int greenMask = palette.greenMask;
                            int blueMask = palette.blueMask;
                            int redShift = palette.redShift;
                            int greenShift = palette.greenShift;
                            int blueShift = palette.blueShift;
                            int[] rgbs = new int[id.width * id.height];
                            int i = 0;
                            while (i < pixels.length) {
                                int pixel = pixels[i];
                                int red = pixel & redMask;
                                red = redShift < 0 ? red >>> -redShift : red << redShift;
                                int green = pixel & greenMask;
                                green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                                int blue = pixel & blueMask;
                                blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                                rgbs[i] = red << 16 | green << 8 | blue;
                                ++i;
                            }
                            Arrays.sort(rgbs);
                            int curr = -1;
                            int len = 0;
                            int max_len = -1;
                            int max_rgb = 0;
                            int i2 = 0;
                            while (i2 < rgbs.length) {
                                int x = rgbs[i2];
                                if (x != 0 && x != 0xFFFFFF) {
                                    if (x == curr) {
                                        if (++len > max_len) {
                                            max_rgb = x;
                                            max_len = len;
                                        }
                                    } else {
                                        curr = x;
                                        len = 1;
                                    }
                                }
                                ++i2;
                            }
                            to_red = redShift < 0 ? to_red << -redShift : to_red >>> -redShift;
                            to_green = greenShift < 0 ? to_green << -greenShift : to_green >>> -greenShift;
                            to_blue = blueShift < 0 ? to_blue << -blueShift : to_blue >>> -blueShift;
                            int to_rgb = (to_red &= redMask) | (to_green &= greenMask) | (to_blue &= blueMask);
                            byte[] alphaData = null;
                            if (original_id.alphaData != null) {
                                id.alphaData = original_id.alphaData;
                            } else if (original_id.transparentPixel >= 0) {
                                alphaData = new byte[pixels.length];
                                Arrays.fill(alphaData, (byte)-1);
                                id.alphaData = alphaData;
                                int[] original_pixels = new int[id.width * id.height];
                                original_id.getPixels(0, 0, original_pixels.length, original_pixels, 0);
                                int i3 = 0;
                                while (i3 < original_pixels.length) {
                                    if (original_pixels[i3] == original_id.transparentPixel) {
                                        alphaData[i3] = 0;
                                    }
                                    ++i3;
                                }
                            }
                            int i4 = 0;
                            while (i4 < pixels.length) {
                                int pixel = pixels[i4];
                                int red = pixel & redMask;
                                red = redShift < 0 ? red >>> -redShift : red << redShift;
                                int green = pixel & greenMask;
                                green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                                int blue = pixel & blueMask;
                                blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                                int rgb = red << 16 | green << 8 | blue;
                                if (rgb == max_rgb) {
                                    pixels[i4] = to_rgb;
                                }
                                ++i4;
                            }
                            id.setPixels(0, 0, pixels.length, pixels, 0);
                            result = new Image(basis.getDevice(), id);
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        this.releaseImage(basisKey);
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    this.releaseImage(basisKey);
                    throw throwable;
                }
                this.releaseImage(basisKey);
            }
        }
        if (result == null) {
            result = ImageLoader.getNoImage(sKey);
        }
        ImageLoaderRefInfo info = new ImageLoaderRefInfo(new Image[]{result});
        this.putRefInfoToImageMap(sKey, info);
        return result;
    }

    private Image getImageSupport(String sKey) {
        Image[] images = this.getImages(sKey);
        if (images == null || images.length == 0 || images[0] == null || images[0].isDisposed()) {
            return ImageLoader.getNoImage(sKey);
        }
        return images[0];
    }

    public long releaseImage(String sKey) {
        if (sKey == null) {
            return 0L;
        }
        ImageLoaderRefInfo imageInfo = this.getRefInfoFromImageMap(sKey);
        if (imageInfo != null) {
            imageInfo.unref();
            return imageInfo.getRefCount();
        }
        return 0L;
    }

    public void addImage(String key, Image image) {
        if (!Utils.isThisThreadSWT()) {
            Debug.out("addImage called on non-SWT thread");
            return;
        }
        ImageLoaderRefInfo existing = this.putIfAbsentRefInfoToImageMap(key, new ImageLoaderRefInfo(image));
        if (existing != null) {
            existing.setImages(new Image[]{image});
            existing.addref();
        }
    }

    public void addImage(String key, Image[] images) {
        if (!Utils.isThisThreadSWT()) {
            Debug.out("addImage called on non-SWT thread");
            return;
        }
        ImageLoaderRefInfo existing = this.putIfAbsentRefInfoToImageMap(key, new ImageLoaderRefInfo(images));
        if (existing != null) {
            existing.setImages(images);
            existing.addref();
        }
    }

    private void logRefCount(String key, ImageLoaderRefInfo info, boolean inc) {
        if (info.isNonDisposable()) {
            return;
        }
        if (inc) {
            System.out.println("ImageLoader: ++ refcount to " + info.getRefCount() + " for " + key + " via " + Debug.getCompressedStackTraceSkipFrames(1));
        } else {
            System.out.println("ImageLoader: -- refcount to " + info.getRefCount() + " for " + key + " via " + Debug.getCompressedStackTraceSkipFrames(1));
        }
    }

    public void addImageNoDipose(String key, Image image) {
        if (!Utils.isThisThreadSWT()) {
            Debug.out("addImageNoDispose called on non-SWT thread");
            return;
        }
        ImageLoaderRefInfo existing = this.putIfAbsentRefInfoToImageMap(key, new ImageLoaderRefInfo(image));
        if (existing != null) {
            existing.setNonDisposable();
            existing.setImages(new Image[]{image});
            existing.addref();
        }
    }

    public static Image getNoImage() {
        return ImageLoader.getNoImage("explicit");
    }

    private static Image getNoImage(String key) {
        if (noImage == null) {
            Display display = Display.getDefault();
            int SIZE = 10;
            noImage = new Image((Device)display, 10, 10);
            GC gc = new GC((Drawable)noImage);
            gc.setBackground(Colors.getSystemColor((Device)display, 7));
            gc.fillRectangle(0, 0, 10, 10);
            gc.setBackground(Colors.getSystemColor((Device)display, 3));
            gc.drawRectangle(0, 0, 9, 9);
            gc.dispose();
        }
        return noImage;
    }

    private Image getNullImage() {
        if (nullImage == null) {
            Display display = Display.getDefault();
            boolean SIZE = true;
            nullImage = new Image((Device)display, 1, 1);
        }
        return nullImage;
    }

    public boolean imageExists(String name) {
        Image[] images;
        ImageLoaderRefInfo refInfoFromImageMap = this.getRefInfoFromImageMap(name);
        if (refInfoFromImageMap != null && (images = refInfoFromImageMap.getImages()) != null && images.length > 0 && ImageLoader.isRealImage(images[0])) {
            return true;
        }
        boolean exists = ImageLoader.isRealImage(this.getImage(name));
        this.releaseImage(name);
        return exists;
    }

    public Image[] imageAdded_NoSWT(String name) {
        ImageLoaderRefInfo info = this._mapImages.get(name);
        if (info != null) {
            return info.getImages();
        }
        return null;
    }

    public boolean imageAdded(String name) {
        Image[] images = this.getImages(name);
        boolean added = images != null && images.length > 0;
        this.releaseImage(name);
        return added;
    }

    public static boolean isRealImage(Image image) {
        if (image == null || image.isDisposed()) {
            return false;
        }
        if (noImage != null) {
            return image != noImage;
        }
        return image != ImageLoader.getNoImage(null);
    }

    public int getAnimationDelay(String sKey) {
        for (SkinProperties sp : this.skinProperties) {
            int delay = sp.getIntValue(String.valueOf(sKey) + ".delay", -1);
            if (delay < 0) continue;
            return delay;
        }
        return 100;
    }

    public Image getUrlImage(String url, ImageDownloaderListener l) {
        return this.getUrlImage(url, null, l);
    }

    public Image getUrlImage(String url, Point maxSize, ImageDownloaderListener l) {
        if (l == null || url == null) {
            Debug.out("eh");
            return null;
        }
        if (!Utils.isThisThreadSWT()) {
            Utils.execSWTThread(() -> this.getUrlImage(url, maxSize, l));
            return null;
        }
        String imageKey = url;
        return this.getUrlImageSupport(url, imageKey, maxSize, l);
    }

    public Image getFileImage(File file, Point maxSize, ImageDownloaderListener l) {
        if (!Utils.isThisThreadSWT()) {
            Debug.out("Called on non-SWT thread");
            return null;
        }
        if (l == null || file == null) {
            return null;
        }
        try {
            String url;
            String imageKey = url = file.toURI().toURL().toExternalForm();
            long lastModified = file.lastModified();
            if (lastModified > 0L) {
                imageKey = String.valueOf(imageKey) + ";" + lastModified;
            }
            return this.getUrlImageSupport(url, imageKey, maxSize, l);
        }
        catch (MalformedURLException e) {
            Debug.out(e);
            return null;
        }
    }

    private Image getUrlImageSupport(String url, String baseImageKey, final Point maxSize, final ImageDownloaderListener l) {
        final String sizedImageKey = maxSize == null ? baseImageKey : String.valueOf(maxSize.x) + "x" + maxSize.y + ";" + baseImageKey;
        ImageLoaderRefInfo refInfoFromImageMap = this.getRefInfoFromImageMap(sizedImageKey);
        if (refInfoFromImageMap != null) {
            Image[] images = refInfoFromImageMap.getImages();
            if (images == null || images.length == 0) {
                return null;
            }
            Image image = images[0];
            refInfoFromImageMap.addref();
            l.imageDownloaded(image, sizedImageKey, true);
            return image;
        }
        final String cache_key = String.valueOf(baseImageKey.hashCode()) + ".ico";
        final File cache_file = new File(this.cache_dir, cache_key);
        if (this.cached_resources.contains(cache_key)) {
            if (cache_file.exists()) {
                Image image;
                FileInputStream fis = new FileInputStream(cache_file);
                try {
                    Image newImage;
                    byte[] imageBytes = FileUtil.readInputStreamAsByteArray(fis);
                    ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);
                    Image image2 = new Image((Device)Display.getCurrent(), (InputStream)is);
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (maxSize != null && (newImage = this.resizeImageIfLarger(image2, maxSize)) != null) {
                        image2.dispose();
                        image2 = newImage;
                    }
                    this.putRefInfoToImageMap(sizedImageKey, new ImageLoaderRefInfo(image2));
                    l.imageDownloaded(image2, sizedImageKey, true);
                    image = image2;
                }
                catch (Throwable throwable) {
                    try {
                        fis.close();
                        throw throwable;
                    }
                    catch (Throwable e) {
                        System.err.println(String.valueOf(e.getMessage()) + " for " + url + " at " + cache_file);
                    }
                }
                fis.close();
                return image;
            } else {
                this.cached_resources.remove(cache_key);
            }
        }
        ImageBytesDownloader.loadImage(url, new ImageBytesDownloader.ImageDownloaderListener(){

            @Override
            public void imageDownloaded(final byte[] imageBytes) {
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        ImageLoaderRefInfo refInfoFromImageMap = ImageLoader.this.getRefInfoFromImageMap(sizedImageKey);
                        if (refInfoFromImageMap != null) {
                            Image[] images = refInfoFromImageMap.getImages();
                            if (images == null || images.length == 0) {
                                return;
                            }
                            Image image = images[0];
                            refInfoFromImageMap.addref();
                            l.imageDownloaded(image, sizedImageKey, true);
                            return;
                        }
                        FileUtil.writeBytesAsFile(cache_file.getAbsolutePath(), imageBytes);
                        ImageLoader.this.cached_resources.add(cache_key);
                        ByteArrayInputStream is = new ByteArrayInputStream(imageBytes);
                        try {
                            Image newImage;
                            Image image = new Image((Device)Display.getCurrent(), (InputStream)is);
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (maxSize != null && (newImage = ImageLoader.this.resizeImageIfLarger(image, maxSize)) != null) {
                                image.dispose();
                                image = newImage;
                            }
                            ImageLoader.this.putRefInfoToImageMap(sizedImageKey, new ImageLoaderRefInfo(image));
                            l.imageDownloaded(image, sizedImageKey, false);
                        }
                        catch (SWTException swte) {
                            System.err.println(String.valueOf(swte.getMessage()) + " for " + sizedImageKey + " at " + cache_file);
                        }
                    }
                });
            }
        });
        return null;
    }

    public Image resizeImageIfLarger(Image image, Point maxSize) {
        if (image == null || image.isDisposed()) {
            return null;
        }
        Rectangle bounds = image.getBounds();
        if (maxSize.y > 0 && bounds.height > maxSize.y) {
            int newX = Math.max(1, bounds.width * maxSize.y / bounds.height);
            if (maxSize.x <= 0 || newX <= maxSize.x) {
                ImageData scaledTo = image.getImageData().scaledTo(newX, maxSize.y);
                Device device = image.getDevice();
                return new Image(device, scaledTo);
            }
        }
        if (maxSize.x > 0 && bounds.width > maxSize.x) {
            int newY = Math.max(1, bounds.height * maxSize.x / bounds.width);
            ImageData scaledTo = image.getImageData().scaledTo(maxSize.x, newY);
            Device device = image.getDevice();
            return new Image(device, scaledTo);
        }
        return null;
    }

    public InputStream getImageStream(String sKey) {
        String[] locations = null;
        ClassLoader cl = null;
        for (SkinProperties sp : this.skinProperties) {
            locations = sp.getStringArray(sKey);
            if (locations == null || locations.length <= 0) continue;
            cl = sp.getClassLoader();
            break;
        }
        if (locations != null) {
            return cl.getResourceAsStream(locations[locations.length - 1]);
        }
        return null;
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println("ImageLoader for " + this.skinProperties);
        writer.indent();
        long[] sizeCouldBeFree = new long[1];
        long[] totalSizeEstimate = new long[1];
        try {
            writer.indent();
            try {
                ImageLoaderRefInfo info;
                writer.println("Non-Disposable:");
                writer.indent();
                for (String key : this._mapImages.keySet()) {
                    info = this._mapImages.get(key);
                    if (!info.isNonDisposable()) continue;
                    this.writeEvidenceLine(writer, key, info, totalSizeEstimate, sizeCouldBeFree);
                }
                writer.exdent();
                writer.println("Disposable:");
                writer.indent();
                for (String key : this._mapImages.keySet()) {
                    info = this._mapImages.get(key);
                    if (info.isNonDisposable()) continue;
                    this.writeEvidenceLine(writer, key, info, totalSizeEstimate, sizeCouldBeFree);
                }
                writer.exdent();
            }
            finally {
                writer.exdent();
            }
            if (totalSizeEstimate[0] > 0L) {
                writer.println(String.valueOf(totalSizeEstimate[0] / 1024L) + "k estimated used for images");
            }
            if (sizeCouldBeFree[0] > 0L) {
                writer.println(String.valueOf(sizeCouldBeFree[0] / 1024L) + "k could be freed");
            }
        }
        finally {
            writer.exdent();
        }
    }

    private void writeEvidenceLine(IndentWriter writer, String key, ImageLoaderRefInfo info, long[] totalSizeEstimate, long[] sizeCouldBeFree) {
        String line = String.valueOf(info.getRefCount()) + "] " + key;
        if (Utils.isThisThreadSWT()) {
            long sizeEstimate = 0L;
            Image[] images = info.getImages();
            int i = 0;
            while (i < images.length) {
                Image img = images[i];
                if (img != null) {
                    if (img.isDisposed()) {
                        line = String.valueOf(line) + "; *DISPOSED*";
                    } else {
                        Rectangle bounds = img.getBounds();
                        long est = (long)(bounds.width * bounds.height) * 4L;
                        sizeEstimate += est;
                        totalSizeEstimate[0] = totalSizeEstimate[0] + est;
                        if (info.canDispose()) {
                            sizeCouldBeFree[0] = sizeCouldBeFree[0] + est;
                        }
                    }
                }
                ++i;
            }
            line = String.valueOf(line) + "; est " + sizeEstimate + " bytes";
        }
        writer.println(line);
    }

    public void addSkinProperties(SkinProperties skinProperties) {
        if (skinProperties == null) {
            return;
        }
        this.skinProperties.add(skinProperties);
        this.disabledOpacity = skinProperties.getIntValue("imageloader.disabled-opacity", -1);
        this.notFound.clear();
    }

    public boolean collectGarbage() {
        if (Utils.isDisplayDisposed()) {
            return false;
        }
        return Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                int numRemoved = 0;
                Iterator iter = ((ConcurrentHashMap.KeySetView)ImageLoader.this._mapImages.keySet()).iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    ImageLoaderRefInfo info = (ImageLoaderRefInfo)ImageLoader.this._mapImages.get(key);
                    if (info == null || !info.canDispose()) continue;
                    iter.remove();
                    ++numRemoved;
                    Image[] images = info.getImages();
                    if (images == null) continue;
                    int j = 0;
                    while (j < images.length) {
                        Image image = images[j];
                        if (ImageLoader.isRealImage(image) && image != nullImage) {
                            image.dispose();
                        }
                        ++j;
                    }
                }
            }
        });
    }

    public void setLabelImage(Label label, String key) {
        if (key == null || label == null || label.isDisposed()) {
            return;
        }
        Image bg = this.getImage(key);
        if (!ImageLoader.isRealImage(bg)) {
            return;
        }
        label.setImage(bg);
        label.addDisposeListener(e -> {
            long l = this.releaseImage(key);
        });
    }

    public Image setButtonImage(Button btn, final String key) {
        Image bg = this.getImage(key);
        btn.setImage(bg);
        btn.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageLoader.this.releaseImage(key);
            }
        });
        return bg;
    }

    public Image setToolItemImage(ToolItem btn, String key) {
        Image bg = this.getImage(key);
        btn.setImage(bg);
        btn.addDisposeListener(e -> {
            long l = this.releaseImage(key);
        });
        return bg;
    }

    public void setBackgroundImage(Control control, final String key) {
        Image bg = this.getImage(key);
        control.setBackgroundImage(bg);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageLoader.this.releaseImage(key);
            }
        });
    }

    public SkinProperties[] getSkinProperties() {
        return this.skinProperties.toArray(new SkinProperties[0]);
    }

    public String findImageID(Image imageToFind) {
        String id = null;
        for (String key : this._mapImages.keySet()) {
            Image[] images = this._mapImages.get(key).getImages();
            if (images == null) continue;
            Image[] imageArray = images;
            int n = images.length;
            int n2 = 0;
            while (n2 < n) {
                Image image = imageArray[n2];
                if (image == imageToFind) {
                    id = id == null ? key : String.valueOf(id) + ", " + key;
                }
                ++n2;
            }
        }
        return id;
    }

    public static Object[] findWidgetWithDisposedImage(Composite c) {
        Control[] children;
        if (c == null) {
            return null;
        }
        Image img = c.getBackgroundImage();
        if (img != null && img.isDisposed()) {
            return new Object[]{c, img};
        }
        Control[] controlArray = children = c.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] findMore;
            Control child = controlArray[n2];
            if (child instanceof Composite && (findMore = ImageLoader.findWidgetWithDisposedImage((Composite)child)) != null) {
                return findMore;
            }
            img = child.getBackgroundImage();
            if (img != null && img.isDisposed()) {
                return new Object[]{child, img};
            }
            if (child instanceof Button ? (img = ((Button)child).getImage()) != null && img.isDisposed() : child instanceof Label && (img = ((Label)child).getImage()) != null && img.isDisposed()) {
                return new Object[]{child, img};
            }
            ++n2;
        }
        return null;
    }

    public static String getBadDisposalDetails(Throwable e, Composite startAt) {
        try {
            if (e instanceof SWTException && e.getMessage().equals("Graphic is disposed")) {
                Object[] badBoys;
                if (startAt == null) {
                    startAt = Utils.findAnyShell();
                }
                if ((badBoys = ImageLoader.findWidgetWithDisposedImage(startAt)) != null) {
                    String imageID = ImageLoader.getInstance().findImageID((Image)badBoys[1]);
                    return "Disposed Graphic id is " + (imageID == null ? "(not found)" : imageID) + ", parent is " + badBoys[0] + "; firstData=" + ((Widget)badBoys[0]).getData();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static interface ImageDownloaderListener {
        public void imageDownloaded(Image var1, String var2, boolean var3);
    }
}

