/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.mainwindow;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnableObject;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.PluginInterface;
import com.biglybt.ui.swt.Utils;
import java.util.LinkedList;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ClipboardCopy {
    private static String MENU_ITEM_KEY = "ClipboardCopy.mi";
    private static String MOUSE_LISTENER_KEY = "ClipboardCopy.ml";
    private static LinkedList<Object[]> history = new LinkedList();

    public static void copyToClipBoard(String data) {
        ClipboardCopy.copyToClipBoard(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToClipBoard(String data, PluginInterface originator) {
        LinkedList<Object[]> linkedList = history;
        synchronized (linkedList) {
            history.add(new Object[]{data, originator});
            if (history.size() > 32) {
                history.removeLast();
            }
        }
        Utils.execSWTThread(() -> new Clipboard(Utils.getDisplay()).setContents(new Object[]{data.replaceAll("\\x00", " ")}, new Transfer[]{TextTransfer.getInstance()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginInterface getOriginator(String text) {
        if (text != null) {
            LinkedList<Object[]> linkedList = history;
            synchronized (linkedList) {
                for (Object[] entry : history) {
                    if (!text.equals((String)entry[0])) continue;
                    return (PluginInterface)entry[1];
                }
            }
        }
        return null;
    }

    public static String copyFromClipboard() {
        if (Utils.isSWTThread()) {
            Clipboard clipboard = new Clipboard(Display.getDefault());
            String text = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
            clipboard.dispose();
            return text;
        }
        return (String)Utils.execSWTThreadWithObject("copyFromClipboard", new AERunnableObject(){

            @Override
            public Object runSupport() {
                Clipboard clipboard = new Clipboard(Display.getDefault());
                String text = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                clipboard.dispose();
                return text;
            }
        }, 10000L);
    }

    public static void addCopyToClipMenu(final Control control, final copyToClipProvider provider) {
        MouseAdapter ml = (MouseAdapter)control.getData(MOUSE_LISTENER_KEY);
        if (ml != null) {
            control.removeMouseListener((MouseListener)ml);
        }
        ml = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (control.isDisposed()) {
                    return;
                }
                final String text = provider.getText();
                if (text == null || text.length() == 0) {
                    return;
                }
                Menu temp = control.getMenu();
                if (temp != null) {
                    MenuItem[] items = temp.getItems();
                    if (items.length == 0) {
                        temp.dispose();
                    } else {
                        return;
                    }
                }
                if (e.button != 3 && (e.button != 1 || e.stateMask != 262144)) {
                    return;
                }
                final Menu menu = new Menu((Decorations)control.getShell(), 8);
                MenuItem item = new MenuItem(menu, 0);
                item.setData(MENU_ITEM_KEY, (Object)"");
                String msg_text_id = provider instanceof copyToClipProvider2 ? ((copyToClipProvider2)provider).getMenuResource() : "label.copy.to.clipboard";
                item.setText(MessageText.getString(msg_text_id));
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent arg0) {
                        new Clipboard(control.getDisplay()).setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
                    }
                });
                control.setMenu(menu);
                menu.addMenuListener((MenuListener)new MenuAdapter(){

                    public void menuHidden(MenuEvent arg0) {
                        if (control.getMenu() == menu) {
                            control.setMenu(null);
                        }
                    }
                });
                menu.setVisible(true);
            }
        };
        control.setData(MOUSE_LISTENER_KEY, (Object)ml);
        control.addMouseListener((MouseListener)ml);
    }

    public static void addCopyToClipMenu(final Menu menu, final String text) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem e = menuItemArray[n2];
            if (e.getData(MENU_ITEM_KEY) != null) {
                e.dispose();
            }
            ++n2;
        }
        MenuItem item = new MenuItem(menu, 0);
        item.setData(MENU_ITEM_KEY, (Object)"");
        String msg_text_id = "label.copy.to.clipboard";
        item.setText(MessageText.getString(msg_text_id));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                new Clipboard(menu.getDisplay()).setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
            }
        });
    }

    public static void addCopyToClipMenu(Menu menu, copyToClipProvider provider) {
        ClipboardCopy.addCopyToClipMenu(menu, "label.copy.to.clipboard", provider);
    }

    public static void addCopyToClipMenu(final Menu menu, String resource_key, final copyToClipProvider provider) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem e = menuItemArray[n2];
            if (e.getData(MENU_ITEM_KEY) != null) {
                e.dispose();
            }
            ++n2;
        }
        MenuItem item = new MenuItem(menu, 0);
        item.setData(MENU_ITEM_KEY, (Object)"");
        item.setText(MessageText.getString(resource_key));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                new Clipboard(menu.getDisplay()).setContents(new Object[]{provider.getText()}, new Transfer[]{TextTransfer.getInstance()});
            }
        });
    }

    public static void removeCopyToClipMenu(Menu menu) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem e = menuItemArray[n2];
            if (e.getData(MENU_ITEM_KEY) != null) {
                e.dispose();
            }
            ++n2;
        }
    }

    public static void addCopyToClipMenu(final Control control) {
        ClipboardCopy.addCopyToClipMenu(control, new copyToClipProvider(){

            @Override
            public String getText() {
                Object o = control.getData();
                if (o instanceof String) {
                    return (String)o;
                }
                if (o instanceof String[]) {
                    String[] strs = (String[])o;
                    String str = "";
                    String[] stringArray = strs;
                    int n = strs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        str = String.valueOf(str) + (str.isEmpty() ? "" : ", ") + s;
                        ++n2;
                    }
                    return str;
                }
                if (control instanceof Label) {
                    return ((Label)control).getText();
                }
                if (control instanceof Link) {
                    String text = ((Link)control).getText();
                    String url = UrlUtils.parseTextForURL(text, false);
                    if (url != null && !url.isEmpty()) {
                        return url;
                    }
                    return text;
                }
                return String.valueOf(o);
            }
        });
    }

    public static void removeCopyToClipMenu(Control control) {
        MouseAdapter ml = (MouseAdapter)control.getData(MOUSE_LISTENER_KEY);
        if (ml != null) {
            control.removeMouseListener((MouseListener)ml);
        }
    }

    public static interface copyToClipProvider {
        public String getText();
    }

    public static interface copyToClipProvider2
    extends copyToClipProvider {
        public String getMenuResource();
    }
}

