/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.mainwindow;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryManager;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.internat.LocaleTorrentUtil;
import com.biglybt.core.internat.LocaleUtilDecoder;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.speedmanager.SpeedLimitHandler;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SHA1Simple;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.pif.ui.tables.TableRowMouseListener;
import com.biglybt.pif.update.Update;
import com.biglybt.pif.update.UpdateCheckInstance;
import com.biglybt.pif.update.UpdateCheckInstanceListener;
import com.biglybt.pif.update.UpdateChecker;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.pifimpl.local.download.DownloadManagerImpl;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.table.impl.TableContextMenuManager;
import com.biglybt.ui.common.util.MenuItemManager;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.BlockedIpsWindow;
import com.biglybt.ui.swt.KeyBindings;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.TextViewerWindow;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.beta.BetaWizard;
import com.biglybt.ui.swt.components.shell.ShellManager;
import com.biglybt.ui.swt.config.wizard.ConfigureWizard;
import com.biglybt.ui.swt.debug.UIDebugGenerator;
import com.biglybt.ui.swt.donations.DonationWindow;
import com.biglybt.ui.swt.exporttorrent.wizard.ExportTorrentWizard;
import com.biglybt.ui.swt.help.AboutWindow;
import com.biglybt.ui.swt.importtorrent.wizard.ImportTorrentWizard;
import com.biglybt.ui.swt.mainwindow.IMainWindow;
import com.biglybt.ui.swt.mainwindow.IMenuConstants;
import com.biglybt.ui.swt.mainwindow.ListenerNeedingCoreRunning;
import com.biglybt.ui.swt.mainwindow.PluginsMenuHelper;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.maketorrent.NewTorrentWizard;
import com.biglybt.ui.swt.minibar.AllTransfersBar;
import com.biglybt.ui.swt.minibar.MiniBarManager;
import com.biglybt.ui.swt.nat.NatTestWindow;
import com.biglybt.ui.swt.plugininstaller.InstallPluginWizard;
import com.biglybt.ui.swt.pluginsuninstaller.UnInstallPluginWizard;
import com.biglybt.ui.swt.sharing.ShareUtils;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.speedtest.SpeedTestWizard;
import com.biglybt.ui.swt.update.UpdateMonitor;
import com.biglybt.ui.swt.views.stats.StatsView;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import com.biglybt.ui.swt.welcome.WelcomeWindow;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class MenuFactory
implements IMenuConstants {
    private static boolean isAZ3 = "az3".equalsIgnoreCase(COConfigurationManager.getStringParameter("ui"));
    private static final boolean DEBUG_SET_FOREGROUND = System.getProperty("debug.setforeground") != null;

    public static MenuItem createFileMenuItem(Menu menuParent) {
        return MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.file");
    }

    public static MenuItem createTransfersMenuItem(Menu menuParent) {
        MenuItem transferMenuItem = MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.transfers");
        Menu transferMenu = transferMenuItem.getMenu();
        MenuFactory.addStartAllMenuItem(transferMenu);
        MenuFactory.addStopAllMenuItem(transferMenu);
        final MenuItem itemPause = MenuFactory.addPauseMenuItem(transferMenu);
        MenuItem itemPauseFor = MenuFactory.addPauseForMenuItem(transferMenu);
        final MenuItem itemResume = MenuFactory.addResumeMenuItem(transferMenu);
        transferMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent menu) {
                if (!CoreFactory.isCoreRunning()) {
                    itemPause.setEnabled(true);
                    itemResume.setEnabled(true);
                } else {
                    Core core = CoreFactory.getSingleton();
                    itemPause.setEnabled(core.getGlobalManager().canPauseDownloads());
                    itemResume.setEnabled(core.getGlobalManager().canResumeDownloads());
                }
            }

            public void menuHidden(MenuEvent menu) {
                itemPause.setEnabled(true);
                itemResume.setEnabled(true);
            }
        });
        return transferMenuItem;
    }

    public static MenuItem createViewMenuItem(Menu menuParent) {
        return MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.view");
    }

    public static void createCommunityMenuItem(Menu menuParent) {
        final Menu communityMenu = MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.community").getMenu();
        MenuBuildUtils.addMaintenanceListenerForMenu(communityMenu, new MenuBuildUtils.MenuBuilder(){

            @Override
            public void buildMenu(Menu menu, MenuEvent menuEvent) {
                MenuFactory.addMenuItem(communityMenu, "MainWindow.menu.community.forums", new Listener(){

                    public void handleEvent(Event e) {
                        Utils.launch("https://forums.biglybt.com/");
                    }
                });
                MenuFactory.addMenuItem(communityMenu, "MainWindow.menu.community.wiki", new Listener(){

                    public void handleEvent(Event e) {
                        Utils.launch("https://wiki.biglybt.com/");
                    }
                });
                MenuBuildUtils.addCommunityChatMenu(communityMenu);
                MenuFactory.addVoteMenuItem(communityMenu);
                MenuFactory.addBugReportMenuItem(communityMenu);
            }
        });
    }

    public static Menu createTorrentMenuItem(Menu menuParent) {
        Menu torrentMenu = MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.torrent").getMenu();
        MenuBuildUtils.addMaintenanceListenerForMenu(torrentMenu, new MenuBuildUtils.MenuBuilder(){

            @Override
            public void buildMenu(Menu menu, MenuEvent menuEvent) {
                MenuFactory.buildTorrentMenu(menu);
            }
        });
        return torrentMenu;
    }

    public static void buildTorrentMenu(Menu menu) {
        DownloadManager[] current_dls = (DownloadManager[])menu.getData("downloads");
        if ((current_dls = ManagerUtils.cleanUp(current_dls)).length == 0) {
            return;
        }
        if (CoreFactory.isCoreRunning()) {
            boolean is_detailed_view = (Boolean)menu.getData("is_detailed_view");
            TableViewSWT tv = (TableViewSWT)menu.getData("TableView");
            Core core = CoreFactory.getSingleton();
            TorrentUtil.fillTorrentMenu(menu, current_dls, core, !is_detailed_view, 0, tv);
        }
        com.biglybt.pif.ui.menus.MenuItem[] menu_items = MenuItemManager.getInstance().getAllAsArray(new String[]{"torrentmenu", "download_context"});
        Object[] plugin_dls = DownloadManagerImpl.getDownloadStatic(current_dls);
        if (menu_items.length > 0) {
            MenuFactory.addSeparatorMenuItem(menu);
            MenuBuildUtils.addPluginMenuItems(menu_items, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(plugin_dls));
        }
        menu_items = null;
        String table_to_use = null;
        int i = 0;
        while (i < current_dls.length) {
            String table_name;
            String string = table_name = current_dls[i].isDownloadComplete(false) ? "MySeeders" : "MyTorrents";
            if (table_to_use != null && !table_to_use.equals(table_name)) {
                table_to_use = null;
                break;
            }
            table_to_use = table_name;
            ++i;
        }
        if (table_to_use != null) {
            menu_items = TableContextMenuManager.getInstance().getAllAsArray(table_to_use);
        }
        if (menu_items != null) {
            MenuFactory.addSeparatorMenuItem(menu);
            Object[] dls_as_rows = null;
            dls_as_rows = new TableRow[plugin_dls.length];
            int i2 = 0;
            while (i2 < plugin_dls.length) {
                dls_as_rows[i2] = MenuFactory.wrapAsRow(plugin_dls[i2], table_to_use);
                ++i2;
            }
            MenuBuildUtils.addPluginMenuItems(menu_items, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(dls_as_rows));
        }
    }

    public static MenuItem createToolsMenuItem(Menu menuParent) {
        return MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.tools");
    }

    public static MenuItem createPluginsMenuItem(Menu menuParent, boolean showPluginViews) {
        MenuItem pluginsMenuItem = MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.view.plugins");
        MenuBuildUtils.addMaintenanceListenerForMenu(pluginsMenuItem.getMenu(), (menu, menuEvent) -> PluginsMenuHelper.buildPluginMenu(menu, showPluginViews));
        return pluginsMenuItem;
    }

    public static MenuItem createWindowMenuItem(Menu menuParent) {
        return MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.window");
    }

    public static MenuItem createHelpMenuItem(Menu menuParent) {
        return MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.help");
    }

    public static MenuItem addCreateMenuItem(Menu menuParent) {
        MenuItem file_create = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.create", new Listener(){

            public void handleEvent(Event e) {
                new NewTorrentWizard(e.display);
            }
        });
        return file_create;
    }

    public static MenuItem createOpenMenuItem(Menu menuParent) {
        return MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.file.open");
    }

    public static MenuItem addLogsViewMenuItem(Menu menuParent) {
        return MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.view.plugins.logViews");
    }

    public static MenuItem addOpenTorrentMenuItem(Menu menuParent) {
        return MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.open.torrent", new Listener(){

            public void handleEvent(Event e) {
                UIFunctionsManagerSWT.getUIFunctionsSWT().openTorrentWindow();
            }
        });
    }

    public static MenuItem addOpenURIMenuItem(Menu menuParent) {
        return MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.open.uri", new Listener(){

            public void handleEvent(Event e) {
                UIFunctionsManagerSWT.getUIFunctionsSWT().openTorrentWindow();
            }
        });
    }

    public static MenuItem addOpenTorrentForTrackingMenuItem(Menu menuParent) {
        MenuItem file_new_torrent_for_tracking = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.open.torrentfortracking", new Listener(){

            public void handleEvent(Event e) {
                TorrentOpener.openTorrentTrackingOnly();
            }
        });
        return file_new_torrent_for_tracking;
    }

    public static MenuItem addSearchMenuItem(Menu menuParent) {
        MenuItem item = MenuFactory.addMenuItem(menuParent, "Button.search", new Listener(){

            public void handleEvent(Event e) {
                UIFunctionsManagerSWT.getUIFunctionsSWT().promptForSearch();
            }
        });
        return item;
    }

    public static MenuItem addOpenVuzeFileMenuItem(final Menu menuParent) {
        return MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.open.vuze", new Listener(){

            public void handleEvent(Event e) {
                Display display = menuParent.getDisplay();
                display.asyncExec((Runnable)new AERunnable(){

                    @Override
                    public void runSupport() {
                        FileDialog dialog = new FileDialog(Utils.findAnyShell(), 135168);
                        dialog.setFilterPath(TorrentOpener.getFilterPathData());
                        dialog.setText(MessageText.getString("MainWindow.dialog.select.vuze.file"));
                        dialog.setFilterExtensions(VuzeFileHandler.getVuzeFileFilterExtensions());
                        dialog.setFilterNames(VuzeFileHandler.getVuzeFileFilterExtensions());
                        final String path = TorrentOpener.setFilterPathData(dialog.open());
                        if (path != null) {
                            Utils.getOffOfSWTThread(new AERunnable(){

                                @Override
                                public void runSupport() {
                                    VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
                                    if (vfh.loadAndHandleVuzeFile(path, 0) == null) {
                                        TorrentOpener.openTorrent(path);
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    public static MenuItem createShareMenuItem(Menu menuParent) {
        MenuItem file_share = MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.file.share");
        return file_share;
    }

    public static MenuItem addShareFileMenuItem(Menu menuParent) {
        MenuItem file_share_file = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.share.file", new Listener(){

            public void handleEvent(Event e) {
                ShareUtils.shareFile(Utils.findAnyShell());
            }
        });
        return file_share_file;
    }

    public static MenuItem addShareFolderMenuItem(Menu menuParent) {
        MenuItem file_share_dir = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.share.dir", new Listener(){

            public void handleEvent(Event e) {
                ShareUtils.shareDir(Utils.findAnyShell());
            }
        });
        return file_share_dir;
    }

    public static MenuItem addShareFolderContentMenuItem(Menu menuParent) {
        MenuItem file_share_dircontents = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.share.dircontents", new Listener(){

            public void handleEvent(Event e) {
                ShareUtils.shareDirContents(Utils.findAnyShell(), false);
            }
        });
        return file_share_dircontents;
    }

    public static MenuItem addShareFolderContentRecursiveMenuItem(Menu menuParent) {
        MenuItem file_share_dircontents_rec = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.share.dircontentsrecursive", new Listener(){

            public void handleEvent(Event e) {
                ShareUtils.shareDirContents(Utils.findAnyShell(), true);
            }
        });
        return file_share_dircontents_rec;
    }

    public static MenuItem addImportMenuItem(Menu menuParent) {
        MenuItem file_import = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.import", new Listener(){

            public void handleEvent(Event e) {
                new ImportTorrentWizard();
            }
        });
        return file_import;
    }

    public static MenuItem addExportMenuItem(Menu menuParent) {
        MenuItem file_export = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.export", new Listener(){

            public void handleEvent(Event e) {
                new ExportTorrentWizard();
            }
        });
        return file_export;
    }

    public static MenuItem addCloseWindowMenuItem(Menu menuParent) {
        MenuItem closeWindow = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.file.closewindow", new Listener(){

            public void handleEvent(Event event2) {
                Shell shell = Utils.getActiveShell();
                if (shell != null && !shell.isDisposed()) {
                    shell.close();
                }
            }
        });
        return closeWindow;
    }

    public static MenuItem addCloseTabMenuItem(Menu menu) {
        final MenuItem menuItem = MenuFactory.addMenuItem(menu, "MainWindow.menu.file.closetab", new Listener(){

            public void handleEvent(Event event2) {
                MdiEntry currentEntry;
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                if (mdi != null && (currentEntry = mdi.getCurrentEntry()) != null && currentEntry.isCloseable()) {
                    mdi.closeEntry(currentEntry, true);
                }
            }
        });
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                MdiEntry currentEntry;
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                if (mdi != null && (currentEntry = mdi.getCurrentEntry()) != null && currentEntry.isCloseable()) {
                    menuItem.setEnabled(true);
                    return;
                }
                menuItem.setEnabled(false);
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        return menuItem;
    }

    public static MenuItem addCloseDetailsMenuItem(Menu menu) {
        final MenuItem item = MenuFactory.addMenuItem(menu, "MainWindow.menu.closealldetails", new Listener(){

            public void handleEvent(Event e) {
                UIFunctionsManagerSWT.getUIFunctionsSWT().closeAllDetails();
            }
        });
        Listener enableHandler = new Listener(){

            public void handleEvent(Event event2) {
                if (MenuFactory.isEnabledForCurrentMode((Widget)item) && !item.isDisposed() && !event2.widget.isDisposed()) {
                    boolean hasDetails = UIFunctionsManagerSWT.getUIFunctionsSWT().hasDetailViews();
                    item.setEnabled(hasDetails);
                }
            }
        };
        menu.addListener(22, enableHandler);
        return item;
    }

    public static MenuItem addCloseDownloadBarsToMenu(Menu menu) {
        final MenuItem item = MenuFactory.addMenuItem(menu, "MainWindow.menu.closealldownloadbars", new Listener(){

            public void handleEvent(Event e) {
                MiniBarManager.getManager().closeAll();
            }
        });
        Listener enableHandler = new Listener(){

            public void handleEvent(Event event2) {
                if (!item.isDisposed()) {
                    item.setEnabled(!MiniBarManager.getManager().getShellManager().isEmpty());
                }
            }
        };
        menu.addListener(22, enableHandler);
        return item;
    }

    public static MenuItem addRestartMenuItem(Menu menuParent) {
        MenuItem file_restart = new MenuItem(menuParent, 0);
        Messages.setLanguageText((Widget)file_restart, "MainWindow.menu.file.restart");
        file_restart.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                UIFunctionsManagerSWT.getUIFunctionsSWT().dispose(true);
            }
        });
        return file_restart;
    }

    public static MenuItem addExitMenuItem(Menu menuParent) {
        MenuItem file_exit = new MenuItem(menuParent, 0);
        if (!COConfigurationManager.getBooleanParameter("Enable System Tray") || !COConfigurationManager.getBooleanParameter("Close To Tray")) {
            KeyBindings.setAccelerator(file_exit, "MainWindow.menu.file.exit");
        }
        Messages.setLanguageText((Widget)file_exit, "MainWindow.menu.file.exit");
        file_exit.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UIFunctionsManagerSWT.getUIFunctionsSWT().dispose(false);
            }
        });
        return file_exit;
    }

    public static MenuItem addStartAllMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.transfers.startalltransfers", new ListenerNeedingCoreRunning(){

            @Override
            public void handleEvent(Core core, Event e) {
                core.getGlobalManager().startAllDownloads();
            }
        });
    }

    public static MenuItem addStopAllMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.transfers.stopalltransfers", new Listener(){

            public void handleEvent(Event event2) {
                ManagerUtils.asyncStopAll();
            }
        });
    }

    public static MenuItem addPauseMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.transfers.pausetransfers", new Listener(){

            public void handleEvent(Event event2) {
                ManagerUtils.asyncPause();
            }
        });
    }

    public static MenuItem addPauseForMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.transfers.pausetransfersfor", new ListenerNeedingCoreRunning(){

            @Override
            public void handleEvent(Core core, Event event2) {
                String text = MessageText.getString("dialog.pause.for.period.text");
                int rem = core.getGlobalManager().getPauseDownloadPeriodRemaining();
                if (rem > 0) {
                    text = String.valueOf(text) + "\n\n" + MessageText.getString("dialog.pause.for.period.text2", new String[]{TimeFormatter.format2(rem, true)});
                }
                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("dialog.pause.for.period.title", "!" + text + "!");
                int def = COConfigurationManager.getIntParameter("pause.for.period.default", 10);
                entryWindow.setPreenteredText(String.valueOf(def), false);
                entryWindow.prompt(new UIInputReceiverListener(){

                    @Override
                    public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                        if (!entryWindow.hasSubmittedInput()) {
                            return;
                        }
                        String sReturn = entryWindow.getSubmittedInput();
                        if (sReturn == null) {
                            return;
                        }
                        int mins = -1;
                        try {
                            mins = Integer.valueOf(sReturn);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (mins <= 0) {
                            MessageBox mb = new MessageBox(Utils.findAnyShell(), 33);
                            mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                            mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                            mb.open();
                            return;
                        }
                        COConfigurationManager.setParameter("pause.for.period.default", mins);
                        ManagerUtils.asyncPauseForPeriod(mins * 60);
                    }
                });
            }
        });
    }

    public static MenuItem addResumeMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.transfers.resumetransfers", new Listener(){

            public void handleEvent(Event event2) {
                ManagerUtils.asyncResume();
            }
        });
    }

    public static MenuItem addMyTorrentsMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.mytorrents", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.getMDI().showEntryByID("Library");
                }
            }
        });
    }

    public static MenuItem addAllPeersMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.allpeers", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.getMDI().showEntryByID("AllPeersView");
                }
            }
        });
    }

    public static MenuItem addAllPiecesMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.allpieces", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.getMDI().showEntryByID("AllPiecesView");
                }
            }
        });
    }

    public static MenuItem addAllBlocksMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.allblocks", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.getMDI().showEntryByID("AllBlocksView");
                }
            }
        });
    }

    public static MenuItem addClientStatsMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.clientstats", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.getMDI().showEntryByID("ClientStatsView");
                }
            }
        });
    }

    public static MenuItem addDeviceManagerMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.devicemanager", new Listener(){

            public void handleEvent(Event e) {
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                mdi.showEntryByID("Devices");
            }
        });
    }

    public static MenuItem addSubscriptionMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "subscriptions.view.title", new Listener(){

            public void handleEvent(Event e) {
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                mdi.showEntryByID("Subscriptions");
            }
        });
    }

    public static MenuItem addMyTrackerMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.mytracker", new Listener(){

            public void handleEvent(Event e) {
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                mdi.showEntryByID("MyTrackerView");
            }
        });
    }

    public static MenuItem addMySharesMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.myshares", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.getMDI().showEntryByID("MySharesView");
                }
            }
        });
    }

    public static MenuItem addViewToolbarMenuItem(Menu menu) {
        final MenuItem item = MenuFactory.addMenuItem(menu, 32, isAZ3 ? "MainWindow.menu.view.searchbar" : "MainWindow.menu.view.iconbar", new Listener(){

            public void handleEvent(Event e) {
                UIFunctionsSWT uiFunctions = MenuFactory.getUIFunctionSWT();
                if (uiFunctions != null) {
                    IMainWindow mainWindow;
                    boolean isToolbarVisible = (mainWindow = uiFunctions.getMainWindow()).isVisible(2);
                    mainWindow.setVisible(2, !isToolbarVisible);
                }
            }
        });
        final ParameterListener listener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                item.setSelection(COConfigurationManager.getBooleanParameter(parameterName));
            }
        };
        COConfigurationManager.addAndFireParameterListener("IconBar.enabled", listener);
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                COConfigurationManager.removeParameterListener("IconBar.enabled", listener);
            }
        });
        return item;
    }

    public static MenuItem addTransferBarToMenu(final Menu menu) {
        final MenuItem item = MenuFactory.addMenuItem(menu, 32, "MainWindow.menu.view.open_global_transfer_bar", new ListenerNeedingCoreRunning(){

            @Override
            public void handleEvent(Core core, Event e) {
                if (AllTransfersBar.getManager().isOpen(core.getGlobalManager())) {
                    AllTransfersBar.closeAllTransfersBar();
                } else {
                    AllTransfersBar.open(Utils.findAnyShell());
                }
            }
        });
        item.setSelection(!MiniBarManager.getManager().getShellManager().isEmpty());
        menu.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                if (item.isDisposed()) {
                    menu.removeListener(22, (Listener)this);
                } else {
                    item.setSelection(!MiniBarManager.getManager().getShellManager().isEmpty());
                }
            }
        });
        return item;
    }

    public static MenuItem addSpeedLimitsToMenu(Menu menuParent) {
        MenuItem speedLimitsMenuItem = MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.speed_limits");
        MenuBuildUtils.addMaintenanceListenerForMenu(speedLimitsMenuItem.getMenu(), new MenuBuildUtils.MenuBuilder(){

            @Override
            public void buildMenu(Menu menu, MenuEvent menuEvent) {
                if (CoreFactory.isCoreRunning()) {
                    Core core = CoreFactory.getSingleton();
                    final SpeedLimitHandler slh = SpeedLimitHandler.getSingleton(core);
                    MenuItem viewCurrentItem = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)viewCurrentItem, "MainWindow.menu.speed_limits.view_current");
                    viewCurrentItem.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            Utils.showText("MainWindow.menu.speed_limits.info.title", "MainWindow.menu.speed_limits.info.curr", slh.getCurrent());
                        }
                    });
                    List<String> profiles = slh.getProfileNames();
                    Menu profiles_menu = new Menu((Decorations)Utils.findAnyShell(), 4);
                    MenuItem profiles_item = new MenuItem(menu, 64);
                    profiles_item.setMenu(profiles_menu);
                    Messages.setLanguageText((Widget)profiles_item, "MainWindow.menu.speed_limits.profiles");
                    if (profiles.size() == 0) {
                        profiles_item.setEnabled(false);
                    } else {
                        for (final String p : profiles) {
                            Menu profile_menu = new Menu((Decorations)Utils.findAnyShell(), 4);
                            MenuItem profile_item = new MenuItem(profiles_menu, 64);
                            profile_item.setMenu(profile_menu);
                            profile_item.setText(p);
                            MenuItem loadItem = new MenuItem(profile_menu, 8);
                            Messages.setLanguageText((Widget)loadItem, "MainWindow.menu.speed_limits.load");
                            loadItem.addListener(13, new Listener(){

                                public void handleEvent(Event arg0) {
                                    Utils.showText("MainWindow.menu.speed_limits.info.title", MessageText.getString("MainWindow.menu.speed_limits.info.prof", new String[]{p}), slh.loadProfile(p));
                                }
                            });
                            MenuItem viewItem = new MenuItem(profile_menu, 8);
                            Messages.setLanguageText((Widget)viewItem, "MainWindow.menu.speed_limits.view");
                            viewItem.addListener(13, new Listener(){

                                public void handleEvent(Event arg0) {
                                    Utils.showText("MainWindow.menu.speed_limits.info.title", MessageText.getString("MainWindow.menu.speed_limits.info.prof", new String[]{p}), slh.getProfile(p));
                                }
                            });
                            MenuFactory.addSeparatorMenuItem(profile_menu);
                            MenuItem deleteItem = new MenuItem(profile_menu, 8);
                            Messages.setLanguageText((Widget)deleteItem, "MainWindow.menu.speed_limits.delete");
                            deleteItem.addListener(13, new Listener(){

                                public void handleEvent(Event arg0) {
                                    slh.deleteProfile(p);
                                }
                            });
                        }
                    }
                    MenuItem saveItem = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)saveItem, "MainWindow.menu.speed_limits.save_current");
                    saveItem.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
                            entry.allowEmptyInput(false);
                            entry.setLocalisedTitle(MessageText.getString("MainWindow.menu.speed_limits.profile"));
                            entry.prompt(new UIInputReceiverListener(){

                                @Override
                                public void UIInputReceiverClosed(UIInputReceiver entry) {
                                    if (!entry.hasSubmittedInput()) {
                                        return;
                                    }
                                    String input = entry.getSubmittedInput().trim();
                                    if (input.length() > 0) {
                                        Utils.showText("MainWindow.menu.speed_limits.info.title", MessageText.getString("MainWindow.menu.speed_limits.info.prof", new String[]{input}), slh.saveProfile(input));
                                    }
                                }
                            });
                        }
                    });
                    MenuFactory.addSeparatorMenuItem(menu);
                    MenuItem resetItem = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)resetItem, "MainWindow.menu.speed_limits.reset");
                    resetItem.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            Utils.showText("MainWindow.menu.speed_limits.info.title", "MainWindow.menu.speed_limits.info.curr", slh.clearCurrentLimits());
                        }
                    });
                    MenuFactory.addSeparatorMenuItem(menu);
                    MenuItem scheduleItem = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)scheduleItem, "MainWindow.menu.speed_limits.schedule");
                    scheduleItem.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            Utils.editSpeedLimitHandlerConfig(slh);
                        }
                    });
                    MenuFactory.addSeparatorMenuItem(menu);
                    MenuItem helpItem = new MenuItem(menu, 8);
                    Messages.setLanguageText((Widget)helpItem, "MainWindow.menu.speed_limits.wiki");
                    helpItem.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            Utils.launch("https://wiki.biglybt.com/w/Speed_Limit_Scheduler");
                        }
                    });
                }
            }
        });
        return speedLimitsMenuItem;
    }

    public static MenuItem addAdvancedHelpMenuItem(Menu menuParent) {
        MenuItem advancedHelpMenuItem = MenuFactory.createTopLevelMenuItem(menuParent, "MainWindow.menu.advanced_tools");
        MenuBuildUtils.addMaintenanceListenerForMenu(advancedHelpMenuItem.getMenu(), new MenuBuildUtils.MenuBuilder(){

            @Override
            public void buildMenu(Menu menu, MenuEvent menuEvent) {
                MenuItem manualInstall = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)manualInstall, "menu.install.manual.update");
                manualInstall.addListener(13, new Listener(){

                    public void handleEvent(Event arg) {
                        Utils.execSWTThreadLater(1, new Runnable(){

                            @Override
                            public void run() {
                                MenuFactory.manualInstall();
                            }
                        });
                    }
                });
                new MenuItem(menu, 2);
                MenuItem viewTorrent = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)viewTorrent, "torrent.view.info");
                viewTorrent.addListener(13, new Listener(){

                    public void handleEvent(Event arg) {
                        Utils.execSWTThreadLater(1, new Runnable(){

                            @Override
                            public void run() {
                                MenuFactory.handleTorrentView();
                            }
                        });
                    }
                });
                MenuItem fixTorrent = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)fixTorrent, "torrent.fix.corrupt");
                fixTorrent.addListener(13, new Listener(){

                    public void handleEvent(Event arg) {
                        Utils.execSWTThreadLater(1, new Runnable(){

                            @Override
                            public void run() {
                                MenuFactory.handleTorrentFixup();
                            }
                        });
                    }
                });
                MenuItem importXMLTorrent = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)importXMLTorrent, "importTorrentWizard.title");
                importXMLTorrent.addListener(13, new Listener(){

                    public void handleEvent(Event arg) {
                        Utils.execSWTThreadLater(1, new Runnable(){

                            @Override
                            public void run() {
                                new ImportTorrentWizard();
                            }
                        });
                    }
                });
                new MenuItem(menu, 2);
                MenuItem bencodeToJSON = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)bencodeToJSON, "menu.bencode.to.json");
                bencodeToJSON.addListener(13, new Listener(){

                    public void handleEvent(Event arg) {
                        Utils.execSWTThreadLater(1, new Runnable(){

                            @Override
                            public void run() {
                                MenuFactory.BencodeToJSON();
                            }
                        });
                    }
                });
                MenuItem JSONToBencode = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)JSONToBencode, "menu.json.to.bencode");
                JSONToBencode.addListener(13, new Listener(){

                    public void handleEvent(Event arg) {
                        Utils.execSWTThreadLater(1, new Runnable(){

                            @Override
                            public void run() {
                                MenuFactory.JSONToBencode();
                            }
                        });
                    }
                });
                new MenuItem(menu, 2);
                MenuItem showChanges = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)showChanges, "show.config.changes");
                showChanges.addListener(13, new Listener(){

                    public void handleEvent(Event arg) {
                        Utils.execSWTThreadLater(1, new Runnable(){

                            @Override
                            public void run() {
                                MenuFactory.handleShowChanges();
                            }
                        });
                    }
                });
                MenuItem showThreads = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)showThreads, "show.threads");
                showThreads.addListener(13, new Listener(){

                    public void handleEvent(Event arg) {
                        Utils.execSWTThreadLater(1, new Runnable(){

                            @Override
                            public void run() {
                                MenuFactory.handleShowThreads();
                            }
                        });
                    }
                });
            }
        });
        return advancedHelpMenuItem;
    }

    private static void BencodeToJSON() {
        final Shell shell = Utils.findAnyShell();
        FileDialog dialog = new FileDialog(shell, 135168);
        dialog.setFilterExtensions(new String[]{"*.config", "*.torrent", "*.tor", Constants.FILE_WILDCARD});
        dialog.setFilterNames(new String[]{"*.config", "*.torrent", "*.tor", Constants.FILE_WILDCARD});
        dialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
        dialog.setText(MessageText.getString("bencode.file.browse"));
        String str = dialog.open();
        if (str != null) {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(str));){
                Map<String, Object> map = BDecoder.decode(bis);
                if (map == null) {
                    throw new Exception("BDecode failed");
                }
                final String json = BEncoder.encodeToJSON(map);
                Utils.execSWTThreadLater(1, new Runnable(){

                    @Override
                    public void run() {
                        FileDialog dialog2 = new FileDialog(shell, 139264);
                        dialog2.setFilterPath(TorrentOpener.getFilterPathTorrent());
                        dialog2.setFilterExtensions(new String[]{"*.json"});
                        String str2 = dialog2.open();
                        if (str2 != null) {
                            if (!str2.toLowerCase(Locale.US).endsWith(".json")) {
                                str2 = String.valueOf(str2) + ".json";
                            }
                            try {
                                if (!FileUtil.writeStringAsFile(new File(str2), json)) {
                                    throw new Exception("Failed to write output file");
                                }
                            }
                            catch (Throwable e) {
                                MessageBoxShell mb = new MessageBoxShell(1, MessageText.getString("ConfigView.section.security.resetkey.error.title"), Debug.getNestedExceptionMessage(e));
                                mb.setParent(shell);
                                mb.open(null);
                            }
                        }
                    }
                });
            }
            catch (Throwable e) {
                MessageBoxShell mb = new MessageBoxShell(1, MessageText.getString("ConfigView.section.security.resetkey.error.title"), Debug.getNestedExceptionMessage(e));
                mb.setParent(shell);
                mb.open(null);
            }
        }
    }

    private static void JSONToBencode() {
        final Shell shell = Utils.findAnyShell();
        FileDialog dialog = new FileDialog(shell, 135168);
        dialog.setFilterExtensions(new String[]{"*.json", Constants.FILE_WILDCARD});
        dialog.setFilterNames(new String[]{"*.json", Constants.FILE_WILDCARD});
        dialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
        dialog.setText(MessageText.getString("json.file.browse"));
        String str = dialog.open();
        if (str != null) {
            try {
                String json = FileUtil.readFileAsString(new File(str), -1, "UTF-8");
                if (json == null) {
                    throw new Exception("JSON decode failed");
                }
                final Map map = BDecoder.decodeFromJSON(json);
                Utils.execSWTThreadLater(1, new Runnable(){

                    @Override
                    public void run() {
                        FileDialog dialog2 = new FileDialog(shell, 139264);
                        dialog2.setFilterPath(TorrentOpener.getFilterPathTorrent());
                        dialog2.setFilterExtensions(new String[]{"*.config", "*.torrent", "*.tor", Constants.FILE_WILDCARD});
                        String str2 = dialog2.open();
                        if (str2 != null) {
                            if (!str2.contains(".")) {
                                str2 = String.valueOf(str2) + ".config";
                            }
                            try {
                                byte[] bytes = BEncoder.encode(map);
                                FileUtil.writeBytesAsFile(str2, bytes);
                            }
                            catch (Throwable e) {
                                MessageBoxShell mb = new MessageBoxShell(1, MessageText.getString("ConfigView.section.security.resetkey.error.title"), Debug.getNestedExceptionMessage(e));
                                mb.setParent(shell);
                                mb.open(null);
                            }
                        }
                    }
                });
            }
            catch (Throwable e) {
                MessageBoxShell mb = new MessageBoxShell(1, MessageText.getString("ConfigView.section.security.resetkey.error.title"), Debug.getNestedExceptionMessage(e));
                mb.setParent(shell);
                mb.open(null);
            }
        }
    }

    private static void manualInstall() {
        block6: {
            Shell shell = Utils.findAnyShell();
            try {
                FileDialog dialog = new FileDialog(shell, 135168);
                dialog.setFilterExtensions(new String[]{"*.jar;*.zip", Constants.FILE_WILDCARD});
                dialog.setFilterNames(new String[]{"*.jar;*.zip", Constants.FILE_WILDCARD});
                dialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
                dialog.setText(MessageText.getString("manual.update.browse"));
                String str = dialog.open();
                if (str == null) break block6;
                final File file = new File(str);
                String name = file.getName();
                if (name.startsWith("core_")) {
                    if (name.endsWith(".zip")) {
                        throw new Exception("Full updates can't be installed manually, please auto-update or download the installer from the website");
                    }
                    Utils.getOffOfSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            HashMap<String, Object> overrides = new HashMap<String, Object>();
                            overrides.put("CoreUpdateChecker.explicit", file);
                            UpdateMonitor.getSingleton(CoreFactory.getSingleton()).performCheck(true, false, false, overrides, new UpdateCheckInstanceListener(){

                                @Override
                                public void cancelled(UpdateCheckInstance instance) {
                                }

                                @Override
                                public void complete(UpdateCheckInstance instance) {
                                }
                            });
                        }
                    });
                    break block6;
                }
                if (name.startsWith("plugins_")) {
                    new InstallPluginWizard(str);
                    break block6;
                }
                if (name.startsWith("swt_")) {
                    Utils.getOffOfSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            HashMap<String, Object> overrides = new HashMap<String, Object>();
                            overrides.put("SWTUpdateChecker.explicit", file);
                            UpdateMonitor.getSingleton(CoreFactory.getSingleton()).performCheck(true, false, false, overrides, new UpdateCheckInstanceListener(){

                                @Override
                                public void cancelled(UpdateCheckInstance instance) {
                                }

                                @Override
                                public void complete(UpdateCheckInstance instance) {
                                }
                            });
                        }
                    });
                    break block6;
                }
                throw new Exception("Unsupported file type - must start with 'core_', 'plugins_' or 'swt_'");
            }
            catch (Throwable e) {
                MessageBoxShell mb = new MessageBoxShell(1, MessageText.getString("ConfigView.section.security.resetkey.error.title"), Debug.getNestedExceptionMessage(e));
                mb.setParent(shell);
                mb.open(null);
            }
        }
    }

    private static void handleTorrentView() {
        block14: {
            Shell shell = Utils.findAnyShell();
            try {
                FileDialog dialog = new FileDialog(shell, 135168);
                dialog.setFilterExtensions(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                dialog.setFilterNames(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                dialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
                dialog.setText(MessageText.getString("torrent.fix.corrupt.browse"));
                String str = dialog.open();
                if (str == null) break block14;
                TorrentOpener.setFilterPathTorrent(str);
                File file = new File(str);
                StringBuilder content = new StringBuilder();
                String NL = "\r\n";
                try {
                    byte[] comment;
                    byte[] created_by;
                    int n;
                    TOTorrentAnnounceURLSet[] sets;
                    URL announce_url;
                    TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedFile(file);
                    LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
                    content.append("Character Encoding:\t").append(locale_decoder.getName()).append(NL);
                    String display_name = locale_decoder.decodeString(torrent.getName());
                    content.append("Name:\t").append(display_name).append(NL);
                    byte[] hash = torrent.getHash();
                    content.append("Hash:\t").append(ByteFormatter.encodeString(hash)).append(NL);
                    content.append("Size:\t").append(DisplayFormatters.formatByteCountToKiBEtc(torrent.getSize())).append(", piece size=").append(DisplayFormatters.formatByteCountToKiBEtc(torrent.getPieceLength())).append(", piece count=").append(torrent.getNumberOfPieces()).append(NL);
                    if (torrent.getPrivate()) {
                        content.append("Private Torrent").append(NL);
                    }
                    if ((announce_url = torrent.getAnnounceURL()) != null) {
                        content.append("Announce URL:\t").append(announce_url).append(NL);
                    }
                    if ((sets = torrent.getAnnounceURLGroup().getAnnounceURLSets()).length > 0) {
                        content.append("Announce List").append(NL);
                        TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = sets;
                        int n2 = sets.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            URL[] urls;
                            TOTorrentAnnounceURLSet set = tOTorrentAnnounceURLSetArray[n3];
                            String x = "";
                            URL[] uRLArray = urls = set.getAnnounceURLs();
                            int n4 = urls.length;
                            n = 0;
                            while (n < n4) {
                                URL u = uRLArray[n];
                                x = String.valueOf(x) + (x.length() == 0 ? "" : ", ") + u;
                                ++n;
                            }
                            content.append("\t").append(x).append(NL);
                            ++n3;
                        }
                    }
                    content.append("Magnet URI:\t").append(UrlUtils.getMagnetURI(display_name, PluginCoreUtils.wrap(torrent))).append(NL);
                    long c_date = torrent.getCreationDate();
                    if (c_date > 0L) {
                        content.append("Created On:\t").append(DisplayFormatters.formatDate(c_date * 1000L)).append(NL);
                    }
                    if ((created_by = torrent.getCreatedBy()) != null) {
                        content.append("Created By:\t").append(locale_decoder.decodeString(created_by)).append(NL);
                    }
                    if ((comment = torrent.getComment()) != null) {
                        content.append("Comment:\t").append(locale_decoder.decodeString(comment)).append(NL);
                    }
                    TOTorrentFile[] files = torrent.getFiles();
                    content.append("Files:\t").append(files.length).append(" - simple=").append(torrent.isSimpleTorrent()).append(NL);
                    TOTorrentFile[] tOTorrentFileArray = files;
                    n = files.length;
                    int n5 = 0;
                    while (n5 < n) {
                        TOTorrentFile tf = tOTorrentFileArray[n5];
                        byte[][] comps = tf.getPathComponents();
                        String f_name = "";
                        byte[][] byArray = comps;
                        int n6 = comps.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            byte[] comp2 = byArray[n7];
                            f_name = String.valueOf(f_name) + (f_name.length() == 0 ? "" : File.separator) + locale_decoder.decodeString(comp2);
                            ++n7;
                        }
                        content.append("\t").append(f_name).append("\t\t").append(DisplayFormatters.formatByteCountToKiBEtc(tf.getLength())).append(NL);
                        ++n5;
                    }
                }
                catch (Throwable e) {
                    content.append(Debug.getNestedExceptionMessage(e));
                }
                new TextViewerWindow(String.valueOf(MessageText.getString("torrent.view.info.title")) + ": " + file.getName(), null, content.toString(), false);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    private static void handleTorrentFixup() {
        final Shell shell = Utils.findAnyShell();
        try {
            FileDialog dialog = new FileDialog(shell, 135168);
            dialog.setFilterExtensions(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
            dialog.setFilterNames(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
            dialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
            dialog.setText(MessageText.getString("torrent.fix.corrupt.browse"));
            String str = dialog.open();
            if (str != null) {
                TorrentOpener.setFilterPathTorrent(str);
                File file = new File(str);
                byte[] bytes = FileUtil.readFileAsByteArray(file);
                Map<String, Object> existing_map = BDecoder.decode(bytes);
                Map existing_info = (Map)existing_map.get("info");
                byte[] existing_info_encoded = BEncoder.encode(existing_info);
                final TOTorrent t = TOTorrentFactory.deserialiseFromMap(existing_map);
                final byte[] old_hash = t.getHash();
                byte[] new_hash = null;
                int i = 0;
                while (i < bytes.length - 5) {
                    if (bytes[i] == 58 && bytes[i + 1] == 105 && bytes[i + 2] == 110 && bytes[i + 3] == 102 && bytes[i + 4] == 111) {
                        new_hash = new SHA1Simple().calculateHash(bytes, i + 5, existing_info_encoded.length);
                        break;
                    }
                    ++i;
                }
                if (new_hash != null) {
                    final byte[] f_new_hash = new_hash;
                    Utils.execSWTThreadLater(1, new Runnable(){

                        @Override
                        public void run() {
                            String title = MessageText.getString("torrent.fix.corrupt.result.title");
                            if (Arrays.equals(old_hash, f_new_hash)) {
                                MessageBoxShell mb = new MessageBoxShell(32, title, MessageText.getString("torrent.fix.corrupt.result.nothing"));
                                mb.setParent(shell);
                                mb.open(null);
                            } else {
                                MessageBoxShell mb = new MessageBoxShell(32, title, MessageText.getString("torrent.fix.corrupt.result.fixed", new String[]{ByteFormatter.encodeString(f_new_hash)}));
                                mb.setParent(shell);
                                mb.open(null);
                                mb.waitUntilClosed();
                                try {
                                    t.setHashOverride(f_new_hash);
                                    Utils.execSWTThreadLater(1, new Runnable(){

                                        @Override
                                        public void run() {
                                            FileDialog dialog2 = new FileDialog(shell, 139264);
                                            dialog2.setFilterPath(TorrentOpener.getFilterPathTorrent());
                                            dialog2.setFilterExtensions(new String[]{"*.torrent"});
                                            String str2 = dialog2.open();
                                            if (str2 != null) {
                                                if (!str2.toLowerCase(Locale.US).endsWith(".tor") && !str2.toLowerCase(Locale.US).endsWith(".torrent")) {
                                                    str2 = String.valueOf(str2) + ".torrent";
                                                }
                                                try {
                                                    t.serialiseToBEncodedFile(new File(str2));
                                                }
                                                catch (Throwable e) {
                                                    Debug.out(e);
                                                }
                                            }
                                        }
                                    });
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private static void handleShowChanges() {
        PluginInterface[] plugins;
        String NL = "\r\n";
        StringWriter content = new StringWriter();
        content.append("**** Please review the contents of this before submitting it ****\r\n\r\n");
        content.append("Settings\r\n");
        IndentWriter iw = new IndentWriter(new PrintWriter(content));
        iw.indent();
        try {
            COConfigurationManager.dumpConfigChanges(iw);
        }
        finally {
            iw.exdent();
            iw.close();
        }
        Core core = CoreFactory.getSingleton();
        content.append("Plugins\r\n");
        PluginInterface[] pluginInterfaceArray = plugins = core.getPluginManager().getPlugins();
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            PluginInterface pi = pluginInterfaceArray[n2];
            if (!pi.getPluginState().isBuiltIn()) {
                content.append("    ").append(pi.getPluginName()).append(": ").append(pi.getPluginVersion()).append("\r\n");
            }
            ++n2;
        }
        List<DownloadManager> dms = core.getGlobalManager().getDownloadManagers();
        content.append("Downloads - ").append(String.valueOf(dms.size())).append("\r\n");
        iw = new IndentWriter(new PrintWriter(content));
        iw.indent();
        try {
            for (DownloadManager dm : dms) {
                String hash_str;
                try {
                    byte[] hash = dm.getTorrent().getHash();
                    hash_str = Base32.encode(hash).substring(0, 16);
                }
                catch (Throwable e) {
                    hash_str = "<no hash>";
                }
                iw.println(String.valueOf(hash_str) + ": " + DisplayFormatters.formatDownloadStatus(dm));
                iw.indent();
                dm.getDownloadState().dump(iw);
                iw.exdent();
            }
        }
        finally {
            iw.exdent();
            iw.close();
        }
        content.append("Categories\r\n");
        Category[] cats = CategoryManager.getCategories();
        iw = new IndentWriter(new PrintWriter(content));
        iw.indent();
        try {
            Category[] categoryArray = cats;
            int n3 = cats.length;
            int n4 = 0;
            while (n4 < n3) {
                Category cat = categoryArray[n4];
                iw.println(cat.getName());
                iw.indent();
                try {
                    cat.dump(iw);
                }
                finally {
                    iw.exdent();
                }
                ++n4;
            }
        }
        finally {
            iw.exdent();
            iw.close();
        }
        content.append("Speed Limits\r\n");
        iw = new IndentWriter(new PrintWriter(content));
        iw.indent();
        try {
            SpeedLimitHandler.getSingleton(core).dump(iw);
        }
        finally {
            iw.exdent();
            iw.close();
        }
        new TextViewerWindow(MessageText.getString("config.changes.title"), null, content.toString(), false);
    }

    private static void handleShowThreads() {
        Supplier<String> textGenerator = () -> {
            StringWriter content = new StringWriter();
            IndentWriter iw = new IndentWriter(new PrintWriter(content));
            AEDiagnostics.dumpThreads(iw);
            iw.close();
            return content.toString();
        };
        new TextViewerWindow(null, MessageText.getString("label.threads"), null, textGenerator.get(), window -> window.setText((String)textGenerator.get(), false), false, false);
    }

    public static MenuItem addBlockedIPsMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.ipFilter", new ListenerNeedingCoreRunning(){

            @Override
            public void handleEvent(Core core, Event e) {
                BlockedIpsWindow.showBlockedIps(core, MenuFactory.getUIFunctionSWT().getMainShell());
            }
        });
    }

    public static MenuItem addConsoleMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.console", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.getMDI().showEntryByID("LoggerView");
                }
            }
        });
    }

    public static MenuItem addStatisticsMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.stats", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    MultipleDocumentInterface mdi = uiFunctions.getMDI();
                    mdi.showEntryByID(StatsView.VIEW_ID);
                }
            }
        });
    }

    public static MenuItem addNatTestMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.tools.nattest", new Listener(){

            public void handleEvent(Event e) {
                new NatTestWindow();
            }
        });
    }

    public static MenuItem addNetStatusMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.tools.netstat", e -> {
            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uiFunctions == null) {
                return;
            }
            uiFunctions.getUISWTInstance().openView("Main", "aznetstatus", null);
        });
    }

    public static MenuItem addSpeedTestMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.tools.speedtest", new Listener(){

            public void handleEvent(Event e) {
                CoreWaiterSWT.waitForCoreRunning(new CoreRunningListener(){

                    @Override
                    public void coreRunning(Core core) {
                        new SpeedTestWizard();
                    }
                });
            }
        });
    }

    public static MenuItem addConfigWizardMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.file.configure", new Listener(){

            public void handleEvent(Event e) {
                new ConfigureWizard(false, 0);
            }
        });
    }

    public static MenuItem addOptionsMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.view.configuration", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.getMDI().showEntryByID("ConfigView");
                }
            }
        });
    }

    public static MenuItem addMinimizeWindowMenuItem(Menu menu) {
        final MenuItem item = MenuFactory.addMenuItem(menu, "MainWindow.menu.window.minimize", new Listener(){

            public void handleEvent(Event event2) {
                Shell shell = Utils.getActiveShell();
                if (shell == null || shell.isDisposed()) {
                    event2.doit = false;
                    return;
                }
                shell.setMinimized(true);
            }
        });
        Listener enableHandler = new Listener(){

            public void handleEvent(Event event2) {
                Shell shell = Utils.getActiveShell();
                if (shell == null || shell.isDisposed() || item.isDisposed()) {
                    event2.doit = false;
                    return;
                }
                if ((shell.getStyle() & 0x80) != 0) {
                    item.setEnabled(!shell.getMinimized());
                } else {
                    item.setEnabled(false);
                }
            }
        };
        menu.addListener(22, enableHandler);
        return item;
    }

    public static MenuItem addBringAllToFrontMenuItem(Menu menu) {
        final MenuItem item = MenuFactory.addMenuItem(menu, "MainWindow.menu.window.alltofront", new Listener(){

            public void handleEvent(Event event2) {
                Iterator<Shell> iter = ShellManager.sharedManager().getWindows();
                while (iter.hasNext()) {
                    Shell shell = iter.next();
                    if (shell.isDisposed() || shell.getMinimized()) continue;
                    shell.open();
                }
            }
        });
        final Listener enableHandler = new Listener(){

            public void handleEvent(Event event2) {
                if (item.isDisposed()) {
                    return;
                }
                Iterator<Shell> iter = ShellManager.sharedManager().getWindows();
                boolean hasNonMaximizedShell = false;
                while (iter.hasNext()) {
                    Shell shell = iter.next();
                    if (shell.isDisposed() || shell.getMinimized()) continue;
                    hasNonMaximizedShell = true;
                    break;
                }
                item.setEnabled(hasNonMaximizedShell);
            }
        };
        menu.addListener(22, enableHandler);
        ShellManager.sharedManager().addWindowAddedListener(enableHandler);
        ShellManager.sharedManager().addWindowRemovedListener(enableHandler);
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event2) {
                ShellManager.sharedManager().removeWindowAddedListener(enableHandler);
                ShellManager.sharedManager().removeWindowRemovedListener(enableHandler);
            }
        });
        return item;
    }

    public static void appendWindowMenuItems(final Menu menuParent) {
        final int numTopItems = menuParent.getItemCount();
        Listener rebuild = new Listener(){

            public void handleEvent(Event event2) {
                try {
                    Shell shell = Utils.getActiveShell();
                    if (menuParent.isDisposed() || shell == null || shell.isDisposed()) {
                        return;
                    }
                    int size = ShellManager.sharedManager().getSize();
                    if (size == menuParent.getItemCount() - numTopItems) {
                        int i = numTopItems;
                        while (i < menuParent.getItemCount()) {
                            MenuItem item;
                            item.setSelection((item = menuParent.getItem(i)).getData() == shell);
                            ++i;
                        }
                        return;
                    }
                    int i = numTopItems;
                    while (i < menuParent.getItemCount()) {
                        menuParent.getItem(i).dispose();
                    }
                    Iterator<Shell> iter = ShellManager.sharedManager().getWindows();
                    int i2 = 0;
                    while (i2 < size) {
                        final Shell sh = iter.next();
                        if (!sh.isDisposed() && sh.getText().length() != 0) {
                            MenuItem item = new MenuItem(menuParent, 32);
                            item.setText(sh.getText());
                            item.setSelection(shell == sh);
                            item.setData((Object)sh);
                            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent event2) {
                                    if (event2.widget.isDisposed() || sh.isDisposed()) {
                                        return;
                                    }
                                    if (sh.getMinimized()) {
                                        sh.setMinimized(false);
                                    }
                                    sh.open();
                                }
                            });
                        }
                        ++i2;
                    }
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LogIDs.GUI, "rebuild menu error", e));
                }
            }
        };
        ShellManager.sharedManager().addWindowAddedListener(rebuild);
        ShellManager.sharedManager().addWindowRemovedListener(rebuild);
        menuParent.addListener(22, rebuild);
    }

    public static MenuItem addZoomWindowMenuItem(Menu menuParent) {
        final MenuItem item = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.window.zoom", new Listener(){

            public void handleEvent(Event event2) {
                Shell shell = Utils.getActiveShell();
                if (shell == null || shell.isDisposed()) {
                    event2.doit = false;
                    return;
                }
                shell.setMaximized(!shell.getMaximized());
            }
        });
        Listener enableHandler = new Listener(){

            public void handleEvent(Event event2) {
                Shell shell = Utils.getActiveShell();
                if (shell == null || shell.isDisposed() || item.isDisposed()) {
                    return;
                }
                if (!Constants.isOSX) {
                    if (shell.getMaximized()) {
                        Messages.setLanguageText((Widget)item, "MainWindow.menu.window.zoom.restore");
                    } else {
                        Messages.setLanguageText((Widget)item, "MainWindow.menu.window.zoom.maximize");
                    }
                }
                if ((shell.getStyle() & 0x400) != 0) {
                    item.setEnabled(!shell.getMinimized());
                } else {
                    item.setEnabled(false);
                }
            }
        };
        menuParent.addListener(22, enableHandler);
        return item;
    }

    public static MenuItem addAboutMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.help.about", new Listener(){

            public void handleEvent(Event e) {
                AboutWindow.show();
            }
        });
    }

    public static MenuItem addWhatsNewMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.help.whatsnew", new Listener(){

            public void handleEvent(Event e) {
                Utils.launch("https://plugins.biglybt.com/changelog.php?version=3.4.0.0");
            }
        });
    }

    public static MenuItem addVoteMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.vote", new Listener(){

            public void handleEvent(Event e) {
                Utils.launch("https://vote.biglybt.com/");
            }
        });
    }

    public static MenuItem addBugReportMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.bugreport", new Listener(){

            public void handleEvent(Event e) {
                Utils.launch("https://bugs.biglybt.com/");
            }
        });
    }

    public static MenuItem addWikiMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.community.wiki", new Listener(){

            public void handleEvent(Event e) {
                Utils.launch("https://wiki.biglybt.com/");
            }
        });
    }

    public static MenuItem addReleaseNotesMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.help.releasenotes", new Listener(){

            public void handleEvent(Event e) {
                new WelcomeWindow(Utils.findAnyShell());
            }
        });
    }

    public static MenuItem addDonationMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.help.donate", new Listener(){

            public void handleEvent(Event e) {
                DonationWindow.open(true, "menu");
            }
        });
    }

    public static MenuItem addGetPluginsMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.help.plugins", new Listener(){

            public void handleEvent(Event e) {
                Utils.launch("https://plugins.biglybt.com/");
            }
        });
    }

    public static MenuItem addDebugHelpMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.help.debug", new Listener(){

            public void handleEvent(Event e) {
                UIDebugGenerator.generate(String.valueOf(Constants.APP_NAME) + " " + "3.4.0.0", "Generated via Help Menu");
            }
        });
    }

    public static MenuItem addCheckUpdateMenuItem(Menu menu) {
        return MenuFactory.addMenuItem(menu, "MainWindow.menu.help.checkupdate", new ListenerNeedingCoreRunning(){

            @Override
            public void handleEvent(final Core core, Event e) {
                UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                if (uiFunctions != null) {
                    uiFunctions.bringToFront();
                }
                Utils.getOffOfSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        UpdateMonitor.getSingleton(core).performCheck(true, false, false, new UpdateCheckInstanceListener(){

                            @Override
                            public void cancelled(UpdateCheckInstance instance) {
                            }

                            @Override
                            public void complete(UpdateCheckInstance instance) {
                                Update[] updates = instance.getUpdates();
                                boolean hasUpdates = false;
                                Update[] updateArray = updates;
                                int n = updates.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Update update = updateArray[n2];
                                    if (update.getDownloaders().length > 0) {
                                        hasUpdates = true;
                                        break;
                                    }
                                    ++n2;
                                }
                                if (!hasUpdates) {
                                    UpdateChecker[] checkers = instance.getCheckers();
                                    ArrayList<String> errors = new ArrayList<String>();
                                    UpdateChecker[] updateCheckerArray = checkers;
                                    int n3 = checkers.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        UpdateChecker checker = updateCheckerArray[n4];
                                        if (checker.getFailed()) {
                                            String name = checker.getComponent().getName();
                                            Throwable reason = checker.getFailureReason();
                                            errors.add(String.valueOf(name) + ", " + Debug.getNestedExceptionMessage(reason));
                                        }
                                        ++n4;
                                    }
                                    if (errors.isEmpty()) {
                                        int build = Constants.getIncrementalBuild();
                                        if (COConfigurationManager.getBooleanParameter("Beta Programme Enabled") && build > 0) {
                                            String build_str = "" + build;
                                            if (build_str.length() == 1) {
                                                build_str = "0" + build_str;
                                            }
                                            MessageBoxShell mb = new MessageBoxShell(34, "window.update.noupdates.beta", new String[]{"B" + build_str});
                                            mb.open(null);
                                        } else {
                                            MessageBoxShell mb = new MessageBoxShell(34, "window.update.noupdates", null);
                                            mb.open(null);
                                        }
                                    } else {
                                        String str = "";
                                        for (String e : errors) {
                                            str = String.valueOf(str) + (str.isEmpty() ? "" : "\n\n") + e;
                                        }
                                        MessageBoxShell mb = new MessageBoxShell(33, "window.update.failed", new String[]{str});
                                        mb.open(null);
                                    }
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    public static void addBetaMenuItem(Menu menuParent) {
        final MenuItem menuItem = MenuFactory.addMenuItem(menuParent, "MainWindow.menu.beta", new Listener(){

            public void handleEvent(Event e) {
                new BetaWizard();
            }
        });
        final ParameterListener listener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (menuItem.isDisposed()) {
                            return;
                        }
                        boolean enabled = COConfigurationManager.getBooleanParameter("Beta Programme Enabled");
                        Messages.setLanguageText((Widget)menuItem, "MainWindow.menu.beta" + (enabled ? ".off" : ".on"));
                    }
                });
            }
        };
        COConfigurationManager.addAndFireParameterListener("Beta Programme Enabled", listener);
        menuParent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                COConfigurationManager.removeParameterListener("Beta Programme Enabled", listener);
            }
        });
        boolean enabled = COConfigurationManager.getBooleanParameter("Beta Programme Enabled");
        if (enabled) {
            MenuFactory.addMenuItem(menuParent, "MainWindow.menu.report.beta.problem", new Listener(){

                public void handleEvent(Event e) {
                    Utils.launch(MessageText.getString("beta.bug.url"));
                }
            });
        }
    }

    public static MenuItem addPluginInstallFromFileItem(Menu menuParent) {
        return MenuFactory.addMenuItem(menuParent, "MainWindow.menu.install.from.file", new Listener(){

            public void handleEvent(Event e) {
                new InstallPluginWizard();
            }
        });
    }

    public static MenuItem addPluginUnInstallMenuItem(Menu menuParent) {
        return MenuFactory.addMenuItem(menuParent, "MainWindow.menu.plugins.uninstallPlugins", new Listener(){

            public void handleEvent(Event e) {
                new UnInstallPluginWizard(Utils.getDisplay());
            }
        });
    }

    public static void addAlertsMenu(Menu menu, boolean createSubmenu, final DownloadManager[] dms) {
        Menu alert_menu;
        if (dms.length == 0) {
            return;
        }
        if (createSubmenu) {
            alert_menu = new Menu((Decorations)menu.getShell(), 4);
            MenuItem alerts_item = new MenuItem(menu, 64);
            Messages.setLanguageText((Widget)alerts_item, "ConfigView.section.interface.alerts");
            alerts_item.setMenu(alert_menu);
        } else {
            alert_menu = menu;
        }
        String[][] alert_keys = new String[][]{{"Play Download Finished", "playdownloadfinished"}, {"Play Download Finished Announcement", "playdownloadspeech"}, {"Popup Download Finished", "popupdownloadfinished"}};
        boolean[] all_enabled = new boolean[alert_keys.length];
        Arrays.fill(all_enabled, true);
        DownloadManager[] downloadManagerArray = dms;
        int n = dms.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager dm = downloadManagerArray[n2];
            DownloadManagerState state = dm.getDownloadState();
            Map map = state.getMapAttribute("df_alerts");
            if (map == null) {
                Arrays.fill(all_enabled, false);
            } else {
                int i = 0;
                while (i < alert_keys.length) {
                    if (!map.containsKey(alert_keys[i][0])) {
                        all_enabled[i] = false;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        int i = 0;
        while (i < alert_keys.length) {
            final String[] entry = alert_keys[i];
            if (i != 1 || Constants.isOSX) {
                final MenuItem item = new MenuItem(alert_menu, 32);
                item.setText(MessageText.getString("ConfigView.label." + entry[1]));
                item.setSelection(all_enabled[i]);
                item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        boolean selected = item.getSelection();
                        DownloadManager[] downloadManagerArray = dms;
                        int n = dms.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DownloadManager dm = downloadManagerArray[n2];
                            DownloadManagerState state = dm.getDownloadState();
                            HashMap<String, String> map = state.getMapAttribute("df_alerts");
                            map = map == null ? new HashMap<String, String>() : new HashMap(map);
                            if (selected) {
                                map.put(entry[0], "");
                            } else {
                                map.remove(entry[0]);
                            }
                            state.setMapAttribute("df_alerts", map);
                            ++n2;
                        }
                    }
                });
            }
            ++i;
        }
    }

    public static void addAlertsMenu(Menu menu, final DownloadManager dm, final DiskManagerFileInfo[] files) {
        if (files.length == 0) {
            return;
        }
        String[][] alert_keys = new String[][]{{"Play File Finished", "playfilefinished"}, {"Play File Finished Announcement", "playfilespeech"}, {"Popup File Finished", "popupfilefinished"}};
        Menu alert_menu = new Menu((Decorations)menu.getShell(), 4);
        MenuItem alerts_item = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)alerts_item, "ConfigView.section.interface.alerts");
        alerts_item.setMenu(alert_menu);
        boolean[] all_enabled = new boolean[alert_keys.length];
        DownloadManagerState state = dm.getDownloadState();
        Map map = state.getMapAttribute("df_alerts");
        if (map != null) {
            Arrays.fill(all_enabled, true);
            DiskManagerFileInfo[] diskManagerFileInfoArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                DiskManagerFileInfo file = diskManagerFileInfoArray[n2];
                int i = 0;
                while (i < alert_keys.length) {
                    String key = String.valueOf(String.valueOf(file.getIndex())) + "." + alert_keys[i][0];
                    if (!map.containsKey(key)) {
                        all_enabled[i] = false;
                    }
                    ++i;
                }
                ++n2;
            }
        }
        int i = 0;
        while (i < alert_keys.length) {
            final String[] entry = alert_keys[i];
            if (i != 1 || Constants.isOSX) {
                final MenuItem item = new MenuItem(alert_menu, 32);
                item.setText(MessageText.getString("ConfigView.label." + entry[1]));
                item.setSelection(all_enabled[i]);
                item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        DownloadManagerState state = dm.getDownloadState();
                        HashMap<String, String> map = state.getMapAttribute("df_alerts");
                        map = map == null ? new HashMap<String, String>() : new HashMap(map);
                        boolean selected = item.getSelection();
                        DiskManagerFileInfo[] diskManagerFileInfoArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DiskManagerFileInfo file = diskManagerFileInfoArray[n2];
                            String key = String.valueOf(String.valueOf(file.getIndex())) + "." + entry[0];
                            if (selected) {
                                map.put(key, "");
                            } else {
                                map.remove(key);
                            }
                            ++n2;
                        }
                        state.setMapAttribute("df_alerts", map);
                    }
                });
            }
            ++i;
        }
    }

    public static final MenuItem addLabelMenuItem(Menu menu, String localizationKey) {
        MenuItem item = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)item, localizationKey);
        item.setEnabled(false);
        return item;
    }

    public static void addPairingMenuItem(Menu menu) {
        MenuFactory.addMenuItem(menu, "MainWindow.menu.pairing", new Listener(){

            public void handleEvent(Event e) {
                UIFunctionsSWT uiFunctionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
                if (uiFunctionsSWT != null) {
                    uiFunctionsSWT.openRemotePairingWindow();
                }
            }
        });
    }

    public static MenuItem addSeparatorMenuItem(Menu menuParent) {
        return new MenuItem(menuParent, 2);
    }

    public static MenuItem createTopLevelMenuItem(Menu menuParent, String localizationKey) {
        Menu menu = new Menu((Decorations)Utils.findAnyShell(), 4);
        MenuItem menuItem = new MenuItem(menuParent, 64);
        Messages.setLanguageText((Widget)menuItem, localizationKey);
        menuItem.setMenu(menu);
        menu.setData("key.menu.id", (Object)localizationKey);
        menuItem.setData("key.menu.id", (Object)localizationKey);
        return menuItem;
    }

    public static final MenuItem addMenuItem(Menu menu, String localizationKey, Listener selListener) {
        return MenuFactory.addMenuItem(menu, localizationKey, selListener, 0);
    }

    public static final MenuItem addMenuItem(Menu menu, String localizationKey, Listener selListener, int style) {
        MenuItem menuItem = new MenuItem(menu, style);
        Messages.setLanguageText((Widget)menuItem, localizationKey);
        KeyBindings.setAccelerator(menuItem, localizationKey);
        if (selListener != null) {
            menuItem.addListener(13, selListener);
        }
        menuItem.setData("key.menu.id", (Object)localizationKey);
        return menuItem;
    }

    public static final MenuItem addMenuItem(Menu menu, int style, String localizationKey, Listener selListener) {
        MenuItem menuItem = new MenuItem(menu, style);
        Messages.setLanguageText((Widget)menuItem, localizationKey);
        KeyBindings.setAccelerator(menuItem, localizationKey);
        menuItem.addListener(13, selListener);
        menuItem.setData("key.menu.id", (Object)localizationKey);
        return menuItem;
    }

    private static UIFunctionsSWT getUIFunctionSWT() {
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null) {
            return uiFunctions;
        }
        throw new IllegalStateException("No instance of UIFunctionsSWT found; the UIFunctionsManager might not have been initialized properly");
    }

    public static void updateMenuText(Object menu) {
        if (menu == null) {
            return;
        }
        if (menu instanceof Menu) {
            MenuItem[] menus = ((Menu)menu).getItems();
            int i = 0;
            while (i < menus.length) {
                MenuFactory.updateMenuText(menus[i]);
                ++i;
            }
        } else if (menu instanceof MenuItem) {
            MenuItem item = (MenuItem)menu;
            if (item.getData("key.menu.id") instanceof String) {
                String localizationKey = (String)item.getData("key.menu.id");
                if (MessageText.keyExists(localizationKey)) {
                    item.setText(MessageText.getString(localizationKey));
                    KeyBindings.setAccelerator(item, localizationKey);
                } else {
                    Messages.updateLanguageForControl((Widget)item);
                }
                MenuFactory.updateMenuText(item.getMenu());
            } else {
                Messages.updateLanguageForControl((Widget)item);
            }
        }
    }

    public static void performOneTimeDisable(MenuItem item, boolean affectsChildMenuItems) {
        item.setEnabled(false);
        if (affectsChildMenuItems) {
            Menu childMenu = item.getMenu();
            if (childMenu == null) {
                return;
            }
            int i = 0;
            while (i < childMenu.getItemCount()) {
                childMenu.getItem(i).setEnabled(false);
                ++i;
            }
        }
    }

    public static Menu findMenu(Menu menuToStartWith, String idToMatch) {
        if (menuToStartWith == null || menuToStartWith.isDisposed() || idToMatch == null || idToMatch.length() < 1) {
            return null;
        }
        if (idToMatch.equals(MenuFactory.getID((Widget)menuToStartWith))) {
            return menuToStartWith;
        }
        MenuItem[] items = menuToStartWith.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            Menu menuToFind = MenuFactory.findMenu(item.getMenu(), idToMatch);
            if (menuToFind != null) {
                return menuToFind;
            }
            ++i;
        }
        return null;
    }

    public static MenuItem findMenuItem(Menu menuToStartWith, String idToMatch) {
        return MenuFactory.findMenuItem(menuToStartWith, idToMatch, true);
    }

    public static MenuItem findMenuItem(Menu menuToStartWith, String idToMatch, boolean deep) {
        if (menuToStartWith == null || menuToStartWith.isDisposed() || idToMatch == null || idToMatch.length() < 1) {
            return null;
        }
        MenuItem[] items = menuToStartWith.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem menuItemToFind;
            MenuItem item = items[i];
            if (idToMatch.equals(MenuFactory.getID((Widget)item))) {
                return item;
            }
            if (deep && (menuItemToFind = MenuFactory.findMenuItem(item.getMenu(), idToMatch)) != null) {
                return menuItemToFind;
            }
            ++i;
        }
        return null;
    }

    private static String getID(Widget widget) {
        Object id;
        if (widget != null && !widget.isDisposed() && (id = widget.getData("key.menu.id")) != null) {
            return id.toString();
        }
        return "";
    }

    public static void setEnablementKeys(Widget widget, int keys) {
        if (widget != null && !widget.isDisposed()) {
            widget.setData("key.enablement", (Object)new Integer(keys));
        }
    }

    public static int getEnablementKeys(Widget widget) {
        Object keys;
        if (widget != null && !widget.isDisposed() && (keys = widget.getData("key.enablement")) instanceof Integer) {
            return (Integer)keys;
        }
        return -1;
    }

    public static void updateEnabledStates(Menu menuToStartWith) {
        if (menuToStartWith == null || menuToStartWith.isDisposed()) {
            return;
        }
        if (!MenuFactory.setEnablement((Widget)menuToStartWith)) {
            return;
        }
        MenuItem[] items = menuToStartWith.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            if (MenuFactory.setEnablement((Widget)item)) {
                MenuFactory.updateEnabledStates(item.getMenu());
            }
            ++i;
        }
    }

    public static boolean setEnablement(Widget widget) {
        if (widget != null && !widget.isDisposed()) {
            boolean isEnabled = MenuFactory.isEnabledForCurrentMode(widget);
            if (widget instanceof MenuItem) {
                ((MenuItem)widget).setEnabled(isEnabled);
            } else if (widget instanceof Menu) {
                ((Menu)widget).setEnabled(isEnabled);
            }
            return isEnabled;
        }
        return false;
    }

    public static boolean isEnabledForCurrentMode(Widget widget) {
        int keys = MenuFactory.getEnablementKeys(widget);
        if (keys <= 0) {
            return true;
        }
        if (isAZ3) {
            return (keys & 2) != 0;
        }
        return (keys & 1) != 0;
    }

    private static TableRow wrapAsRow(final Object o, final String table_name) {
        return new TableRow(){

            @Override
            public Object getDataSource() {
                return o;
            }

            @Override
            public String getTableID() {
                return table_name;
            }

            private void notSupported() {
                throw new RuntimeException("method is not supported - table row is a \"virtual\" one, only getDataSource and getTableID are supported.");
            }

            private void setForegroundDebug() {
                if (DEBUG_SET_FOREGROUND) {
                    Debug.out("setForeground on fake TableRow");
                }
            }

            @Override
            public TableView<?> getView() {
                return null;
            }

            @Override
            public int getIndex() {
                this.notSupported();
                return 0;
            }

            @Override
            public boolean isValid() {
                this.notSupported();
                return false;
            }

            @Override
            public TableCell getTableCell(String sColumnName) {
                this.notSupported();
                return null;
            }

            @Override
            public TableCell getTableCell(TableColumn column) {
                this.notSupported();
                return null;
            }

            @Override
            public boolean isSelected() {
                this.notSupported();
                return false;
            }

            @Override
            public void addMouseListener(TableRowMouseListener listener) {
                this.notSupported();
            }

            @Override
            public void removeMouseListener(TableRowMouseListener listener) {
                this.notSupported();
            }

            @Override
            public Object getData(String id) {
                return null;
            }

            @Override
            public void setData(String id, Object data) {
            }
        };
    }

    public static void initSystemMenu() {
        Display current = Display.getCurrent();
        Menu systemMenu = current.getSystemMenu();
        if (systemMenu != null) {
            MenuItem sysItem;
            MenuItem sysServices = MenuFactory.getItem(systemMenu, SWT.getMessage((String)"Services"));
            if (sysServices != null) {
                sysServices.setEnabled(false);
            }
            if ((sysItem = MenuFactory.getItem(systemMenu, -1)) != null) {
                sysItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AboutWindow.show();
                    }
                });
            }
            if ((sysItem = MenuFactory.getItem(systemMenu, -2)) != null) {
                sysItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                        if (uiFunctions != null) {
                            uiFunctions.getMDI().showEntryByID("ConfigView");
                        }
                    }
                });
            }
            int quitIndex = systemMenu.indexOf(MenuFactory.getItem(systemMenu, -6));
            MenuItem restartItem = new MenuItem(systemMenu, 64, quitIndex);
            Messages.setLanguageText((Widget)restartItem, "MainWindow.menu.file.restart");
            restartItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        uiFunctions.dispose(true);
                    }
                }
            });
            boolean isAZ3 = "az3".equalsIgnoreCase(COConfigurationManager.getStringParameter("ui"));
            if (!isAZ3) {
                int prefIndex = systemMenu.indexOf(MenuFactory.getItem(systemMenu, -2)) + 1;
                MenuItem wizItem = new MenuItem(systemMenu, 64, prefIndex);
                Messages.setLanguageText((Widget)wizItem, "MainWindow.menu.file.configure");
                wizItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        new ConfigureWizard(false, 0);
                    }
                });
                MenuItem natMenu = new MenuItem(systemMenu, 64, prefIndex);
                Messages.setLanguageText((Widget)natMenu, "MainWindow.menu.tools.nattest");
                natMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        new NatTestWindow();
                    }
                });
                MenuItem netstatMenu = new MenuItem(systemMenu, 64, prefIndex);
                Messages.setLanguageText((Widget)netstatMenu, "MainWindow.menu.tools.netstat");
                netstatMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                        if (uiFunctions == null) {
                            return;
                        }
                        uiFunctions.getUISWTInstance().openView("Main", "aznetstatus", null);
                    }
                });
                MenuItem speedMenu = new MenuItem(systemMenu, 64, prefIndex);
                Messages.setLanguageText((Widget)speedMenu, "MainWindow.menu.tools.speedtest");
                speedMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        new SpeedTestWizard();
                    }
                });
            }
        }
    }

    private static MenuItem getItem(Menu menu, String title) {
        MenuItem[] items;
        MenuItem[] menuItemArray = items = menu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (title.equals(item.getText())) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private static MenuItem getItem(Menu menu, int id) {
        MenuItem[] items;
        MenuItem[] menuItemArray = items = menu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (item.getID() == id) {
                return item;
            }
            ++n2;
        }
        return null;
    }
}

