/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.mdi;

import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.ui.mdi.MdiCloseListener;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryVitalityImage;
import com.biglybt.ui.mdi.MdiEntryVitalityImageListener;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.widgets.TabFolderRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class MdiEntryVitalityImageSWT
implements MdiEntryVitalityImage,
TabFolderRenderer.TabbedEntryVitalityImage {
    private String imageID;
    private final MdiEntry mdiEntry;
    private List<MdiEntryVitalityImageListener> listeners = Collections.EMPTY_LIST;
    private String tooltip;
    private Rectangle hitArea;
    private boolean visible = true;
    private int currentAnimationIndex;
    private String suffix = "";
    private TimerEventPerformer performer;
    private TimerEventPeriodic timerEvent;
    private Image[] images;
    private int delayTime = -1;
    private String fullImageID;
    private int alignment = 131072;
    private boolean showOutsideOfEntry;
    private boolean showOnlyOnSelection;
    private boolean alwaysLast;

    public MdiEntryVitalityImageSWT(MdiEntry mdiEntry, String imageID) {
        this.mdiEntry = mdiEntry;
        mdiEntry.addListener(new MdiCloseListener(){

            @Override
            public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                ImageLoader imageLoader = ImageLoader.getInstance();
                if (MdiEntryVitalityImageSWT.this.fullImageID != null && imageLoader != null) {
                    imageLoader.releaseImage(MdiEntryVitalityImageSWT.this.fullImageID);
                }
            }
        });
        this.setImageID(imageID);
    }

    @Override
    public String getImageID() {
        return this.imageID;
    }

    @Override
    public MdiEntry getMdiEntry() {
        return this.mdiEntry;
    }

    @Override
    public void addListener(MdiEntryVitalityImageListener l) {
        if (this.listeners == Collections.EMPTY_LIST) {
            this.listeners = new ArrayList<MdiEntryVitalityImageListener>(1);
        }
        this.listeners.add(l);
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    @Override
    public void triggerClickedListeners(int x, int y) {
        Object[] list = this.listeners.toArray();
        int i = 0;
        while (i < list.length) {
            MdiEntryVitalityImageListener l = (MdiEntryVitalityImageListener)list[i];
            try {
                l.mdiEntryVitalityImage_clicked(x, y);
            }
            catch (Exception e) {
                Debug.out(e);
            }
            ++i;
        }
    }

    @Override
    public void setToolTip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    @Override
    public void setHitArea(Rectangle hitArea) {
        this.hitArea = hitArea;
    }

    public Rectangle getHitArea() {
        return this.hitArea;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        if (visible) {
            this.createTimerEvent();
        } else if (this.timerEvent != null) {
            this.timerEvent.cancel();
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (MdiEntryVitalityImageSWT.this.mdiEntry != null) {
                    MdiEntryVitalityImageSWT.this.mdiEntry.redraw();
                }
            }
        });
    }

    private synchronized void createTimerEvent() {
        if (this.timerEvent != null) {
            this.timerEvent.cancel();
        }
        if (this.images != null && this.images.length > 1) {
            int delay;
            ImageLoader imageLoader = ImageLoader.getInstance();
            int n = delay = this.delayTime == -1 ? imageLoader.getAnimationDelay(this.imageID) : this.delayTime;
            if (this.performer == null) {
                this.performer = new TimerEventPerformer(){
                    private boolean exec_pending = false;
                    private Object lock = this;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent event2) {
                        Object object = this.lock;
                        synchronized (object) {
                            if (this.exec_pending) {
                                return;
                            }
                            this.exec_pending = true;
                        }
                        Utils.execSWTThread(new AERunnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void runSupport() {
                                Object object = lock;
                                synchronized (object) {
                                    exec_pending = false;
                                }
                                if (MdiEntryVitalityImageSWT.this.images == null || MdiEntryVitalityImageSWT.this.images.length == 0 || !MdiEntryVitalityImageSWT.this.visible || MdiEntryVitalityImageSWT.this.hitArea == null) {
                                    return;
                                }
                                MdiEntryVitalityImageSWT mdiEntryVitalityImageSWT = MdiEntryVitalityImageSWT.this;
                                mdiEntryVitalityImageSWT.currentAnimationIndex = mdiEntryVitalityImageSWT.currentAnimationIndex + 1;
                                if (MdiEntryVitalityImageSWT.this.currentAnimationIndex >= MdiEntryVitalityImageSWT.this.images.length) {
                                    MdiEntryVitalityImageSWT.this.currentAnimationIndex = 0;
                                }
                                if (MdiEntryVitalityImageSWT.this.mdiEntry instanceof MdiEntrySWT) {
                                    ((MdiEntrySWT)MdiEntryVitalityImageSWT.this.mdiEntry).redraw(MdiEntryVitalityImageSWT.this.hitArea);
                                }
                            }
                        });
                    }
                };
            }
            this.timerEvent = SimpleTimer.addPeriodicEvent("Animate " + this.mdiEntry.getViewID() + "::" + this.imageID + this.suffix, delay, this.performer);
        }
    }

    public int getCurrentAnimationIndex(Image[] images) {
        if (this.currentAnimationIndex >= images.length) {
            this.currentAnimationIndex = 0;
        } else if (this.currentAnimationIndex < 0) {
            this.currentAnimationIndex = 0;
        }
        return this.currentAnimationIndex;
    }

    @Override
    public void switchSuffix(String suffix) {
        if (suffix == null) {
            suffix = "";
        }
        if (suffix.equals(this.suffix)) {
            return;
        }
        this.suffix = suffix;
        this.setImageID(this.imageID);
    }

    @Override
    public void setImageID(final String id) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                ImageLoader imageLoader = ImageLoader.getInstance();
                String newFullImageID = String.valueOf(id) + MdiEntryVitalityImageSWT.this.suffix;
                if (newFullImageID.equals(MdiEntryVitalityImageSWT.this.fullImageID)) {
                    return;
                }
                if (MdiEntryVitalityImageSWT.this.fullImageID != null) {
                    imageLoader.releaseImage(MdiEntryVitalityImageSWT.this.fullImageID);
                }
                MdiEntryVitalityImageSWT.this.imageID = id;
                MdiEntryVitalityImageSWT.this.images = imageLoader.getImages(newFullImageID);
                if (MdiEntryVitalityImageSWT.this.images == null || MdiEntryVitalityImageSWT.this.images.length == 0) {
                    imageLoader.releaseImage(newFullImageID);
                    newFullImageID = id;
                    MdiEntryVitalityImageSWT.this.images = imageLoader.getImages(id);
                }
                MdiEntryVitalityImageSWT.this.fullImageID = newFullImageID;
                MdiEntryVitalityImageSWT.this.currentAnimationIndex = 0;
                if (MdiEntryVitalityImageSWT.this.isVisible()) {
                    MdiEntryVitalityImageSWT.this.createTimerEvent();
                }
                if (MdiEntryVitalityImageSWT.this.mdiEntry != null) {
                    MdiEntryVitalityImageSWT.this.mdiEntry.redraw();
                }
            }
        });
    }

    @Override
    public Image getImage() {
        if (this.images == null || this.images.length == 0 || this.currentAnimationIndex >= this.images.length) {
            return null;
        }
        return this.images[this.currentAnimationIndex];
    }

    public void setDelayTime(int delayTime) {
        if (this.delayTime == delayTime) {
            return;
        }
        this.delayTime = delayTime;
        if (this.isVisible()) {
            this.createTimerEvent();
        }
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    @Override
    public int getAlignment() {
        return this.alignment;
    }

    @Override
    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    @Override
    public boolean getShowOutsideOfEntry() {
        return this.showOutsideOfEntry;
    }

    @Override
    public void setShowOutsideOfEntry(boolean showOutsideOfEntry) {
        this.showOutsideOfEntry = showOutsideOfEntry;
    }

    public void setShowOnlyOnSelection(boolean showOnlyOnSelection) {
        this.showOnlyOnSelection = showOnlyOnSelection;
    }

    @Override
    public boolean getShowOnlyOnSelection() {
        return this.showOnlyOnSelection;
    }

    public void setAlwaysLast(boolean alwaysLast) {
        this.alwaysLast = alwaysLast;
    }

    @Override
    public boolean getAlwaysLast() {
        return this.alwaysLast;
    }

    public void dispose() {
        if (this.listeners.size() > 0) {
            this.listeners.clear();
        }
    }
}

