/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.mdi;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.impl.ConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginManager;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.ui.common.util.MenuItemManager;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.debug.ObfuscateImage;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mdi.BaseMDI;
import com.biglybt.ui.swt.mdi.BaseMdiEntry;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.mdi.MdiEntryVitalityImageSWT;
import com.biglybt.ui.swt.mdi.TabbedEntry;
import com.biglybt.ui.swt.mdi.TabbedMdiInterface;
import com.biglybt.ui.swt.mdi.TabbedMdiMaximizeListener;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEventListener;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewEventCancelledException;
import com.biglybt.ui.swt.shells.PopOutManager;
import com.biglybt.ui.swt.shells.main.MainMDISetup;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinFactory;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectTabFolder;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.views.IViewAlwaysInitialize;
import com.biglybt.ui.swt.views.ViewManagerSWT;
import com.biglybt.ui.swt.widgets.TabFolderRenderer;
import com.biglybt.util.DataSourceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class TabbedMDI
extends BaseMDI
implements TabbedMdiInterface,
AEDiagnosticsEvidenceGenerator,
ParameterListener,
ObfuscateImage {
    private static final String KEY_AUTO_CLOSE = "TabbedMDI:autoclose";
    private CTabFolder tabFolder;
    private TabFolderRenderer tabFolderRenderer;
    private LinkedList<TabbedEntry> select_history = new LinkedList();
    protected boolean minimized;
    private int iFolderHeightAdj;
    private final String props_prefix;
    private int minimumCharacters = 25;
    protected boolean isMainMDI;
    private Map mapUserClosedTabs;
    private boolean maximizeVisible = false;
    private boolean minimizeVisible = false;
    private TabbedMdiMaximizeListener maximizeListener;
    private ParameterListener paramFancyTabListener;
    private Composite topRight;
    private boolean destroyEntriesOnDeactivate = true;
    private Object dataSource;
    private boolean allowSubViews = true;

    public TabbedMDI() {
        super(null, "Main", null);
        AEDiagnostics.addWeakEvidenceGenerator(this);
        this.mapUserClosedTabs = new HashMap();
        this.isMainMDI = true;
        this.destroyEntriesOnDeactivate = false;
        this.props_prefix = "sidebar";
        this.setCloseableConfigFile("tabsauto.config");
    }

    public TabbedMDI(Class<?> pluginDataSourceType, String viewID, String props_prefix, UISWTView parentView, Object dataSource) {
        super(pluginDataSourceType, viewID, parentView);
        this.dataSource = dataSource;
        this.props_prefix = props_prefix;
        this.minimumCharacters = 0;
        this.isMainMDI = false;
        this.setCloseableConfigFile(null);
        String key = String.valueOf(this.props_prefix) + ".closedtabs";
        this.mapUserClosedTabs = COConfigurationManager.getMapParameter(key, new HashMap());
        COConfigurationManager.addWeakParameterListener(this, false, key);
        String key2 = String.valueOf(props_prefix) + ".tabOrder";
        List pref = BDecoder.decodeStrings(COConfigurationManager.getListParameter(key2, new ArrayList()));
        this.setPreferredOrder(pref.toArray(new String[0]));
    }

    @Override
    public void buildMDI(Composite parent) {
        Utils.execSWTThread(() -> {
            SWTSkin skin = SWTSkinFactory.getInstance();
            SWTSkinObjectTabFolder soFolder = new SWTSkinObjectTabFolder(skin, skin.getSkinProperties(), this.props_prefix, "tabfolder.fill", parent);
            this.setMainSkinObject(soFolder);
            soFolder.addListener(this);
            skin.addSkinObject(soFolder);
        });
    }

    @Override
    public void buildMDI(SWTSkinObject skinObject) {
        this.setMainSkinObject(skinObject);
        skinObject.addListener(this);
    }

    @Override
    public Object skinObjectCreated(SWTSkinObject skinObject, Object params) {
        Object o = super.skinObjectCreated(skinObject, params);
        this.creatMDI();
        return o;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        MdiEntrySWT[] entries;
        this.saveCloseables();
        MdiEntrySWT[] mdiEntrySWTArray = entries = this.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            MdiEntrySWT entry = mdiEntrySWTArray[n2];
            this.closeEntry(entry, false);
            ++n2;
        }
        String key = String.valueOf(this.props_prefix) + ".closedtabs";
        COConfigurationManager.removeWeakParameterListener(this, key);
        COConfigurationManager.removeParameterListener("GUI_SWT_bFancyTab", this.paramFancyTabListener);
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void creatMDI() {
        Listener mouseDownListener;
        Listener[] mouseDownListeners;
        this.tabFolder = this.soMain instanceof SWTSkinObjectTabFolder ? ((SWTSkinObjectTabFolder)this.soMain).getTabFolder() : new CTabFolder((Composite)this.soMain.getControl(), 2240);
        this.tabFolderRenderer = new TabFolderRenderer(this.tabFolder, new TabFolderRenderer.Adapter(){

            @Override
            public TabbedEntry getTabbedEntryFromTabItem(CTabItem item) {
                return TabbedMDI.this.getEntryFromTabItem(item);
            }
        });
        this.iFolderHeightAdj = this.tabFolder.computeSize((int)-1, (int)0).y;
        if (this.isMainMDI) {
            this.paramFancyTabListener = new ParameterListener(){

                @Override
                public void parameterChanged(String parameterName) {
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            boolean simple = !COConfigurationManager.getBooleanParameter("GUI_SWT_bFancyTab");
                            TabbedMDI.this.tabFolder.setSimple(simple);
                        }
                    });
                }
            };
            COConfigurationManager.addAndFireParameterListener("GUI_SWT_bFancyTab", this.paramFancyTabListener);
            this.tabFolder.setSimple(!COConfigurationManager.getBooleanParameter("GUI_SWT_bFancyTab"));
        } else {
            this.tabFolder.setSimple(true);
            this.tabFolder.setMaximizeVisible(this.maximizeVisible);
            this.tabFolder.setMinimizeVisible(this.minimizeVisible);
            this.tabFolder.setUnselectedCloseVisible(false);
        }
        Display display = this.tabFolder.getDisplay();
        float[] hsb = this.tabFolder.getBackground().getRGB().getHSB();
        hsb[2] = (float)((double)hsb[2] * (Constants.isOSX ? 0.9 : 0.97));
        this.tabFolder.setBackground(ColorCache.getColor((Device)display, hsb));
        hsb = this.tabFolder.getForeground().getRGB().getHSB();
        hsb[2] = (float)((double)hsb[2] * (Constants.isOSX ? 1.1 : 0.03));
        if (!Utils.isDarkAppearanceNativeWindows()) {
            this.tabFolder.setForeground(ColorCache.getColor((Device)display, hsb));
            this.tabFolder.setSelectionBackground(new Color[]{Colors.getSystemColor((Device)display, 25), Colors.getSystemColor((Device)display, 25), Colors.getSystemColor((Device)display, 22)}, new int[]{10, 90}, true);
            this.tabFolder.setSelectionForeground(Colors.getSystemColor((Device)display, 24));
        }
        if (this.minimumCharacters > 0) {
            this.tabFolder.setMinimumCharacters(this.minimumCharacters);
        }
        this.tabFolder.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                CTabItem item = (CTabItem)event2.item;
                TabbedEntry entry = (TabbedEntry)item.getData("TabbedEntry");
                if (!TabbedMDI.this.isMainMDI && !TabbedMDI.this.soMain.isDisposed() && item.getData(TabbedMDI.KEY_AUTO_CLOSE) == null) {
                    String id = entry.getViewID();
                    String key = String.valueOf(TabbedMDI.this.props_prefix) + ".selectedTab";
                    COConfigurationManager.setParameter(key, id);
                }
                TabbedMDI.this.showEntry(entry);
            }
        });
        this.tabFolder.addMouseMoveListener(e -> {
            CTabItem item;
            MdiEntryVitalityImageSWT vitalityImage = this.getVitalityImageAtPos(e.x, e.y);
            String tooltip = null;
            Cursor cursor = null;
            if (vitalityImage != null && vitalityImage.isVisible()) {
                if (vitalityImage.hasListeners()) {
                    cursor = e.display.getSystemCursor(21);
                }
                tooltip = vitalityImage.getToolTip();
            }
            if (this.tabFolder.getCursor() != cursor) {
                this.tabFolder.setCursor(cursor);
            }
            if ((item = this.tabFolder.getItem(new Point(e.x, e.y))) != null && item.getToolTipText() != tooltip) {
                item.setToolTipText(tooltip);
            }
        });
        Listener[] listenerArray = mouseDownListeners = this.tabFolder.getListeners(3);
        int n = mouseDownListeners.length;
        int n2 = 0;
        while (n2 < n) {
            mouseDownListener = listenerArray[n2];
            this.tabFolder.removeListener(3, mouseDownListener);
            ++n2;
        }
        Utils.addSafeMouseUpListener((Control)this.tabFolder, e -> e.widget.setData("downedVI", (Object)this.getVitalityImageAtPos(e.x, e.y)), e -> {
            MdiEntryVitalityImageSWT vi = (MdiEntryVitalityImageSWT)e.widget.getData("downedVI");
            e.widget.setData("downedVI", null);
            if (e.button != 1) {
                return;
            }
            if (vi != null && vi.hasListeners()) {
                MdiEntryVitalityImageSWT viUp = this.getVitalityImageAtPos(e.x, e.y);
                if (vi != viUp) {
                    return;
                }
                vi.triggerClickedListeners(e.x, e.y);
                return;
            }
            if (this.tabFolder.getMinimized()) {
                this.restore();
                e.button = 0;
                this.tabFolder.notifyListeners(7, null);
            }
        });
        listenerArray = mouseDownListeners;
        n = mouseDownListeners.length;
        n2 = 0;
        while (n2 < n) {
            mouseDownListener = listenerArray[n2];
            this.tabFolder.addListener(3, mouseDownListener);
            ++n2;
        }
        this.tabFolder.addListener(8, e -> {
            if (!this.tabFolder.getMinimized() && this.tabFolder.getMinimizeVisible()) {
                this.minimize();
            }
        });
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void minimize(CTabFolderEvent event2) {
                TabbedMDI.this.minimize();
            }

            public void maximize(CTabFolderEvent event2) {
                if (TabbedMDI.this.maximizeListener != null) {
                    TabbedMDI.this.maximizeListener.maximizePressed();
                }
            }

            public void restore(CTabFolderEvent event_maybe_null) {
                TabbedMDI.this.restore();
            }

            public void close(CTabFolderEvent event2) {
                TabbedEntry prev;
                UISWTViewBuilderCore builder;
                TabbedEntry entry = (TabbedEntry)event2.item.getData("TabbedEntry");
                UISWTViewBuilderCore uISWTViewBuilderCore = builder = entry == null ? null : entry.getEventListenerBuilder();
                if (entry != null) {
                    entry.setUserInitiatedClose();
                }
                if ((prev = TabbedMDI.this.getPrevious(entry)) != null) {
                    TabbedMDI.this.showEntry(prev);
                }
                if (TabbedMDI.this.props_prefix != null) {
                    Utils.execSWTThreadLater(0, () -> {
                        String view_id = entry.getViewID();
                        String key = String.valueOf(TabbedMDI.this.props_prefix) + ".closedtabs";
                        Map closedtabs = COConfigurationManager.getMapParameter(key, new HashMap());
                        if (closedtabs.containsKey(view_id)) {
                            return;
                        }
                        closedtabs.put(view_id, entry.getTitle());
                        if (builder != null && builder.getPreferredAfterID() == null) {
                            MdiEntrySWT[] entries = TabbedMDI.this.getEntries();
                            if (entries.length > 1 && entries[0] == entry) {
                                builder.setPreferredAfterID("~" + entries[1].getViewID());
                            } else {
                                int i = 1;
                                while (i < entries.length) {
                                    MdiEntrySWT e = entries[i];
                                    if (e == entry) {
                                        builder.setPreferredAfterID(entries[i - 1].getViewID());
                                        break;
                                    }
                                    ++i;
                                }
                            }
                        }
                        COConfigurationManager.setParameter(key, closedtabs);
                    });
                }
            }
        });
        if (this.isMainMDI) {
            this.tabFolder.getDisplay().addFilter(1, new Listener(){

                public void handleEvent(Event event2) {
                    TabbedEntry current;
                    if (TabbedMDI.this.tabFolder.isDisposed()) {
                        return;
                    }
                    Control focus_control = TabbedMDI.this.tabFolder.getDisplay().getFocusControl();
                    if (focus_control != null && focus_control.getShell() != TabbedMDI.this.tabFolder.getShell()) {
                        return;
                    }
                    int key = event2.character;
                    if ((event2.stateMask & SWT.MOD1) != 0 && event2.character <= '\u001a' && event2.character > '\u0000') {
                        key += 96;
                    }
                    if (key == 27 || event2.keyCode == 0x100000D && event2.stateMask == 262144) {
                        TabbedMDI.this.closeEntry(TabbedMDI.this.getCurrentEntry(), true);
                        event2.doit = false;
                    } else if (event2.keyCode == 0x100000F || event2.character == '\t' && (event2.stateMask & 0x40000) != 0) {
                        if ((event2.stateMask & 0x20000) == 0) {
                            event2.doit = false;
                            TabbedMDI.this.selectNextTab(true);
                        } else if (event2.stateMask == 131072) {
                            TabbedMDI.this.selectNextTab(false);
                            event2.doit = false;
                        }
                    } else if (focus_control == TabbedMDI.this.tabFolder && (current = TabbedMDI.this.getCurrentEntry()) != null && current.processAccelerator(event2.character, event2.stateMask)) {
                        event2.doit = false;
                    }
                }
            });
        }
        this.tabFolder.getTabHeight();
        final Menu menu = new Menu((Control)this.tabFolder);
        this.tabFolder.setMenu(menu);
        MenuBuildUtils.addMaintenanceListenerForMenu(menu, new MenuBuildUtils.MenuBuilder(){

            @Override
            public void buildMenu(Menu root_menu, MenuEvent event2) {
                Point cursorLocation = event2.display.getCursorLocation();
                Point ptOnControl = TabbedMDI.this.tabFolder.toControl(cursorLocation.x, cursorLocation.y);
                if (ptOnControl.y > TabbedMDI.this.tabFolder.getTabHeight()) {
                    return;
                }
                CTabItem item = TabbedMDI.this.tabFolder.getItem(TabbedMDI.this.tabFolder.toControl(cursorLocation.x, cursorLocation.y));
                if (item == null) {
                    for (Object id : TabbedMDI.this.mapUserClosedTabs.keySet()) {
                        String temp;
                        final String view_id = (String)id;
                        MenuItem mi = new MenuItem(menu, 8);
                        Object oTitle = TabbedMDI.this.mapUserClosedTabs.get(id);
                        String title = oTitle instanceof String && ((String)oTitle).length() > 0 ? (String)oTitle : MessageText.getString(TabbedMDI.this.getViewTitleID(view_id));
                        if (title.contains(".") && (temp = MessageText.getString(title)) != null && !temp.isEmpty()) {
                            title = temp;
                        }
                        mi.setText(title);
                        mi.addListener(13, new Listener(){

                            public void handleEvent(Event event2) {
                                Map closedtabs;
                                String key = String.valueOf(TabbedMDI.this.props_prefix) + ".openedtabs";
                                Map openedTabs = COConfigurationManager.getMapParameter(key, new HashMap());
                                if (!openedTabs.containsKey(view_id)) {
                                    openedTabs.put(view_id, 1);
                                    COConfigurationManager.setParameter(key, openedTabs);
                                }
                                if ((closedtabs = COConfigurationManager.getMapParameter(key = String.valueOf(TabbedMDI.this.props_prefix) + ".closedtabs", new HashMap())).containsKey(view_id)) {
                                    closedtabs.remove(view_id);
                                    COConfigurationManager.setParameter(key, closedtabs);
                                }
                                if (!(this).TabbedMDI.this.isMainMDI) {
                                    CTabItem[] items = TabbedMDI.this.tabFolder.getItems();
                                    ArrayList<String> ids = new ArrayList<String>();
                                    CTabItem[] cTabItemArray = items;
                                    int n = items.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        CTabItem item = cTabItemArray[n2];
                                        TabbedEntry e = TabbedMDI.this.getEntryFromTabItem(item);
                                        if (e != null) {
                                            ids.add(e.getViewID());
                                        }
                                        ++n2;
                                    }
                                    if (!ids.contains(view_id)) {
                                        ids.add(view_id);
                                    }
                                    TabbedMDI.this.setPreferredOrder(ids.toArray(new String[0]));
                                    String key2 = String.valueOf(TabbedMDI.this.props_prefix) + ".tabOrder";
                                    COConfigurationManager.setParameter(key2, ids);
                                }
                                TabbedMDI.this.showEntryByID(view_id);
                            }
                        });
                    }
                    if (!TabbedMDI.this.mapUserClosedTabs.isEmpty()) {
                        new MenuItem(menu, 2);
                    }
                    MenuItem miReset = new MenuItem(menu, 8);
                    miReset.setText(MessageText.getString("menu.reset.tabs"));
                    miReset.addListener(13, ev -> {
                        TabbedMDI.this.mapUserClosedTabs.clear();
                        String key = String.valueOf(TabbedMDI.this.props_prefix) + ".closedtabs";
                        COConfigurationManager.setParameter(key, TabbedMDI.this.mapUserClosedTabs);
                        key = String.valueOf(TabbedMDI.this.props_prefix) + ".openedtabs";
                        COConfigurationManager.setParameter(key, new HashMap());
                        TabbedMDI.this.setPreferredOrder(new String[0]);
                        String key2 = String.valueOf(TabbedMDI.this.props_prefix) + ".tabOrder";
                        COConfigurationManager.setParameter(key2, new ArrayList());
                        TabbedMDI.this.buildTabs();
                    });
                    new MenuItem(menu, 2);
                }
                TabbedEntry entry = null;
                if (item != null) {
                    entry = TabbedMDI.this.getEntryFromTabItem(item);
                    TabbedMDI.this.showEntry(entry);
                }
                TabbedMDI.this.fillMenu(menu, entry, TabbedMDI.this.props_prefix);
            }
        });
        if (this.minimizeVisible) {
            boolean toMinimize = ConfigurationManager.getInstance().getBooleanParameter(String.valueOf(this.props_prefix) + ".subViews.minimized");
            this.setMinimized(toMinimize);
        }
        if (!this.isMainMDI) {
            this.addDragDropListeners();
        }
        this.buildTabs();
    }

    private void addDragDropListeners() {
        DragSource dragSource = new DragSource((Control)this.tabFolder, 2);
        dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){
            private CTabItem item;

            public void dragStart(DragSourceEvent event2) {
                Point cursorLocation = TabbedMDI.this.tabFolder.getDisplay().getCursorLocation();
                Point p = TabbedMDI.this.tabFolder.toControl(cursorLocation);
                this.item = TabbedMDI.this.tabFolder.getItem(p);
                event2.doit = this.item != null;
            }

            public void dragSetData(DragSourceEvent event2) {
                if (this.item != null) {
                    event2.data = ((TabbedEntry)this.item.getData("TabbedEntry")).getViewID();
                } else {
                    event2.data = null;
                    event2.doit = false;
                }
            }
        });
        DropTarget dropTarget = new DropTarget((Control)this.tabFolder, 2);
        dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){
            private int pos;

            public void dragOver(DropTargetEvent event2) {
                Point rel = TabbedMDI.this.tabFolder.toControl(new Point(event2.x, event2.y));
                if (rel.y > TabbedMDI.this.tabFolder.getTabHeight()) {
                    event2.detail = 0;
                    this.pos = -1;
                } else {
                    event2.detail = 2;
                    CTabItem item = TabbedMDI.this.tabFolder.getItem(rel);
                    this.pos = item == null ? TabbedMDI.this.tabFolder.getItemCount() - 1 : TabbedMDI.this.tabFolder.indexOf(item);
                }
            }

            public void drop(DropTargetEvent event2) {
                if (this.pos < 0) {
                    return;
                }
                CTabItem[] items = TabbedMDI.this.tabFolder.getItems();
                ArrayList<String> ids = new ArrayList<String>();
                CTabItem[] cTabItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    CTabItem x = cTabItemArray[n2];
                    ids.add(((TabbedEntry)x.getData("TabbedEntry")).getViewID());
                    ++n2;
                }
                String target_id = (String)event2.data;
                if (ids.indexOf(target_id) == this.pos) {
                    return;
                }
                ids.remove(target_id);
                ids.add(this.pos, target_id);
                TabbedMDI.this.setPreferredOrder(ids.toArray(new String[0]));
                String key2 = String.valueOf(TabbedMDI.this.props_prefix) + ".tabOrder";
                COConfigurationManager.setParameter(key2, ids);
                TabbedMDI.this.buildTabs();
            }
        });
        this.tabFolder.addListener(12, ev -> {
            dragSource.dispose();
            dropTarget.dispose();
        });
    }

    private void buildTabs() {
        CTabItem item;
        CTabItem[] items = this.tabFolder.getItems();
        Object object = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            item = object[n2];
            item.setData(KEY_AUTO_CLOSE, (Object)true);
            ++n2;
        }
        object = items;
        n = items.length;
        n2 = 0;
        while (n2 < n) {
            item = object[n2];
            item.dispose();
            ++n2;
        }
        ViewManagerSWT vm = ViewManagerSWT.getInstance();
        List<UISWTViewBuilderCore> builders = vm.getBuilders(this.getViewID(), this.getDataSourceType());
        for (UISWTViewBuilderCore builder : builders) {
            String view_id;
            String key;
            Map openedTabs;
            boolean defaultVisibility = builder.getDefaultVisibility();
            if (!(defaultVisibility || (openedTabs = COConfigurationManager.getMapParameter(key = String.valueOf(this.props_prefix) + ".openedtabs", new HashMap())).containsKey(view_id = builder.getViewID()) || this.mapUserClosedTabs.containsKey(view_id))) {
                key = String.valueOf(this.props_prefix) + ".closedtabs";
                Map closedTabs = COConfigurationManager.getMapParameter(key, new HashMap());
                closedTabs.put(view_id, builder.getInitialTitle());
                COConfigurationManager.setParameter(key, closedTabs);
            }
            try {
                this.createEntry(builder, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.isMainMDI) {
            Utils.execSWTThreadLater(0, () -> {
                int index;
                String key = String.valueOf(this.props_prefix) + ".selectedTab";
                String id = COConfigurationManager.getStringParameter(key, null);
                if (id != null && (index = this.indexOf(id)) != -1) {
                    this.tabFolder.setSelection(index);
                    return;
                }
                if (this.tabFolder.getItemCount() > 0) {
                    this.tabFolder.setSelection(0);
                }
            });
        }
    }

    private MdiEntryVitalityImageSWT getVitalityImageAtPos(int x, int y) {
        CTabItem item = this.tabFolder.getItem(new Point(x, y));
        if (item == null) {
            return null;
        }
        TabbedEntry entry = this.getEntryFromTabItem(item);
        if (entry == null) {
            return null;
        }
        List<MdiEntryVitalityImageSWT> vitalityImages = entry.getVitalityImages();
        for (MdiEntryVitalityImageSWT vitalityImage : vitalityImages) {
            Rectangle hitArea;
            if (!vitalityImage.isVisible() || (hitArea = vitalityImage.getHitArea()) == null || !hitArea.contains(x, y)) continue;
            return vitalityImage;
        }
        return null;
    }

    private String getViewTitleID(String view_id) {
        String history_key = "swt.ui.table.tab.view.namecache." + view_id;
        String id = COConfigurationManager.getStringParameter(history_key, "");
        if (id.length() == 0) {
            String test = String.valueOf(view_id) + ".title.full";
            if (MessageText.keyExists(test)) {
                return test;
            }
            id = "!" + view_id + "!";
        }
        return id;
    }

    private void minimize() {
        this.minimized = true;
        this.tabFolder.setMinimized(true);
        CTabItem[] items = this.tabFolder.getItems();
        String tt = MessageText.getString("label.click.to.restore");
        int i = 0;
        while (i < items.length) {
            CTabItem tabItem = items[i];
            Utils.setTT(tabItem, tt);
            Control control = tabItem.getControl();
            if (control != null && !control.isDisposed()) {
                tabItem.getControl().setVisible(false);
            }
            ++i;
        }
        this.tabFolder.getParent().notifyListeners(11, null);
        this.showEntry(null);
        ConfigurationManager configMan = ConfigurationManager.getInstance();
        configMan.setParameter(String.valueOf(this.props_prefix) + ".subViews.minimized", true);
    }

    private void restore() {
        this.minimized = false;
        this.tabFolder.setMinimized(false);
        CTabItem selection = this.tabFolder.getSelection();
        if (selection != null) {
            TabbedEntry tabbedEntry = this.getEntryFromTabItem(selection);
            this.showEntry(tabbedEntry);
            tabbedEntry.updateUI(true);
        }
        if (this.tabFolder.getMaximizeVisible()) {
            CTabItem[] items = this.tabFolder.getItems();
            String tt = MessageText.getString("label.dblclick.to.min");
            int i = 0;
            while (i < items.length) {
                CTabItem tabItem = items[i];
                Utils.setTT(tabItem, tt);
                ++i;
            }
        }
        this.tabFolder.getParent().notifyListeners(11, null);
        ConfigurationManager configMan = ConfigurationManager.getInstance();
        configMan.setParameter(String.valueOf(this.props_prefix) + ".subViews.minimized", false);
    }

    private void selectNextTab(boolean selectNext) {
        if (this.tabFolder == null || this.tabFolder.isDisposed()) {
            return;
        }
        int nextOrPrevious = selectNext ? 1 : -1;
        int index = this.tabFolder.getSelectionIndex() + nextOrPrevious;
        if (index == 0 && selectNext || index == -2 || this.tabFolder.getItemCount() < 2) {
            return;
        }
        if (index == this.tabFolder.getItemCount()) {
            index = 0;
        } else if (index < 0) {
            index = this.tabFolder.getItemCount() - 1;
        }
        CTabItem item = this.tabFolder.getItem(index);
        TabbedEntry entry = this.getEntryFromTabItem(item);
        if (entry != null) {
            this.showEntry(entry);
        }
    }

    @Override
    protected boolean wasEntryLoadedOnce(String id) {
        boolean loadedOnce = COConfigurationManager.getBooleanParameter("tab.once." + id, false);
        return loadedOnce;
    }

    @Override
    protected void setEntryLoadedOnce(String id) {
        COConfigurationManager.setParameter("tab.once." + id, true);
    }

    private TabbedEntry getPrevious(TabbedEntry current) {
        TabbedEntry next;
        if (this.select_history.remove(current) && this.select_history.size() > 0 && Utils.isSWTThread() && !(next = this.select_history.getLast()).isEntryDisposed() && next != current) {
            CTabItem[] items = this.tabFolder.getItems();
            int i = 0;
            while (i < items.length) {
                CTabItem item = items[i];
                TabbedEntry scanEntry = this.getEntryFromTabItem(item);
                if (scanEntry == next) {
                    this.tabFolder.setSelection(item);
                    break;
                }
                ++i;
            }
            return next;
        }
        return null;
    }

    @Override
    public void showEntry(MdiEntry _newEntry) {
        TabbedEntry oldEntry;
        if (_newEntry == null) {
            return;
        }
        TabbedEntry newEntry = (TabbedEntry)_newEntry;
        this.select_history.remove(newEntry);
        this.select_history.add(newEntry);
        if (this.select_history.size() > 64) {
            this.select_history.removeFirst();
        }
        if (newEntry == (oldEntry = this.getCurrentEntry()) && oldEntry != null) {
            ((BaseMdiEntry)newEntry).show();
            this.triggerSelectionListener(newEntry, newEntry);
            return;
        }
        if (oldEntry != null) {
            oldEntry.hide();
        }
        this.setCurrentEntry(newEntry);
        if (newEntry instanceof BaseMdiEntry) {
            ((BaseMdiEntry)newEntry).show();
        }
        this.triggerSelectionListener(newEntry, oldEntry);
    }

    private TabbedEntry createEntryFromSkinRef(String id, String configID, String title, ViewTitleInfo titleInfo, Object params, boolean closeable, String preferredAfterID) {
        TabbedEntry oldEntry = this.getEntry(id);
        if (oldEntry != null) {
            return oldEntry;
        }
        TabbedEntry entry = new TabbedEntry(this, this.skin, id);
        entry.setTitle(title);
        entry.setDatasource(this.dataSource);
        entry.setSkinRef(configID, params);
        entry.setViewTitleInfo(titleInfo);
        entry.setDestroyOnDeactivate(this.destroyEntriesOnDeactivate);
        entry.setPreferredAfterID(preferredAfterID);
        entry.setCloseable(closeable);
        entry.setParentView(this.getParentView());
        this.setupNewEntry(entry);
        return entry;
    }

    @Override
    public TabbedEntry createEntryFromSkinRef(String parentEntryID, String id, String configID, String title, ViewTitleInfo titleInfo, Object params, boolean closeable, String preferedAfterID) {
        return this.createEntryFromSkinRef(id, configID, title, titleInfo, params, closeable, preferedAfterID);
    }

    @Override
    public TabbedEntry createEntry(UISWTViewBuilderCore builder, boolean closeable) {
        String id = builder.getViewID();
        if (this.isEntryClosedByUser(id)) {
            return null;
        }
        TabbedEntry oldEntry = this.getEntry(id);
        if (oldEntry != null) {
            oldEntry.setDatasource(builder.getInitialDataSource());
            return oldEntry;
        }
        TabbedEntry entry = new TabbedEntry(this, this.skin, id);
        entry.setDatasource(this.dataSource == null ? builder.getInitialDataSource() : this.dataSource);
        String preferredAfterID = builder.getPreferredAfterID();
        entry.setPreferredAfterID(preferredAfterID);
        entry.setDestroyOnDeactivate(this.destroyEntriesOnDeactivate);
        entry.setTitle(builder.getInitialTitle());
        entry.setCloseable(closeable);
        entry.setParentView(this.getParentView());
        try {
            this.addItem(entry);
            UISWTViewEventListener l = builder.createEventListener(entry);
            entry.setEventListener(l, builder, true);
            this.setupNewEntry(entry);
            this.addMenus(entry, id);
            if (l instanceof IViewAlwaysInitialize) {
                entry.build();
            }
        }
        catch (Exception e) {
            if (!(e instanceof UISWTViewEventCancelledException)) {
                Debug.out("Can't create " + builder.getViewID(), e);
            }
            this.closeEntry(entry, false);
            return null;
        }
        return entry;
    }

    @Override
    protected BaseMdiEntry closeEntryByID(String id, boolean userInitiated) {
        TabbedEntry existing = this.getEntry(id);
        TabbedEntry prev = this.getPrevious(existing);
        BaseMdiEntry entry = super.closeEntryByID(id, userInitiated);
        if (entry == null || Utils.isDisplayDisposed()) {
            return entry;
        }
        if (userInitiated && prev != null) {
            this.showEntry(prev);
        }
        return entry;
    }

    @Override
    public void updateUI() {
        if (this.getMinimized() || !this.isVisible()) {
            return;
        }
        super.updateUI();
    }

    private boolean isEntryClosedByUser(String id) {
        return this.mapUserClosedTabs.containsKey(id);
    }

    private void setupNewEntry(TabbedEntry entry) {
        this.addItem(entry);
        Utils.execSWTThreadLater(0, () -> this.swt_setupNewEntry(entry));
    }

    private void swt_setupNewEntry(TabbedEntry entry) {
        if (this.tabFolder == null || this.tabFolder.isDisposed()) {
            return;
        }
        String viewID = entry.getViewID();
        if (this.getEntry(viewID) != entry) {
            return;
        }
        int index = -1;
        String preferredAfterID = entry.getPreferredAfterID();
        if (preferredAfterID != null) {
            if (preferredAfterID.length() == 0) {
                index = 0;
            } else {
                boolean preferBefore = preferredAfterID.startsWith("~");
                if (preferBefore) {
                    preferredAfterID = preferredAfterID.substring(1);
                }
                index = this.indexOf(preferredAfterID);
                if (!preferBefore && index >= 0) {
                    ++index;
                }
            }
        }
        if (index == -1) {
            String[] order = this.getPreferredOrder();
            int i = 0;
            block0: while (i < order.length) {
                String orderID = order[i];
                if (orderID.equals(viewID)) {
                    Integer x;
                    CTabItem[] items = this.tabFolder.getItems();
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    int j = 0;
                    while (j < items.length) {
                        TabbedEntry e = this.getEntryFromTabItem(items[j]);
                        if (e != null) {
                            map.put(e.getViewID(), j);
                        }
                        ++j;
                    }
                    j = i - 1;
                    while (j >= 0) {
                        x = (Integer)map.get(order[j]);
                        if (x != null) {
                            index = x + 1;
                            break;
                        }
                        --j;
                    }
                    if (index != -1) break;
                    j = i + 1;
                    while (j < order.length) {
                        x = (Integer)map.get(order[j]);
                        if (x != null) {
                            index = x;
                            break block0;
                        }
                        ++j;
                    }
                    break;
                }
                ++i;
            }
        }
        if (index < 0 || index >= this.tabFolder.getItemCount()) {
            index = this.tabFolder.getItemCount();
        }
        CTabItem cTabItem = new CTabItem(this.tabFolder, 0, index);
        cTabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TabbedMDI.this.tabFolder.getItemCount() == 0) {
                    TabbedMDI.this.setCurrentEntry(null);
                }
            }
        });
        cTabItem.setData("TabbedEntry", (Object)entry);
        entry.setSwtItem(cTabItem);
        if (this.tabFolder.getItemCount() == 1) {
            Utils.execSWTThreadLater(0, new AERunnable(){

                @Override
                public void runSupport() {
                    if (TabbedMDI.this.getCurrentEntry() != null || TabbedMDI.this.tabFolder.isDisposed()) {
                        return;
                    }
                    CTabItem selection = TabbedMDI.this.tabFolder.getSelection();
                    if (selection == null) {
                        if (TabbedMDI.this.tabFolder.getItemCount() > 0) {
                            selection = TabbedMDI.this.tabFolder.getItem(0);
                        } else {
                            return;
                        }
                    }
                    TabbedEntry entry = TabbedMDI.this.getEntryFromTabItem(selection);
                    TabbedMDI.this.showEntry(entry);
                }
            });
        }
    }

    private int indexOf(MdiEntry entry) {
        CTabItem[] items = this.tabFolder.getItems();
        int i = 0;
        while (i < items.length) {
            if (this.getEntryFromTabItem(items[i]) == entry) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int indexOf(String viewID) {
        CTabItem[] items = this.tabFolder.getItems();
        int i = 0;
        while (i < items.length) {
            TabbedEntry entry = this.getEntryFromTabItem(items[i]);
            if (entry != null && entry.getViewID().equals(viewID)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected TabbedEntry getEntryFromTabItem(CTabItem item) {
        if (item.isDisposed()) {
            return null;
        }
        return (TabbedEntry)item.getData("TabbedEntry");
    }

    @Override
    public String getUpdateUIName() {
        String name = "MDI";
        TabbedEntry entry = this.getCurrentEntry();
        if (entry != null) {
            name = String.valueOf(name) + "-" + entry.getViewID();
        }
        return name;
    }

    @Override
    public void generate(IndentWriter writer) {
        MdiEntrySWT[] entries;
        MdiEntrySWT[] mdiEntrySWTArray = entries = this.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                MdiEntrySWT entry = mdiEntrySWTArray[n2];
                if (entry != null && !(entry instanceof AEDiagnosticsEvidenceGenerator)) {
                    writer.println("TabbedMdi View (No Generator): " + entry.getViewID());
                    try {
                        try {
                            writer.indent();
                            writer.println("Parent: " + entry.getParentID());
                            writer.println("Title: " + entry.getTitle());
                        }
                        catch (Exception exception) {
                            writer.exdent();
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        writer.exdent();
                        throw throwable;
                    }
                    writer.exdent();
                }
            }
            ++n2;
        }
    }

    @Override
    public TabbedEntry createHeader(String id, String title, String preferredAfterID) {
        return null;
    }

    @Override
    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    @Override
    public void setMaximizeVisible(final boolean visible) {
        this.maximizeVisible = visible;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (TabbedMDI.this.tabFolder == null || TabbedMDI.this.tabFolder.isDisposed()) {
                    return;
                }
                TabbedMDI.this.tabFolder.setMaximizeVisible(visible);
            }
        });
    }

    @Override
    public void setMinimizeVisible(final boolean visible) {
        this.minimizeVisible = visible;
        if (this.minimizeVisible) {
            boolean toMinimize = ConfigurationManager.getInstance().getBooleanParameter(String.valueOf(this.props_prefix) + ".subViews.minimized");
            this.setMinimized(toMinimize);
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (TabbedMDI.this.tabFolder == null || TabbedMDI.this.tabFolder.isDisposed()) {
                    return;
                }
                TabbedMDI.this.tabFolder.setMinimizeVisible(visible);
            }
        });
    }

    @Override
    public boolean getMinimized() {
        return this.minimized;
    }

    @Override
    public void setMinimized(final boolean minimized) {
        this.minimized = minimized;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (TabbedMDI.this.tabFolder == null || TabbedMDI.this.tabFolder.isDisposed()) {
                    return;
                }
                if (minimized) {
                    TabbedMDI.this.minimize();
                } else {
                    TabbedMDI.this.restore();
                }
            }
        });
    }

    public TabFolderRenderer getRenderer() {
        return this.tabFolderRenderer;
    }

    @Override
    public int getFolderHeight() {
        return this.iFolderHeightAdj;
    }

    @Override
    public void parameterChanged(String parameterName) {
        if (this.isDisposed()) {
            return;
        }
        this.mapUserClosedTabs = COConfigurationManager.getMapParameter(parameterName, new HashMap());
        for (Object id : this.mapUserClosedTabs.keySet()) {
            String view_id = (String)id;
            if (!this.entryExists(view_id)) continue;
            this.closeEntryByID(view_id);
        }
    }

    @Override
    public void setTabbedMdiMaximizeListener(TabbedMdiMaximizeListener l) {
        this.maximizeListener = l;
    }

    @Override
    public void setDestroyEntriesOnDeactivate(boolean destroyEntriesOnDeactivate) {
        MdiEntrySWT[] entries;
        this.destroyEntriesOnDeactivate = destroyEntriesOnDeactivate;
        MdiEntrySWT[] mdiEntrySWTArray = entries = this.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            MdiEntrySWT entry = mdiEntrySWTArray[n2];
            entry.setDestroyOnDeactivate(destroyEntriesOnDeactivate);
            ++n2;
        }
    }

    @Override
    public void setEntriesDataSource(Object newDataSource) {
        MdiEntrySWT[] entries;
        if (DataSourceUtils.areSame(newDataSource, this.dataSource)) {
            return;
        }
        this.dataSource = newDataSource;
        MdiEntrySWT[] mdiEntrySWTArray = entries = this.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            MdiEntrySWT entry = mdiEntrySWTArray[n2];
            entry.setDatasource(this.dataSource);
            ++n2;
        }
        DownloadManager[] dms = DataSourceUtils.getDMs(this.dataSource);
        if (this.maximizeListener != null) {
            this.setMaximizeVisible(dms.length == 1);
        }
    }

    @Override
    public void setAllowSubViews(boolean allowSubViews) {
        this.allowSubViews = allowSubViews;
    }

    @Override
    public boolean getAllowSubViews() {
        return this.allowSubViews;
    }

    public boolean isEmpty() {
        return this.getEntries().length == 0 && (this.mapUserClosedTabs == null || this.mapUserClosedTabs.isEmpty());
    }

    @Override
    public Image obfuscatedImage(Image image) {
        MdiEntrySWT[] entries;
        MdiEntrySWT[] mdiEntrySWTArray = entries = this.getEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            MdiEntrySWT entry = mdiEntrySWTArray[n2];
            if (entry instanceof ObfuscateImage) {
                ObfuscateImage oi = (ObfuscateImage)((Object)entry);
                image = oi.obfuscatedImage(image);
            }
            ++n2;
        }
        return image;
    }

    @Override
    protected MdiEntry createEntryByCreationListener(String id, Map<?, ?> autoOpenInfo) {
        TabbedEntry result = (TabbedEntry)super.createEntryByCreationListener(id, autoOpenInfo);
        if (result != null) {
            this.addMenus(result, id);
        }
        return result;
    }

    private void addMenus(final TabbedEntry entry, String id) {
        com.biglybt.pif.ui.menus.MenuItem menuParentItem;
        PluginManager pm = CoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getDefaultPluginInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        if (!Utils.isAZ2UI()) {
            menuParentItem = menuManager.addMenuItem(String.valueOf(id) + "._end_", "menu.add.to");
            menuParentItem.setStyle(5);
            menuParentItem.setDisposeWithUIDetach("swt");
            menuParentItem.addFillListener(new MenuItemFillListener(){

                @Override
                public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                    Object[] odata;
                    TabbedEntry target = entry;
                    if (data instanceof Object[] && (odata = (Object[])data).length == 1 && odata[0] instanceof TabbedEntry) {
                        target = (TabbedEntry)odata[0];
                    }
                    menu.setVisible(target.canBuildStandAlone());
                }
            });
            com.biglybt.pif.ui.menus.MenuItem menuItemDashBoard = menuManager.addMenuItem(menuParentItem, "label.dashboard");
            menuItemDashBoard.addListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                    TabbedEntry target = entry;
                    if (data instanceof Object[]) {
                        Object[] odata = (Object[])data;
                        if (odata.length == 1 && odata[0] instanceof TabbedEntry) {
                            target = (TabbedEntry)odata[0];
                        }
                    } else if (data instanceof TabbedEntry) {
                        target = (TabbedEntry)data;
                    }
                    MainMDISetup.getSb_dashboard().addItem(target);
                }
            });
            com.biglybt.pif.ui.menus.MenuItem menuItemTopbar = menuManager.addMenuItem(menuParentItem, "label.topbar");
            menuItemTopbar.addListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                    TabbedEntry target = entry;
                    if (data instanceof Object[]) {
                        Object[] odata = (Object[])data;
                        if (odata.length == 1 && odata[0] instanceof TabbedEntry) {
                            target = (TabbedEntry)odata[0];
                        }
                    } else if (data instanceof TabbedEntry) {
                        target = (TabbedEntry)data;
                    }
                    MainMDISetup.getSb_dashboard().addItemToTopbar(target);
                }
            });
            com.biglybt.pif.ui.menus.MenuItem menuItemSidebar = menuManager.addMenuItem(menuParentItem, "label.sidebar");
            menuItemSidebar.addListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                    TabbedEntry target = entry;
                    if (data instanceof Object[]) {
                        Object[] odata = (Object[])data;
                        if (odata.length == 1 && odata[0] instanceof TabbedEntry) {
                            target = (TabbedEntry)odata[0];
                        }
                    } else if (data instanceof TabbedEntry) {
                        target = (TabbedEntry)data;
                    }
                    MainMDISetup.getSb_dashboard().addItemToSidebar(target);
                }
            });
            com.biglybt.pif.ui.menus.MenuItem menuItemRightbar = menuManager.addMenuItem(menuParentItem, "label.rightbar");
            menuItemRightbar.addListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                    TabbedEntry target = entry;
                    if (data instanceof Object[]) {
                        Object[] odata = (Object[])data;
                        if (odata.length == 1 && odata[0] instanceof TabbedEntry) {
                            target = (TabbedEntry)odata[0];
                        }
                    } else if (data instanceof TabbedEntry) {
                        target = (TabbedEntry)data;
                    }
                    MainMDISetup.getSb_dashboard().addItemToRightbar(target);
                }
            });
        }
        menuParentItem = menuManager.addMenuItem(String.valueOf(id) + "._end_", "label.pop.out");
        menuParentItem.setStyle(5);
        menuParentItem.setDisposeWithUIDetach("swt");
        menuParentItem.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                Object[] odata;
                TabbedEntry target = entry;
                if (data instanceof Object[] && (odata = (Object[])data).length == 1 && odata[0] instanceof TabbedEntry) {
                    target = (TabbedEntry)odata[0];
                }
                menu.setVisible(target.canBuildStandAlone());
            }
        });
        com.biglybt.pif.ui.menus.MenuItem menuItemIndependent = menuManager.addMenuItem(menuParentItem, "menu.independent");
        final com.biglybt.pif.ui.menus.MenuItem menuItemOnTop = menuManager.addMenuItem(menuParentItem, "menu.on.top");
        MenuItemListener listener = new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                TabbedEntry target = entry;
                if (data instanceof Object[]) {
                    Object[] odata = (Object[])data;
                    if (odata.length == 1 && odata[0] instanceof TabbedEntry) {
                        target = (TabbedEntry)odata[0];
                    }
                } else if (data instanceof TabbedEntry) {
                    target = (TabbedEntry)data;
                }
                TabbedMDI.this.popoutEntry(target, menu == menuItemOnTop ? PopOutManager.OPT_MAP_ON_TOP : PopOutManager.OPT_MAP_NONE);
            }
        };
        menuItemIndependent.addListener(listener);
        menuItemOnTop.addListener(listener);
    }

    @Override
    public boolean popoutEntry(MdiEntry entry, Map<String, Object> options) {
        return PopOutManager.popOut((TabbedEntry)entry, options);
    }

    @Override
    public void fillMenu(Menu menu, MdiEntry entry, String menuID) {
        com.biglybt.pif.ui.menus.MenuItem[] menu_items;
        super.fillMenu(menu, entry, menuID);
        if (entry != null && (menu_items = MenuItemManager.getInstance().getAllAsArray(String.valueOf(entry.getViewID()) + "._end_")).length > 0) {
            MenuBuildUtils.addPluginMenuItems(menu_items, menu, false, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(new Object[]{entry}));
        }
    }

    @Override
    public String getMenuIdPrefix() {
        return String.valueOf(this.props_prefix) + ".";
    }

    @Override
    protected void setCurrentEntry(MdiEntrySWT entry) {
        super.setCurrentEntry(entry);
        Utils.execSWTThread(this::swt_refreshVitality);
    }

    protected void swt_refreshVitality() {
        UISWTView parentView;
        TabbedEntry currentEntry = this.getCurrentEntry();
        if (currentEntry == null) {
            return;
        }
        if (this.topRight != null) {
            this.topRight.dispose();
        }
        boolean canPopOut = (parentView = this.getParentView()) instanceof UISWTViewCore && ((UISWTViewCore)parentView).canBuildStandAlone();
        List<MdiEntryVitalityImageSWT> vitalityImages = currentEntry.getVitalityImages();
        if (vitalityImages.isEmpty() && !canPopOut) {
            this.topRight = null;
            return;
        }
        this.topRight = new Composite((Composite)this.tabFolder, 0);
        RowLayout layout = new RowLayout(256);
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.wrap = false;
        this.topRight.setLayout((Layout)layout);
        for (MdiEntryVitalityImageSWT vitalityImage : vitalityImages) {
            if (!vitalityImage.isVisible() || !vitalityImage.hasListeners() || !vitalityImage.getShowOutsideOfEntry()) continue;
            Label label = new Label(this.topRight, 0x1000000);
            Image image = ImageLoader.getInstance().getImage(vitalityImage.getImageID());
            label.setImage(image);
            RowData rowData = new RowData();
            rowData.width = image.getBounds().width;
            rowData.height = this.tabFolder.getTabHeight();
            label.setLayoutData((Object)rowData);
            label.setCursor(label.getDisplay().getSystemCursor(21));
            Utils.setTT((Control)label, vitalityImage.getToolTip());
            if (!vitalityImage.hasListeners()) continue;
            Utils.addSafeMouseUpListener((Control)label, event2 -> vitalityImage.triggerClickedListeners(0, 0));
        }
        if (canPopOut) {
            Label label = new Label(this.topRight, 0x1000000);
            Image image = ImageLoader.getInstance().getImage("popout_window");
            label.setImage(image);
            RowData rowData = new RowData();
            rowData.width = image.getBounds().width;
            rowData.height = this.tabFolder.getTabHeight();
            label.setLayoutData((Object)rowData);
            label.setCursor(label.getDisplay().getSystemCursor(21));
            Utils.setTT((Control)label, MessageText.getString("label.pop.out"));
            Utils.addSafeMouseUpListener((Control)label, event2 -> PopOutManager.popOut(parentView, currentEntry));
        }
        this.tabFolder.setTopRight((Control)this.topRight);
    }

    @Override
    public TabbedEntry getEntry(String id) {
        return (TabbedEntry)super.getEntry(id);
    }

    @Override
    public TabbedEntry getCurrentEntry() {
        return (TabbedEntry)super.getCurrentEntry();
    }

    @Override
    public TabbedEntry getEntryBySkinView(Object skinView) {
        return (TabbedEntry)super.getEntryBySkinView(skinView);
    }

    @Override
    public void runWhenIdle(Runnable r) {
        r.run();
    }
}

