/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.nat;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.ipchecker.natchecker.NatChecker;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.networkmanager.admin.NetworkAdminProgressListener;
import com.biglybt.core.networkmanager.admin.NetworkAdminProtocol;
import com.biglybt.core.util.Debug;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.function.Consumer;

public class NATTestHelpers {
    public static void runTCP(int TCPListenPort, Consumer<String> logger) {
        NatChecker checker;
        InetAddress a;
        int n;
        int n2;
        InetAddress[] inetAddressArray;
        InetAddress bind;
        logger.accept(String.valueOf(MessageText.getString("configureWizard.nat.testing")) + " TCP " + TCPListenPort + " ... ");
        InetAddress[] bind_ips = NetworkAdmin.getSingleton().getMultiHomedServiceBindAddresses(true);
        if (NetworkAdmin.getSingleton().hasIPV4Potential()) {
            bind = bind_ips[0];
            if (!bind.isAnyLocalAddress()) {
                inetAddressArray = bind_ips;
                n2 = bind_ips.length;
                n = 0;
                while (n < n2) {
                    a = inetAddressArray[n];
                    if (a instanceof Inet4Address) {
                        bind = a;
                        break;
                    }
                    ++n;
                }
            }
            checker = new NatChecker(CoreFactory.getSingleton(), bind, TCPListenPort, false, false);
            switch (checker.getResult()) {
                case 1: {
                    logger.accept("\n" + MessageText.getString("configureWizard.nat.ok") + " (" + checker.getExternalAddress().getHostAddress() + ")\n" + checker.getAdditionalInfo());
                    break;
                }
                case 2: {
                    logger.accept("\n" + MessageText.getString("configureWizard.nat.ko") + " - " + checker.getAdditionalInfo() + ".\n");
                    break;
                }
                default: {
                    logger.accept("\n" + MessageText.getString("configureWizard.nat.unable") + ". \n(" + checker.getAdditionalInfo() + ").\n");
                    break;
                }
            }
        } else {
            logger.accept("\n\tIPv4 " + MessageText.getString("azbuddy.os_not_avail").toLowerCase());
        }
        if (NetworkAdmin.getSingleton().hasIPV6Potential()) {
            bind = bind_ips[0];
            if (!bind.isAnyLocalAddress()) {
                inetAddressArray = bind_ips;
                n2 = bind_ips.length;
                n = 0;
                while (n < n2) {
                    a = inetAddressArray[n];
                    if (a instanceof Inet6Address) {
                        bind = a;
                        break;
                    }
                    ++n;
                }
            }
            logger.accept("\n" + MessageText.getString("configureWizard.nat.testing") + " TCP " + TCPListenPort + " IPv6 ... ");
            checker = new NatChecker(CoreFactory.getSingleton(), bind, TCPListenPort, true, false);
            switch (checker.getResult()) {
                case 1: {
                    logger.accept("\n" + MessageText.getString("configureWizard.nat.ok") + " (" + checker.getExternalAddress().getHostAddress() + ")\n" + checker.getAdditionalInfo());
                    break;
                }
                case 2: {
                    logger.accept("\n" + MessageText.getString("configureWizard.nat.ko") + " - " + checker.getAdditionalInfo() + ".\n");
                    break;
                }
                default: {
                    logger.accept("\n" + MessageText.getString("configureWizard.nat.unable") + ". \n(" + checker.getAdditionalInfo() + ").\n");
                    break;
                }
            }
        } else {
            logger.accept("\n\tIPv6 " + MessageText.getString("azbuddy.os_not_avail").toLowerCase());
        }
    }

    public static void runUDP(Core core, int udp_port, final Consumer<String> logger) {
        NetworkAdmin admin = NetworkAdmin.getSingleton();
        NetworkAdminProtocol[] inbound_protocols = admin.getInboundProtocols(core);
        NetworkAdminProtocol selected = null;
        NetworkAdminProtocol[] networkAdminProtocolArray = inbound_protocols;
        int n = inbound_protocols.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkAdminProtocol p = networkAdminProtocolArray[n2];
            if (p.getType() == 3 && p.getPort() == udp_port) {
                selected = p;
                break;
            }
            ++n2;
        }
        if (selected == null) {
            selected = admin.createInboundProtocol(core, 3, udp_port);
        }
        if (selected == null) {
            logger.accept("\n" + MessageText.getString("configureWizard.nat.ko") + ". \n( No UDP protocols enabled ).\n");
        } else {
            InetAddress result;
            if (NetworkAdmin.getSingleton().hasIPV4Potential()) {
                logger.accept(String.valueOf(MessageText.getString("configureWizard.nat.testing")) + " UDP " + udp_port + " ... ");
                try {
                    result = selected.test(null, false, true, new NetworkAdminProgressListener(){

                        @Override
                        public void reportProgress(String task2) {
                            logger.accept("\n    " + task2);
                        }
                    });
                    logger.accept("\n" + MessageText.getString("configureWizard.nat.ok") + " (" + result.getHostAddress() + ")\n");
                }
                catch (Throwable e) {
                    logger.accept("\n" + MessageText.getString("configureWizard.nat.ko") + ". " + Debug.getNestedExceptionMessage(e) + ".\n");
                }
            } else {
                logger.accept("\n\tIPv4 " + MessageText.getString("azbuddy.os_not_avail").toLowerCase());
            }
            if (NetworkAdmin.getSingleton().hasIPV6Potential()) {
                logger.accept("\n" + MessageText.getString("configureWizard.nat.testing") + " UDP " + udp_port + " IPv6 ... ");
                try {
                    result = selected.test(null, true, true, new NetworkAdminProgressListener(){

                        @Override
                        public void reportProgress(String task2) {
                            logger.accept("\n    " + task2);
                        }
                    });
                    logger.accept("\n" + MessageText.getString("configureWizard.nat.ok") + " (" + result.getHostAddress() + ")\n");
                }
                catch (Throwable e) {
                    logger.accept("\n" + MessageText.getString("configureWizard.nat.ko") + ". " + Debug.getNestedExceptionMessage(e) + ".\n");
                }
            } else {
                logger.accept("\n\tIPv6 " + MessageText.getString("azbuddy.os_not_avail").toLowerCase());
            }
        }
    }
}

