/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.nat;

import com.biglybt.core.Core;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.nat.NATTestHelpers;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class NatTestWindow {
    Display display;
    Button bTestTCP;
    Button bTestUDP;
    Button bApply;
    Button bCancel;
    StyledText textResults;
    int serverTCPListenPort = COConfigurationManager.getIntParameter("TCP.Listen.Port");
    int serverUDPListenPort = COConfigurationManager.getIntParameter("UDP.Listen.Port");

    public NatTestWindow() {
        final Shell shell = ShellFactory.createMainShell(2160);
        shell.setText(MessageText.getString("configureWizard.nat.title"));
        Utils.setShellIcon(shell);
        this.display = shell.getDisplay();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 64);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.widthHint = 400;
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "configureWizard.nat.message");
        label = new Label(panel, 0);
        label = new Label(panel, 0);
        label = new Label(panel, 0);
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.nat.server.tcp_listen_port");
        final Text textServerTCPListen = new Text(panel, 2048);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        textServerTCPListen.setLayoutData((Object)gridData);
        textServerTCPListen.setText("" + this.serverTCPListenPort);
        textServerTCPListen.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        textServerTCPListen.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                try {
                    int TCPListenPort;
                    NatTestWindow.this.serverTCPListenPort = TCPListenPort = Integer.parseInt(textServerTCPListen.getText());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.bTestTCP = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.bTestTCP, "configureWizard.nat.test");
        gridData = new GridData();
        gridData.widthHint = 70;
        this.bTestTCP.setLayoutData((Object)gridData);
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.nat.server.udp_listen_port");
        final Text textServerUDPListen = new Text(panel, 2048);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        textServerUDPListen.setLayoutData((Object)gridData);
        textServerUDPListen.setText("" + this.serverUDPListenPort);
        textServerUDPListen.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        textServerUDPListen.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                try {
                    int UDPListenPort;
                    NatTestWindow.this.serverUDPListenPort = UDPListenPort = Integer.parseInt(textServerUDPListen.getText());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.bTestUDP = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.bTestUDP, "configureWizard.nat.test");
        gridData = new GridData();
        gridData.widthHint = 70;
        this.bTestUDP.setLayoutData((Object)gridData);
        this.textResults = new StyledText(panel, 2626);
        gridData = new GridData();
        gridData.widthHint = 400;
        gridData.heightHint = 100;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 3;
        this.textResults.setLayoutData((Object)gridData);
        if (!Utils.isDarkAppearanceNative()) {
            this.textResults.setBackground(Colors.getSystemColor((Device)panel.getDisplay(), 1));
        }
        this.bTestTCP.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                NatTestWindow.this.bTestUDP.setEnabled(false);
                NatTestWindow.this.bTestTCP.setEnabled(false);
                NatTestWindow.this.bApply.setEnabled(false);
                NatTestWindow.this.textResults.setText("");
                CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.ANY_THREAD, new CoreRunningListener(){

                    @Override
                    public void coreRunning(Core core) {
                        CheckerTCP checker = new CheckerTCP((this).NatTestWindow.this.serverTCPListenPort);
                        checker.start();
                    }
                });
            }
        });
        this.bTestUDP.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                NatTestWindow.this.bTestUDP.setEnabled(false);
                NatTestWindow.this.bTestTCP.setEnabled(false);
                NatTestWindow.this.bApply.setEnabled(false);
                NatTestWindow.this.textResults.setText("");
                CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.ANY_THREAD, new CoreRunningListener(){

                    @Override
                    public void coreRunning(Core core) {
                        CheckerUDP checker = new CheckerUDP(core, (this).NatTestWindow.this.serverUDPListenPort);
                        checker.start();
                    }
                });
            }
        });
        this.bApply = new Button(panel, 8);
        this.bApply.setText(MessageText.getString("Button.apply"));
        gridData = new GridData();
        gridData.widthHint = 70;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 131072;
        gridData.horizontalSpan = 2;
        this.bApply.setLayoutData((Object)gridData);
        this.bApply.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                int old_tcp = COConfigurationManager.getIntParameter("TCP.Listen.Port");
                int old_udp = COConfigurationManager.getIntParameter("UDP.Listen.Port");
                int old_udp2 = COConfigurationManager.getIntParameter("UDP.NonData.Listen.Port");
                if (old_tcp != NatTestWindow.this.serverTCPListenPort) {
                    COConfigurationManager.setParameter("TCP.Listen.Port", NatTestWindow.this.serverTCPListenPort);
                }
                if (old_udp != NatTestWindow.this.serverUDPListenPort) {
                    COConfigurationManager.setParameter("UDP.Listen.Port", NatTestWindow.this.serverUDPListenPort);
                    if (old_udp == old_udp2) {
                        COConfigurationManager.setParameter("UDP.NonData.Listen.Port", NatTestWindow.this.serverUDPListenPort);
                    }
                }
                COConfigurationManager.save();
                shell.close();
            }
        });
        this.bCancel = new Button(panel, 8);
        this.bCancel.setText(MessageText.getString("Button.cancel"));
        gridData = new GridData();
        gridData.widthHint = 70;
        this.bCancel.setLayoutData((Object)gridData);
        this.bCancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                shell.close();
            }
        });
        shell.setDefaultButton(this.bApply);
        shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    shell.close();
                }
            }
        });
        boolean hasMetrics = Utils.hasShellMetricsConfig("NatTestWindow.metrics");
        Utils.linkShellMetricsToConfig(shell, "NatTestWindow.metrics");
        if (!hasMetrics) {
            shell.pack();
            Utils.centreWindow(shell);
        }
        shell.open();
    }

    public void printMessage(final String message) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            @Override
            public void runSupport() {
                if (NatTestWindow.this.textResults == null || NatTestWindow.this.textResults.isDisposed()) {
                    return;
                }
                NatTestWindow.this.textResults.append(message);
                NatTestWindow.this.textResults.setSelection(NatTestWindow.this.textResults.getText().length());
            }
        });
    }

    public class CheckerTCP
    extends AEThread2 {
        private int TCPListenPort;

        public CheckerTCP(int tcp_listen_port) {
            super("NAT Checker TCP");
            this.TCPListenPort = tcp_listen_port;
        }

        @Override
        public void run() {
            try {
                NATTestHelpers.runTCP(this.TCPListenPort, NatTestWindow.this::printMessage);
            }
            catch (Throwable throwable) {
                if (NatTestWindow.this.display.isDisposed()) {
                    return;
                }
                NatTestWindow.this.display.asyncExec((Runnable)new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (((CheckerTCP)CheckerTCP.this).NatTestWindow.this.bTestTCP != null && !((CheckerTCP)CheckerTCP.this).NatTestWindow.this.bTestTCP.isDisposed()) {
                            ((CheckerTCP)CheckerTCP.this).NatTestWindow.this.bTestTCP.setEnabled(true);
                        }
                        if (((CheckerTCP)CheckerTCP.this).NatTestWindow.this.bTestUDP != null && !((CheckerTCP)CheckerTCP.this).NatTestWindow.this.bTestUDP.isDisposed()) {
                            ((CheckerTCP)CheckerTCP.this).NatTestWindow.this.bTestUDP.setEnabled(true);
                        }
                        if (((CheckerTCP)CheckerTCP.this).NatTestWindow.this.bApply != null && !((CheckerTCP)CheckerTCP.this).NatTestWindow.this.bApply.isDisposed()) {
                            ((CheckerTCP)CheckerTCP.this).NatTestWindow.this.bApply.setEnabled(true);
                        }
                    }
                });
                throw throwable;
            }
            if (NatTestWindow.this.display.isDisposed()) {
                return;
            }
            NatTestWindow.this.display.asyncExec((Runnable)new /* invalid duplicate definition of identical inner class */);
        }
    }

    public class CheckerUDP
    extends AEThread2 {
        private Core core;
        private int udp_port;

        public CheckerUDP(Core _core, int _udp_port) {
            super("NAT Checker UDP");
            this.core = _core;
            this.udp_port = _udp_port;
        }

        @Override
        public void run() {
            try {
                NATTestHelpers.runUDP(this.core, this.udp_port, NatTestWindow.this::printMessage);
            }
            catch (Throwable throwable) {
                if (NatTestWindow.this.display.isDisposed()) {
                    return;
                }
                NatTestWindow.this.display.asyncExec((Runnable)new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (((CheckerUDP)CheckerUDP.this).NatTestWindow.this.bTestTCP != null && !((CheckerUDP)CheckerUDP.this).NatTestWindow.this.bTestTCP.isDisposed()) {
                            ((CheckerUDP)CheckerUDP.this).NatTestWindow.this.bTestTCP.setEnabled(true);
                        }
                        if (((CheckerUDP)CheckerUDP.this).NatTestWindow.this.bTestUDP != null && !((CheckerUDP)CheckerUDP.this).NatTestWindow.this.bTestUDP.isDisposed()) {
                            ((CheckerUDP)CheckerUDP.this).NatTestWindow.this.bTestUDP.setEnabled(true);
                        }
                        if (((CheckerUDP)CheckerUDP.this).NatTestWindow.this.bApply != null && !((CheckerUDP)CheckerUDP.this).NatTestWindow.this.bApply.isDisposed()) {
                            ((CheckerUDP)CheckerUDP.this).NatTestWindow.this.bApply.setEnabled(true);
                        }
                    }
                });
                throw throwable;
            }
            if (NatTestWindow.this.display.isDisposed()) {
                return;
            }
            NatTestWindow.this.display.asyncExec((Runnable)new /* invalid duplicate definition of identical inner class */);
        }
    }
}

