/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.pifimpl;

import com.biglybt.pif.ui.toolbar.UIToolBarItem;
import com.biglybt.pif.ui.toolbar.UIToolBarManager;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentListener;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.pifimpl.UIToolBarItemImpl;
import com.biglybt.ui.swt.pifimpl.UIToolBarManagerCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UIToolBarManagerImpl
implements UIToolBarManagerCore {
    private static UIToolBarManagerImpl instance;
    private final SelectedContentListener selectedContentListener;
    private Map<String, UIToolBarItem> items = new LinkedHashMap<String, UIToolBarItem>();
    private Map<String, List<String>> mapGroupToItemIDs = new HashMap<String, List<String>>();
    public List<ToolBarManagerListener> listListeners = new ArrayList<ToolBarManagerListener>();

    public static UIToolBarManager getInstance() {
        if (instance == null) {
            instance = new UIToolBarManagerImpl();
        }
        return instance;
    }

    public static void destroyInstance() {
        if (instance != null) {
            instance.destroy();
            instance = null;
        }
    }

    public UIToolBarManagerImpl() {
        this.selectedContentListener = new SelectedContentListener(){

            @Override
            public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewID) {
                if (Utils.isDisplayDisposed()) {
                    return;
                }
                if (viewID == null) {
                    ToolBarItem[] allSWTToolBarItems;
                    ToolBarItem[] toolBarItemArray = allSWTToolBarItems = UIToolBarManagerImpl.this.getAllSWTToolBarItems();
                    int n = allSWTToolBarItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ToolBarItem item = toolBarItemArray[n2];
                        item.setState(0L);
                        ++n2;
                    }
                }
            }
        };
        SelectedContentManager.addCurrentlySelectedContentListener(this.selectedContentListener);
    }

    private void destroy() {
        SelectedContentManager.removeCurrentlySelectedContentListener(this.selectedContentListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ToolBarManagerListener l) {
        List<ToolBarManagerListener> list = this.listListeners;
        synchronized (list) {
            this.listListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ToolBarManagerListener l) {
        List<ToolBarManagerListener> list = this.listListeners;
        synchronized (list) {
            this.listListeners.remove(l);
        }
    }

    @Override
    public UIToolBarItem getToolBarItem(String itemID) {
        return this.items.get(itemID);
    }

    @Override
    public UIToolBarItem[] getAllToolBarItems() {
        return this.items.values().toArray(new UIToolBarItem[0]);
    }

    @Override
    public ToolBarItem[] getAllSWTToolBarItems() {
        return this.items.values().toArray(new ToolBarItem[0]);
    }

    @Override
    public UIToolBarItem createToolBarItem(String id) {
        UIToolBarItemImpl base = new UIToolBarItemImpl(id);
        return base;
    }

    @Override
    public void addToolBarItem(UIToolBarItem item) {
        this.addToolBarItem(item, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToolBarItem(UIToolBarItem item, boolean trigger) {
        if (item == null) {
            return;
        }
        if (this.items.containsKey(item.getID())) {
            return;
        }
        this.items.put(item.getID(), item);
        String groupID = item.getGroupID();
        Map<String, List<String>> map = this.mapGroupToItemIDs;
        synchronized (map) {
            List<String> list = this.mapGroupToItemIDs.get(groupID);
            if (list == null) {
                list = new ArrayList<String>();
                this.mapGroupToItemIDs.put(groupID, list);
            }
            list.add(item.getID());
        }
        if (trigger) {
            ToolBarManagerListener[] listeners;
            ToolBarManagerListener[] toolBarManagerListenerArray = listeners = this.listListeners.toArray(new ToolBarManagerListener[0]);
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                ToolBarManagerListener l = toolBarManagerListenerArray[n2];
                l.toolbarItemAdded(item);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getToolBarIDsByGroup(String groupID) {
        Map<String, List<String>> map = this.mapGroupToItemIDs;
        synchronized (map) {
            List<String> list = this.mapGroupToItemIDs.get(groupID);
            if (list == null) {
                return new String[0];
            }
            return list.toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIToolBarItem[] getToolBarItemsByGroup(String groupID) {
        Map<String, List<String>> map = this.mapGroupToItemIDs;
        synchronized (map) {
            List<String> list = this.mapGroupToItemIDs.get(groupID);
            if (list == null) {
                return new UIToolBarItem[0];
            }
            UIToolBarItem[] items = new UIToolBarItem[list.size()];
            int i = 0;
            for (String id : list) {
                items[i] = this.getToolBarItem(id);
                ++i;
            }
            return items;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeToolBarItem(String id) {
        UIToolBarItem toolBarItem = this.items.remove(id);
        if (toolBarItem != null) {
            ToolBarManagerListener[] listeners;
            Map<String, List<String>> map = this.mapGroupToItemIDs;
            synchronized (map) {
                List<String> list = this.mapGroupToItemIDs.get(toolBarItem.getGroupID());
                if (list != null) {
                    list.remove(toolBarItem.getID());
                }
            }
            ToolBarManagerListener[] toolBarManagerListenerArray = listeners = this.listListeners.toArray(new ToolBarManagerListener[0]);
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                ToolBarManagerListener l = toolBarManagerListenerArray[n2];
                l.toolbarItemRemoved(toolBarItem);
                ++n2;
            }
        }
    }

    @Override
    public String[] getGroupIDs() {
        return this.mapGroupToItemIDs.keySet().toArray(new String[0]);
    }

    public static interface ToolBarManagerListener {
        public void toolbarItemRemoved(UIToolBarItem var1);

        public void toolbarItemAdded(UIToolBarItem var1);
    }
}

