/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.plugininstall;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.installer.InstallablePlugin;
import com.biglybt.pif.installer.PluginInstallationListener;
import com.biglybt.pif.installer.PluginInstaller;
import com.biglybt.pif.installer.StandardPlugin;
import com.biglybt.pif.update.Update;
import com.biglybt.pif.update.UpdateCheckInstance;
import com.biglybt.pif.update.UpdateCheckInstanceListener;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloader;
import com.biglybt.pif.utils.resourcedownloader.ResourceDownloaderAdapter;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.swt.plugininstall.SimplePluginInstallWindow;
import com.biglybt.ui.swt.plugininstall.SimplePluginInstallerListener;
import java.util.HashMap;

public class SimplePluginInstaller {
    private String plugin_id;
    private UIFunctions.actionListener action_listener;
    private SimplePluginInstallerListener listener;
    private PluginInstaller installer;
    private volatile UpdateCheckInstance instance;
    private boolean completed;
    private boolean cancelled;

    public SimplePluginInstaller(String _plugin_id, String _resource_prefix, final UIFunctions.actionListener _action_listener) {
        this.plugin_id = _plugin_id;
        PluginInterface existing = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID(this.plugin_id);
        if (existing != null) {
            if (existing.getPluginState().isOperational()) {
                _action_listener.actionComplete(true);
            } else {
                _action_listener.actionComplete(new Exception("Plugin is installed but not operational"));
            }
            return;
        }
        this.action_listener = new UIFunctions.actionListener(){
            private boolean informed = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionComplete(Object result) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (this.informed) {
                        return;
                    }
                    this.informed = true;
                }
                _action_listener.actionComplete(result);
            }
        };
        SimplePluginInstallWindow window = new SimplePluginInstallWindow(this, _resource_prefix);
        window.open();
        AEThread2 installerThread = new AEThread2("plugin installer", true){

            @Override
            public void run() {
                SimplePluginInstaller.this.install();
            }
        };
        installerThread.start();
    }

    public void setListener(SimplePluginInstallerListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        UpdateCheckInstance to_cancel = null;
        SimplePluginInstaller simplePluginInstaller = this;
        synchronized (simplePluginInstaller) {
            if (this.completed) {
                return;
            }
            this.cancelled = true;
            to_cancel = this.instance;
        }
        if (to_cancel != null) {
            to_cancel.cancel();
        }
        this.action_listener.actionComplete(new Exception("Cancelled"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean install() {
        Object[] result;
        AESemaphore sem;
        block8: {
            try {
                boolean kill_it;
                this.installer = CoreFactory.getSingleton().getPluginManager().getPluginInstaller();
                StandardPlugin sp = this.installer.getStandardPlugin(this.plugin_id);
                if (sp == null) {
                    throw new Exception("Unknown plugin");
                }
                HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
                properties.put(1, 3);
                properties.put(3, true);
                sem = new AESemaphore("plugin-install");
                result = new Object[1];
                this.instance = this.installer.install(new InstallablePlugin[]{sp}, false, properties, new PluginInstallationListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void completed() {
                        SimplePluginInstaller simplePluginInstaller = SimplePluginInstaller.this;
                        synchronized (simplePluginInstaller) {
                            SimplePluginInstaller.this.completed = true;
                        }
                        result[0] = true;
                        if (SimplePluginInstaller.this.listener != null) {
                            SimplePluginInstaller.this.listener.finished();
                        }
                        sem.release();
                    }

                    @Override
                    public void cancelled() {
                        result[0] = new Exception("Cancelled");
                        if (SimplePluginInstaller.this.listener != null) {
                            SimplePluginInstaller.this.listener.finished();
                        }
                        sem.release();
                    }

                    @Override
                    public void failed(PluginException e) {
                        result[0] = e;
                        if (SimplePluginInstaller.this.listener != null) {
                            SimplePluginInstaller.this.listener.finished();
                        }
                        sem.release();
                    }
                });
                SimplePluginInstaller simplePluginInstaller = this;
                synchronized (simplePluginInstaller) {
                    kill_it = this.cancelled;
                }
                if (!kill_it) break block8;
                this.instance.cancel();
                this.action_listener.actionComplete(new Exception("Cancelled"));
                return false;
            }
            catch (Throwable e) {
                this.action_listener.actionComplete(e);
                if (this.listener != null) {
                    this.listener.finished();
                }
                return false;
            }
        }
        this.instance.addListener(new UpdateCheckInstanceListener(){

            @Override
            public void cancelled(UpdateCheckInstance instance) {
            }

            @Override
            public void complete(UpdateCheckInstance instance) {
                Update[] updates;
                Update[] updateArray = updates = instance.getUpdates();
                int n = updates.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourceDownloader[] rds;
                    Update update = updateArray[n2];
                    ResourceDownloader[] resourceDownloaderArray = rds = update.getDownloaders();
                    int n3 = rds.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ResourceDownloader rd = resourceDownloaderArray[n4];
                        rd.addListener(new ResourceDownloaderAdapter(){

                            @Override
                            public void reportActivity(ResourceDownloader downloader, String activity) {
                            }

                            @Override
                            public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
                                if (SimplePluginInstaller.this.listener != null) {
                                    SimplePluginInstaller.this.listener.progress(percentage);
                                }
                            }
                        });
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
        sem.reserve();
        this.action_listener.actionComplete(result[0]);
        return result[0] instanceof Boolean;
    }
}

