/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.plugininstaller;

import com.biglybt.core.Core;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.installer.FilePluginInstaller;
import com.biglybt.pif.installer.InstallablePlugin;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.mainwindow.ListenerNeedingCoreRunning;
import com.biglybt.ui.swt.plugininstaller.IPWInstallModePanel;
import com.biglybt.ui.swt.plugininstaller.InstallPluginWizard;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import com.biglybt.ui.swt.wizard.AbstractWizardPanel;
import com.biglybt.ui.swt.wizard.IWizardPanel;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class IPWFilePanel
extends AbstractWizardPanel<InstallPluginWizard> {
    String initial_file;
    Text txtFile;
    boolean valid = false;

    public IPWFilePanel(InstallPluginWizard wizard, IWizardPanel<InstallPluginWizard> previous) {
        super(wizard, previous);
    }

    public IPWFilePanel(InstallPluginWizard wizard, IWizardPanel<InstallPluginWizard> previous, String file) {
        super(wizard, previous);
        this.initial_file = file;
    }

    @Override
    public void show() {
        ((InstallPluginWizard)this.wizard).setTitle(MessageText.getString("installPluginsWizard.file.title"));
        ((InstallPluginWizard)this.wizard).setErrorMessage("");
        Composite rootPanel = ((InstallPluginWizard)this.wizard).getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "installPluginsWizard.file.file");
        this.txtFile = new Text(panel, 2048);
        if (this.initial_file != null) {
            this.txtFile.setText(this.initial_file);
        }
        GridData data = new GridData(768);
        this.txtFile.setLayoutData((Object)data);
        this.txtFile.addListener(24, (Listener)new ListenerNeedingCoreRunning(){

            @Override
            public void handleEvent(Core core, Event event2) {
                IPWFilePanel.this.checkValidFile(core);
            }
        });
        Button btnBrowse = new Button(panel, 8);
        Messages.setLanguageText((Widget)btnBrowse, "installPluginsWizard.file.browse");
        btnBrowse.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                FileDialog fd = new FileDialog(((InstallPluginWizard)IPWFilePanel.this.wizard).getWizardWindow());
                fd.setFilterExtensions(new String[]{"*.zip;*.jar;*.biglybt"});
                fd.setFilterNames(new String[]{MessageText.getString("label.biglybt.plugins")});
                String fileName = fd.open();
                if (fileName != null) {
                    IPWFilePanel.this.txtFile.setText(fileName);
                }
            }
        });
        if (this.initial_file != null) {
            CoreWaiterSWT.waitForCoreRunning(new CoreRunningListener(){

                @Override
                public void coreRunning(Core core) {
                    IPWFilePanel.this.checkValidFile(core);
                }
            });
        }
    }

    private void checkValidFile(Core core) {
        String fileName = this.txtFile.getText();
        String error_message = null;
        try {
            File f = new File(fileName);
            if (f.isFile() && (f.getName().endsWith(".jar") || f.getName().endsWith(".zip") || f.getName().endsWith(".biglybt"))) {
                ((InstallPluginWizard)this.wizard).setErrorMessage("");
                ((InstallPluginWizard)this.wizard).setNextEnabled(true);
                ArrayList<InstallablePlugin> list = new ArrayList<InstallablePlugin>();
                FilePluginInstaller plugin = core.getPluginManager().getPluginInstaller().installFromFile(f);
                list.add(plugin);
                ((InstallPluginWizard)this.wizard).plugins = list;
                this.valid = true;
                return;
            }
        }
        catch (PluginException e) {
            error_message = e.getMessage();
        }
        catch (Exception e) {
            error_message = null;
            Debug.printStackTrace(e);
        }
        this.valid = false;
        if (!fileName.equals("")) {
            String error_message_full = new File(fileName).isFile() ? MessageText.getString("installPluginsWizard.file.invalidfile") : MessageText.getString("installPluginsWizard.file.no_such_file");
            if (error_message != null) {
                error_message_full = String.valueOf(error_message_full) + " (" + error_message + ")";
            }
            ((InstallPluginWizard)this.wizard).setErrorMessage(error_message_full);
            ((InstallPluginWizard)this.wizard).setNextEnabled(false);
        }
    }

    @Override
    public boolean isNextEnabled() {
        return this.valid;
    }

    @Override
    public IWizardPanel<InstallPluginWizard> getNextPanel() {
        return new IPWInstallModePanel((InstallPluginWizard)this.wizard, this);
    }
}

