/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.pluginsuninstaller;

import com.biglybt.core.Core;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.PluginInterface;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.pluginsuninstaller.UIPWFinishPanel;
import com.biglybt.ui.swt.pluginsuninstaller.UnInstallPluginWizard;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import com.biglybt.ui.swt.wizard.AbstractWizardPanel;
import com.biglybt.ui.swt.wizard.IWizardPanel;
import com.biglybt.ui.swt.wizard.Wizard;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class UIPWListPanel
extends AbstractWizardPanel {
    Table pluginList;

    public UIPWListPanel(Wizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    @Override
    public void show() {
        CoreWaiterSWT.waitForCoreRunning(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                UIPWListPanel.this._show(core);
            }
        });
    }

    private void _show(Core core) {
        this.wizard.setTitle(MessageText.getString("uninstallPluginsWizard.list.title"));
        this.wizard.setErrorMessage("");
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        Label lblStatus = new Label(panel, 0);
        Messages.setLanguageText((Widget)lblStatus, "uninstallPluginsWizard.list.loaded");
        this.pluginList = new Table(panel, 68132);
        this.pluginList.setHeaderVisible(true);
        GridData data = new GridData(768);
        data.heightHint = 200;
        this.pluginList.setLayoutData((Object)data);
        TableColumn tcName = new TableColumn(this.pluginList, 16384);
        Messages.setLanguageText((Widget)tcName, "label.name");
        tcName.setWidth(200);
        TableColumn tcVersion = new TableColumn(this.pluginList, 16384);
        Messages.setLanguageText((Widget)tcVersion, "ConfigView.pluginlist.column.version");
        tcVersion.setWidth(150);
        PluginInterface[] plugins = new PluginInterface[]{};
        try {
            plugins = core.getPluginManager().getPluginInterfaces();
            Arrays.sort(plugins, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((PluginInterface)o1).getPluginName().compareTo(((PluginInterface)o2).getPluginName());
                }
            });
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        HashMap<String, ArrayList<PluginInterface>> pid_map = new HashMap<String, ArrayList<PluginInterface>>();
        int i = 0;
        while (i < plugins.length) {
            PluginInterface plugin = plugins[i];
            String pid = plugin.getPluginID();
            ArrayList<PluginInterface> pis = (ArrayList<PluginInterface>)pid_map.get(pid);
            if (pis == null) {
                pis = new ArrayList<PluginInterface>();
                pid_map.put(pid, pis);
            }
            pis.add(plugin);
            ++i;
        }
        ArrayList[] pid_list = new ArrayList[pid_map.size()];
        pid_map.values().toArray(pid_list);
        Arrays.sort(pid_list, new Comparator(){

            public int compare(Object o1, Object o2) {
                ArrayList l1 = (ArrayList)o1;
                ArrayList l2 = (ArrayList)o2;
                return ((PluginInterface)l1.get(0)).getPluginName().compareToIgnoreCase(((PluginInterface)l2.get(0)).getPluginName());
            }
        });
        int i2 = 0;
        while (i2 < pid_list.length) {
            ArrayList pis = pid_list[i2];
            boolean skip = false;
            String display_name = "";
            int j = 0;
            while (j < pis.size()) {
                PluginInterface pi = (PluginInterface)pis.get(j);
                if (pi.getPluginState().isMandatory() || pi.getPluginState().isBuiltIn()) {
                    skip = true;
                    break;
                }
                display_name = String.valueOf(display_name) + (j == 0 ? "" : ",") + pi.getPluginName();
                ++j;
            }
            if (!skip) {
                PluginInterface plugin = (PluginInterface)pis.get(0);
                List selected_plugins = ((UnInstallPluginWizard)this.wizard).getPluginList();
                TableItem item = new TableItem(this.pluginList, 0);
                item.setData((Object)plugin);
                item.setText(0, display_name);
                item.setChecked(selected_plugins.contains(plugin));
                String version = plugin.getPluginVersion();
                if (version == null) {
                    version = MessageText.getString("uninstallPluginsWizard.list.nullversion");
                }
                item.setText(1, version);
            }
            ++i2;
        }
        this.pluginList.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UIPWListPanel.this.updateList();
            }
        });
    }

    @Override
    public boolean isFinishEnabled() {
        return ((UnInstallPluginWizard)this.wizard).getPluginList().size() > 0;
    }

    @Override
    public IWizardPanel getFinishPanel() {
        return new UIPWFinishPanel(this.wizard, (IWizardPanel)this);
    }

    public void updateList() {
        ArrayList<Object> list = new ArrayList<Object>();
        TableItem[] items = this.pluginList.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                list.add(items[i].getData());
            }
            ++i;
        }
        ((UnInstallPluginWizard)this.wizard).setPluginList(list);
        ((UnInstallPluginWizard)this.wizard).setFinishEnabled(this.isFinishEnabled());
    }
}

