/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.progress;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.progress.IProgressReport;
import com.biglybt.ui.swt.progress.IProgressReportConstants;
import com.biglybt.ui.swt.progress.IProgressReporter;
import com.biglybt.ui.swt.progress.IProgressReporterListener;
import com.biglybt.ui.swt.progress.ProgressReporterPanel;
import com.biglybt.ui.swt.progress.ProgressReportingManager;
import com.biglybt.ui.swt.twistie.ITwistieListener;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ProgressReporterWindow
implements IProgressReportConstants,
ITwistieListener,
DisposeListener {
    private Shell shell;
    private ScrolledComposite scrollable;
    private Composite scrollChild;
    private IProgressReporter[] pReporters;
    private static final ArrayList reportersRegistry = new ArrayList();
    private static boolean isShowingEmpty = false;
    private int defaultShellWidth = 500;
    private int initialMaxNumberOfPanels = 3;
    private int style;
    private boolean isAutoRemove = false;

    private ProgressReporterWindow(IProgressReporter pReporter, int style) {
        this.style = style;
        this.pReporters = pReporter != null ? new IProgressReporter[]{pReporter} : new IProgressReporter[0];
        this.createControls();
    }

    private ProgressReporterWindow(IProgressReporter[] pReporters, int style) {
        this.style = style;
        this.pReporters = pReporters != null ? pReporters : new IProgressReporter[0];
        this.createControls();
    }

    public static void open(IProgressReporter pReporter, int style) {
        new ProgressReporterWindow(pReporter, style).openWindow();
    }

    public static void open(IProgressReporter[] pReporters, int style) {
        new ProgressReporterWindow(pReporters, style).openWindow();
    }

    public static boolean isShowingEmpty() {
        return isShowingEmpty;
    }

    public static boolean isOpened(IProgressReporter pReporter) {
        return reportersRegistry.contains(pReporter);
    }

    private void createControls() {
        int shellStyle = 2160;
        if ((this.style & 4) != 0) {
            shellStyle |= 0x10000;
        }
        this.shell = ShellFactory.createMainShell(shellStyle);
        this.shell.setText(MessageText.getString("progress.window.title"));
        Utils.setShellIcon(this.shell);
        GridLayout gLayout = new GridLayout();
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        this.shell.setLayout((Layout)gLayout);
        this.scrollable = new ScrolledComposite((Composite)this.shell, 512);
        this.scrollable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrollChild = new Composite((Composite)this.scrollable, 0);
        GridLayout gLayoutChild = new GridLayout();
        gLayoutChild.marginHeight = 0;
        gLayoutChild.marginWidth = 0;
        gLayoutChild.verticalSpacing = 0;
        this.scrollChild.setLayout((Layout)gLayoutChild);
        this.scrollable.setContent((Control)this.scrollChild);
        this.scrollable.setExpandVertical(true);
        this.scrollable.setExpandHorizontal(true);
        this.scrollable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = ProgressReporterWindow.this.scrollable.getClientArea();
                ProgressReporterWindow.this.scrollable.setMinSize(ProgressReporterWindow.this.scrollChild.computeSize(r.width, -1));
            }
        });
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event2) {
                Control[] controls = ProgressReporterWindow.this.scrollChild.getChildren();
                int i = 0;
                while (i < controls.length) {
                    if (controls[i] instanceof ProgressReporterPanel) {
                        ((ProgressReporterPanel)controls[i]).removeDisposeListener(ProgressReporterWindow.this);
                    }
                    ++i;
                }
                i = 0;
                while (i < ProgressReporterWindow.this.pReporters.length) {
                    reportersRegistry.remove(ProgressReporterWindow.this.pReporters[i]);
                    ++i;
                }
                isShowingEmpty = false;
            }
        });
        if (this.pReporters.length == 0) {
            this.createEmptyPanel();
        } else {
            this.createPanels();
        }
        if ((this.style & 0x20) != 0) {
            this.createToolbar();
        }
        this.isAutoRemove = COConfigurationManager.getBooleanParameter("auto_remove_inactive_items");
    }

    private void createToolbar() {
        Composite toolbarPanel = new Composite((Composite)this.shell, 0);
        toolbarPanel.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout gLayout = new GridLayout(3, false);
        gLayout.marginWidth = 25;
        gLayout.marginTop = 0;
        gLayout.marginBottom = 0;
        toolbarPanel.setLayout((Layout)gLayout);
        final Button autoClearButton = new Button(toolbarPanel, 32);
        autoClearButton.setText(MessageText.getString("Progress.reporting.window.remove.auto"));
        Utils.setTT((Control)autoClearButton, MessageText.getString("Progress.reporting.window.remove.auto.tooltip"));
        autoClearButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        autoClearButton.setSelection(COConfigurationManager.getBooleanParameter("auto_remove_inactive_items"));
        Label dummy = new Label(toolbarPanel, 0);
        dummy.setLayoutData((Object)new GridData(4, 4, true, false));
        final Button clearInActiveButton = new Button(toolbarPanel, 0);
        clearInActiveButton.setText(MessageText.getString("Progress.reporting.window.remove.now"));
        Utils.setTT((Control)clearInActiveButton, MessageText.getString("Progress.reporting.window.remove.now.tooltip"));
        clearInActiveButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        clearInActiveButton.setEnabled(!COConfigurationManager.getBooleanParameter("auto_remove_inactive_items"));
        autoClearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                COConfigurationManager.setParameter("auto_remove_inactive_items", autoClearButton.getSelection());
                clearInActiveButton.setEnabled(!autoClearButton.getSelection());
                ProgressReporterWindow.this.isAutoRemove = autoClearButton.getSelection();
                if (ProgressReporterWindow.this.isAutoRemove) {
                    ProgressReporterWindow.this.removeInActivePanels();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        clearInActiveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProgressReporterWindow.this.removeInActivePanels();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void removeInActivePanels() {
        Control[] controls = this.scrollChild.getChildren();
        int i = 0;
        while (i < controls.length) {
            IProgressReporter pReporter;
            if (controls[i] != null && !controls[i].isDisposed() && controls[i] instanceof ProgressReporterPanel && !(pReporter = ((ProgressReporterPanel)controls[i]).getProgressReporter()).getProgressReport().isActive() && !pReporter.getProgressReport().isInErrorState()) {
                ProgressReportingManager.getInstance().remove(pReporter);
                controls[i].dispose();
            }
            ++i;
        }
    }

    private void createEmptyPanel() {
        GridData gData = new GridData(4, 4, true, true);
        gData.heightHint = 100;
        Composite emptyPanel = Utils.createSkinnedComposite(this.scrollChild, 2048, gData);
        emptyPanel.setLayout((Layout)new GridLayout());
        Label nothingToDisplay = new Label(emptyPanel, 0);
        nothingToDisplay.setLayoutData((Object)new GridData(4, 4, true, true));
        nothingToDisplay.setText(MessageText.getString("Progress.reporting.no.reports.to.display"));
        isShowingEmpty = true;
    }

    private void openWindow() {
        Control[] controls = this.scrollChild.getChildren();
        int i = this.initialMaxNumberOfPanels;
        while (i < controls.length) {
            ((GridData)controls[i].getLayoutData()).exclude = true;
            ++i;
        }
        Point defaultSize = this.shell.computeSize(this.defaultShellWidth, -1);
        int i2 = 0;
        while (i2 < controls.length) {
            ((GridData)controls[i2].getLayoutData()).exclude = false;
            ++i2;
        }
        this.formatLastPanel(null);
        this.scrollChild.layout();
        boolean alreadyPositioned = Utils.linkShellMetricsToConfig(this.shell, "com.biglybt.ui.swt.progress.ProgressReporterWindow");
        if (!alreadyPositioned) {
            this.shell.setSize(defaultSize);
            this.shell.layout(false);
            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uiFunctions == null) {
                Utils.centreWindow(this.shell);
            } else {
                Utils.centerWindowRelativeTo(this.shell, (Control)uiFunctions.getMainShell());
            }
        }
        if (COConfigurationManager.getBooleanParameter("Reduce Auto Activate Window")) {
            this.shell.setVisible(true);
            this.shell.setFocus();
        } else {
            this.shell.open();
        }
    }

    public int getStyle() {
        return this.style;
    }

    private void createPanels() {
        int size = this.pReporters.length;
        if (size < 2) {
            this.style |= 8;
        }
        int i = 0;
        while (i < size) {
            if (this.pReporters[i] != null) {
                reportersRegistry.add(this.pReporters[i]);
                ProgressReporterPanel panel = new ProgressReporterPanel(this, this.scrollChild, this.pReporters[i], this.style | 0x10);
                panel.setLayoutData(new GridData(4, 4, true, false));
                panel.addTwistieListener(this);
                panel.addDisposeListener(this);
                this.pReporters[i].addListener(new AutoRemoveListener(panel));
            }
            ++i;
        }
        this.formatLastPanel(null);
    }

    private void formatLastPanel(ProgressReporterPanel panelToIgnore) {
        Control[] controls = this.scrollChild.getChildren();
        int i = controls.length - 1;
        while (i >= 0) {
            if (!controls[i].equals(panelToIgnore)) {
                ((GridData)controls[i].getLayoutData()).grabExcessVerticalSpace = true;
                break;
            }
            --i;
        }
    }

    private void removeReporter(IProgressReporter reporter) {
        reportersRegistry.remove(reporter);
        int IDX = Arrays.binarySearch(this.pReporters, reporter);
        if (IDX >= 0) {
            IProgressReporter[] rps = new IProgressReporter[this.pReporters.length - 1];
            int i = 0;
            while (i < rps.length) {
                rps[i] = this.pReporters[i >= IDX ? i + 1 : i];
                ++i;
            }
            this.pReporters = rps;
        }
    }

    @Override
    public void isCollapsed(boolean value) {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.scrollable.setRedraw(false);
            Rectangle r = this.scrollable.getClientArea();
            this.scrollable.setMinSize(this.scrollChild.computeSize(r.width, -1));
            if (this.pReporters.length == 1) {
                Point p = this.shell.computeSize(this.defaultShellWidth, -1);
                if (this.shell.getSize().y != p.y) {
                    p.x = this.shell.getSize().x;
                    this.shell.setSize(p);
                }
            }
            this.scrollable.layout();
            this.scrollable.setRedraw(true);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (e.widget instanceof ProgressReporterPanel) {
            ProgressReporterPanel panel = (ProgressReporterPanel)e.widget;
            this.removeReporter(panel.pReporter);
            panel.removeTwistieListener(this);
            ((GridData)panel.getLayoutData()).exclude = true;
            panel.setVisible(false);
            if (this.pReporters.length == 0) {
                if ((this.style & 2) != 0) {
                    if (this.shell != null && !this.shell.isDisposed()) {
                        this.shell.close();
                    }
                } else {
                    this.createEmptyPanel();
                }
            } else {
                this.formatLastPanel(panel);
            }
            if (this.shell != null && !this.shell.isDisposed()) {
                this.shell.layout(true, true);
            }
        }
    }

    private class AutoRemoveListener
    implements IProgressReporterListener {
        private ProgressReporterPanel panel = null;

        private AutoRemoveListener(ProgressReporterPanel panel) {
            this.panel = panel;
        }

        @Override
        public int report(IProgressReport progressReport) {
            if (ProgressReporterWindow.this.isAutoRemove && !progressReport.isActive() && !progressReport.isInErrorState()) {
                if (this.panel != null && !this.panel.isDisposed()) {
                    ProgressReportingManager.getInstance().remove(this.panel.getProgressReporter());
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            AutoRemoveListener.this.panel.dispose();
                        }
                    });
                }
                return 1;
            }
            return 0;
        }
    }
}

