/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.search;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.DataSourceResolver;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryVitalityImage;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.biglybt.ui.swt.search.SBC_SearchResultsView;
import com.biglybt.ui.swt.search.SearchResultsTabAreaBase;
import com.biglybt.ui.swt.search.SearchResultsTabAreaBrowser;
import com.biglybt.ui.swt.search.SearchUI;
import com.biglybt.ui.swt.search.SearchUtils;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinButtonUtility;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectBrowser;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.views.skin.SkinView;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SearchResultsTabArea
extends SkinView
implements ViewTitleInfo {
    private boolean isBrowserView = COConfigurationManager.getBooleanParameter("Search View Is Web View", true);
    private boolean isViewSwitchHidden = COConfigurationManager.getBooleanParameter("Search View Switch Hidden", false);
    private SWTSkinObjectBrowser browserSkinObject;
    private SWTSkinObjectContainer nativeSkinObject;
    private SWTSkin skin;
    private MdiEntry mdi_entry;
    private MdiEntryVitalityImage vitalityImage;
    private boolean menu_added;
    private SearchQuery current_sq;
    private SearchResultsTabAreaBase activeImpl;
    private SearchResultsTabAreaBrowser browserImpl = new SearchResultsTabAreaBrowser(this);
    private SBC_SearchResultsView nativeImpl = new SBC_SearchResultsView(this);
    private SWTSkinObject soButtonWeb;
    private SWTSkinObject soButtonMeta;

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        MultipleDocumentInterfaceSWT mdi;
        this.skin = skinObject.getSkin();
        SWTSkinObjectContainer controlArea = (SWTSkinObjectContainer)this.skin.getSkinObject("searchresultstop", skinObject);
        if (controlArea != null) {
            if (this.isViewSwitchHidden) {
                controlArea.setVisible(false);
            } else {
                Composite control_area = controlArea.getComposite();
                this.soButtonWeb = this.skin.getSkinObject("searchresults-button-web", controlArea);
                this.soButtonMeta = this.skin.getSkinObject("searchresults-button-meta", controlArea);
                SWTSkinButtonUtility btnWeb = new SWTSkinButtonUtility(this.soButtonWeb);
                btnWeb.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                    @Override
                    public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                        SearchResultsTabArea.this.isBrowserView = true;
                        COConfigurationManager.setParameter("Search View Is Web View", SearchResultsTabArea.this.isBrowserView);
                        SearchResultsTabArea.this.selectView(skinObject);
                    }
                });
                SWTSkinButtonUtility btnMeta = new SWTSkinButtonUtility(this.soButtonMeta);
                btnMeta.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                    @Override
                    public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                        SearchResultsTabArea.this.isBrowserView = false;
                        COConfigurationManager.setParameter("Search View Is Web View", SearchResultsTabArea.this.isBrowserView);
                        SearchResultsTabArea.this.selectView(skinObject);
                    }
                });
            }
        }
        if ((mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT()) != null) {
            this.mdi_entry = mdi.getEntryBySkinView(this);
            if (this.mdi_entry != null) {
                this.mdi_entry.setViewTitleInfo(this);
                this.vitalityImage = this.mdi_entry.addVitalityImage("image.sidebar.vitality.dots");
                if (this.vitalityImage != null) {
                    this.vitalityImage.setVisible(false);
                }
            }
        }
        this.browserSkinObject = (SWTSkinObjectBrowser)this.skin.getSkinObject("web-search-results", skinObject);
        this.browserImpl.init(this.browserSkinObject);
        this.nativeSkinObject = (SWTSkinObjectContainer)this.skin.getSkinObject("meta-search-results", skinObject);
        this.nativeImpl.skinObjectInitialShow(skinObject, params);
        this.selectView(skinObject);
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(final Core core) {
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        SearchResultsTabArea.this.initCoreStuff(core);
                    }
                });
            }
        });
        return null;
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        if (this.activeImpl != null) {
            this.activeImpl.refreshView();
        }
        return super.skinObjectShown(skinObject, params);
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        this.browserImpl.destroy();
        this.nativeImpl.skinObjectDestroyed(skinObject, params);
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void selectView(SWTSkinObject parent) {
        SearchResultsTabAreaBase newImpl;
        SearchResultsTabAreaBase searchResultsTabAreaBase = newImpl = this.isBrowserView ? this.browserImpl : this.nativeImpl;
        if (newImpl == this.activeImpl) {
            return;
        }
        Control[] kids = this.nativeSkinObject.getControl().getParent().getChildren();
        Control visible_parent = this.isBrowserView ? this.browserSkinObject.getControl() : this.nativeSkinObject.getControl();
        Control[] controlArray = kids;
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            Control kid;
            kid.setVisible((kid = controlArray[n2]) == visible_parent);
            ++n2;
        }
        this.browserSkinObject.setVisible(this.isBrowserView);
        this.nativeSkinObject.setVisible(!this.isBrowserView);
        if (this.soButtonWeb != null) {
            this.soButtonWeb.switchSuffix(this.isBrowserView ? "-selected" : "");
        }
        if (this.soButtonMeta != null) {
            this.soButtonMeta.switchSuffix(this.isBrowserView ? "" : "-selected");
        }
        parent.relayout();
        if (this.activeImpl != null) {
            this.activeImpl.hideView();
        }
        this.activeImpl = newImpl;
        this.activeImpl.showView();
        if (this.current_sq != null) {
            this.anotherSearch(this.current_sq);
        }
    }

    private void initCoreStuff(Core core) {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        if (!this.menu_added) {
            this.menu_added = true;
            SearchUtils.addMenus(menuManager);
        }
    }

    @Override
    public Object dataSourceChanged(SWTSkinObject skinObject, Object params) {
        if (params instanceof SearchQuery) {
            this.anotherSearch((SearchQuery)params);
        }
        return null;
    }

    public void anotherSearch(String searchText, boolean toSubscribe) {
        this.anotherSearch(new SearchQuery(searchText, toSubscribe));
    }

    public void anotherSearch(SearchQuery another_sq) {
        this.current_sq = another_sq;
        if (this.activeImpl != null) {
            this.activeImpl.anotherSearch(this.current_sq);
            ViewTitleInfoManager.refreshTitleInfo(this);
        }
    }

    public SearchQuery getCurrentSearch() {
        return this.current_sq;
    }

    @Override
    public Object getTitleInfoProperty(int pid) {
        int results;
        SearchQuery sq = this.current_sq;
        SearchResultsTabAreaBase impl = this.activeImpl;
        if (pid == 5) {
            if (sq != null) {
                return sq.term;
            }
        } else if (pid == 0 && impl != null && (results = impl.getResultCount()) >= 0) {
            return String.valueOf(results);
        }
        return null;
    }

    protected void setBusy(boolean busy) {
        if (this.vitalityImage != null) {
            this.vitalityImage.setVisible(busy);
        }
    }

    protected void resultsFound() {
        ViewTitleInfoManager.refreshTitleInfo(this);
        if (this.mdi_entry != null) {
            this.mdi_entry.redraw();
        }
    }

    public static class SearchQuery
    implements DataSourceResolver.ExportableDataSource {
        public String term;
        public boolean toSubscribe;

        public SearchQuery(String term, boolean toSubscribe) {
            this.term = term;
            this.toSubscribe = toSubscribe;
        }

        @Override
        public DataSourceResolver.ExportedDataSource exportDataSource() {
            return new DataSourceResolver.ExportedDataSource(){

                @Override
                public Class<? extends DataSourceResolver.DataSourceImporter> getExporter() {
                    return SearchUI.class;
                }

                @Override
                public Map<String, Object> getExport() {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("term", term);
                    map.put("toSubscribe", new Long(toSubscribe ? 1 : 0));
                    return map;
                }
            };
        }
    }
}

