/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.sharing;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread;
import com.biglybt.core.util.Debug;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import java.io.File;
import java.util.Map;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ShareUtils {
    public static void shareFile(final Shell shell) {
        new AEThread("shareFile"){

            @Override
            public void runSupport() {
                Display display = shell.getDisplay();
                final String[] path = new String[1];
                final AESemaphore sem = new AESemaphore("ShareUtils:file");
                display.asyncExec((Runnable)new AERunnable(){

                    @Override
                    public void runSupport() {
                        try {
                            FileDialog dialog = new FileDialog(shell, 135168);
                            dialog.setFilterPath(TorrentOpener.getFilterPathData());
                            dialog.setText(MessageText.getString("MainWindow.dialog.share.sharefile"));
                            path[0] = TorrentOpener.setFilterPathData(dialog.open());
                        }
                        finally {
                            sem.release();
                        }
                    }
                });
                sem.reserve();
                if (path[0] != null) {
                    ShareUtils.shareFile(path[0]);
                }
            }
        }.start();
    }

    public static void shareDir(Shell shell) {
        ShareUtils.shareDirSupport(shell, false, false);
    }

    public static void shareDirContents(Shell shell, boolean recursive) {
        ShareUtils.shareDirSupport(shell, true, recursive);
    }

    protected static void shareDirSupport(final Shell shell, final boolean contents, final boolean recursive) {
        new AEThread("shareDirSupport"){

            @Override
            public void runSupport() {
                Display display = shell.getDisplay();
                final String[] path = new String[1];
                final AESemaphore sem = new AESemaphore("ShareUtils:dir");
                display.asyncExec((Runnable)new AERunnable(){

                    @Override
                    public void runSupport() {
                        try {
                            DirectoryDialog dialog = new DirectoryDialog(shell, 131072);
                            dialog.setFilterPath(TorrentOpener.getFilterPathData());
                            dialog.setText(contents ? String.valueOf(MessageText.getString("MainWindow.dialog.share.sharedircontents")) + (recursive ? "(" + MessageText.getString("MainWindow.dialog.share.sharedircontents.recursive") + ")" : "") : MessageText.getString("MainWindow.dialog.share.sharedir"));
                            path[0] = TorrentOpener.setFilterPathData(dialog.open());
                        }
                        finally {
                            sem.release();
                        }
                    }
                });
                sem.reserve();
                if (path[0] != null) {
                    if (contents) {
                        ShareUtils.shareDirContents(path[0], recursive);
                    } else {
                        ShareUtils.shareDir(path[0]);
                    }
                }
            }
        }.start();
    }

    public static void shareFile(String file_name) {
        ShareUtils.shareFile(file_name, null);
    }

    public static void shareFile(final String file_name, final Map<String, String> properties) {
        new AEThread("shareFile"){

            @Override
            public void runSupport() {
                try {
                    PluginInitializer.getDefaultInterface().getShareManager().addFile(new File(file_name), properties);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }.start();
    }

    public static void shareDir(String file_name) {
        ShareUtils.shareDir(file_name, null);
    }

    public static void shareDir(final String file_name, final Map<String, String> properties) {
        new AEThread("shareDir"){

            @Override
            public void runSupport() {
                try {
                    PluginInitializer.getDefaultInterface().getShareManager().addDir(new File(file_name), properties);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }.start();
    }

    public static void shareDirContents(final String file_name, final boolean recursive) {
        new AEThread("shareDirCntents"){

            @Override
            public void runSupport() {
                try {
                    PluginInitializer.getDefaultInterface().getShareManager().addDirContents(new File(file_name), recursive);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }.start();
    }
}

