/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import org.eclipse.swt.widgets.Shell;

public class CoreWaiterSWT {
    private static final boolean DEBUG = false;
    private static boolean startupAbandoned;
    private static Shell shell;

    public static void waitForCoreRunning(CoreRunningListener l) {
        CoreWaiterSWT.waitForCore(TriggerInThread.SWT_THREAD, l);
    }

    public static void waitForCore(final TriggerInThread triggerInThread, final CoreRunningListener l) {
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(final Core core) {
                if (triggerInThread == TriggerInThread.ANY_THREAD) {
                    l.coreRunning(core);
                } else if (triggerInThread == TriggerInThread.NEW_THREAD) {
                    new AEThread2("CoreWaiterInvoke", true){

                        @Override
                        public void run() {
                            l.coreRunning(core);
                        }
                    }.start();
                }
                Utils.execSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (shell != null && !shell.isDisposed()) {
                            shell.dispose();
                            CoreWaiterSWT.shell = null;
                        }
                        if (triggerInThread == TriggerInThread.SWT_THREAD) {
                            l.coreRunning(core);
                        }
                    }
                });
            }
        });
        if (!CoreFactory.isCoreRunning()) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    CoreWaiterSWT.showWaitWindow();
                }
            });
        }
    }

    public static void startupAbandoned() {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                startupAbandoned = true;
                if (shell != null) {
                    shell.dispose();
                }
            }
        });
    }

    private static void showWaitWindow() {
        if (startupAbandoned) {
            return;
        }
        if (shell != null && !shell.isDisposed()) {
            shell.forceActive();
            return;
        }
        UIFunctionsSWT uiFunctionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctionsSWT != null) {
            shell = uiFunctionsSWT.showCoreWaitDlg();
        }
    }

    public static enum TriggerInThread {
        SWT_THREAD,
        ANY_THREAD,
        NEW_THREAD;

    }
}

