/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.pif.download.Download;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mdi.BaseMdiEntry;
import com.biglybt.ui.swt.mdi.TabbedEntry;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.pifimpl.UISWTViewCore;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinFactory;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.views.skin.SkinnedDialog;
import com.biglybt.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.biglybt.util.DataSourceUtils;
import com.biglybt.util.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Shell;

public class PopOutManager {
    public static final String OPT_ON_TOP = "on-top";
    public static final String OPT_CAN_MINIMIZE = "can-min";
    public static final Map<String, Object> OPT_MAP_NONE = new HashMap<String, Object>();
    public static final Map<String, Object> OPT_MAP_ON_TOP = new HashMap<String, Object>();
    private static final String CONFIG_FILE = "popouts.config";
    private static final int STYLE_DEFAULT = 3184;
    private static final int TYPE_DIALOG = 0;
    private static final int TYPE_MDI_ID = 1;
    private static long next_id;
    private static List<PopOutDetails> popout_details;

    static {
        OPT_MAP_ON_TOP.put(OPT_ON_TOP, true);
        next_id = 0L;
        popout_details = new ArrayList<PopOutDetails>();
    }

    public static void initialise() {
        Utils.execSWTThread(PopOutManager::loadConfig);
    }

    private static synchronized void loadConfig() {
        boolean save_config = false;
        try {
            if (FileUtil.resilientConfigFileExists(CONFIG_FILE)) {
                List popout_list;
                Map popouts_map = FileUtil.readResilientConfigFile(CONFIG_FILE);
                if ((popouts_map = BDecoder.decodeStrings(popouts_map)) != null && (popout_list = (List)popouts_map.get("popouts")) != null) {
                    for (Map map : popout_list) {
                        PopOutDetails details = new PopOutDetails();
                        try {
                            Number type = (Number)map.get("type");
                            details.type = type == null ? 0 : type.intValue();
                            details.id = ((Number)map.get("id")).longValue();
                            details.title = MapUtils.getMapString(map, "title", "?");
                            Number style = (Number)map.get("style");
                            details.style = style == null ? 3184 : style.intValue();
                            details.on_top = ((Number)map.get("on_top")).longValue() == 1L;
                            details.config_prefix = MapUtils.getMapString(map, "config_prefix", "?");
                            details.state = (Map)map.get("state");
                            next_id = Math.max(details.id + 1L, next_id);
                            if (PopOutManager.recoverPopOut(details)) {
                                popout_details.add(details);
                                continue;
                            }
                            save_config = true;
                        }
                        catch (Throwable e) {
                            save_config = true;
                            Debug.out(e);
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            save_config = true;
            Debug.out(e);
        }
        if (save_config) {
            PopOutManager.saveConfig();
        }
    }

    private static void saveConfig() {
        if (popout_details.isEmpty()) {
            FileUtil.deleteResilientConfigFile(CONFIG_FILE);
        } else {
            HashMap popouts_map = new HashMap();
            ArrayList popout_list = new ArrayList();
            popouts_map.put("popouts", popout_list);
            for (PopOutDetails details : popout_details) {
                try {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("type", details.type);
                    map.put("id", details.id);
                    map.put("title", details.title);
                    map.put("style", details.style);
                    map.put("on_top", details.on_top ? 1 : 0);
                    map.put("config_prefix", details.config_prefix);
                    map.put("state", details.state);
                    popout_list.add(map);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            FileUtil.writeResilientConfigFile(CONFIG_FILE, popouts_map);
        }
    }

    private static void registerPopOut(SkinnedDialog dialog, String title, int style, boolean on_top, String config_prefix, BaseMdiEntry entry) {
        Map<String, Object> state = entry.exportStandAlone();
        PopOutManager.registerPopOut(dialog, title, style, on_top, config_prefix, state);
    }

    private static synchronized void registerPopOut(SkinnedDialog dialog, String title, int style, boolean on_top, String config_prefix, Map<String, Object> state) {
        long id = next_id++;
        PopOutDetails details = new PopOutDetails();
        details.type = 0;
        details.id = id;
        details.title = title;
        details.style = style;
        details.on_top = on_top;
        details.config_prefix = config_prefix;
        details.state = state;
        popout_details.add(details);
        dialog.addCloseListener(d -> PopOutManager.unregisterPopOut(id));
        PopOutManager.saveConfig();
    }

    private static synchronized void unregisterPopOut(long id) {
        Iterator<PopOutDetails> it = popout_details.iterator();
        while (it.hasNext()) {
            PopOutDetails details = it.next();
            if (details.id != id) continue;
            it.remove();
            break;
        }
        PopOutManager.saveConfig();
    }

    private static boolean recoverPopOut(PopOutDetails details) {
        if (details.type == 0) {
            SkinnedDialog skinnedDialog = new SkinnedDialog("skin3_dlg_sidebar_popout", "shell", details.on_top ? UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell() : null, details.style);
            SWTSkin skin = skinnedDialog.getSkin();
            SWTSkinObjectContainer cont = BaseMdiEntry.importStandAlone((SWTSkinObjectContainer)skin.getSkinObject("content-area"), details.state, null);
            if (cont != null) {
                skinnedDialog.setTitle(details.title);
                skinnedDialog.addCloseListener(d -> PopOutManager.unregisterPopOut(popOutDetails.id));
                skinnedDialog.open(details.config_prefix, true);
                return true;
            }
            skinnedDialog.close();
        } else {
            UIFunctions uif;
            String mdi_id = (String)details.state.get("mdi_id");
            if (mdi_id != null && (uif = UIFunctionsManager.getUIFunctions()) != null) {
                uif.getMDI().showEntryByID(mdi_id);
            }
        }
        return false;
    }

    public static void registerSideBarSection(Shell shell, String mdi_id) {
        long id = next_id++;
        PopOutDetails details = new PopOutDetails();
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("mdi_id", mdi_id);
        details.type = 1;
        details.id = id;
        details.title = "";
        details.on_top = true;
        details.config_prefix = "";
        details.state = state;
        popout_details.add(details);
        shell.addDisposeListener(ev -> {
            if (!Utils.isTerminated()) {
                PopOutManager.unregisterPopOut(id);
            }
        });
        PopOutManager.saveConfig();
    }

    private static boolean getOption(Map<String, Object> map, String opt) {
        Object obj;
        if (map != null && (obj = map.get(opt)) instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public static boolean popOut(SideBarEntrySWT entry, Map<String, Object> options) {
        SkinnedDialog skinnedDialog;
        SWTSkin skin;
        SWTSkinObjectContainer cont;
        boolean onTop = PopOutManager.getOption(options, OPT_ON_TOP);
        boolean canMin = PopOutManager.getOption(options, OPT_CAN_MINIMIZE);
        int style = 3184;
        if (canMin) {
            style |= 0x80;
        }
        if ((cont = entry.buildStandAlone((SWTSkinObjectContainer)(skin = (skinnedDialog = new SkinnedDialog("skin3_dlg_sidebar_popout", "shell", onTop ? UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell() : null, style)).getSkin()).getSkinObject("content-area"))) != null) {
            String title = entry.getTitle();
            skinnedDialog.setTitle(title);
            String metrics_id = entry.getDatasource() instanceof Download ? "DMDetails" : entry.getId();
            String configPrefix = "mdi.popout:" + metrics_id;
            PopOutManager.registerPopOut(skinnedDialog, title, style, onTop, configPrefix, entry);
            skinnedDialog.open(configPrefix, true);
            return true;
        }
        skinnedDialog.close();
        return false;
    }

    public static boolean popOut(TabbedEntry entry, Map<String, Object> options) {
        SkinnedDialog skinnedDialog;
        SWTSkin skin;
        SWTSkinObjectContainer cont;
        boolean onTop = PopOutManager.getOption(options, OPT_ON_TOP);
        boolean canMin = PopOutManager.getOption(options, OPT_CAN_MINIMIZE);
        int style = 3184;
        if (canMin) {
            style |= 0x80;
        }
        if ((cont = entry.buildStandAlone((SWTSkinObjectContainer)(skin = (skinnedDialog = new SkinnedDialog("skin3_dlg_sidebar_popout", "shell", onTop ? UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell() : null, style)).getSkin()).getSkinObject("content-area"))) != null) {
            String ds_str = "";
            Object ds = entry.getDatasourceCore();
            DownloadManager dm = DataSourceUtils.getDM(ds);
            if (dm != null) {
                ds_str = dm.getDisplayName();
            }
            String title = String.valueOf(entry.getTitle()) + (ds_str.length() == 0 ? "" : " - " + ds_str);
            skinnedDialog.setTitle(title);
            String metrics_id = entry.getDatasource() instanceof Download ? "DMDetails" : entry.getId();
            String configPrefix = "mdi.popout:" + metrics_id;
            PopOutManager.registerPopOut(skinnedDialog, title, style, onTop, configPrefix, entry);
            skinnedDialog.open(configPrefix, true);
            return true;
        }
        skinnedDialog.close();
        return false;
    }

    public static void popOut(UISWTView parentView, TabbedEntry entry) {
        int style = 3184;
        SkinnedDialog skinnedDialog = new SkinnedDialog("skin3_dlg_sidebar_popout", "shell", null, style);
        SWTSkin skin = skinnedDialog.getSkin();
        SWTSkinObjectContainer cont = ((UISWTViewCore)parentView).buildStandAlone((SWTSkinObjectContainer)skin.getSkinObject("content-area"));
        if (cont != null) {
            String ds_str = "";
            Object ds = parentView.getDataSource();
            DownloadManager dm = DataSourceUtils.getDM(ds);
            if (dm != null) {
                ds_str = dm.getDisplayName();
            }
            skinnedDialog.setTitle(String.valueOf(((UISWTViewCore)parentView).getFullTitle()) + (ds_str.length() == 0 ? "" : " - " + ds_str));
            skinnedDialog.open("mdi.popout:" + entry.getId(), true);
        } else {
            skinnedDialog.close();
        }
    }

    public static void popOut(TabbedEntry entry) {
        int style = 3184;
        SkinnedDialog skinnedDialog = new SkinnedDialog("skin3_dlg_sidebar_popout", "shell", null, style);
        SWTSkin skin = skinnedDialog.getSkin();
        SWTSkinObjectContainer cont = entry.buildStandAlone((SWTSkinObjectContainer)skin.getSkinObject("content-area"));
        if (cont != null) {
            String ds_str = "";
            Object ds = entry.getDataSource();
            Tag[] tags = DataSourceUtils.getTags(ds);
            if (tags.length > 0) {
                Tag[] tagArray = tags;
                int n = tags.length;
                int n2 = 0;
                while (n2 < n) {
                    Tag tag = tagArray[n2];
                    if ((ds_str = String.valueOf(ds_str) + (ds_str.isEmpty() ? "" : ", ") + tag.getTagName()).length() > 200) {
                        ds_str = String.valueOf(ds_str.substring(0, 200)) + "...";
                        break;
                    }
                    ++n2;
                }
            } else {
                DownloadManager[] dms;
                DownloadManager[] downloadManagerArray = dms = DataSourceUtils.getDMs(ds);
                int n = dms.length;
                int n3 = 0;
                while (n3 < n) {
                    DownloadManager dm = downloadManagerArray[n3];
                    if ((ds_str = String.valueOf(ds_str) + (ds_str.isEmpty() ? "" : ", ") + dm.getDisplayName()).length() > 200) {
                        ds_str = String.valueOf(ds_str.substring(0, 200)) + "...";
                        break;
                    }
                    ++n3;
                }
            }
            String title = String.valueOf(entry.getTitle()) + (ds_str.length() == 0 ? "" : " - " + ds_str);
            skinnedDialog.setTitle(title);
            String configPrefix = "mdi.popout:" + entry.getId();
            PopOutManager.registerPopOut(skinnedDialog, title, style, false, configPrefix, entry);
            skinnedDialog.open(configPrefix, true);
        } else {
            skinnedDialog.close();
        }
    }

    public static SkinnedDialog buildSkinnedDialog(String id, Object ds, UISWTViewBuilderCore builder) {
        SkinnedDialog skinnedDialog = new SkinnedDialog("skin3_dlg_sidebar_popout", "shell", null, 3184);
        SWTSkin skin = skinnedDialog.getSkin();
        SWTSkinObjectContainer so = (SWTSkinObjectContainer)skin.getSkinObject("content-area");
        SWTSkinObjectContainer cont = BaseMdiEntry.buildStandAlone(so, null, SWTSkinFactory.getInstance(), id, ds, 0, builder);
        if (cont == null) {
            skinnedDialog.close();
            return null;
        }
        return skinnedDialog;
    }

    public static void popOutStandAlone(String title, Map<String, Object> state, String configPrefix) {
        int style = 3184;
        SkinnedDialog skinnedDialog = new SkinnedDialog("skin3_dlg_sidebar_popout", "shell", null, style);
        SWTSkin skin = skinnedDialog.getSkin();
        SWTSkinObjectContainer cont = BaseMdiEntry.importStandAlone((SWTSkinObjectContainer)skin.getSkinObject("content-area"), state, null);
        if (cont != null) {
            skinnedDialog.setTitle(title);
            PopOutManager.registerPopOut(skinnedDialog, title, style, false, configPrefix, state);
            skinnedDialog.open(configPrefix, true);
        } else {
            skinnedDialog.close();
        }
    }

    private static class PopOutDetails {
        int type;
        long id;
        String title;
        int style;
        boolean on_top;
        String config_prefix;
        Map<String, Object> state;

        private PopOutDetails() {
        }
    }
}

