/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.pairing.PairingException;
import com.biglybt.core.pairing.PairingManager;
import com.biglybt.core.pairing.PairingManagerFactory;
import com.biglybt.core.pairing.PairingManagerListener;
import com.biglybt.core.pairing.PairingTest;
import com.biglybt.core.pairing.PairingTestListener;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.PluginException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.installer.InstallablePlugin;
import com.biglybt.pif.installer.PluginInstallationListener;
import com.biglybt.pif.installer.PluginInstaller;
import com.biglybt.pif.installer.StandardPlugin;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinButtonUtility;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectButton;
import com.biglybt.ui.swt.skin.SWTSkinObjectImage;
import com.biglybt.ui.swt.skin.SWTSkinObjectText;
import com.biglybt.ui.swt.skin.SWTSkinObjectText_UrlClickedListener;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.views.skin.SkinnedDialog;
import com.biglybt.util.StringCompareUtils;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RemotePairingWindow
implements PairingManagerListener {
    private static final String PLUGINID_WEBUI = "xmwebui";
    private static final boolean SHOW_SPEW = false;
    private static final boolean DEBUG = false;
    private static final boolean USE_OUR_QR = false;
    static RemotePairingWindow instance = null;
    private SkinnedDialog skinnedDialog;
    private SWTSkin skin;
    private SWTSkinObjectButton soEnablePairing;
    private PairingManager pairingManager;
    private SWTSkinObject soCodeArea;
    private Font fontCode;
    private String accessCode;
    private Control control;
    private SWTSkinObjectText soStatusText;
    private SWTSkinObject soFTUX;
    private SWTSkinObject soCode;
    private SWTSkinObjectText soToClipboard;
    private boolean hideCode = true;
    private String fallBackStatusText = "";
    private static testPairingClass testPairingClass;
    private PairingTest pairingTest;
    private boolean alreadyTested;
    private String storedToClipboardText;
    private String lastPairingTestError;
    private SWTSkinObjectImage soQR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void open() {
        Class<RemotePairingWindow> clazz = RemotePairingWindow.class;
        synchronized (RemotePairingWindow.class) {
            if (instance == null) {
                instance = new RemotePairingWindow();
            }
            final RemotePairingWindow inst = instance;
            // ** MonitorExit[var1] (shouldn't be in output)
            CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.SWT_THREAD, new CoreRunningListener(){

                @Override
                public void coreRunning(Core core) {
                    inst._open();
                }
            });
            return;
        }
    }

    private PluginInterface getWebUI() {
        return CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID(PLUGINID_WEBUI, true);
    }

    private void _open() {
        boolean showFTUX;
        this.alreadyTested = false;
        this.pairingManager = PairingManagerFactory.getSingleton();
        PluginInterface piWebUI = this.getWebUI();
        boolean bl = showFTUX = piWebUI == null || !this.pairingManager.isEnabled();
        if (this.skinnedDialog == null || this.skinnedDialog.isDisposed()) {
            this.skinnedDialog = new SkinnedDialog("skin3_dlg_remotepairing", "shell", 2144);
            this.skin = this.skinnedDialog.getSkin();
            this.soCodeArea = this.skin.getSkinObject("code-area");
            this.control = this.soCodeArea.getControl();
            this.soEnablePairing = (SWTSkinObjectButton)this.skin.getSkinObject("enable-pairing");
            this.soEnablePairing.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                @Override
                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    skinObject.getControl().setEnabled(false);
                    if (!RemotePairingWindow.this.pairingManager.isEnabled()) {
                        RemotePairingWindow.this.pairingManager.setEnabled(true);
                    } else {
                        RemotePairingWindow.this.somethingChanged(RemotePairingWindow.this.pairingManager);
                    }
                    if (RemotePairingWindow.this.getWebUI() == null) {
                        RemotePairingWindow.this.installWebUI();
                    } else {
                        RemotePairingWindow.this.switchToCode();
                    }
                }
            });
            this.soFTUX = this.skin.getSkinObject("pairing-ftux");
            this.soCode = this.skin.getSkinObject("pairing-code");
            this.soQR = (SWTSkinObjectImage)this.skin.getSkinObject("pairing-qr");
            if (this.accessCode != null) {
                this.setupQR(this.accessCode);
            }
            this.soStatusText = (SWTSkinObjectText)this.skin.getSkinObject("status-text");
            this.soStatusText.addUrlClickedListener(new SWTSkinObjectText_UrlClickedListener(){

                @Override
                public boolean urlClicked(GCStringPrinter.URLInfo urlInfo) {
                    if (urlInfo.url.equals("retry")) {
                        RemotePairingWindow.this.alreadyTested = false;
                        RemotePairingWindow.this.testPairing(false);
                        return true;
                    }
                    return false;
                }
            });
            this.pairingManager.addListener(this);
            Font font = this.control.getFont();
            GC gc = new GC((Drawable)this.control);
            this.fontCode = FontUtils.getFontWithStyle(font, 1, 1.33f);
            gc.dispose();
            this.control.setFont(this.fontCode);
            this.control.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Color oldColor = e.gc.getForeground();
                    Rectangle printArea = ((Composite)e.widget).getClientArea();
                    printArea.y += 10;
                    printArea.height -= 20;
                    int fullWidth = printArea.width;
                    int fullHeight = printArea.height;
                    GCStringPrinter sp = new GCStringPrinter(e.gc, MessageText.getString("remote.pairing.accesscode"), printArea, false, false, 0);
                    sp.calculateMetrics();
                    Point sizeAccess = sp.getCalculatedSize();
                    String drawAccessCode = RemotePairingWindow.this.accessCode == null ? "      " : RemotePairingWindow.this.accessCode;
                    int numBoxes = drawAccessCode.length();
                    int boxSize = 25;
                    int boxSizeAndPadding = 30;
                    int allBoxesWidth = numBoxes * boxSizeAndPadding;
                    int textPadding = 15;
                    printArea.y = (fullHeight - boxSizeAndPadding - sizeAccess.y + textPadding) / 2;
                    sp.printString(e.gc, printArea, 0x1000080);
                    if (Utils.isDarkAppearanceNative()) {
                        e.gc.setBackground(Colors.getSystemColor((Device)RemotePairingWindow.this.control.getDisplay(), 22));
                        e.gc.setForeground(Colors.getSystemColor((Device)RemotePairingWindow.this.control.getDisplay(), 21));
                        if (Utils.isDarkAppearanceNativeWindows()) {
                            oldColor = Colors.getSystemColor((Device)RemotePairingWindow.this.control.getDisplay(), 21);
                        }
                    } else {
                        e.gc.setBackground(Colors.white);
                        e.gc.setForeground(Colors.blue);
                    }
                    int xStart = (fullWidth - allBoxesWidth) / 2;
                    int yStart = printArea.y + sizeAccess.y + textPadding;
                    int i = 0;
                    while (i < numBoxes) {
                        Rectangle r = new Rectangle(xStart + i * boxSizeAndPadding, yStart, boxSize, boxSize);
                        e.gc.fillRectangle(r);
                        e.gc.setForeground(Colors.blues[9]);
                        e.gc.drawRectangle(r);
                        if (RemotePairingWindow.this.isCodeVisible()) {
                            e.gc.setForeground(oldColor);
                            GCStringPrinter.printString(e.gc, "" + drawAccessCode.charAt(i), r, false, false, 0x1000000);
                        }
                        ++i;
                    }
                }
            });
            this.soToClipboard = (SWTSkinObjectText)this.skin.getSkinObject("pair-clipboard");
            this.soToClipboard.addUrlClickedListener(new SWTSkinObjectText_UrlClickedListener(){

                @Override
                public boolean urlClicked(GCStringPrinter.URLInfo urlInfo) {
                    if (urlInfo.url.equals("new")) {
                        try {
                            RemotePairingWindow.this.accessCode = RemotePairingWindow.this.pairingManager.getReplacementAccessCode();
                        }
                        catch (PairingException pairingException) {
                            // empty catch block
                        }
                        RemotePairingWindow.this.control.redraw();
                        RemotePairingWindow.this.setupQR(RemotePairingWindow.this.accessCode);
                        String s = RemotePairingWindow.this.soToClipboard.getText();
                        int i = s.indexOf("|");
                        if (i > 0) {
                            RemotePairingWindow.this.soToClipboard.setText(s.substring(0, i - 1));
                        }
                    } else if (urlInfo.url.equals("clip")) {
                        ClipboardCopy.copyToClipBoard(RemotePairingWindow.this.accessCode);
                    }
                    return true;
                }
            });
            SWTSkinButtonUtility btnToClipboard = new SWTSkinButtonUtility(this.soToClipboard);
            btnToClipboard.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                @Override
                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                }
            });
            this.skinnedDialog.addCloseListener(new SkinnedDialog.SkinnedDialogClosedListener(){

                @Override
                public void skinDialogClosed(SkinnedDialog dialog) {
                    RemotePairingWindow.this.skinnedDialog = null;
                    RemotePairingWindow.this.pairingManager.removeListener(RemotePairingWindow.this);
                    Utils.disposeSWTObjects(RemotePairingWindow.this.fontCode);
                    if (RemotePairingWindow.this.pairingTest != null) {
                        RemotePairingWindow.this.pairingTest.cancel();
                    }
                }
            });
            if (showFTUX) {
                this.soFTUX.getControl().moveAbove(null);
            }
        }
        this.setCodeVisible(false);
        this.skinnedDialog.open();
        if (showFTUX) {
            this.switchToFTUX();
        } else {
            this.switchToCode();
        }
    }

    private void setupQR(String ac) {
        if (this.soQR == null || this.soQR.isDisposed()) {
            return;
        }
        this.setupQR_URL(ac);
    }

    private void setupQR_URL(String ac) {
        URL server_url = PairingManagerFactory.getSingleton().getWebRemoteURL();
        String url = "https://chart.googleapis.com/chart?chs=150x150&cht=qr&chl=" + UrlUtils.encode(String.valueOf(server_url.toExternalForm()) + "?ac=" + ac + "&ref=1") + "&choe=UTF-8&chld=|0";
        this.soQR.setImageUrl(url);
    }

    public void switchToFTUX() {
        SWTSkinObject soPairInstallArea = this.skin.getSkinObject("pair-install");
        if (soPairInstallArea != null) {
            soPairInstallArea.getControl().moveAbove(null);
        }
        this.soFTUX.setVisible(true);
        this.soCode.setVisible(false);
    }

    public void switchToCode() {
        this.somethingChanged(this.pairingManager);
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                SWTSkinObject soPairArea;
                if (RemotePairingWindow.this.skinnedDialog == null || RemotePairingWindow.this.skinnedDialog.isDisposed()) {
                    return;
                }
                SWTSkinObjectImage soImage = (SWTSkinObjectImage)RemotePairingWindow.this.skin.getSkinObject("status-image");
                if (soImage != null) {
                    soImage.setImageByID("icon.spin", null);
                }
                if ((soPairArea = RemotePairingWindow.this.skin.getSkinObject("reset-pair-area")) != null) {
                    soPairArea.getControl().moveAbove(null);
                }
                RemotePairingWindow.this.soFTUX.setVisible(false);
                RemotePairingWindow.this.soCode.setVisible(true);
            }
        });
    }

    protected void testPairing(boolean delay) {
        if (this.alreadyTested) {
            return;
        }
        this.lastPairingTestError = "";
        this.alreadyTested = true;
        this.storedToClipboardText = this.soToClipboard.getText();
        try {
            this.setCodeVisible(false);
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    RemotePairingWindow.this.control.redraw();
                    SWTSkinObjectImage soImage = (SWTSkinObjectImage)RemotePairingWindow.this.skin.getSkinObject("status-image");
                    if (soImage != null) {
                        soImage.setImageByID("icon.spin", null);
                    }
                }
            });
            final String defColorID = Utils.isDarkAppearanceNative() ? "#c0c0c0" : "#000000";
            this.soStatusText.setTextID("remote.pairing.test.running");
            this.soStatusText.setTextColor(ColorCache.getColor((Device)this.control.getDisplay(), defColorID));
            this.soToClipboard.setText(" ");
            final PairingTestListener testListener = new PairingTestListener(){

                @Override
                public void testStarted(PairingTest test) {
                }

                @Override
                public void testComplete(PairingTest test) {
                    if (RemotePairingWindow.this.skinnedDialog == null || RemotePairingWindow.this.skinnedDialog.isDisposed() || RemotePairingWindow.this.control.isDisposed()) {
                        return;
                    }
                    int outcome = test.getOutcome();
                    String iconID = null;
                    String colorID = defColorID;
                    switch (outcome) {
                        case 1: {
                            RemotePairingWindow.this.fallBackStatusText = MessageText.getString("remote.pairing.test.success");
                            iconID = "icon.success";
                            colorID = "#007305";
                            break;
                        }
                        case 6: {
                            RemotePairingWindow.this.fallBackStatusText = test.getErrorMessage();
                            iconID = "icon.warning";
                            colorID = "#A97000";
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            RemotePairingWindow.this.fallBackStatusText = MessageText.getString("remote.pairing.test.unavailable", new String[]{test.getErrorMessage()});
                            iconID = "icon.warning";
                            colorID = "#C98000";
                            break;
                        }
                        default: {
                            RemotePairingWindow.this.fallBackStatusText = MessageText.getString("remote.pairing.test.fail", new String[]{test.getErrorMessage()});
                            iconID = "icon.failure";
                            colorID = "#c90000";
                        }
                    }
                    RemotePairingWindow.this.setCodeVisible(true);
                    final String fIconID = iconID;
                    RemotePairingWindow.this.somethingChanged(RemotePairingWindow.this.pairingManager);
                    RemotePairingWindow.this.lastPairingTestError = RemotePairingWindow.this.pairingTest.getErrorMessage();
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            if (!RemotePairingWindow.this.control.isDisposed()) {
                                RemotePairingWindow.this.control.redraw();
                                SWTSkinObjectImage soImage = (SWTSkinObjectImage)RemotePairingWindow.this.skin.getSkinObject("status-image");
                                if (soImage != null) {
                                    soImage.setImageByID(fIconID, null);
                                }
                            }
                        }
                    });
                    RemotePairingWindow.this.updateToolTip();
                    RemotePairingWindow.this.soStatusText.setText(RemotePairingWindow.this.fallBackStatusText);
                    RemotePairingWindow.this.soStatusText.setTextColor(ColorCache.getColor((Device)RemotePairingWindow.this.control.getDisplay(), colorID));
                    RemotePairingWindow.this.soToClipboard.setText(RemotePairingWindow.this.storedToClipboardText);
                }
            };
            SimpleTimer.addEvent("testPairing", SystemTime.getOffsetTime(delay ? 5000 : 0), new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent event2) {
                    try {
                        RemotePairingWindow.this.pairingTest = RemotePairingWindow.this.pairingManager.testService(RemotePairingWindow.PLUGINID_WEBUI, testListener);
                    }
                    catch (PairingException e) {
                        RemotePairingWindow.this.finishFailedTest();
                        RemotePairingWindow.this.setStatusToException(e);
                        Debug.out(e);
                    }
                    if (RemotePairingWindow.this.pairingTest == null) {
                        RemotePairingWindow.this.finishFailedTest();
                    }
                }
            });
        }
        catch (Exception e) {
            this.finishFailedTest();
            this.setStatusToException(e);
            Debug.out(e);
        }
    }

    protected void setStatusToException(Exception e) {
        this.soStatusText.setText(String.valueOf(Debug.getNestedExceptionMessage(e)) + ". <A HREF=\"retry\">Try again</A>");
        this.soStatusText.setTextColor(ColorCache.getColor((Device)this.control.getDisplay(), "#c90000"));
        SWTSkinObjectImage soImage = (SWTSkinObjectImage)this.skin.getSkinObject("status-image");
        if (soImage != null) {
            soImage.setImageByID("icon.failure", null);
        }
    }

    protected void updateToolTip() {
        SWTSkinObjectImage soImage = (SWTSkinObjectImage)this.skin.getSkinObject("status-image");
        if (soImage != null) {
            String lastPairingErr;
            String status;
            String s = this.lastPairingTestError;
            if (s == null) {
                s = "";
            }
            if ((status = this.pairingManager.getStatus()) != null && status.length() > 0) {
                if (s.length() > 0) {
                    s = String.valueOf(s) + "\n";
                }
                s = String.valueOf(s) + "Pairing Status: " + status;
            }
            if ((lastPairingErr = this.pairingManager.getLastServerError()) != null && lastPairingErr.length() > 0) {
                if (s.length() > 0) {
                    s = String.valueOf(s) + "\n";
                }
                s = String.valueOf(s) + "Pairing Error: " + lastPairingErr;
            }
            soImage.setTooltipID("!" + s + "!");
        }
    }

    private void finishFailedTest() {
        this.setCodeVisible(true);
        this.somethingChanged(this.pairingManager);
        if (this.storedToClipboardText != null && this.storedToClipboardText.length() > 0) {
            this.soToClipboard.setText(this.storedToClipboardText);
        }
    }

    protected void installWebUI() {
        PluginInstaller installer = CoreFactory.getSingleton().getPluginManager().getPluginInstaller();
        StandardPlugin vuze_plugin = null;
        try {
            vuze_plugin = installer.getStandardPlugin(PLUGINID_WEBUI);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (vuze_plugin == null) {
            return;
        }
        if (vuze_plugin.isAlreadyInstalled()) {
            PluginInterface plugin = vuze_plugin.getAlreadyInstalledPlugin();
            plugin.getPluginState().setDisabled(false);
            return;
        }
        try {
            this.switchToFTUX();
            SWTSkinObject soInstall = this.skin.getSkinObject("pairing-install");
            final SWTSkinObject soLearnMore = this.skin.getSkinObject("learn-more");
            if (soLearnMore != null) {
                soLearnMore.setVisible(false);
            }
            HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
            properties.put(1, 2);
            properties.put(2, soInstall.getControl());
            properties.put(3, true);
            installer.install(new InstallablePlugin[]{vuze_plugin}, false, properties, new PluginInstallationListener(){

                @Override
                public void completed() {
                    if (soLearnMore != null) {
                        soLearnMore.setVisible(true);
                    }
                    RemotePairingWindow.this.switchToCode();
                }

                @Override
                public void cancelled() {
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            if (RemotePairingWindow.this.skinnedDialog != null && !RemotePairingWindow.this.skinnedDialog.isDisposed()) {
                                RemotePairingWindow.this.skinnedDialog.close();
                                RemotePairingWindow.this.skinnedDialog = null;
                            }
                        }
                    });
                }

                @Override
                public void failed(PluginException e) {
                    Debug.out(e);
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    @Override
    public void somethingChanged(PairingManager pm) {
        boolean newAccessCode;
        if (this.skinnedDialog.isDisposed()) {
            return;
        }
        this.updateToolTip();
        String lastAccessCode = this.accessCode;
        this.accessCode = this.pairingManager.peekAccessCode();
        boolean bl = newAccessCode = !StringCompareUtils.equals(lastAccessCode, this.accessCode);
        if (this.accessCode != null && this.getWebUI() != null && !this.alreadyTested && !pm.hasActionOutstanding()) {
            if (newAccessCode) {
                this.testPairing(true);
            } else {
                this.testPairing(false);
            }
        } else {
            String last_error = pm.getLastServerError();
            if (last_error != null && last_error.length() > 0) {
                this.soStatusText.setText(last_error);
                this.soStatusText.setTextColor(ColorCache.getColor((Device)this.control.getDisplay(), "#c90000"));
            }
        }
        if (newAccessCode) {
            this.setupQR(this.accessCode);
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    RemotePairingWindow.this.control.redraw();
                }
            });
        }
    }

    public boolean isCodeVisible() {
        return this.hideCode;
    }

    public void setCodeVisible(boolean hideCode) {
        this.hideCode = hideCode;
        if (this.soQR != null && !this.soQR.isDisposed()) {
            this.soQR.setVisible(hideCode);
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (RemotePairingWindow.this.control != null && !RemotePairingWindow.this.control.isDisposed()) {
                    RemotePairingWindow.this.control.redraw();
                    RemotePairingWindow.this.control.update();
                }
            }
        });
    }

    public static class testPairingClass
    implements PairingTest {
        int curOutcome = 0;
        int[] testOutcomes = new int[]{1, 2, 6, 5, 4, 3};
        String[] testErrs = new String[]{"Success", "Could Not Connect blah blah technical stuff", "You Cancelled (unpossible!)", "Server Failed", "Server Overloaded", "Server Unavailable"};

        public void inc() {
            ++this.curOutcome;
            if (this.curOutcome == this.testOutcomes.length) {
                this.curOutcome = 0;
            }
        }

        @Override
        public int getOutcome() {
            return this.testOutcomes[this.curOutcome];
        }

        @Override
        public String getErrorMessage() {
            return this.testErrs[this.curOutcome];
        }

        @Override
        public void cancel() {
        }
    }
}

