/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells;

import com.biglybt.core.util.AEThread2;
import com.biglybt.ui.common.RememberedDecisionsManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class RevertFileLocationsWindow {
    private static final int REVERT_COPY = 1;
    private static final int REVERT_RETAIN_NAMES = 2;
    private static final int REVERT_HARD_LINK = 4;
    private Shell shell;
    private boolean done;
    private ResultListener resultListener;

    public void open(ResultListener l) {
        this.resultListener = l;
        Utils.execSWTThread(this::openInSWT);
    }

    private void openInSWT() {
        this.shell = ShellFactory.createMainShell(2160);
        Utils.setShellIcon(this.shell);
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    RevertFileLocationsWindow.this.shell.dispose();
                }
            }
        });
        this.shell.addDisposeListener(e -> {
            if (!this.done) {
                this.resultListener.closed(false, false, false, false);
            }
        });
        Messages.setLanguageText((Widget)this.shell, "MyTorrentsView.menu.revertfiles");
        Label lblMessage = new Label((Composite)this.shell, 64);
        Messages.setLanguageText((Widget)lblMessage, "revert.file.locations.message");
        Button btnHardLink = new Button((Composite)this.shell, 32);
        Messages.setLanguageText((Widget)btnHardLink, "revert.file.locations.hardlink");
        Button btnCopy = new Button((Composite)this.shell, 32);
        Messages.setLanguageText((Widget)btnCopy, "revert.file.locations.copy");
        Button btnRetainNames = new Button((Composite)this.shell, 32);
        Messages.setLanguageText((Widget)btnRetainNames, "revert.file.locations.retain.names");
        Label separator = new Label((Composite)this.shell, 258);
        Composite cButtons = new Composite((Composite)this.shell, 0);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.fill = true;
        rowLayout.spacing = 3;
        cButtons.setLayout((Layout)rowLayout);
        Button[] buttons = Utils.createOKCancelButtons(cButtons);
        Button btnOk = buttons[0];
        Button btnCancel = buttons[1];
        this.shell.setDefaultButton(btnOk);
        btnOk.addListener(13, ev -> {
            this.done = true;
            int decisions = 0;
            boolean hard_link = btnHardLink.getSelection();
            boolean copy = btnCopy.getSelection();
            boolean retain = btnRetainNames.getSelection();
            if (hard_link) {
                decisions |= 4;
            }
            if (copy) {
                decisions |= 1;
            }
            if (retain) {
                decisions |= 2;
            }
            RememberedDecisionsManager.setRemembered("revert.file.locations", decisions);
            AEThread2.createAndStartDaemon("RevertFiles", () -> this.resultListener.closed(true, hard_link, copy, retain));
            this.shell.dispose();
        });
        btnCancel.addListener(13, ev -> this.shell.dispose());
        this.shell.setLayout((Layout)new FormLayout());
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 3);
        fd.left = new FormAttachment(0, 8);
        fd.right = new FormAttachment(100, -3);
        fd.width = 300;
        lblMessage.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)lblMessage, 10, 16384);
        fd.left = new FormAttachment(0, 8);
        fd.right = new FormAttachment(100, -8);
        btnHardLink.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)btnHardLink, 0, 16384);
        fd.left = new FormAttachment(0, 8);
        fd.right = new FormAttachment(100, -8);
        btnCopy.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)btnCopy, 0, 16384);
        fd.left = new FormAttachment(0, 8);
        fd.right = new FormAttachment(100, -8);
        btnRetainNames.setLayoutData((Object)fd);
        int decisions = RememberedDecisionsManager.getRememberedDecision("revert.file.locations");
        if (decisions > 0) {
            if ((decisions & 4) > 0) {
                btnHardLink.setSelection(true);
            }
            if ((decisions & 1) > 0) {
                btnCopy.setSelection(true);
            }
            if ((decisions & 2) > 0) {
                btnRetainNames.setSelection(true);
            }
            if (btnHardLink.getSelection()) {
                btnCopy.setEnabled(false);
            } else if (btnCopy.getSelection()) {
                btnHardLink.setEnabled(false);
            }
        }
        btnCopy.addListener(13, ev -> btnHardLink.setEnabled(!btnCopy.getSelection()));
        btnHardLink.addListener(13, ev -> btnCopy.setEnabled(!btnHardLink.getSelection()));
        fd = new FormData();
        fd.top = new FormAttachment((Control)btnRetainNames, 2);
        fd.left = new FormAttachment(0, 3);
        fd.right = new FormAttachment(100, -3);
        separator.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)separator, 5);
        fd.right = new FormAttachment(100, -3);
        fd.bottom = new FormAttachment(100, -3);
        cButtons.setLayoutData((Object)fd);
        this.shell.pack();
        Utils.centreWindow(this.shell);
        this.shell.open();
    }

    public void cancel() {
        Utils.execSWTThread(() -> this.shell.dispose());
    }

    public static interface ResultListener {
        public void closed(boolean var1, boolean var2, boolean var3, boolean var4);
    }
}

