/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells;

import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.shells.DockPosition;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ShellDocker {
    private DockPosition anchorControlPosition = new DockPosition();
    private boolean isDocked = true;
    private boolean moveWithShell = true;
    private boolean resizeWithShell = false;
    private Listener dockingEnabler = null;
    private Control anchorControl = null;
    private Shell dockedShell = null;
    private Shell mainShell = null;

    public ShellDocker(Control anchorControl, Shell dockedShell) {
        if (anchorControl == null || anchorControl.isDisposed()) {
            throw new NullPointerException("anchorControl cannot be null or disposed");
        }
        if (dockedShell == null || dockedShell.isDisposed()) {
            throw new NullPointerException("dockedShell cannot be null or disposed");
        }
        this.anchorControl = anchorControl;
        this.dockedShell = dockedShell;
        this.mainShell = anchorControl.getShell();
    }

    public void openShell() {
        this.openShell(this.isDocked(), false);
    }

    public void openShell(boolean isDocked) {
        this.openShell(isDocked, false);
    }

    public void openShell(boolean isDocked, boolean isAnimated) {
        this.setDocked(isDocked);
        if (!isDocked) {
            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uiFunctions == null) {
                Utils.centreWindow(this.dockedShell);
            } else {
                Utils.centerWindowRelativeTo(this.dockedShell, (Control)uiFunctions.getMainShell());
            }
        }
        if (!isAnimated) {
            this.dockedShell.open();
        } else {
            this.dockedShell.open();
        }
    }

    public boolean isDocked() {
        return this.isDocked;
    }

    public void setDocked(boolean isDocked) {
        this.isDocked = isDocked;
        if (isDocked) {
            this.performDocking();
            if (this.dockingEnabler == null) {
                this.dockingEnabler = new Listener(){

                    public void handleEvent(Event event2) {
                        if (event2.type == 11) {
                            if (ShellDocker.this.isResizeWithShell()) {
                                System.out.println("resizing");
                            } else {
                                ShellDocker.this.performDocking();
                            }
                        } else if (event2.type == 10) {
                            ShellDocker.this.performDocking();
                        }
                    }
                };
            }
            if (this.mainShell != null && !this.mainShell.isDisposed()) {
                if (this.isMoveWithShell()) {
                    this.mainShell.addListener(10, this.dockingEnabler);
                }
                if (this.isResizeWithShell()) {
                    this.mainShell.addListener(11, this.dockingEnabler);
                }
                this.anchorControl.addListener(10, this.dockingEnabler);
                this.anchorControl.addListener(11, this.dockingEnabler);
            }
            this.anchorControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ShellDocker.this.setDocked(false);
                }
            });
            this.dockedShell.addListener(21, new Listener(){

                public void handleEvent(Event e) {
                    ShellDocker.this.setDocked(false);
                }
            });
        } else {
            if (this.mainShell != null && !this.mainShell.isDisposed() && this.dockingEnabler != null) {
                this.mainShell.removeListener(10, this.dockingEnabler);
                this.mainShell.removeListener(11, this.dockingEnabler);
            }
            if (this.anchorControl != null && !this.anchorControl.isDisposed() && this.dockingEnabler != null) {
                this.anchorControl.removeListener(10, this.dockingEnabler);
                this.anchorControl.removeListener(11, this.dockingEnabler);
            }
        }
    }

    private void performDocking() {
        if (this.isAlive()) {
            switch (this.anchorControlPosition.getPosition()) {
                case 1: {
                    this.dockedShell.setLocation(this.mainShell.toDisplay(this.anchorControl.getLocation()));
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    Point p = this.mainShell.toDisplay(this.anchorControl.getLocation());
                    p.x += this.anchorControlPosition.getOffset().xOffset;
                    p.y += this.anchorControlPosition.getOffset().yOffset;
                    p.y += this.anchorControl.getSize().y;
                    this.dockedShell.setLocation(p);
                    break;
                }
                case 4: {
                    Point p = this.mainShell.toDisplay(this.anchorControl.getLocation());
                    p.x += this.anchorControlPosition.getOffset().xOffset;
                    p.y += this.anchorControlPosition.getOffset().yOffset;
                    p.x += this.anchorControl.getSize().x;
                    p.y += this.anchorControl.getSize().y;
                    this.dockedShell.setLocation(p);
                    break;
                }
            }
        }
    }

    private boolean isAlive() {
        if (this.mainShell == null || this.mainShell.isDisposed()) {
            System.err.println("\tmainshell is disposed?");
            return false;
        }
        if (this.dockedShell == null || this.dockedShell.isDisposed()) {
            System.err.println("\tdockedShell is disposed?");
            return false;
        }
        if (this.anchorControl == null || this.anchorControl.isDisposed()) {
            System.err.println("\tanchorControl is disposed?");
            return false;
        }
        return true;
    }

    public boolean isMoveWithShell() {
        return this.moveWithShell;
    }

    public void setMoveWithShell(boolean moveWithShell) {
        this.moveWithShell = moveWithShell;
    }

    public boolean isResizeWithShell() {
        return this.resizeWithShell;
    }

    public void setResizeWithShell(boolean resizeWithShell) {
        this.resizeWithShell = resizeWithShell;
    }

    public DockPosition getAnchorControlPosition() {
        return this.anchorControlPosition;
    }

    public void setAnchorControlPosition(DockPosition anchorControlPosition) {
        this.anchorControlPosition = anchorControlPosition;
    }
}

