/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells.main;

import com.biglybt.core.Core;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.debug.UIDebugGenerator;
import com.biglybt.ui.swt.donations.DonationWindow;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObjectContainer;
import com.biglybt.ui.swt.views.skin.VuzeMessageBox;
import com.biglybt.ui.swt.views.skin.VuzeMessageBoxListener;
import java.util.List;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class DebugMenuHelper {
    public static MenuItem createDebugMenuItem(Menu menuDebug) {
        final UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions == null) {
            throw new IllegalStateException("UIFunctionsManagerSWT.getUIFunctionsSWT() is returning null");
        }
        MenuItem item = new MenuItem(menuDebug, 8);
        item.setText("Run GC");
        item.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                System.gc();
            }
        });
        item = new MenuItem(menuDebug, 8);
        item.setText("&CoreReq");
        item.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                CoreWaiterSWT.waitForCoreRunning(new CoreRunningListener(){

                    @Override
                    public void coreRunning(Core core) {
                        new MessageBoxShell(0, "Done", "Core Now Avail").open(null);
                    }
                });
            }
        });
        item = new MenuItem(menuDebug, 64);
        item.setText("DW");
        Menu menuBrowserTB = new Menu(menuDebug.getParent(), 4);
        item.setMenu(menuBrowserTB);
        item = new MenuItem(menuBrowserTB, 0);
        item.setText("popup check");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean oldDebug = DonationWindow.DEBUG;
                DonationWindow.DEBUG = true;
                DonationWindow.checkForDonationPopup();
                DonationWindow.DEBUG = oldDebug;
            }
        });
        item = new MenuItem(menuBrowserTB, 0);
        item.setText("show");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean oldDebug = DonationWindow.DEBUG;
                DonationWindow.DEBUG = true;
                DonationWindow.open(true, "debug");
                DonationWindow.DEBUG = oldDebug;
            }
        });
        item = new MenuItem(menuDebug, 0);
        item.setText("Alerts");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = "This is a  long message with lots of information and stuff you really should read.  Are you still reading? Good, because reading <a href=\"http://moo.com\">stimulates</a> the mind.\n\nYeah Baby.";
                LogAlert logAlert = new LogAlert(true, 0, "Simple");
                Logger.log(logAlert);
                logAlert = new LogAlert(true, 1, text);
                logAlert.details = "Details: \n\n" + text;
                Logger.log(logAlert);
                logAlert = new LogAlert(true, 3, "ShortText");
                logAlert.details = "Details";
                Logger.log(logAlert);
                logAlert = new LogAlert(true, 1, "Forced Alert");
                logAlert.forceNotify = true;
                logAlert.details = "Details: \n\n" + text;
                Logger.log(logAlert);
            }
        });
        item = new MenuItem(menuDebug, 0);
        item.setText("MsgBox");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VuzeMessageBox box = new VuzeMessageBox("Title", "Text", new String[]{"Ok", "Cancel"}, 0);
                box.setListener(new VuzeMessageBoxListener(){

                    @Override
                    public void shellReady(Shell shell, SWTSkinObjectContainer soExtra) {
                        SWTSkin skin = soExtra.getSkin();
                        skin.createSkinObject("dlg.generic.test", "dlg.generic.test", soExtra);
                        skin.layout(soExtra);
                        shell.layout(true, true);
                    }
                });
                box.open(null);
            }
        });
        item = new MenuItem(menuDebug, 64);
        item.setText("Size");
        Menu menuSize = new Menu(menuDebug.getParent(), 4);
        item.setMenu(menuSize);
        int[] sizes = new int[]{640, 430, 800, 550, 1024, 718, 1280, 700, 1440, 850, 1600, 1050, 1920, 1150};
        int i = 0;
        while (i < sizes.length) {
            final int x = sizes[i];
            final int y = sizes[i + 1];
            item = new MenuItem(menuSize, 0);
            item.setText(x + "," + y);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell().setSize(x, y);
                }
            });
            i += 2;
        }
        item = new MenuItem(menuDebug, 8);
        item.setText("Dump UI");
        item.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Utils.dump((Control)uiFunctions.getMainShell());
            }
        });
        item = new MenuItem(menuDebug, 0);
        item.setText("Obfuscated Shell Image");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                Display display = Display.getCurrent();
                List<Image> shell_images = UIDebugGenerator.getShellImages();
                Image biggest_image = null;
                long biggest_area = 0L;
                for (Image image : shell_images) {
                    Shell shell2 = new Shell(display);
                    Rectangle bounds = image.getBounds();
                    long area = bounds.width * bounds.height;
                    if (area > biggest_area) {
                        biggest_image = image;
                    }
                    Point size = shell2.computeSize(bounds.width, bounds.height);
                    shell2.setSize(size);
                    shell2.setBackgroundImage(image);
                    shell2.open();
                }
                if (biggest_image != null) {
                    new Clipboard(display).setContents(new Object[]{biggest_image.getImageData()}, new Transfer[]{ImageTransfer.getInstance()});
                }
            }
        });
        return item;
    }
}

