/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells.opentorrent;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.torrent.impl.TorrentOpenFileOptions;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import com.biglybt.ui.swt.views.table.utils.TableColumnSWTUtils;
import java.text.NumberFormat;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class TableColumnOTOF_Size
implements TableCellRefreshListener,
TableColumnExtraInfoListener,
TableCellSWTPaintListener,
TableCellToolTipListener {
    public static final String COLUMN_ID = "size";

    public TableColumnOTOF_Size(TableColumn column) {
        column.initialize(2, -2, 80);
        column.addListeners(this);
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    @Override
    public void refresh(TableCell cell) {
        Object ds = cell.getDataSource();
        if (!(ds instanceof TorrentOpenFileOptions)) {
            return;
        }
        TorrentOpenFileOptions tfi = (TorrentOpenFileOptions)ds;
        cell.setSortValue(tfi.lSize);
        cell.setText(DisplayFormatters.formatByteCountToKiBEtc(tfi.lSize));
        TableColumnSWTUtils.setSizeAlpha(cell, tfi.lSize);
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        Object ds = cell.getDataSource();
        if (!(ds instanceof TorrentOpenFileOptions)) {
            return;
        }
        TorrentOpenFileOptions tfi = (TorrentOpenFileOptions)ds;
        float pct = (float)tfi.lSize / (float)tfi.parent.getTorrent().getSize();
        Rectangle bounds = cell.getBounds();
        bounds.width = (int)((float)bounds.width * pct);
        if (bounds.width > 2) {
            ++bounds.x;
            ++bounds.y;
            bounds.height -= 2;
            bounds.width -= 2;
            gc.setBackground(gc.getForeground());
            int alpha = gc.getAlpha();
            gc.setAlpha(10);
            gc.fillRectangle(bounds);
            gc.setAlpha(alpha);
        }
    }

    @Override
    public void cellHover(TableCell cell) {
        Object ds = cell.getDataSource();
        if (!(ds instanceof TorrentOpenFileOptions)) {
            return;
        }
        TorrentOpenFileOptions tfi = (TorrentOpenFileOptions)ds;
        String tooltip = String.valueOf(NumberFormat.getInstance().format(tfi.lSize)) + " " + MessageText.getString("DHTView.transport.bytes");
        cell.setToolTip(tooltip);
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }
}

