/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.shells.uiswitcher;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.UISwitcherUtil;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.mainwindow.Colors;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class UISwitcherWindow {
    private static String CFG_PREFIX = "window.uiswitcher.";
    private static String[] IDS = new String[]{"NewUI", "ClassicUI"};
    private Shell shell;
    private Button btnOk;
    private int ui = -1;
    private List<Object> disposeList = new ArrayList<Object>();

    public UISwitcherWindow() {
        this(false, true);
    }

    public UISwitcherWindow(boolean standalone, final boolean allowCancel) {
        String originalUIMode = UISwitcherUtil.calcUIMode();
        try {
            final Button[] buttons = new Button[IDS.length];
            int style = 2096;
            if (allowCancel) {
                style |= 0x40;
            }
            this.shell = standalone ? new Shell(Display.getDefault(), style) : ShellFactory.createShell(null, style);
            this.shell.setText(MessageText.getString(String.valueOf(CFG_PREFIX) + "title"));
            Utils.setShellIcon(this.shell);
            this.shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Utils.disposeSWTObjects(UISwitcherWindow.this.disposeList);
                    if (UISwitcherWindow.this.ui == 0) {
                        COConfigurationManager.setParameter("ui", "az3");
                    } else if (UISwitcherWindow.this.ui == 1) {
                        COConfigurationManager.setParameter("ui", "az2");
                    }
                    if (UISwitcherWindow.this.ui != -1) {
                        COConfigurationManager.setParameter("ui.asked", true);
                        UISwitcherUtil.triggerListeners(UISwitcherUtil.calcUIMode());
                    }
                }
            });
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            layout.marginWidth = 5;
            layout.marginHeight = 0;
            layout.verticalSpacing = 1;
            this.shell.setLayout((Layout)layout);
            Label title = new Label((Composite)this.shell, 64);
            GridData gd = new GridData(768);
            gd.verticalIndent = 3;
            title.setLayoutData((Object)gd);
            Messages.setLanguageText((Widget)title, String.valueOf(CFG_PREFIX) + "text");
            Listener radioListener = new Listener(){

                public void handleEvent(Event event2) {
                    int idx;
                    if (event2.widget instanceof Composite) {
                        Long l = (Long)event2.widget.getData("INDEX");
                        idx = l.intValue();
                    } else {
                        Composite c = ((Control)event2.widget).getParent();
                        Long l = (Long)c.getData("INDEX");
                        idx = l.intValue();
                    }
                    int i = 0;
                    while (i < buttons.length) {
                        boolean selected = idx == i;
                        Composite c = buttons[i].getParent();
                        c.setBackground(selected ? Colors.getSystemColor((Device)c.getDisplay(), 26) : null);
                        Color fg = selected ? Colors.getSystemColor((Device)c.getDisplay(), 27) : null;
                        Control[] children = c.getChildren();
                        int j = 0;
                        while (j < children.length) {
                            Control control = children[j];
                            control.setForeground(fg);
                            ++j;
                        }
                        buttons[i].setSelection(selected);
                        ++i;
                    }
                }
            };
            FontData[] fontData = this.shell.getFont().getFontData();
            fontData[0].setHeight((int)((double)fontData[0].getHeight() * 1.5));
            fontData[0].setStyle(1);
            Font headerFont = new Font((Device)this.shell.getDisplay(), fontData);
            this.disposeList.add(headerFont);
            Composite cCenter = new Composite((Composite)this.shell, 0);
            cCenter.setLayout((Layout)new GridLayout());
            cCenter.setLayoutData((Object)new GridData(64));
            int i = 0;
            while (i < IDS.length) {
                Composite c = new Composite(cCenter, 0);
                gd = new GridData(768);
                gd.verticalIndent = 0;
                c.setLayoutData((Object)gd);
                GridLayout gridLayout = new GridLayout(1, false);
                gridLayout.horizontalSpacing = 0;
                gridLayout.marginWidth = 5;
                gridLayout.marginHeight = 3;
                gridLayout.verticalSpacing = 0;
                c.setLayout((Layout)gridLayout);
                c.setData("INDEX", (Object)new Long(i));
                c.addListener(3, radioListener);
                buttons[i] = new Button(c, 16);
                buttons[i].setLayoutData((Object)new GridData(256));
                Messages.setLanguageText((Widget)buttons[i], String.valueOf(CFG_PREFIX) + IDS[i] + ".title");
                buttons[i].setData("INDEX", (Object)new Long(i));
                buttons[i].addListener(13, radioListener);
                buttons[i].setFont(headerFont);
                buttons[i].addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        if (e.detail == 64) {
                            e.doit = true;
                            e.detail = 16;
                        } else if (e.detail == 32) {
                            e.detail = 8;
                            e.doit = true;
                        } else if (e.detail == 16 || e.detail == 8) {
                            UISwitcherWindow.this.btnOk.setFocus();
                            e.doit = false;
                        } else if (e.detail == 4) {
                            e.doit = true;
                        } else if (e.detail == 2) {
                            e.doit = false;
                            if (allowCancel) {
                                UISwitcherWindow.this.ui = -1;
                                UISwitcherWindow.this.shell.dispose();
                            }
                        } else {
                            e.doit = false;
                        }
                    }
                });
                buttons[i].addListener(1, new Listener(){

                    public void handleEvent(Event event2) {
                        if (event2.keyCode == 0x1000001) {
                            UISwitcherWindow.this.shell.getDisplay().getFocusControl().traverse(32);
                        } else if (event2.keyCode == 0x1000002) {
                            UISwitcherWindow.this.shell.getDisplay().getFocusControl().traverse(64);
                        }
                    }
                });
                Label info = new Label(c, 64);
                gd = new GridData(1808);
                gd.horizontalIndent = 20;
                gd.verticalAlignment = 128;
                info.setLayoutData((Object)gd);
                Messages.setLanguageText((Widget)info, String.valueOf(CFG_PREFIX) + IDS[i] + ".text");
                info.addListener(3, radioListener);
                ++i;
            }
            Event eventSelectFirst = new Event();
            eventSelectFirst.widget = buttons[0];
            radioListener.handleEvent(eventSelectFirst);
            Composite cBottom = new Composite((Composite)this.shell, 0);
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cBottom.setLayout((Layout)layout);
            cBottom.setLayoutData((Object)new GridData(64));
            this.btnOk = new Button(cBottom, 8);
            Messages.setLanguageText((Widget)this.btnOk, "Button.ok");
            this.shell.setDefaultButton(this.btnOk);
            this.btnOk.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    int i = 0;
                    while (i < buttons.length) {
                        if (buttons[i].getSelection()) {
                            UISwitcherWindow.this.ui = i;
                            break;
                        }
                        ++i;
                    }
                    UISwitcherWindow.this.shell.dispose();
                }
            });
            gd = new GridData(128);
            this.btnOk.setLayoutData((Object)gd);
            this.shell.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2) {
                        UISwitcherWindow.this.shell.dispose();
                        e.doit = false;
                        return;
                    }
                    e.doit = true;
                }
            });
            Point point = this.shell.computeSize(400, -1);
            this.shell.setSize(point);
            Utils.centreWindow(this.shell);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        this.shell.open();
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        UISwitcherWindow window = new UISwitcherWindow(true, true);
        window.open();
        Shell shell = window.shell;
        while (!shell.isDisposed()) {
            if (shell.getDisplay().readAndDispatch()) continue;
            shell.getDisplay().sleep();
        }
        System.out.println(window.ui);
    }
}

