/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.skin;

import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWTBGImagePainter
implements Listener {
    private static boolean DEBUG = false;
    private Rectangle lastResizeRect = Utils.EMPTY_RECT;
    private final Shell shell;
    private String imgSrcID;
    private String imgSrcLeftID;
    private String imgSrcRightID;
    private Image imgSrc;
    private Image imgSrcLeft;
    private Image imgSrcRight;
    private Rectangle imgSrcBounds;
    private Rectangle imgSrcLeftBounds;
    private Rectangle imgSrcRightBounds;
    private Image lastImage = null;
    boolean inEvent = false;
    Rectangle lastBounds = Utils.EMPTY_RECT;
    Point lastShellBGSize = new Point(0, 0);
    private final int tileMode;
    private final Control control;
    private final boolean useBGImage;
    private boolean bDirty;
    private int fdWidth = -1;
    private int fdHeight = -1;
    private ImageLoader imageLoader = null;

    private SWTBGImagePainter(Control control, int tileMode, boolean useGBImage) {
        this.control = control;
        this.shell = control.getShell();
        this.tileMode = tileMode;
        this.useBGImage = useGBImage;
        control.setData("BGPainter", (Object)this);
    }

    public SWTBGImagePainter(Control control, Image bgImage, int tileMode) {
        this(control, null, null, bgImage, tileMode);
    }

    public SWTBGImagePainter(Control control, Image bgImageLeft, Image bgImageRight, Image bgImage, int tileMode) {
        this(control, tileMode, true);
        this.setImages(bgImageLeft, bgImageRight, bgImage);
        if (this.bDirty && control.isVisible()) {
            this.buildBackground(control);
        }
        control.addListener(11, (Listener)this);
        control.addListener(9, (Listener)this);
        control.getShell().addListener(22, (Listener)this);
        control.addListener(12, (Listener)this);
    }

    public SWTBGImagePainter(Control control, ImageLoader imageLoader, String bgImageLeftId, String bgImageRightId, String bgImageId, int tileMode, boolean useBGImage) {
        this(control, tileMode, useBGImage);
        this.setImage(imageLoader, bgImageLeftId, bgImageRightId, bgImageId);
        if (this.bDirty && control.isVisible()) {
            this.buildBackground(control);
        }
        control.addListener(11, (Listener)this);
        control.addListener(9, (Listener)this);
        control.getShell().addListener(22, (Listener)this);
        control.addListener(12, (Listener)this);
    }

    public Image getLatestImage() {
        return this.lastImage;
    }

    public void dispose() {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        this.control.removeListener(11, (Listener)this);
        this.control.removeListener(9, (Listener)this);
        this.control.getShell().removeListener(22, (Listener)this);
        this.control.removeListener(12, (Listener)this);
        if (this.useBGImage) {
            this.control.setBackgroundImage(null);
        } else {
            this.control.setData("BGImage", null);
        }
        FormData formData = (FormData)this.control.getLayoutData();
        formData.width = -1;
        formData.height = -1;
        this.control.setData("BGPainter", null);
    }

    public void setImage(Image bgImageLeft, Image bgImageRight, Image bgImage) {
        this.setImages(bgImageLeft, bgImageRight, bgImage);
        if (this.bDirty) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (!SWTBGImagePainter.this.control.isVisible()) {
                        return;
                    }
                    SWTBGImagePainter.this.buildBackground(SWTBGImagePainter.this.control);
                }
            });
        }
    }

    public void setImage(ImageLoader imageLoader, String idLeft, String idRight, String id) {
        this.setImages(imageLoader, idLeft, idRight, id);
        if (this.bDirty) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (!SWTBGImagePainter.this.control.isVisible()) {
                        return;
                    }
                    SWTBGImagePainter.this.buildBackground(SWTBGImagePainter.this.control);
                }
            });
        }
    }

    private boolean imagesEqual(Image image1, Image image2) {
        if (image1 == image2) {
            return true;
        }
        return !ImageLoader.isRealImage(image1) && !ImageLoader.isRealImage(image2);
    }

    private void setImages(Image bgImageLeft, Image bgImageRight, Image bgImage) {
        if (this.imagesEqual(this.imgSrc, bgImage) && this.imagesEqual(this.imgSrcLeft, bgImageLeft) && this.imagesEqual(this.imgSrcRight, bgImageRight)) {
            if (DEBUG) {
                System.out.println("same");
            }
            return;
        }
        this.imgSrcLeftID = null;
        this.imgSrcRightID = null;
        this.imgSrcID = null;
        if (DEBUG) {
            System.out.println("SI " + bgImageLeft + ";" + bgImageRight + ";" + bgImage + ";" + this.control.getData("SkinObject") + "/" + this.control.isVisible() + this.control.getSize() + "\\" + Debug.getStackTrace(true, false));
        }
        this.imgSrc = bgImage;
        if (this.imgSrc != null) {
            this.imgSrcBounds = this.imgSrc.getBounds();
        }
        this.lastShellBGSize = new Point(0, 0);
        if (ImageLoader.isRealImage(bgImageLeft)) {
            this.imgSrcLeft = bgImageLeft;
            this.imgSrcLeftBounds = this.imgSrcLeft.getBounds();
        } else {
            this.imgSrcLeft = null;
            this.imgSrcLeftBounds = Utils.EMPTY_RECT;
        }
        if (ImageLoader.isRealImage(bgImageRight)) {
            this.imgSrcRight = bgImageRight;
            this.imgSrcRightBounds = this.imgSrcRight.getBounds();
        } else {
            this.imgSrcRight = null;
            this.imgSrcRightBounds = Utils.EMPTY_RECT;
        }
        this.bDirty = true;
        if ((this.tileMode & 3) != 3) {
            FormData fd;
            int width = -1;
            int height = -1;
            if (this.tileMode == 1 || this.tileMode == 0) {
                width = this.imgSrcBounds.width + this.imgSrcLeftBounds.width + this.imgSrcRightBounds.width;
            }
            if (this.tileMode == 2 || this.tileMode == 0) {
                height = this.imgSrcBounds.height;
            }
            if ((fd = (FormData)this.control.getLayoutData()) == null) {
                fd = new FormData();
            }
            if (fd.width == this.fdWidth || fd.height == this.fdHeight) {
                if (fd.width == this.fdWidth) {
                    this.fdWidth = fd.width = width;
                }
                if (fd.height == this.fdHeight) {
                    this.fdHeight = fd.height = height;
                }
                this.control.setLayoutData((Object)fd);
                if (this.control.isVisible()) {
                    this.bDirty = true;
                    this.control.getParent().layout(true, true);
                }
            }
        }
    }

    public void setImages(ImageLoader imageLoader, String bgImageLeftId, String bgImageRightId, String bgImageId) {
        Image imgSrcLeft;
        this.imageLoader = imageLoader;
        this.imgSrcLeftID = bgImageLeftId;
        this.imgSrcRightID = bgImageRightId;
        this.imgSrcID = bgImageId;
        this.imgSrcLeftBounds = Utils.EMPTY_RECT;
        this.imgSrcRightBounds = Utils.EMPTY_RECT;
        if (this.imgSrcID != null) {
            Image imgSrc = imageLoader.getImage(this.imgSrcID);
            this.imgSrcBounds = imgSrc.getBounds();
            imageLoader.releaseImage(this.imgSrcID);
        }
        if (ImageLoader.isRealImage(imgSrcLeft = imageLoader.getImage(this.imgSrcLeftID))) {
            this.imgSrcLeftBounds = imgSrcLeft.getBounds();
        }
        imageLoader.releaseImage(this.imgSrcLeftID);
        Image imgSrcRight = imageLoader.getImage(this.imgSrcRightID);
        if (ImageLoader.isRealImage(imgSrcRight)) {
            this.imgSrcRightBounds = imgSrcRight.getBounds();
        }
        imageLoader.releaseImage(this.imgSrcRightID);
        this.bDirty = true;
        if ((this.tileMode & 3) != 3) {
            FormData fd;
            int width = -1;
            int height = -1;
            if (this.tileMode == 1 || this.tileMode == 0) {
                width = this.imgSrcBounds.width + this.imgSrcLeftBounds.width + this.imgSrcRightBounds.width;
            }
            if (this.tileMode == 2 || this.tileMode == 0) {
                height = this.imgSrcBounds.height;
            }
            if ((fd = (FormData)this.control.getLayoutData()) == null) {
                fd = new FormData();
            }
            if (fd.width == this.fdWidth || fd.height == this.fdHeight) {
                if (fd.width == this.fdWidth) {
                    this.fdWidth = fd.width = width;
                }
                if (fd.height == this.fdHeight) {
                    this.fdHeight = fd.height = height;
                }
                this.control.setLayoutData((Object)fd);
                if (this.control.isVisible()) {
                    this.bDirty = true;
                    this.control.getParent().layout(true, true);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void buildBackground(Control control) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 43[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display, 2144);
        shell.setLayout((Layout)new FillLayout());
        Composite c = new Composite((Composite)shell, 2048);
        c.setLayout((Layout)new FillLayout());
        c.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawLine(0, 0, 100, 50);
            }
        });
        Label lbl = new Label(c, 0);
        lbl.setText("text");
        shell.open();
        while (!shell.isDisposed()) {
            if (!display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void handleEvent(Event event2) {
        if (event2.type == 11) {
            Control control = (Control)event2.widget;
            Rectangle resizeRect = control.getBounds();
            if (resizeRect.equals((Object)this.lastResizeRect)) {
                return;
            }
            this.lastResizeRect = resizeRect;
            if (DEBUG) {
                System.out.println("BGPaint:HE: " + control.getData("ConfigID") + ";" + event2 + ";" + control.isVisible());
            }
            this.buildBackground(control);
        } else if (event2.type == 9) {
            Control control = (Control)event2.widget;
            if (DEBUG) {
                System.out.println("BGPaint:P: " + control.getData("ConfigID") + ";" + event2 + ";" + control.isVisible());
            }
            this.buildBackground(control);
            if (!this.useBGImage && this.lastImage != null && !this.lastImage.isDisposed()) {
                event2.gc.drawImage(this.lastImage, 0, 0);
            }
        } else if (event2.type == 22) {
            if (DEBUG) {
                System.out.println("BGPaint:S: " + this.control.getData("ConfigID") + ";" + event2 + ";" + this.control.isVisible());
            }
            this.buildBackground(this.control);
        } else if (event2.type == 12) {
            if (DEBUG) {
                System.out.println("dispose.. " + this.lastImage + ";" + this.control.getData("SkinObject"));
            }
            if (this.lastImage != null && !this.lastImage.isDisposed()) {
                this.lastImage.dispose();
                this.lastImage = null;
            }
        }
    }
}

