/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.skin;

import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectBasic;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import com.biglybt.ui.swt.utils.FontUtils;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;

public class SWTSkinObjectList
extends SWTSkinObjectBasic {
    private List widget;

    public SWTSkinObjectList(SWTSkin skin, SWTSkinProperties properties, String id, String configID, SWTSkinObject parentSkinObject) {
        super(skin, properties, id, configID, "combo", parentSkinObject);
        Composite createOn = this.parent == null ? skin.getShell() : (Composite)this.parent.getControl();
        int style = 2562;
        String styleString = properties.getStringValue(String.valueOf(this.sConfigID) + ".style");
        if (styleString != null) {
            Object[] styles = RegExUtil.PAT_SPLIT_COMMA.split(styleString.toLowerCase());
            Arrays.sort(styles);
            if (Arrays.binarySearch(styles, "readonly") >= 0) {
                style |= 8;
            }
        }
        this.widget = new List(createOn, style);
        this.setControl((Control)this.widget);
        this.updateFont("");
    }

    public void setList(final String[] list) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectList.this.widget != null && !SWTSkinObjectList.this.widget.isDisposed()) {
                    SWTSkinObjectList.this.widget.setItems(list);
                }
            }
        });
    }

    public List getListControl() {
        return this.widget;
    }

    private void updateFont(String suffix) {
        String sPrefix = String.valueOf(this.sConfigID) + ".text";
        Font existingFont = (Font)this.widget.getData("Font" + suffix);
        if (existingFont != null && !existingFont.isDisposed()) {
            this.widget.setFont(existingFont);
        } else {
            String sSize;
            boolean bNewFont = false;
            float fontSizeAdj = -1.0f;
            String sFontFace = null;
            FontData[] tempFontData = this.widget.getFont().getFontData();
            sFontFace = this.properties.getStringValue(String.valueOf(sPrefix) + ".font" + suffix);
            if (sFontFace != null) {
                tempFontData[0].setName(sFontFace);
                bNewFont = true;
            }
            if ((sSize = this.properties.getStringValue(String.valueOf(sPrefix) + ".size" + suffix)) != null) {
                sSize = sSize.trim();
                try {
                    char firstChar = sSize.charAt(0);
                    char lastChar = sSize.charAt(sSize.length() - 1);
                    if (firstChar == '+' || firstChar == '-') {
                        sSize = sSize.substring(1);
                    } else if (lastChar == '%') {
                        sSize = sSize.substring(0, sSize.length() - 1);
                    }
                    float dSize = NumberFormat.getInstance(Locale.US).parse(sSize).floatValue();
                    fontSizeAdj = lastChar == '%' ? dSize / 100.0f : (firstChar == '+' ? 1.0f + dSize * 0.1f : (firstChar == '-' ? 1.0f - dSize * 0.1f : (sSize.endsWith("rem") ? dSize : dSize / (float)FontUtils.getFontHeightInPX(tempFontData))));
                    bNewFont = true;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (bNewFont) {
                FontData[] fd = this.widget.getFont().getFontData();
                if (fontSizeAdj > 0.0f) {
                    FontUtils.setFontDataHeight(fd, FontUtils.getHeight(fd) * fontSizeAdj);
                }
                if (sFontFace != null) {
                    fd[0].setName(sFontFace);
                }
                final Font textWidgetFont = new Font((Device)this.widget.getDisplay(), fd);
                this.widget.setFont(textWidgetFont);
                this.widget.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        textWidgetFont.dispose();
                    }
                });
                this.widget.setData("Font" + suffix, (Object)textWidgetFont);
            }
        }
    }
}

