/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.skin;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectBasic;
import com.biglybt.ui.swt.skin.SWTSkinObjectListener;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import java.text.NumberFormat;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class SWTSkinObjectSash
extends SWTSkinObjectBasic {
    private static final boolean FASTDRAG = true;
    protected String sControlBefore;
    protected String sControlAfter;
    private Composite createOn;
    private final boolean isVertical;
    private Sash sash;
    private Composite parentComposite;
    private Composite above = null;
    private int aboveMin = 0;
    private Composite below = null;
    private int belowMin = 0;
    private String sBorder;
    private SWTSkinObject soAbove;
    private SWTSkinObject soBelow;

    public SWTSkinObjectSash(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parent, final boolean bVertical) {
        super(skin, properties, sID, sConfigID, "sash", parent);
        int style;
        this.isVertical = bVertical;
        int n = style = bVertical ? 512 : 256;
        if (typeParams.length > 2) {
            this.sControlBefore = typeParams[1];
            this.sControlAfter = typeParams[2];
        }
        this.createOn = parent == null ? skin.getShell() : (Composite)parent.getControl();
        if (this.createOn == null || this.createOn.isDisposed()) {
            Debug.out("Can not create " + sID + " because parent is null or disposed");
            return;
        }
        this.sash = new Sash(this.createOn, style);
        int splitAtPX = COConfigurationManager.getIntParameter("v3." + sID + ".splitAtPX", -1);
        if (splitAtPX >= 0) {
            this.sash.setData("PX", (Object)new Long(splitAtPX));
        } else {
            String sPos = properties.getStringValue(String.valueOf(sConfigID) + ".startpos");
            if (sPos != null) {
                try {
                    int l = NumberFormat.getInstance().parse(sPos).intValue();
                    this.sash.setData("PX", (Object)new Long(l));
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
        this.parentComposite = this.createOn;
        SWTSkinObject soInitializeSashAfterCreated = parent == null ? this : parent;
        soInitializeSashAfterCreated.addListener(new SWTSkinObjectListener(){

            @Override
            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 4) {
                    SWTSkinObjectSash.this.initialize();
                }
                return null;
            }
        });
        this.sBorder = properties.getStringValue(String.valueOf(sConfigID) + ".border", (String)null);
        if (this.sBorder != null) {
            this.sash.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.setForeground(e.gc.getDevice().getSystemColor(18));
                    Point size = SWTSkinObjectSash.this.sash.getSize();
                    if (bVertical) {
                        e.gc.drawLine(0, 0, 0, size.y);
                        if (!SWTSkinObjectSash.this.sBorder.startsWith("thin-top")) {
                            int x = size.x - 1;
                            e.gc.drawLine(x, 0, x, 0 + size.y);
                        }
                    } else {
                        e.gc.drawLine(0, 0, 0 + size.x, 0);
                        if (!SWTSkinObjectSash.this.sBorder.startsWith("thin-top")) {
                            int y = size.y - 1;
                            e.gc.drawLine(0, y, 0 + size.x, y);
                        }
                    }
                }
            });
        }
        this.setControl((Control)this.sash);
    }

    protected void initialize() {
        SWTSkinObject skinObject = this.skin.getSkinObjectByID(this.sControlBefore);
        if (skinObject != null) {
            this.soAbove = skinObject;
            this.above = (Composite)skinObject.getControl();
            this.aboveMin = skinObject.getProperties().getIntValue(String.valueOf(this.getConfigID()) + ".above" + (this.isVertical ? ".minwidth" : ".minheight"), 0);
            boolean aboveVisible = COConfigurationManager.getBooleanParameter("v3." + this.sID + ".aboveVisible", true);
            this.soAbove.setVisible(aboveVisible);
        }
        if ((skinObject = this.skin.getSkinObjectByID(this.sControlAfter)) != null) {
            this.soBelow = skinObject;
            this.below = (Composite)skinObject.getControl();
        }
        if (this.below == null) {
            return;
        }
        this.belowMin = skinObject == null ? 0 : skinObject.getProperties().getIntValue(String.valueOf(this.getConfigID()) + ".below" + (this.isVertical ? ".minwidth" : ".minheight"), 0);
        Listener l = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 4) {
                    if (e.button == 3 || e.button == 1 && (e.stateMask & SWT.MOD1) > 0) {
                        String sPos = SWTSkinObjectSash.this.properties.getStringValue(String.valueOf(SWTSkinObjectSash.this.sConfigID) + ".startpos");
                        if (sPos == null) {
                            return;
                        }
                        try {
                            int l = NumberFormat.getInstance().parse(sPos).intValue();
                            SWTSkinObjectSash.this.sash.setData("PX", (Object)new Long(l));
                            e.type = 22;
                        }
                        catch (Exception ex) {
                            Debug.out(ex);
                            return;
                        }
                    } else {
                        return;
                    }
                }
                if (e.type == 22) {
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        @Override
                        public void runSupport() {
                            SWTSkinObjectSash.this.handleShow();
                        }
                    });
                } else if (e.type == 13) {
                    int excess;
                    if (e.detail == 1) {
                        return;
                    }
                    Rectangle area = SWTSkinObjectSash.this.parentComposite.getBounds();
                    FormData aboveData = (FormData)SWTSkinObjectSash.this.above.getLayoutData();
                    if (SWTSkinObjectSash.this.isVertical) {
                        aboveData.width = e.x - SWTSkinObjectSash.this.above.getBorderWidth();
                        if (aboveData.width < SWTSkinObjectSash.this.aboveMin) {
                            aboveData.width = SWTSkinObjectSash.this.aboveMin;
                            e.x = SWTSkinObjectSash.this.aboveMin;
                        } else {
                            excess = area.width - SWTSkinObjectSash.this.above.getBorderWidth() * 2 - ((SWTSkinObjectSash)SWTSkinObjectSash.this).sash.getSize().x;
                            if (excess - aboveData.width < SWTSkinObjectSash.this.belowMin) {
                                aboveData.width = excess - SWTSkinObjectSash.this.belowMin;
                                e.doit = false;
                            }
                        }
                    } else {
                        aboveData.height = e.y - SWTSkinObjectSash.this.above.getBorderWidth();
                        if (aboveData.height < SWTSkinObjectSash.this.aboveMin) {
                            aboveData.height = SWTSkinObjectSash.this.aboveMin;
                            e.y = SWTSkinObjectSash.this.aboveMin;
                        } else {
                            excess = area.height - SWTSkinObjectSash.this.above.getBorderWidth() * 2 - ((SWTSkinObjectSash)SWTSkinObjectSash.this).sash.getSize().y;
                            if (excess - aboveData.height < SWTSkinObjectSash.this.belowMin) {
                                aboveData.height = excess - SWTSkinObjectSash.this.belowMin;
                                e.doit = false;
                            }
                        }
                    }
                    SWTSkinObjectSash.this.parentComposite.layout(true);
                    double aboveNewSize = SWTSkinObjectSash.this.isVertical ? (double)((SWTSkinObjectSash)SWTSkinObjectSash.this).above.getBounds().width + (double)((SWTSkinObjectSash)SWTSkinObjectSash.this).sash.getSize().x / 2.0 : (double)((SWTSkinObjectSash)SWTSkinObjectSash.this).above.getBounds().height + (double)((SWTSkinObjectSash)SWTSkinObjectSash.this).sash.getSize().y / 2.0;
                    SWTSkinObjectSash.this.sash.setData("PX", (Object)new Long((long)aboveNewSize));
                }
            }
        };
        this.sash.addListener(13, l);
        this.sash.addListener(4, l);
        this.sash.getShell().addListener(22, l);
        this.handleShow();
    }

    @Override
    public void dispose() {
        Long px = (Long)this.sash.getData("PX");
        if (px != null && px != 0L) {
            COConfigurationManager.setParameter("v3." + this.sID + ".splitAtPX", px);
        }
        super.dispose();
    }

    protected void handleShow() {
        FormData aboveData;
        int newAboveSize;
        if (this.sash.isDisposed()) {
            return;
        }
        Long px = (Long)this.sash.getData("PX");
        if (px == null) {
            return;
        }
        if (px < 0L) {
            if (this.parentComposite.getSize().y <= 0) {
                return;
            }
            px = -px.longValue();
            this.sash.setData("PX", (Object)px);
            this.setBelowSize(px.intValue());
            return;
        }
        if (this.soAbove.isVisible()) {
            newAboveSize = px.intValue();
            if (newAboveSize < this.aboveMin) {
                newAboveSize = this.aboveMin;
            }
        } else {
            newAboveSize = 0;
        }
        if ((aboveData = (FormData)this.above.getLayoutData()) == null) {
            aboveData = Utils.getFilledFormData();
            this.above.setLayoutData((Object)aboveData);
        }
        if (this.isVertical) {
            aboveData.width = newAboveSize;
        } else {
            aboveData.height = newAboveSize;
        }
        this.parentComposite.layout(true);
    }

    private void setBelowSize(final int px) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                int sashHeight = SWTSkinObjectSash.this.isVertical ? ((SWTSkinObjectSash)SWTSkinObjectSash.this).sash.getSize().x : ((SWTSkinObjectSash)SWTSkinObjectSash.this).sash.getSize().y;
                int parentHeight = ((SWTSkinObjectSash)SWTSkinObjectSash.this).parentComposite.getBounds().height - SWTSkinObjectSash.this.parentComposite.getBorderWidth() * 2;
                int wantAboveSize = parentHeight - sashHeight - px;
                if (wantAboveSize < 0) {
                    wantAboveSize = 0;
                }
                SWTSkinObjectSash.this.sash.setData("PX", (Object)new Long(wantAboveSize));
                SWTSkinObjectSash.this.handleShow();
            }
        });
    }

    public boolean isAboveVisible() {
        if (this.soAbove == null || this.soAbove.isDisposed()) {
            return false;
        }
        return this.soAbove.isVisible();
    }

    public void setAboveVisible(boolean visible) {
        if (this.soAbove == null) {
            return;
        }
        COConfigurationManager.setParameter("v3." + this.sID + ".aboveVisible", visible);
        this.soAbove.setVisible(visible);
        this.handleShow();
    }
}

