/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.skin;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.skin.SWTColorWithAlpha;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectBasic;
import com.biglybt.ui.swt.skin.SWTSkinObjectText;
import com.biglybt.ui.swt.skin.SWTSkinObjectText_UrlClickedListener;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import com.biglybt.ui.swt.skin.SWTSkinUtils;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.utils.SWTRunnable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class SWTSkinObjectText2
extends SWTSkinObjectBasic
implements SWTSkinObjectText,
PaintListener {
    String sText;
    String sDisplayText;
    String sKey;
    boolean bIsTextDefault = false;
    private int style;
    private Canvas canvas;
    private boolean isUnderline;
    private int antialiasMode = -1;
    private boolean isAllcaps;
    private boolean hasShadow;
    private int hpadding;
    private int vpadding;
    private boolean relayoutOnTextChange = true;
    private boolean bgAware = false;
    private boolean isItalic = false;
    private static Font font = null;
    private GCStringPrinter lastStringPrinter;
    private Color colorUrl;
    private int alpha = 255;
    private List<SWTSkinObjectText_UrlClickedListener> listUrlClickedListeners = new ArrayList<SWTSkinObjectText_UrlClickedListener>();
    private Color colorUrl2;
    private Color explicitColor;
    protected boolean mouseDown;
    private SWTColorWithAlpha colorShadow;

    public SWTSkinObjectText2(SWTSkin skin, final SWTSkinProperties skinProperties, String sID, final String sConfigID, String[] typeParams, SWTSkinObject parent) {
        super(skin, skinProperties, sID, sConfigID, "text", parent);
        String pAntiAlias;
        String sAntiAlias;
        String sVAlign;
        int align;
        final String sPrefix = String.valueOf(sConfigID) + ".text";
        this.style = this.properties.getBooleanValue(String.valueOf(sPrefix) + ".wrap", true) ? 64 : 0;
        String sAlign = skinProperties.getStringValue(String.valueOf(sConfigID) + ".align");
        if (sAlign != null && (align = SWTSkinUtils.getAlignment(sAlign, 0)) != 0) {
            this.style |= align;
        }
        if ((sVAlign = skinProperties.getStringValue(String.valueOf(sConfigID) + ".v-align")) != null) {
            int align2 = SWTSkinUtils.getAlignment(sVAlign, 0);
            if (align2 != 0x1000000) {
                this.style = align2 != 0 ? (this.style |= align2) : (this.style |= 0x80);
            }
        } else {
            this.style |= 0x80;
        }
        int canvasStyle = 0x20000000;
        if (skinProperties.getIntValue(String.valueOf(sConfigID) + ".border", 0) == 1 || skin.DEBUGLAYOUT) {
            canvasStyle |= 0x800;
        }
        if ((sAntiAlias = skinProperties.getStringValue(String.valueOf(sConfigID) + ".antialias", (String)null)) != null && sAntiAlias.length() > 0) {
            int n = this.antialiasMode = sAntiAlias.equals("1") || sAntiAlias.toLowerCase().equals("true") ? 1 : 0;
        }
        if ((pAntiAlias = skinProperties.getStringValue(String.valueOf(sPrefix) + ".antialias", (String)null)) != null && pAntiAlias.length() > 0) {
            this.antialiasMode = pAntiAlias.equals("1") || pAntiAlias.toLowerCase().equals("true") ? 1 : 0;
        }
        this.relayoutOnTextChange = skinProperties.getBooleanValue(String.valueOf(sPrefix) + ".relayoutOnChange", true);
        this.bgAware = skinProperties.getBooleanValue(String.valueOf(sPrefix) + ".bgaware", false);
        Composite createOn = parent == null ? skin.getShell() : (Composite)parent.getControl();
        this.canvas = new Canvas(createOn, canvasStyle){
            Point ptMax;
            {
                super($anonymous0, $anonymous1);
                this.ptMax = new Point(0, 0);
            }

            public Point computeSize(int wHint, int hHint, boolean changed) {
                int fixedHeight;
                int fixedWidth;
                int border = this.getBorderWidth() * 2;
                if (border == 0 && (SWTSkinObjectText2.this.canvas.getStyle() & 0x800) > 0) {
                    border = 2;
                }
                Point pt = new Point(border, border);
                if (SWTSkinObjectText2.this.sDisplayText == null) {
                    return pt;
                }
                Font existingFont = (Font)SWTSkinObjectText2.this.canvas.getData("font");
                Color existingColor = (Color)SWTSkinObjectText2.this.canvas.getData("color");
                GC gc = new GC((Drawable)this);
                if (existingFont != null) {
                    gc.setFont(existingFont);
                }
                if (existingColor != null) {
                    gc.setForeground(existingColor);
                }
                if (SWTSkinObjectText2.this.antialiasMode != -1) {
                    try {
                        gc.setTextAntialias(SWTSkinObjectText2.this.antialiasMode);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                gc.setAlpha(SWTSkinObjectText2.this.alpha);
                GCStringPrinter sp = new GCStringPrinter(gc, SWTSkinObjectText2.this.sDisplayText, new Rectangle(0, 0, wHint == -1 ? 3000 : wHint, hHint == -1 ? 3000 : hHint), true, false, SWTSkinObjectText2.this.style & 0x40);
                sp.calculateMetrics();
                pt = sp.getCalculatedSize();
                pt.x += (border + SWTSkinObjectText2.this.hpadding) * 2;
                pt.y += (border + SWTSkinObjectText2.this.vpadding) * 2;
                gc.dispose();
                if (SWTSkinObjectText2.this.isUnderline) {
                    ++pt.y;
                }
                if (SWTSkinObjectText2.this.hasShadow) {
                    ++pt.x;
                }
                if (SWTSkinObjectText2.this.isItalic) {
                    pt.x += 4;
                }
                if ((fixedWidth = skinProperties.getIntValue(String.valueOf(sConfigID) + ".width", -1)) >= 0) {
                    pt.x = fixedWidth;
                }
                if ((fixedHeight = skinProperties.getIntValue(String.valueOf(sConfigID) + ".height", -1)) >= 0) {
                    pt.y = fixedHeight;
                }
                if (this.isVisible()) {
                    if (pt.x > this.ptMax.x) {
                        this.ptMax.x = pt.x;
                    }
                    if (pt.y > this.ptMax.y) {
                        this.ptMax.y = pt.y;
                    }
                }
                return pt;
            }
        };
        this.canvas.setData("font", (Object)font);
        this.setControl((Control)this.canvas);
        if (typeParams.length > 1) {
            this.bIsTextDefault = true;
            this.sText = typeParams[1];
            int i = 2;
            while (i < typeParams.length) {
                this.sText = String.valueOf(this.sText) + ", " + typeParams[i];
                ++i;
            }
            this.sDisplayText = this.isAllcaps && this.sText != null ? this.sText.toUpperCase() : this.sText;
        }
        this.canvas.addMouseListener(new MouseListener(){
            private String lastDownURL;

            public void mouseUp(MouseEvent e) {
                GCStringPrinter.URLInfo hitUrl;
                SWTSkinObjectText2.this.mouseDown = false;
                if (SWTSkinObjectText2.this.lastStringPrinter != null && e.button == 1 && (hitUrl = SWTSkinObjectText2.this.lastStringPrinter.getHitUrl(e.x, e.y)) != null) {
                    SWTSkinObjectText_UrlClickedListener[] listeners;
                    SWTSkinObjectText_UrlClickedListener[] sWTSkinObjectText_UrlClickedListenerArray = listeners = SWTSkinObjectText2.this.listUrlClickedListeners.toArray(new SWTSkinObjectText_UrlClickedListener[0]);
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SWTSkinObjectText_UrlClickedListener l = sWTSkinObjectText_UrlClickedListenerArray[n2];
                        if (l.urlClicked(hitUrl)) {
                            return;
                        }
                        ++n2;
                    }
                    String url = hitUrl.url;
                    url = SWTSkinObjectText2.this.fixupURL(skinProperties, sPrefix, url);
                    Utils.launch(url);
                }
            }

            public void mouseDown(MouseEvent e) {
                SWTSkinObjectText2.this.mouseDown = true;
                if (SWTSkinObjectText2.this.lastStringPrinter != null) {
                    String curURL;
                    GCStringPrinter.URLInfo hitUrl = SWTSkinObjectText2.this.lastStringPrinter.getHitUrl(e.x, e.y);
                    String string = curURL = hitUrl == null ? "" : hitUrl.url;
                    if (curURL.equals(this.lastDownURL)) {
                        this.lastDownURL = curURL;
                        SWTSkinObjectText2.this.canvas.redraw();
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.canvas.addMouseMoveListener(new MouseMoveListener(){
            Boolean doUrlToolTip = null;

            public void mouseMove(MouseEvent e) {
                if (SWTSkinObjectText2.this.lastStringPrinter != null && SWTSkinObjectText2.this.lastStringPrinter.hasHitUrl()) {
                    GCStringPrinter.URLInfo hitUrl = SWTSkinObjectText2.this.lastStringPrinter.getHitUrl(e.x, e.y);
                    if (this.doUrlToolTip == null) {
                        this.doUrlToolTip = SWTSkinObjectText2.this.getTooltipID(false) == null;
                    }
                    if (this.doUrlToolTip.booleanValue()) {
                        String tooltip = null;
                        if (hitUrl != null) {
                            tooltip = hitUrl.title == null ? "!" + hitUrl.url + "!" : "!" + hitUrl.title + " (" + hitUrl.url + ")!";
                        }
                        SWTSkinObjectText2.this.setTooltipID(tooltip);
                    }
                    SWTSkinObjectText2.this.canvas.setCursor(hitUrl == null ? null : SWTSkinObjectText2.this.canvas.getDisplay().getSystemCursor(21));
                }
            }
        });
        if (skinProperties.getBooleanValue(String.valueOf(sConfigID) + ".clipboardmenu", false)) {
            Menu menu = new Menu((Control)this.canvas);
            MenuItem menuItem = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)menuItem, "MyTorrentsView.menu.thisColumn.toClipboard");
            menuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ClipboardCopy.copyToClipBoard(SWTSkinObjectText2.this.getText());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.canvas.setMenu(menu);
        } else {
            final Menu menu = new Menu((Control)this.canvas);
            this.canvas.setMenu(menu);
            this.canvas.addMenuDetectListener(e -> this.canvas.setData("MenuDetectEvent", (Object)e));
            menu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    MenuDetectEvent mde = (MenuDetectEvent)SWTSkinObjectText2.this.canvas.getData("MenuDetectEvent");
                    MenuItem[] menuItemArray = menu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem mi = menuItemArray[n2];
                        mi.dispose();
                        ++n2;
                    }
                    if (SWTSkinObjectText2.this.lastStringPrinter != null && mde != null) {
                        Point mapped = SWTSkinObjectText2.this.canvas.getDisplay().map(null, (Control)SWTSkinObjectText2.this.canvas, new Point(mde.x, mde.y));
                        GCStringPrinter.URLInfo hitUrl = SWTSkinObjectText2.this.lastStringPrinter.getHitUrl(mapped.x, mapped.y);
                        if (hitUrl != null) {
                            String url = SWTSkinObjectText2.this.fixupURL(skinProperties, sPrefix, hitUrl.url);
                            ClipboardCopy.addCopyToClipMenu(menu, () -> url);
                        }
                    }
                }

                public void menuHidden(MenuEvent e) {
                }
            });
        }
        this.setAlwaysHookPaintListener(true);
        this.updateFont("");
    }

    private String fixupURL(SWTSkinProperties skinProperties, String sPrefix, String url) {
        try {
            boolean rawURL;
            if (url.startsWith("/")) {
                url = "https://www.biglybt.com/";
            }
            if (!(rawURL = skinProperties.getBooleanValue(String.valueOf(sPrefix) + ".urlraw", false))) {
                url = url.contains("?") ? String.valueOf(url) + "&" : String.valueOf(url) + "?";
                url = String.valueOf(url) + "fromWeb=false&os.version=" + UrlUtils.encode(Constants.OSVersion) + "&java.version=" + UrlUtils.encode(Constants.JAVA_VERSION);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return url;
    }

    @Override
    public String switchSuffix(String suffix, int level, boolean walkUp, boolean walkDown) {
        String text;
        boolean forceSwitch = suffix == null;
        String oldSuffix = this.getSuffix();
        if ((suffix = super.switchSuffix(suffix, level, walkUp, walkDown)) == null) {
            return null;
        }
        if (!forceSwitch && suffix.equals(oldSuffix)) {
            return suffix;
        }
        String sPrefix = String.valueOf(this.sConfigID) + ".text";
        if ((this.sText == null || this.bIsTextDefault) && (text = this.properties.getStringValue(String.valueOf(sPrefix) + suffix)) != null) {
            this.sText = text;
            this.sDisplayText = this.isAllcaps && this.sText != null ? this.sText.toUpperCase() : this.sText;
        }
        final String fSuffix = suffix;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectText2.this.canvas == null || SWTSkinObjectText2.this.canvas.isDisposed()) {
                    return;
                }
                SWTSkinObjectText2.this.updateFont(fSuffix);
            }
        });
        return suffix;
    }

    private void updateFont(String suffix) {
        String sPrefix = String.valueOf(this.sConfigID) + ".text";
        Color newColorURL = this.properties.getColor(String.valueOf(sPrefix) + ".urlcolor" + suffix);
        this.colorUrl = newColorURL != null ? newColorURL : this.properties.getColor(String.valueOf(sPrefix) + ".urlcolor");
        Color newColorURL2 = this.properties.getColor(String.valueOf(sPrefix) + ".urlcolor-pressed");
        if (newColorURL2 != null) {
            this.colorUrl2 = newColorURL2;
        }
        if (this.explicitColor == null) {
            Color color = this.properties.getColor(String.valueOf(sPrefix) + ".color" + suffix);
            if (this.debug) {
                System.out.println(this + "; " + sPrefix + ";" + suffix + "; " + color + "; " + this.getText());
            }
            if (color != null) {
                this.canvas.setData("color", (Object)color);
            } else {
                this.canvas.setData("color", (Object)this.properties.getColor(String.valueOf(sPrefix) + ".color"));
            }
        }
        this.alpha = this.properties.getIntValue(String.valueOf(this.sConfigID) + ".alpha", 255);
        this.hpadding = this.properties.getIntValue(String.valueOf(sPrefix) + ".h-padding", 0);
        this.vpadding = this.properties.getIntValue(String.valueOf(sPrefix) + ".v-padding", 0);
        Font existingFont = (Font)this.canvas.getData("Font" + suffix);
        if (existingFont != null && !existingFont.isDisposed()) {
            this.canvas.setData("font", (Object)existingFont);
        } else {
            String sSize;
            String sStyle;
            boolean bNewFont = false;
            float fontSizeAdj = -1.0f;
            int iFontWeight = -1;
            String sFontFace = null;
            FontData[] tempFontData = this.canvas.getFont().getFontData();
            sFontFace = this.properties.getStringValue(String.valueOf(sPrefix) + ".font" + suffix);
            if (sFontFace != null) {
                tempFontData[0].setName(sFontFace);
                bNewFont = true;
            }
            if ((sStyle = this.properties.getStringValue(String.valueOf(sPrefix) + ".style" + suffix)) != null) {
                this.isAllcaps = false;
                String[] sStyles = RegExUtil.PAT_SPLIT_COMMA.split(sStyle.toLowerCase());
                int i = 0;
                while (i < sStyles.length) {
                    String s = sStyles[i];
                    if (s.equals("allcaps")) {
                        this.isAllcaps = true;
                    }
                    if (s.equals("bold")) {
                        iFontWeight = iFontWeight == -1 ? 1 : (iFontWeight |= 1);
                        bNewFont = true;
                    }
                    if (s.equals("italic")) {
                        iFontWeight = iFontWeight == -1 ? 2 : (iFontWeight |= 2);
                        bNewFont = true;
                        this.isItalic = true;
                    } else {
                        this.isItalic = false;
                    }
                    this.isUnderline = s.equals("underline");
                    if (this.isUnderline) {
                        this.canvas.addPaintListener(new PaintListener(){

                            public void paintControl(PaintEvent e) {
                                int x = 0;
                                Point pt = e.gc.textExtent(SWTSkinObjectText2.this.sDisplayText);
                                Point size = ((Control)e.widget).getSize();
                                if (pt.x < size.x) {
                                    x = size.x - pt.x;
                                    size.x = pt.x;
                                }
                                e.gc.drawLine(x, size.y - 1, size.x - 1 + x, size.y - 1);
                            }
                        });
                    }
                    if (s.equals("strike")) {
                        this.canvas.addPaintListener(new PaintListener(){

                            public void paintControl(PaintEvent e) {
                                Point size = ((Control)e.widget).getSize();
                                int y = size.y / 2;
                                e.gc.drawLine(0, y, size.x - 1, y);
                            }
                        });
                    }
                    if (s.equals("normal")) {
                        bNewFont = true;
                    }
                    if (s.equals("shadow")) {
                        this.hasShadow = true;
                    }
                    ++i;
                }
                this.sDisplayText = this.isAllcaps && this.sText != null ? this.sText.toUpperCase() : this.sText;
            }
            this.colorShadow = this.properties.getColorWithAlpha(String.valueOf(sPrefix) + ".shadow");
            if (this.colorShadow.color != null) {
                this.hasShadow = true;
            }
            if (iFontWeight >= 0) {
                tempFontData[0].setStyle(iFontWeight);
            }
            if ((sSize = this.properties.getStringValue(String.valueOf(sPrefix) + ".size" + suffix)) != null) {
                sSize = sSize.trim();
                try {
                    char firstChar = sSize.charAt(0);
                    char lastChar = sSize.charAt(sSize.length() - 1);
                    if (firstChar == '+' || firstChar == '-') {
                        sSize = sSize.substring(1);
                    } else if (lastChar == '%') {
                        sSize = sSize.substring(0, sSize.length() - 1);
                    }
                    float dSize = NumberFormat.getInstance(Locale.US).parse(sSize).floatValue();
                    fontSizeAdj = lastChar == '%' ? dSize / 100.0f : (firstChar == '+' ? 1.0f + dSize * 0.1f : (firstChar == '-' ? 1.0f - dSize * 0.1f : (sSize.endsWith("rem") ? dSize : dSize / (float)FontUtils.getFontHeightInPX(tempFontData))));
                    bNewFont = true;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (bNewFont) {
                FontData[] fd = this.canvas.getFont().getFontData();
                if (fontSizeAdj > 0.0f) {
                    FontUtils.setFontDataHeight(fd, FontUtils.getHeight(fd) * fontSizeAdj);
                }
                if (iFontWeight >= 0) {
                    fd[0].setStyle(iFontWeight);
                }
                if (sFontFace != null) {
                    fd[0].setName(sFontFace);
                }
                final Font canvasFont = new Font((Device)this.canvas.getDisplay(), fd);
                this.canvas.setData("font", (Object)canvasFont);
                this.canvas.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        canvasFont.dispose();
                    }
                });
                this.canvas.setData("Font" + suffix, (Object)canvasFont);
            }
        }
        this.canvas.redraw();
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (text.equals(this.sText)) {
            return;
        }
        this.sText = text;
        this.sDisplayText = this.isAllcaps && this.sText != null ? this.sText.toUpperCase() : this.sText;
        this.sKey = null;
        this.bIsTextDefault = false;
        Utils.execSWTThread(new SWTRunnable(){

            @Override
            public void runWithDisplay(Display display) {
                SWTSkinObjectText2.this.lastStringPrinter = null;
                if (SWTSkinObjectText2.this.canvas != null && !SWTSkinObjectText2.this.canvas.isDisposed()) {
                    SWTSkinObjectText2.this.canvas.setCursor(null);
                    SWTSkinObjectText2.this.canvas.redraw();
                    if (SWTSkinObjectText2.this.relayoutOnTextChange) {
                        Utils.relayout((Control)SWTSkinObjectText2.this.canvas);
                    }
                }
            }
        });
    }

    @Override
    public void paintControl(GC gc) {
        if (this.sText == null || this.sText.length() == 0) {
            return;
        }
        super.paintControl(gc);
        Composite composite = (Composite)this.control;
        Rectangle clientArea = composite.getClientArea();
        clientArea.x += this.hpadding;
        clientArea.width -= this.hpadding * 2;
        clientArea.y += this.vpadding;
        clientArea.height -= this.vpadding * 2;
        Font existingFont = (Font)this.canvas.getData("font");
        Color existingColor = (Color)this.canvas.getData("color");
        boolean doShadow = this.hasShadow;
        if (this.bgAware && !Colors.isBlackTextReadable(gc.getBackground())) {
            existingColor = Colors.white;
            doShadow = false;
        }
        if (existingFont != null) {
            gc.setFont(existingFont);
        }
        if (this.debug) {
            System.out.println("paint " + existingColor + ";" + gc.getForeground());
        }
        if (existingColor != null) {
            gc.setForeground(existingColor);
        }
        if (this.antialiasMode != -1) {
            try {
                gc.setTextAntialias(this.antialiasMode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (doShadow) {
            Rectangle r = new Rectangle(clientArea.x + 1, clientArea.y + 1, clientArea.width, clientArea.height);
            Color foreground = gc.getForeground();
            if (this.colorShadow.color == null) {
                Color color = ColorCache.getColor(gc.getDevice(), 0, 0, 0);
                gc.setForeground(color);
                gc.setAlpha(64);
            } else {
                gc.setForeground(this.colorShadow.color);
                gc.setAlpha(this.colorShadow.alpha);
            }
            GCStringPrinter.printString(gc, this.sDisplayText, r, true, false, this.style);
            gc.setForeground(foreground);
        }
        gc.setAlpha(this.alpha);
        if (this.alpha == 255 && doShadow && (this.colorShadow.color == null || this.colorShadow.alpha < 255)) {
            gc.setAlpha(254);
        }
        this.lastStringPrinter = new GCStringPrinter(gc, this.sDisplayText, clientArea, true, false, this.style);
        if (this.colorUrl != null) {
            this.lastStringPrinter.setUrlColor(this.colorUrl);
        }
        if (this.colorUrl2 != null && this.mouseDown) {
            this.lastStringPrinter.calculateMetrics();
            Display display = Display.getCurrent();
            Point cursorLocation = this.canvas.toControl(display.getCursorLocation());
            GCStringPrinter.URLInfo hitUrl = this.lastStringPrinter.getHitUrl(cursorLocation.x, cursorLocation.y);
            if (hitUrl != null) {
                hitUrl.urlColor = this.colorUrl2;
            }
        }
        this.lastStringPrinter.printString();
    }

    @Override
    public void setTextID(String key) {
        this.setTextID(key, false);
    }

    private void setTextID(String key, boolean forceRefresh) {
        if (key == null) {
            this.setText("");
        } else if (!forceRefresh && key.equals(this.sKey)) {
            return;
        }
        this.sText = MessageText.getString(key);
        this.sDisplayText = this.isAllcaps && this.sText != null ? this.sText.toUpperCase() : this.sText;
        this.sKey = key;
        this.bIsTextDefault = false;
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectText2.this.canvas == null || SWTSkinObjectText2.this.canvas.isDisposed()) {
                    return;
                }
                SWTSkinObjectText2.this.canvas.redraw();
                if (SWTSkinObjectText2.this.relayoutOnTextChange) {
                    SWTSkinObjectText2.this.canvas.layout(true);
                    Utils.relayout((Control)SWTSkinObjectText2.this.canvas);
                }
            }
        });
    }

    @Override
    public void setTextID(String key, String[] params) {
        if (key == null) {
            this.setText("");
        }
        this.sText = MessageText.getString(key, params);
        this.sDisplayText = this.isAllcaps && this.sText != null ? this.sText.toUpperCase() : this.sText;
        this.sKey = key;
        this.bIsTextDefault = false;
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectText2.this.canvas == null || SWTSkinObjectText2.this.canvas.isDisposed()) {
                    return;
                }
                SWTSkinObjectText2.this.canvas.redraw();
                if (SWTSkinObjectText2.this.relayoutOnTextChange) {
                    SWTSkinObjectText2.this.canvas.layout(true);
                    Utils.relayout((Control)SWTSkinObjectText2.this.canvas);
                }
            }
        });
    }

    @Override
    public void triggerListeners(int eventType, Object params) {
        if (eventType == 6 && this.sKey != null) {
            this.setTextID(this.sKey, true);
        }
        super.triggerListeners(eventType, params);
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(int style) {
        this.style = style;
    }

    @Override
    public String getText() {
        return this.sDisplayText;
    }

    @Override
    public void addUrlClickedListener(SWTSkinObjectText_UrlClickedListener l) {
        this.listUrlClickedListeners.add(l);
    }

    @Override
    public void removeUrlClickedListener(SWTSkinObjectText_UrlClickedListener l) {
        this.listUrlClickedListeners.remove(l);
    }

    @Override
    public void setTextColor(final Color color) {
        this.explicitColor = color;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (SWTSkinObjectText2.this.canvas == null || SWTSkinObjectText2.this.canvas.isDisposed()) {
                    return;
                }
                SWTSkinObjectText2.this.canvas.setData("color", (Object)color);
                SWTSkinObjectText2.this.canvas.redraw();
            }
        });
    }
}

