/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.skin;

import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.skin.SWTSkin;
import com.biglybt.ui.swt.skin.SWTSkinLayoutCompleteListener;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.skin.SWTSkinObjectTab;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import com.biglybt.ui.swt.skin.SWTSkinTabSetListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SWTSkinTabSet {
    private Listener tabMouseListener;
    private final SWTSkin skin;
    private final String sID;
    private SWTSkinObjectTab activeTab;
    private List tabs;
    private ArrayList listeners = new ArrayList();

    public SWTSkinTabSet(SWTSkin skin, String sID) {
        this.sID = sID;
        this.skin = skin;
        this.tabs = new ArrayList();
    }

    public void addTab(final SWTSkinObjectTab tab) {
        this.tabs.add(tab);
        tab.setTabset(this);
        this.addMouseListener(tab, tab.getControl());
        this.skin.addListener(new SWTSkinLayoutCompleteListener(){

            @Override
            public void skinLayoutCompleted() {
                SWTSkinTabSet.this.setTabVisible(tab, SWTSkinTabSet.this.activeTab == tab, null);
            }
        });
    }

    public SWTSkinObjectTab getActiveTab() {
        return this.activeTab;
    }

    public SWTSkinObjectTab[] getTabs() {
        return this.tabs.toArray(new SWTSkinObjectTab[0]);
    }

    public SWTSkinObjectTab getTabByID(String sID) {
        int i = 0;
        while (i < this.tabs.size()) {
            SWTSkinObjectTab tab = (SWTSkinObjectTab)this.tabs.get(i);
            String sTabID = tab.getSkinObjectID();
            if (sTabID.equals(sID)) {
                return tab;
            }
            ++i;
        }
        return null;
    }

    public SWTSkinObjectTab getTab(String sViewID) {
        int i = 0;
        while (i < this.tabs.size()) {
            SWTSkinObjectTab tab = (SWTSkinObjectTab)this.tabs.get(i);
            String sTabViewID = tab.getViewID();
            if (sTabViewID.equals(sViewID)) {
                return tab;
            }
            ++i;
        }
        return null;
    }

    public boolean setActiveTab(String viewID) {
        SWTSkinObject skinObject = this.skin.getSkinObject(viewID);
        if (skinObject == null) {
            return false;
        }
        return this.skin.activateTab(skinObject) != null;
    }

    public void setActiveTab(SWTSkinObjectTab newTab) {
        this.setActiveTab(newTab, false);
    }

    private void setActiveTab(final SWTSkinObjectTab newTab, final boolean evenIfSame) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                Composite shell = SWTSkinTabSet.this.skin.getShell();
                Cursor cursor = shell.getCursor();
                try {
                    shell.setCursor(shell.getDisplay().getSystemCursor(1));
                    SWTSkinTabSet.this.swtSetActiveTab(newTab, evenIfSame);
                }
                finally {
                    shell.setCursor(cursor);
                }
            }
        });
    }

    protected void swtSetActiveTab(SWTSkinObjectTab newTab, boolean evenIfSame) {
        String sOldID;
        if (!this.tabs.contains(newTab)) {
            System.err.println("Not contain in " + this.sID + ": " + newTab);
            return;
        }
        String string = sOldID = this.activeTab == null ? "" : this.activeTab.getSkinObjectID();
        if (newTab != this.activeTab) {
            SWTSkinObject[] objects = this.setTabVisible(newTab, true, null);
            if (this.activeTab != null) {
                this.setTabVisible(this.activeTab, false, objects);
            }
            this.activeTab = newTab;
        } else if (!evenIfSame) {
            return;
        }
        String sConfigID = this.activeTab.getConfigID();
        String sNewID = this.activeTab.getSkinObjectID();
        SWTSkinObject parent = this.skin.getSkinObject(this.activeTab.getProperties().getStringValue(String.valueOf(sConfigID) + ".activate"));
        if (parent != null) {
            parent.getControl().setFocus();
        }
        this.triggerChangeListener(sOldID, sNewID);
    }

    private void triggerChangeListener(String oldID, String newID) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            try {
                SWTSkinTabSetListener l = (SWTSkinTabSetListener)iter.next();
                l.tabChanged(this, oldID, newID);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private void addMouseListener(SWTSkinObject tab, Control control) {
        if (this.tabMouseListener == null) {
            this.tabMouseListener = new Listener(){
                boolean bDownPressed = false;

                public void handleEvent(Event event2) {
                    if (event2.type == 3) {
                        this.bDownPressed = true;
                        return;
                    }
                    if (!this.bDownPressed) {
                        return;
                    }
                    this.bDownPressed = false;
                    Control control = (Control)event2.widget;
                    SWTSkinTabSet.this.setActiveTab((SWTSkinObjectTab)control.getData("Tab"), true);
                }
            };
        }
        control.setData("Tab", (Object)tab);
        control.addListener(4, this.tabMouseListener);
        control.addListener(3, this.tabMouseListener);
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                this.addMouseListener(tab, children[i]);
                ++i;
            }
        }
    }

    private SWTSkinObject[] setTabVisible(SWTSkinObjectTab tab, boolean visible, SWTSkinObject[] skipObjects) {
        String sSkinID = tab.getSkinObjectID();
        SWTSkinObject soTabContent = this.skin.getSkinObjectByID(sSkinID);
        if (soTabContent == null) {
            return null;
        }
        String suffix = visible ? "-selected" : "";
        soTabContent.switchSuffix(suffix, 1, true);
        SWTSkinObject[] activeWidgets = tab.getActiveWidgets(visible);
        int i = 0;
        while (i < activeWidgets.length) {
            SWTSkinObject skinObject = activeWidgets[i];
            boolean ok = true;
            if (skipObjects != null) {
                int j = 0;
                while (j < skipObjects.length) {
                    if (skinObject.equals(skipObjects[j])) {
                        ok = false;
                        break;
                    }
                    ++j;
                }
            }
            if (ok) {
                if (visible) {
                    skinObject.setDefaultVisibility();
                } else {
                    skinObject.setVisible(visible);
                }
            }
            ++i;
        }
        tab.triggerListeners(2);
        return activeWidgets;
    }

    public void addListener(SWTSkinTabSetListener listener) {
        this.listeners.add(listener);
    }

    public String getID() {
        return this.sID;
    }

    protected static String[] getTemplateInfo(SWTSkin skin, SWTSkinObject skinObject, String sTemplateKey) {
        SWTSkinProperties skinProperties = skin.getSkinProperties();
        String sID = String.valueOf(skinObject.getConfigID()) + ".view.template." + sTemplateKey;
        return skinProperties.getStringArray(sID);
    }

    protected static String getTemplateID(SWTSkin skin, SWTSkinObject skinObject, String sTemplateKey) {
        String[] templateInfo2 = SWTSkinTabSet.getTemplateInfo(skin, skinObject, sTemplateKey);
        if (templateInfo2 != null) {
            return templateInfo2[0];
        }
        return null;
    }

    public static String getTabSetID(SWTSkin skin, SWTSkinObject skinObject, String sTemplateKey) {
        String[] templateInfo2 = SWTSkinTabSet.getTemplateInfo(skin, skinObject, sTemplateKey);
        if (templateInfo2 != null && templateInfo2.length > 1) {
            return templateInfo2[1];
        }
        return null;
    }
}

