/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.speedtest;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.speedmanager.LimitToTextHelper;
import com.biglybt.core.speedmanager.SpeedManager;
import com.biglybt.core.speedmanager.SpeedManagerLimitEstimate;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.wizard.AbstractWizardPanel;
import com.biglybt.ui.swt.wizard.IWizardPanel;
import com.biglybt.ui.swt.wizard.Wizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class SpeedTestFinishPanel
extends AbstractWizardPanel {
    SpeedManager speedManager = CoreFactory.getSingleton().getSpeedManager();
    LimitToTextHelper helper = new LimitToTextHelper();

    public SpeedTestFinishPanel(Wizard wizard, IWizardPanel previousPanel) {
        super(wizard, previousPanel);
    }

    @Override
    public void show() {
        String title = MessageText.getString("SpeedTestWizard.finish.panel.title");
        this.wizard.setTitle(title);
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 64);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.widthHint = 380;
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "SpeedTestWizard.finish.panel.click.close");
        int kinb = DisplayFormatters.getKinB();
        SpeedManagerLimitEstimate upEst = this.speedManager.getEstimatedUploadCapacityBytesPerSec();
        int maxUploadKbs = upEst.getBytesPerSec() / kinb;
        SpeedManagerLimitEstimate downEst = this.speedManager.getEstimatedDownloadCapacityBytesPerSec();
        int maxDownloadKbs = downEst.getBytesPerSec() / kinb;
        boolean autoSpeedEnabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Enabled");
        boolean autoSpeedSeedingEnabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Seeding Enabled");
        Label s2 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        s2.setLayoutData((Object)gridData);
        String autoSpeed = MessageText.getString("SpeedTestWizard.finish.panel.auto.speed");
        this.createStatusLine(panel, autoSpeed, autoSpeedEnabled);
        String autoSpeedWhileSeeding = MessageText.getString("SpeedTestWizard.finish.panel.auto.speed.seeding");
        this.createStatusLine(panel, autoSpeedWhileSeeding, autoSpeedSeedingEnabled);
        Label s1 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        s1.setLayoutData((Object)gridData);
        this.createHeaderLine(panel);
        String maxUploadLbl = MessageText.getString("SpeedView.stats.estupcap");
        this.createDataLine(panel, maxUploadLbl, maxUploadKbs, upEst);
        String maxDownloadLbl = MessageText.getString("SpeedView.stats.estdowncap");
        this.createDataLine(panel, maxDownloadLbl, maxDownloadKbs, downEst);
    }

    private void createHeaderLine(Composite panel) {
        Label c1 = new Label(panel, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        c1.setLayoutData((Object)gridData);
        c1.setText(" ");
        Label c2 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 2;
        c2.setLayoutData((Object)gridData);
        c2.setText(MessageText.getString("SpeedTestWizard.set.upload.bytes.per.sec"));
        Label c3 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 1;
        c3.setLayoutData((Object)gridData);
        c3.setText(MessageText.getString("SpeedTestWizard.set.upload.bits.per.sec"));
    }

    private void createStatusLine(Composite panel, String label, boolean enabled) {
        Label r3c1 = new Label(panel, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 3;
        r3c1.setLayoutData((Object)gridData);
        r3c1.setText(label);
        Label c3 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 2;
        c3.setLayoutData((Object)gridData);
        if (enabled) {
            c3.setText(MessageText.getString("SpeedTestWizard.finish.panel.enabled", "enabled"));
        } else {
            c3.setText(MessageText.getString("label.disabled", "disabled"));
        }
        Label c2 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 1;
        c2.setLayoutData((Object)gridData);
        String maxUploadBitsSec = "       ";
        c2.setText(maxUploadBitsSec);
    }

    private void createDataLine(Composite panel, String label, int maxKbps, SpeedManagerLimitEstimate estimate) {
        Label c1 = new Label(panel, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 3;
        c1.setLayoutData((Object)gridData);
        c1.setText(String.valueOf(label) + "  ");
        Label c2 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 2;
        c2.setLayoutData((Object)gridData);
        String estString = this.helper.getLimitText(estimate);
        c2.setText(estString);
        Label c3 = new Label(panel, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 1;
        c3.setLayoutData((Object)gridData);
        String maxBitsPerSec = maxKbps == 0 ? MessageText.getString("ConfigView.unlimited") : DisplayFormatters.formatByteCountToBitsPerSec2(maxKbps * DisplayFormatters.getKinB());
        c3.setText(maxBitsPerSec);
    }

    @Override
    public boolean isPreviousEnabled() {
        return false;
    }
}

