/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.speedtest;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ipc.IPCException;
import com.biglybt.pif.ipc.IPCInterface;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import com.biglybt.ui.swt.speedtest.SpeedTestPanel;
import com.biglybt.ui.swt.speedtest.SpeedTestWizard;
import com.biglybt.ui.swt.wizard.AbstractWizardPanel;
import com.biglybt.ui.swt.wizard.IWizardPanel;
import java.util.HashMap;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class SpeedTestSelector
extends AbstractWizardPanel<SpeedTestWizard> {
    private boolean mlab_test = true;

    public SpeedTestSelector(SpeedTestWizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    @Override
    public void show() {
        ((SpeedTestWizard)this.wizard).setTitle(MessageText.getString("speedtest.wizard.select.title"));
        ((SpeedTestWizard)this.wizard).setCurrentInfo("");
        Composite rootPanel = ((SpeedTestWizard)this.wizard).getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(1808);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        Group gRadio = Utils.createSkinnedGroup(panel, 0);
        Messages.setLanguageText((Widget)gRadio, "speedtest.wizard.select.group");
        gRadio.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        gRadio.setLayout((Layout)layout);
        gridData = new GridData(768);
        gRadio.setLayoutData((Object)gridData);
        Button auto_button = new Button((Composite)gRadio, 16);
        Messages.setLanguageText((Widget)auto_button, "speedtest.wizard.select.general");
        auto_button.setSelection(true);
        final Button manual_button = new Button((Composite)gRadio, 16);
        Messages.setLanguageText((Widget)manual_button, "speedtest.wizard.select.bt");
        manual_button.setEnabled(false);
        manual_button.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SpeedTestSelector.this.mlab_test = !manual_button.getSelection();
            }
        });
    }

    @Override
    public boolean isNextEnabled() {
        return true;
    }

    @Override
    public boolean isPreviousEnabled() {
        return false;
    }

    @Override
    public IWizardPanel getNextPanel() {
        if (this.mlab_test) {
            ((SpeedTestWizard)this.wizard).close();
            SpeedTestSelector.runMLABTest(null);
            return null;
        }
        return new SpeedTestPanel((SpeedTestWizard)this.wizard, null);
    }

    public static void runMLABTest(final Runnable runWhenClosed) {
        CoreWaiterSWT.waitForCoreRunning(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                UIFunctionsManager.getUIFunctions().installPlugin("mlab", "dlg.install.mlab", new UIFunctions.actionListener(){

                    @Override
                    public void actionComplete(Object result) {
                        if (result instanceof Boolean) {
                            SpeedTestSelector._runMLABTest(runWhenClosed);
                        } else {
                            try {
                                Throwable error = (Throwable)result;
                                Debug.out(error);
                            }
                            finally {
                                if (runWhenClosed != null) {
                                    runWhenClosed.run();
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    private static void _runMLABTest(final Runnable runWhenClosed) {
        block5: {
            PluginInterface pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("mlab");
            if (pi == null) {
                Debug.out("mlab plugin not available");
                if (runWhenClosed != null) {
                    runWhenClosed.run();
                }
            } else {
                try {
                    HashMap map = new HashMap();
                    pi.getIPC().invoke("runTest", new Object[]{map, new IPCInterface(){

                        @Override
                        public Object invoke(String methodName, Object[] params) throws IPCException {
                            COConfigurationManager.setParameter("SpeedTest Completed", true);
                            if (runWhenClosed != null) {
                                runWhenClosed.run();
                            }
                            return null;
                        }

                        @Override
                        public boolean canInvoke(String methodName, Object[] params) {
                            return true;
                        }
                    }, true});
                }
                catch (Throwable e) {
                    Debug.out(e);
                    if (runWhenClosed == null) break block5;
                    runWhenClosed.run();
                }
            }
        }
    }
}

