/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.subscriptions;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionAssociationLookup;
import com.biglybt.core.subs.SubscriptionException;
import com.biglybt.core.subs.SubscriptionLookupListener;
import com.biglybt.core.subs.SubscriptionManager;
import com.biglybt.core.subs.SubscriptionManagerFactory;
import com.biglybt.core.subs.SubscriptionPopularityListener;
import com.biglybt.core.util.AEThread2;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.widgets.AnimatedImage;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SubscriptionListWindow
implements SubscriptionLookupListener {
    private final String display_name;
    private final byte[] torrent_hash;
    private final String[] networks;
    private final boolean useCachedSubs;
    private Display display;
    private Shell shell;
    AnimatedImage animatedImage;
    Button action;
    Label loadingText;
    ProgressBar loadingProgress;
    boolean loadingDone = false;
    SubscriptionAssociationLookup lookup = null;
    Composite mainComposite;
    Composite loadingPanel;
    Composite listPanel;
    Table subscriptionsList;
    StackLayout mainLayout;
    SubscriptionItemModel[] subscriptionItems;

    public SubscriptionListWindow(Shell parent, String display_name, byte[] torrent_hash, String[] networks, boolean useCachedSubs) {
        this.display_name = display_name;
        this.torrent_hash = torrent_hash;
        this.networks = networks;
        this.useCachedSubs = useCachedSubs;
        this.shell = ShellFactory.createShell(parent, 2160);
        Utils.setShellIcon(this.shell);
        this.shell.setSize(400, 300);
        Utils.centerWindowRelativeTo(this.shell, (Control)parent);
        String networks_str = "";
        String[] stringArray = networks;
        int n = networks.length;
        int n2 = 0;
        while (n2 < n) {
            String net = stringArray[n2];
            networks_str = String.valueOf(networks_str) + (networks_str.length() == 0 ? "" : ", ") + MessageText.getString("ConfigView.section.connection.networks." + net);
            ++n2;
        }
        if (networks_str.length() == 0) {
            networks_str = MessageText.getString("label.none");
        }
        this.display = this.shell.getDisplay();
        this.shell.setText(String.valueOf(MessageText.getString("subscriptions.listwindow.title")) + " [" + networks_str + "]");
        this.shell.setLayout((Layout)new FormLayout());
        this.mainComposite = new Composite((Composite)this.shell, 0);
        Label separator = new Label((Composite)this.shell, 258);
        Button cancel = new Button((Composite)this.shell, 8);
        this.action = new Button((Composite)this.shell, 8);
        cancel.setText(MessageText.getString("Button.cancel"));
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment((Control)separator, 0);
        this.mainComposite.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment((Control)cancel, -2);
        separator.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this.action);
        data.width = 100;
        data.bottom = new FormAttachment(100, -5);
        cancel.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, -5);
        data.width = 100;
        data.bottom = new FormAttachment(100, -5);
        this.action.setLayoutData((Object)data);
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (SubscriptionListWindow.this.lookup != null) {
                    SubscriptionListWindow.this.lookup.cancel();
                }
                if (!SubscriptionListWindow.this.shell.isDisposed()) {
                    SubscriptionListWindow.this.shell.dispose();
                }
            }
        });
        this.mainLayout = new StackLayout();
        this.mainComposite.setLayout((Layout)this.mainLayout);
        this.loadingPanel = new Composite(this.mainComposite, 0);
        this.loadingPanel.setLayout((Layout)new FormLayout());
        this.listPanel = new Composite(this.mainComposite, 0);
        this.listPanel.setLayout((Layout)new FillLayout());
        this.subscriptionsList = new Table(this.listPanel, 268501508);
        this.subscriptionsList.setHeaderVisible(true);
        TableColumn name = new TableColumn(this.subscriptionsList, 0);
        name.setText(MessageText.getString("subscriptions.listwindow.name"));
        name.setWidth(310);
        name.setResizable(false);
        TableColumn popularity = new TableColumn(this.subscriptionsList, 0);
        popularity.setText(MessageText.getString("subscriptions.listwindow.popularity"));
        popularity.setWidth(70);
        popularity.setResizable(false);
        this.subscriptionsList.addListener(36, new Listener(){

            public void handleEvent(Event e) {
                TableItem item = (TableItem)e.item;
                int index = SubscriptionListWindow.this.subscriptionsList.indexOf(item);
                if (index >= 0 && index < SubscriptionListWindow.this.subscriptionItems.length) {
                    SubscriptionItemModel subscriptionItem = SubscriptionListWindow.this.subscriptionItems[index];
                    item.setText(0, subscriptionItem.name);
                    item.setText(1, subscriptionItem.popularityDisplay);
                }
            }
        });
        this.subscriptionsList.setSortColumn(popularity);
        this.subscriptionsList.setSortDirection(1024);
        this.subscriptionsList.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SubscriptionListWindow.this.action.setEnabled(SubscriptionListWindow.this.subscriptionsList.getSelectionIndex() != -1);
            }
        });
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                TableColumn sortColumn = SubscriptionListWindow.this.subscriptionsList.getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = SubscriptionListWindow.this.subscriptionsList.getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    SubscriptionListWindow.this.subscriptionsList.setSortColumn(currentColumn);
                    dir = 1024;
                }
                SubscriptionListWindow.this.subscriptionsList.setSortDirection(dir);
                SubscriptionListWindow.this.sortAndRefresh();
            }
        };
        name.addListener(13, sortListener);
        popularity.addListener(13, sortListener);
        this.animatedImage = new AnimatedImage(this.loadingPanel);
        this.loadingText = new Label(this.loadingPanel, 0x1000040);
        this.loadingProgress = new ProgressBar(this.loadingPanel, 256);
        this.animatedImage.setImageFromName("spinner_big");
        this.loadingText.setText(MessageText.getString("subscriptions.listwindow.loadingtext", new String[]{display_name}));
        this.loadingProgress.setMinimum(0);
        this.loadingProgress.setMaximum(300);
        this.loadingProgress.setSelection(0);
        data = new FormData();
        data.left = new FormAttachment(1, 2, -16);
        data.top = new FormAttachment(1, 2, -32);
        data.width = 32;
        data.height = 32;
        this.animatedImage.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment(this.animatedImage.getControl(), 10);
        data.height = 50;
        this.loadingText.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment((Control)this.loadingText, 5);
        this.loadingProgress.setLayoutData((Object)data);
        boolean autoCheck = COConfigurationManager.getBooleanParameter("subscriptions.autocheck");
        if (autoCheck) {
            this.startChecking();
        } else {
            this.action.setText(MessageText.getString("Button.yes"));
            Composite acceptPanel = new Composite(this.mainComposite, 0);
            acceptPanel.setLayout((Layout)new FormLayout());
            Label acceptLabel = new Label(acceptPanel, 0x1000040);
            acceptLabel.setText(MessageText.getString("subscriptions.listwindow.autochecktext"));
            data = new FormData();
            data.left = new FormAttachment(0, 5);
            data.right = new FormAttachment(100, -5);
            data.top = new FormAttachment(1, 3, 0);
            acceptLabel.setLayoutData((Object)data);
            this.action.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    SubscriptionListWindow.this.action.removeListener(13, (Listener)this);
                    COConfigurationManager.setParameter("subscriptions.autocheck", true);
                    SubscriptionListWindow.this.startChecking();
                    SubscriptionListWindow.this.mainComposite.layout();
                }
            });
            this.mainLayout.topControl = acceptPanel;
        }
        this.shell.open();
    }

    private void startChecking() {
        this.action.setText(MessageText.getString("subscriptions.listwindow.subscribe"));
        this.action.setEnabled(false);
        try {
            SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
            if (this.useCachedSubs) {
                Subscription[] subs = subs_man.getKnownSubscriptions(this.torrent_hash);
                this.complete(this.torrent_hash, subs);
            } else {
                this.lookup = subs_man.lookupAssociations(this.torrent_hash, this.display_name, this.networks, this);
                this.lookup.setTimeout(60000L);
            }
            this.loadingDone = false;
            AEThread2 progressMover = new AEThread2("progressMover", true){

                @Override
                public void run() {
                    final int[] waitTime = new int[]{100};
                    while (!SubscriptionListWindow.this.loadingDone) {
                        if (SubscriptionListWindow.this.display != null && !SubscriptionListWindow.this.display.isDisposed()) {
                            SubscriptionListWindow.this.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if ((this).SubscriptionListWindow.this.loadingProgress != null && !(this).SubscriptionListWindow.this.loadingProgress.isDisposed()) {
                                        int currentSelection = (this).SubscriptionListWindow.this.loadingProgress.getSelection() + 1;
                                        (this).SubscriptionListWindow.this.loadingProgress.setSelection(currentSelection);
                                        if (currentSelection > (this).SubscriptionListWindow.this.loadingProgress.getMaximum() * 80 / 100) {
                                            waitTime[0] = 300;
                                        }
                                        if (currentSelection > (this).SubscriptionListWindow.this.loadingProgress.getMaximum() * 90 / 100) {
                                            waitTime[0] = 1000;
                                        }
                                    } else {
                                        (this).SubscriptionListWindow.this.loadingDone = true;
                                    }
                                }
                            });
                        }
                        try {
                            Thread.sleep(waitTime[0]);
                        }
                        catch (Exception e) {
                            SubscriptionListWindow.this.loadingDone = true;
                        }
                    }
                }
            };
            progressMover.start();
        }
        catch (Exception e) {
            this.failed(null, null);
        }
        this.animatedImage.start();
        this.mainLayout.topControl = this.loadingPanel;
    }

    @Override
    public void found(byte[] hash, Subscription subscription) {
    }

    @Override
    public void complete(byte[] hash, final Subscription[] subscriptions) {
        if (subscriptions.length <= 0) {
            this.failed(hash, null);
        } else if (this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (SubscriptionListWindow.this.mainComposite.isDisposed()) {
                        return;
                    }
                    SubscriptionListWindow.this.subscriptionItems = new SubscriptionItemModel[subscriptions.length];
                    int i = 0;
                    while (i < subscriptions.length) {
                        SubscriptionItemModel subscriptionItem;
                        SubscriptionListWindow.this.subscriptionItems[i] = subscriptionItem = new SubscriptionItemModel();
                        subscriptionItem.name = subscriptions[i].getName();
                        subscriptionItem.popularity = -1L;
                        subscriptionItem.popularityDisplay = MessageText.getString("subscriptions.listwindow.popularity.reading");
                        subscriptionItem.subscription = subscriptions[i];
                        try {
                            subscriptions[i].getPopularity(new SubscriptionPopularityListener(){

                                @Override
                                public void gotPopularity(long popularity) {
                                    SubscriptionListWindow.this.update(subscriptionItem, popularity, String.valueOf(popularity));
                                }

                                @Override
                                public void failed(SubscriptionException error) {
                                    SubscriptionListWindow.this.update(subscriptionItem, -2L, MessageText.getString("subscriptions.listwindow.popularity.unknown"));
                                }
                            });
                        }
                        catch (SubscriptionException e) {
                            SubscriptionListWindow.this.update(subscriptionItem, -2L, MessageText.getString("subscriptions.listwindow.popularity.unknown"));
                        }
                        ++i;
                    }
                    SubscriptionListWindow.this.animatedImage.stop();
                    SubscriptionListWindow.this.mainLayout.topControl = SubscriptionListWindow.this.listPanel;
                    SubscriptionListWindow.this.mainComposite.layout();
                    SubscriptionListWindow.this.sortAndRefresh();
                    SubscriptionListWindow.this.subscriptionsList.setSelection(0);
                    SubscriptionListWindow.this.action.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            Subscription subscription;
                            int selectedIndex;
                            if ((this).SubscriptionListWindow.this.subscriptionsList != null && !(this).SubscriptionListWindow.this.subscriptionsList.isDisposed() && (selectedIndex = (this).SubscriptionListWindow.this.subscriptionsList.getSelectionIndex()) >= 0 && selectedIndex < (this).SubscriptionListWindow.this.subscriptionItems.length && (subscription = (this).SubscriptionListWindow.this.subscriptionItems[selectedIndex].subscription) != null) {
                                subscription.setSubscribed(true);
                                subscription.requestAttention();
                            }
                        }
                    });
                }
            });
        }
    }

    protected void update(final SubscriptionItemModel subscriptionItem, final long popularity, final String text) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                subscriptionItem.popularity = popularity;
                subscriptionItem.popularityDisplay = text;
                SubscriptionListWindow.this.sortAndRefresh();
            }
        });
    }

    private void sortAndRefresh() {
        if (this.subscriptionsList.isDisposed()) {
            return;
        }
        int i = 0;
        while (i < this.subscriptionItems.length) {
            this.subscriptionItems[i].selected = false;
            ++i;
        }
        int currentSelection = this.subscriptionsList.getSelectionIndex();
        if (currentSelection >= 0 && currentSelection < this.subscriptionItems.length) {
            this.subscriptionItems[currentSelection].selected = true;
        }
        final int dir = this.subscriptionsList.getSortDirection() == 1024 ? 1 : -1;
        final boolean nameSort = this.subscriptionsList.getColumn(0) == this.subscriptionsList.getSortColumn();
        Arrays.sort(this.subscriptionItems, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                SubscriptionItemModel item0 = (SubscriptionItemModel)arg0;
                SubscriptionItemModel item1 = (SubscriptionItemModel)arg1;
                if (nameSort) {
                    return dir * item0.name.compareTo(item1.name);
                }
                return dir * (int)(item1.popularity - item0.popularity);
            }
        });
        this.subscriptionsList.setItemCount(this.subscriptionItems.length);
        this.subscriptionsList.clearAll();
        if (currentSelection >= 0 && currentSelection < this.subscriptionItems.length) {
            int i2 = 0;
            while (i2 < this.subscriptionItems.length) {
                if (this.subscriptionItems[i2].selected) {
                    this.subscriptionsList.setSelection(i2);
                }
                ++i2;
            }
        }
    }

    @Override
    public void failed(byte[] hash, SubscriptionException error) {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    SubscriptionListWindow.this.animatedImage.stop();
                    SubscriptionListWindow.this.animatedImage.dispose();
                    SubscriptionListWindow.this.loadingProgress.dispose();
                    if (!SubscriptionListWindow.this.loadingText.isDisposed()) {
                        SubscriptionListWindow.this.loadingText.setText(MessageText.getString("subscriptions.listwindow.failed"));
                    }
                }
            });
        }
    }

    private static class SubscriptionItemModel {
        String name;
        long popularity;
        String popularityDisplay;
        Subscription subscription;
        boolean selected;

        private SubscriptionItemModel() {
        }
    }
}

