/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.subscriptions;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentCreator;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.util.AETemporaryFileHandler;
import com.biglybt.core.util.Debug;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.ui.selectedcontent.DownloadUrlInfo;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.ISelectedVuzeFileContent;
import java.io.File;
import java.net.URL;
import java.util.Map;

public class SubscriptionSelectedContent
implements ISelectedVuzeFileContent {
    private Subscription subs;
    private TOTorrent torrent;

    protected SubscriptionSelectedContent(Subscription _subs) {
        this.subs = _subs;
    }

    @Override
    public String getDisplayName() {
        return String.valueOf(MessageText.getString("subscriptions.column.name")) + ": " + this.subs.getName();
    }

    @Override
    public String getHash() {
        return this.subs.getID();
    }

    @Override
    public VuzeFile getVuzeFile() {
        try {
            return this.subs.getVuzeFile();
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TOTorrent getTorrent() {
        SubscriptionSelectedContent subscriptionSelectedContent = this;
        synchronized (subscriptionSelectedContent) {
            block9: {
                if (this.torrent == null) {
                    try {
                        VuzeFile vf = this.subs.getVuzeFile();
                        if (vf == null) break block9;
                        File f1 = AETemporaryFileHandler.createTempFile();
                        File f = new File(f1.getParent(), "Update Vuze to access this share_" + f1.getName());
                        f1.delete();
                        try {
                            vf.write(f);
                            TOTorrentCreator cr = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(f, new URL("dht://"));
                            TOTorrent temp = cr.create();
                            Map vuze_map = vf.exportToMap();
                            Map torrent_map = temp.serialiseToMap();
                            torrent_map.putAll(vuze_map);
                            this.torrent = TOTorrentFactory.deserialiseFromMap(torrent_map);
                        }
                        finally {
                            f.delete();
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }
        return this.torrent;
    }

    @Override
    public void setHash(String hash) {
    }

    @Override
    public DownloadManager getDownloadManager() {
        return null;
    }

    @Override
    public int getFileIndex() {
        return 0;
    }

    @Override
    public void setDownloadManager(DownloadManager dm) {
    }

    @Override
    public void setTorrent(TOTorrent torrent) {
    }

    @Override
    public void setDisplayName(String displayName) {
    }

    @Override
    public DownloadUrlInfo getDownloadInfo() {
        return null;
    }

    @Override
    public boolean sameAs(ISelectedContent _other) {
        if (_other == this) {
            return true;
        }
        if (_other instanceof SubscriptionSelectedContent) {
            SubscriptionSelectedContent other = (SubscriptionSelectedContent)_other;
            return this.subs == other.subs;
        }
        return false;
    }
}

