/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.updater2;

import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEVerifier;
import com.biglybt.core.util.Constants;
import com.biglybt.core.versioncheck.VersionCheckClient;
import com.biglybt.pif.update.UpdateChecker;
import com.biglybt.ui.swt.Utils;
import java.util.Map;

public class SWTVersionGetter {
    private static final LogIDs LOGID = LogIDs.GUI;
    private String platform = Utils.getSWTPlatform();
    private int currentVersion = Utils.getSWTVersion();
    private int currentRevision = Utils.getSWTRevision();
    private int latestVersion = 0;
    private int latestRevision = 0;
    private UpdateChecker checker;
    private String[] mirrors;
    private String infoURL;

    public SWTVersionGetter(UpdateChecker _checker) {
        this.checker = _checker;
    }

    public boolean needsUpdate() {
        block4: {
            try {
                this.downloadLatestVersion();
                String msg = "SWT: current version = " + this.currentVersion + (this.currentRevision == 0 ? "" : "r" + this.currentRevision) + ", latest version = " + this.latestVersion + (this.latestRevision == 0 ? "" : "r" + this.latestRevision);
                this.checker.reportProgress(msg);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, msg));
                }
                if (this.latestVersion <= this.currentVersion) break block4;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return this.latestVersion == this.currentVersion && this.latestRevision > this.currentRevision;
    }

    private void downloadLatestVersion() {
        byte[] info_bytes;
        byte[] url_bytes;
        byte[] revision_bytes;
        byte[] version_bytes;
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Requesting latest SWT version and url from version check client."));
        }
        Map reply = VersionCheckClient.getSingleton().getVersionCheckInfo("sw");
        String msg = "SWT version check received:";
        boolean done = false;
        if (Constants.isOSX && (version_bytes = (byte[])reply.get("swt_version_cocoa")) != null) {
            this.latestVersion = Integer.parseInt(new String(version_bytes));
            msg = String.valueOf(msg) + " version=" + this.latestVersion;
            revision_bytes = (byte[])reply.get("swt_revision_cocoa");
            if (revision_bytes != null) {
                this.latestRevision = Integer.parseInt(new String(revision_bytes));
                msg = String.valueOf(msg) + "r" + this.latestRevision;
            }
            if ((url_bytes = (byte[])reply.get("swt_url_cocoa")) != null) {
                this.mirrors = new String[]{new String(url_bytes)};
                msg = String.valueOf(msg) + " url=" + this.mirrors[0];
            }
            done = true;
        }
        if (!done) {
            version_bytes = (byte[])reply.get("swt_version");
            if (version_bytes != null) {
                this.latestVersion = Integer.parseInt(new String(version_bytes));
                msg = String.valueOf(msg) + " version=" + this.latestVersion;
            }
            if ((revision_bytes = (byte[])reply.get("swt_revision")) != null) {
                this.latestRevision = Integer.parseInt(new String(revision_bytes));
                msg = String.valueOf(msg) + "r" + this.latestRevision;
            }
            if ((url_bytes = (byte[])reply.get("swt_url")) != null) {
                this.mirrors = new String[]{new String(url_bytes)};
                msg = String.valueOf(msg) + " url=" + this.mirrors[0];
            }
        }
        if ((info_bytes = (byte[])reply.get("swt_info_url")) != null) {
            byte[] sig = (byte[])reply.get("swt_info_sig");
            if (sig == null) {
                Logger.log(new LogEvent(LogIDs.LOGGER, "swt info signature check failed - missing signature"));
            } else {
                try {
                    this.infoURL = new String(info_bytes);
                    try {
                        AEVerifier.verifyData(this.infoURL, sig);
                    }
                    catch (Throwable e) {
                        Logger.log(new LogEvent(LogIDs.LOGGER, "swt info signature check failed", e));
                        this.infoURL = null;
                    }
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LOGID, "swt info_url", e));
                }
            }
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, msg));
        }
    }

    public String getLatestVersionAndRevision() {
        return String.valueOf(this.latestVersion) + (this.latestRevision == 0 ? "" : "r" + this.latestRevision);
    }

    public int getCurrentVersion() {
        return this.currentVersion;
    }

    public int getCurrentRevision() {
        return this.currentRevision;
    }

    public String getCurrentVersionAndRevision() {
        return String.valueOf(this.currentVersion) + (this.currentRevision == 0 ? "" : "r" + this.currentRevision);
    }

    public String getPlatform() {
        return this.platform;
    }

    public String[] getMirrors() {
        return this.mirrors;
    }

    public String getInfoURL() {
        return this.infoURL;
    }
}

