/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.utils;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

public class ColorCache {
    private static final boolean DEBUG = Constants.isCVSVersion();
    private static final Map<Long, Color> mapColors = new HashMap<Long, Color>();
    private static final HashSet<Color> colorsToDispose = new HashSet();
    private static final int SYSTEMCOLOR_INDEXSTART = 17;
    private static final String[] systemColorNames = new String[]{"COLOR_WIDGET_DARK_SHADOW", "COLOR_WIDGET_NORMAL_SHADOW", "COLOR_WIDGET_LIGHT_SHADOW", "COLOR_WIDGET_HIGHLIGHT_SHADOW", "COLOR_WIDGET_FOREGROUND", "COLOR_WIDGET_BACKGROUND", "COLOR_WIDGET_BORDER", "COLOR_LIST_FOREGROUND", "COLOR_LIST_BACKGROUND", "COLOR_LIST_SELECTION", "COLOR_LIST_SELECTION_TEXT", "COLOR_INFO_FOREGROUND", "COLOR_INFO_BACKGROUND", "COLOR_TITLE_FOREGROUND", "COLOR_TITLE_BACKGROUND", "COLOR_TITLE_BACKGROUND_GRADIENT", "COLOR_TITLE_INACTIVE_FOREGROUND", "COLOR_TITLE_INACTIVE_BACKGROUND", "COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT", "COLOR_LINK_FOREGROUND"};
    private static TimerEventPeriodic timerColorCacheChecker;
    private static boolean forceNoColor;

    static {
        forceNoColor = COConfigurationManager.getBooleanParameter("ForceNoColor");
        COConfigurationManager.addParameterListener("ForceNoColor", name -> {
            if (forceNoColor == COConfigurationManager.getBooleanParameter(name)) {
                return;
            }
            forceNoColor = !forceNoColor;
            ColorCache.reset();
        });
    }

    public static void reset() {
        mapColors.clear();
    }

    public static void dispose() {
        Object[] disposeList = colorsToDispose.toArray();
        colorsToDispose.clear();
        Utils.disposeSWTObjects(disposeList);
        if (timerColorCacheChecker != null) {
            timerColorCacheChecker.cancel();
            timerColorCacheChecker = null;
        }
    }

    public static Color getSchemedColor(Device device, int red, int green, int blue) {
        ColorCache.ensureMapColorsInitialized(device);
        Long key = new Long(((long)red << 16) + (long)(green << 8) + (long)blue + 0x1000000L);
        Color color = mapColors.get(key);
        if (color == null || color.isDisposed()) {
            try {
                if (red < 0) {
                    red = 0;
                } else if (red > 255) {
                    red = 255;
                }
                if (green < 0) {
                    green = 0;
                } else if (green > 255) {
                    green = 255;
                }
                if (blue < 0) {
                    blue = 0;
                } else if (blue > 255) {
                    blue = 255;
                }
                RGB rgb = new RGB(red, green, blue);
                float[] hsb = rgb.getHSB();
                hsb[0] = hsb[0] + (float)Colors.diffHue;
                if (hsb[0] > 360.0f) {
                    hsb[0] = hsb[0] - 360.0f;
                } else if (hsb[0] < 0.0f) {
                    hsb[0] = hsb[0] + 360.0f;
                }
                hsb[1] = hsb[1] * Colors.diffSatPct;
                color = ColorCache.getColor(device, hsb);
                mapColors.put(key, color);
            }
            catch (IllegalArgumentException e) {
                Debug.out("One Invalid: " + red + ";" + green + ";" + blue, e);
            }
        }
        return color;
    }

    public static Color getColor(Device device, int red, int green, int blue) {
        if (Utils.isDisplayDisposed()) {
            return null;
        }
        ColorCache.ensureMapColorsInitialized(device);
        Long key = new Long(((long)red << 16) + (long)(green << 8) + (long)blue);
        Color color = mapColors.get(key);
        if (color == null || color.isDisposed()) {
            if (device == null) {
                return null;
            }
            try {
                if (red < 0) {
                    red = 0;
                } else if (red > 255) {
                    red = 255;
                }
                if (green < 0) {
                    green = 0;
                } else if (green > 255) {
                    green = 255;
                }
                if (blue < 0) {
                    blue = 0;
                } else if (blue > 255) {
                    blue = 255;
                }
                if (forceNoColor && (blue != red || blue != green)) {
                    double brightness = Math.sqrt((double)(red * red) * 0.299 + (double)(green * green) * 0.587 + (double)(blue * blue) * 0.114);
                    int grayscale = (int)brightness;
                    color = ColorCache.getColor(device, grayscale, grayscale, grayscale);
                } else {
                    color = new Color(device, red, green, blue);
                    colorsToDispose.add(color);
                }
            }
            catch (IllegalArgumentException e) {
                Debug.out("One Invalid: " + red + ";" + green + ";" + blue, e);
            }
            ColorCache.addColor(key, color);
        }
        return color;
    }

    private static void ensureMapColorsInitialized(Device device) {
        if (device == null || device.isDisposed()) {
            return;
        }
        if (mapColors.size() == 0) {
            int i = 1;
            while (i <= 16) {
                Color color = device.getSystemColor(i);
                Long key = new Long(((long)color.getRed() << 16) + (long)(color.getGreen() << 8) + (long)color.getBlue());
                ColorCache.addColor(key, color);
                ++i;
            }
            if (DEBUG) {
                timerColorCacheChecker = SimpleTimer.addPeriodicEvent("ColorCacheChecker", 60000L, new TimerEventPerformer(){

                    @Override
                    public void perform(TimerEvent event2) {
                        if (Utils.isDisplayDisposed()) {
                            event2.cancel();
                            return;
                        }
                        Utils.execSWTThread(new AERunnable(){

                            @Override
                            public void runSupport() {
                                Iterator iter = mapColors.keySet().iterator();
                                while (iter.hasNext()) {
                                    Long key = (Long)iter.next();
                                    Color color = (Color)mapColors.get(key);
                                    if (!color.isDisposed()) continue;
                                    System.err.println("Someone disposed of color " + Long.toHexString(key));
                                    iter.remove();
                                }
                            }
                        });
                    }
                });
            }
        }
    }

    public static Color getColor(Device device, String value) {
        return ColorCache.getColor(device, value, false);
    }

    public static Color getSchemedColor(Device device, String value) {
        return ColorCache.getColor(device, value, true);
    }

    private static Color getColor(Device device, String c_value, boolean useScheme) {
        int[] colors;
        block19: {
            block20: {
                String x_value;
                String def_value;
                block21: {
                    colors = new int[3];
                    if (c_value == null || c_value.length() == 0) {
                        return null;
                    }
                    try {
                        String config_name;
                        if (c_value.charAt(0) == '#') {
                            if (c_value.length() == 4) {
                                long l = Long.parseLong(c_value.substring(1), 16);
                                colors[0] = (int)(l >> 8 & 0xFL) << 4;
                                colors[1] = (int)(l >> 4 & 0xFL) << 4;
                                colors[2] = (int)(l & 0xFL) << 4;
                            } else {
                                long l = Long.parseLong(c_value.substring(1), 16);
                                colors[0] = (int)(l >> 16 & 0xFFL);
                                colors[1] = (int)(l >> 8 & 0xFFL);
                                colors[2] = (int)(l & 0xFFL);
                            }
                            break block19;
                        }
                        if (c_value.indexOf(44) > 0) {
                            StringTokenizer st = new StringTokenizer(c_value, ",");
                            colors[0] = Integer.parseInt(st.nextToken());
                            colors[1] = Integer.parseInt(st.nextToken());
                            colors[2] = Integer.parseInt(st.nextToken());
                            break block19;
                        }
                        String u_value = c_value.toUpperCase();
                        if (u_value.startsWith("COLOR_")) {
                            int i = 0;
                            while (i < systemColorNames.length) {
                                String name = systemColorNames[i];
                                if (name.equals(u_value) && device != null && !device.isDisposed()) {
                                    if (Utils.isDarkAppearanceNativeWindows()) {
                                        return Colors.getSystemColor(device, i + 17);
                                    }
                                    return device.getSystemColor(i + 17);
                                }
                                ++i;
                            }
                            break block20;
                        }
                        if (u_value.startsWith("BLUE.FADED.")) {
                            int idx = Integer.parseInt(u_value.substring(11));
                            return Colors.faded[idx];
                        }
                        if (u_value.startsWith("BLUE.")) {
                            int idx = Integer.parseInt(u_value.substring(5));
                            return Colors.blues[idx];
                        }
                        if (u_value.equals("ALTROW")) {
                            return Colors.colorAltRow;
                        }
                        if (!c_value.startsWith("config.")) break block20;
                        int def_pos = c_value.indexOf(58);
                        if (def_pos != -1) {
                            config_name = c_value.substring(0, def_pos);
                            def_value = c_value.substring(def_pos + 1);
                        } else {
                            config_name = c_value;
                            def_value = null;
                        }
                        x_value = COConfigurationManager.getStringParameter(config_name, def_value);
                        if (!"null".equals(x_value)) break block21;
                        return null;
                    }
                    catch (Exception e) {
                        Debug.out(c_value, e);
                        return null;
                    }
                }
                useScheme = x_value == def_value;
                Color result = ColorCache.getColor(device, x_value, useScheme);
                if (result == null) {
                    Debug.out("No color found for '" + c_value + "'");
                    result = Colors.white;
                }
                return result;
            }
            return null;
        }
        if (!useScheme) {
            return ColorCache.getColor(device, colors[0], colors[1], colors[2]);
        }
        return ColorCache.getSchemedColor(device, colors[0], colors[1], colors[2]);
    }

    private static void addColor(Long key, Color color) {
        mapColors.put(key, color);
    }

    public static Color getColor(Device device, int[] rgb) {
        if (rgb == null || rgb.length < 3) {
            return null;
        }
        return ColorCache.getColor(device, rgb[0], rgb[1], rgb[2]);
    }

    public static Color getRandomColor() {
        if (mapColors.size() == 0) {
            return Colors.black;
        }
        int r = (int)(Math.random() * (double)mapColors.size());
        return (Color)mapColors.values().toArray()[r];
    }

    public static Color getColor(Device device, float[] hsb) {
        if (hsb[0] < 0.0f) {
            hsb[0] = 0.0f;
        } else if (hsb[0] > 360.0f) {
            hsb[0] = 360.0f;
        }
        if (hsb[1] < 0.0f) {
            hsb[1] = 0.0f;
        } else if (hsb[1] > 1.0f) {
            hsb[1] = 1.0f;
        }
        if (hsb[2] < 0.0f) {
            hsb[2] = 0.0f;
        } else if (hsb[2] > 1.0f) {
            hsb[2] = 1.0f;
        }
        RGB rgb = new RGB(hsb[0], hsb[1], hsb[2]);
        return ColorCache.getColor(device, rgb.red, rgb.green, rgb.blue);
    }

    public static Color getColor(Device device, RGB rgb) {
        return ColorCache.getColor(device, rgb.red, rgb.green, rgb.blue);
    }

    public static class MyAEDiagnosticsEvidenceGenerator
    implements AEDiagnosticsEvidenceGenerator {
        @Override
        public void generate(IndentWriter writer) {
            writer.println("Colors:");
            writer.indent();
            writer.println("# cached: " + mapColors.size());
            writer.exdent();
        }
    }
}

