/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.utils;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerAdapter;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.torrentdownloader.TorrentDownloader;
import com.biglybt.core.torrentdownloader.TorrentDownloaderCallBackInterface;
import com.biglybt.core.util.AERunnableObject;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.RememberedDecisionsManager;
import com.biglybt.ui.selectedcontent.DownloadUrlInfo;
import com.biglybt.ui.swt.FileDownloadWindow;
import com.biglybt.ui.swt.ImageRepository;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.browser.listener.DownloadUrlInfoSWT;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.shells.MessageSlideShell;
import com.biglybt.ui.swt.views.skin.TorrentListViewsUtils;
import com.biglybt.util.DataSourceUtils;
import com.biglybt.util.PlayUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TorrentUIUtilsV3 {
    private static final String MSG_ALREADY_EXISTS = "OpenTorrentWindow.mb.alreadyExists";
    private static final String MSG_ALREADY_EXISTS_NAME = "OpenTorrentWindow.mb.alreadyExists.default.name";
    private static final Pattern hashPattern = Pattern.compile("download/([A-Z0-9]{32})\\.torrent");
    static ImageLoader imageLoaderThumb;
    private static List<MessageBoxShell> active_aa_dialogs;

    static {
        active_aa_dialogs = new ArrayList<MessageBoxShell>();
    }

    public static void disposeStatic() {
        if (imageLoaderThumb != null) {
            imageLoaderThumb.dispose();
            imageLoaderThumb = null;
        }
    }

    public static void loadTorrent(final DownloadUrlInfo dlInfo, final boolean playNow, final boolean playPrepare, final boolean bringToFront) {
        CoreWaiterSWT.waitForCoreRunning(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                TorrentUIUtilsV3._loadTorrent(core, dlInfo, playNow, playPrepare, bringToFront);
            }
        });
    }

    private static void _loadTorrent(final Core core, final DownloadUrlInfo dlInfo, final boolean playNow, final boolean playPrepare, boolean bringToFront) {
        if (dlInfo instanceof DownloadUrlInfoSWT) {
            DownloadUrlInfoSWT dlInfoSWT = (DownloadUrlInfoSWT)dlInfo;
            dlInfoSWT.invoke(playNow ? "play" : "download");
            return;
        }
        String url = dlInfo.getDownloadURL();
        try {
            UIFunctionsSWT uiFunctions;
            Matcher m = hashPattern.matcher(url);
            if (m.find()) {
                String hash = m.group(1);
                GlobalManager gm = core.getGlobalManager();
                final DownloadManager dm = gm.getDownloadManager(new HashWrapper(Base32.decode(hash)));
                if (dm != null) {
                    if (playNow || playPrepare) {
                        new AEThread2("playExisting", true){

                            @Override
                            public void run() {
                                if (playNow) {
                                    Debug.outNoStack("loadTorrent already exists.. playing", false);
                                    TorrentListViewsUtils.playOrStream(dm, -1);
                                } else {
                                    Debug.outNoStack("loadTorrent already exists.. preparing", false);
                                    PlayUtils.prepareForPlay(dm);
                                }
                            }
                        }.start();
                    } else {
                        TorrentUIUtilsV3.showTorrentAlreadyAdded(" ", dm.getDisplayName());
                    }
                    return;
                }
            }
            if ((uiFunctions = (UIFunctionsSWT)UIFunctionsManager.getUIFunctions()) != null) {
                Shell shell;
                if (bringToFront) {
                    uiFunctions.bringToFront();
                }
                if ((shell = uiFunctions.getMainShell()) != null) {
                    new FileDownloadWindow(shell, url, dlInfo.getReferer(), dlInfo.getRequestProperties(), null, new TorrentDownloaderCallBackInterface(){

                        @Override
                        public void TorrentDownloaderEvent(int state, TorrentDownloader inf) {
                            if (state == 3) {
                                DownloadManager existingDM;
                                HashWrapper hw;
                                TOTorrent torrent;
                                File file = inf.getFile();
                                file.deleteOnExit();
                                if (!TorrentUtil.isFileTorrent(dlInfo.getDownloadURL(), file, file.getName(), true)) {
                                    return;
                                }
                                try {
                                    torrent = TorrentUtils.readFromFile(file, false);
                                }
                                catch (TOTorrentException e) {
                                    Debug.out(e);
                                    return;
                                }
                                if (playNow && !PlatformTorrentUtils.isPlatformTracker(torrent)) {
                                    Debug.out("stopped loading torrent because it's not in whitelist");
                                    return;
                                }
                                try {
                                    hw = torrent.getHashWrapper();
                                }
                                catch (TOTorrentException e1) {
                                    Debug.out(e1);
                                    return;
                                }
                                GlobalManager gm = core.getGlobalManager();
                                if ((playNow || playPrepare) && (existingDM = gm.getDownloadManager(hw)) != null) {
                                    if (playNow) {
                                        TorrentListViewsUtils.playOrStream(existingDM, -1);
                                    } else {
                                        PlayUtils.prepareForPlay(existingDM);
                                    }
                                    return;
                                }
                                final HashWrapper fhw = hw;
                                GlobalManagerAdapter l = new GlobalManagerAdapter(){

                                    @Override
                                    public void downloadManagerAdded(DownloadManager dm) {
                                        try {
                                            core.getGlobalManager().removeListener(this);
                                            TorrentUIUtilsV3.handleDMAdded(dm, playNow, playPrepare, fhw);
                                        }
                                        catch (Exception e) {
                                            Debug.out(e);
                                        }
                                    }
                                };
                                gm.addListener(l, false);
                                TorrentOpener.openTorrent(file.getAbsolutePath());
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    private static void handleDMAdded(final DownloadManager dm, final boolean playNow, final boolean playPrepare, final HashWrapper fhw) {
        new AEThread2("playDM", true){

            @Override
            public void run() {
                try {
                    HashWrapper hw = dm.getTorrent().getHashWrapper();
                    if (!hw.equals(fhw)) {
                        return;
                    }
                    if (playNow || playPrepare) {
                        if (playNow) {
                            TorrentListViewsUtils.playOrStream(dm, -1);
                        } else {
                            PlayUtils.prepareForPlay(dm);
                        }
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }.start();
    }

    public static void addTorrentToGM(final TOTorrent torrent) {
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                try {
                    File tempTorrentFile = File.createTempFile("AZU", ".torrent");
                    tempTorrentFile.deleteOnExit();
                    String filename = tempTorrentFile.getAbsolutePath();
                    torrent.serialiseToBEncodedFile(tempTorrentFile);
                    String savePath = COConfigurationManager.getStringParameter("Default save path");
                    if (savePath == null || savePath.length() == 0) {
                        savePath = ".";
                    }
                    core.getGlobalManager().addDownloadManager(filename, savePath);
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
            }
        });
    }

    public static Image[] getContentImage(Object datasource, boolean big, ContentImageLoadedListener l) {
        Image image;
        String thumbnailUrl;
        if (l == null) {
            return null;
        }
        TOTorrent torrent = DataSourceUtils.getTorrent(datasource);
        if (torrent == null) {
            l.contentImageLoaded(null, true);
            return null;
        }
        if (imageLoaderThumb == null) {
            imageLoaderThumb = new ImageLoader(null, null);
        }
        if ((thumbnailUrl = PlatformTorrentUtils.getContentThumbnailUrl(torrent)) != null && imageLoaderThumb.imageExists(thumbnailUrl)) {
            Image image2 = imageLoaderThumb.getImage(thumbnailUrl);
            l.contentImageLoaded(image2, true);
            return new Image[]{image2};
        }
        String hash = null;
        try {
            hash = torrent.getHashWrapper().toBase32String();
        }
        catch (TOTorrentException tOTorrentException) {
            // empty catch block
        }
        if (hash == null) {
            l.contentImageLoaded(null, true);
            return null;
        }
        int thumbnailVersion = PlatformTorrentUtils.getContentVersion(torrent);
        String id = "Thumbnail." + hash + "." + torrent.getSize() + "." + thumbnailVersion + (big ? ".big" : "");
        Image image3 = image = imageLoaderThumb.imageAdded(id) ? imageLoaderThumb.getImage(id) : null;
        if (image != null && !image.isDisposed()) {
            l.contentImageLoaded(image, true);
            return new Image[]{image};
        }
        final byte[] imageBytes = PlatformTorrentUtils.getContentThumbnail(torrent);
        if (imageBytes != null) {
            image = (Image)Utils.execSWTThreadWithObject("thumbcreator", new AERunnableObject(){

                @Override
                public Object runSupport() {
                    try {
                        ByteArrayInputStream bis = new ByteArrayInputStream(imageBytes);
                        Image image = new Image((Device)Display.getDefault(), (InputStream)bis);
                        return image;
                    }
                    catch (Throwable e) {
                        return null;
                    }
                }
            }, 500L);
        }
        if (image == null || image.isDisposed()) {
            DownloadManager dm = DataSourceUtils.getDM(datasource);
            String path = null;
            if (dm == null) {
                TOTorrentFile[] files = torrent.getFiles();
                if (files.length > 0) {
                    path = files[0].getRelativePath();
                }
            } else {
                DiskManagerFileInfo primaryFile = dm.getDownloadState().getPrimaryFile();
                String string = path = primaryFile == null ? null : primaryFile.getFile(true).getName();
                if (path == null) {
                    path = dm.getSaveLocation().getAbsolutePath();
                }
            }
            if (path != null && (image = ImageRepository.getPathIcon(path, big, false)) != null && !torrent.isSimpleTorrent()) {
                Image[] imageArray;
                Image parentPathIcon = ImageRepository.getPathIcon(new File(path).getParent(), false, false);
                if (parentPathIcon == null || parentPathIcon.isDisposed()) {
                    Image[] imageArray2 = new Image[1];
                    imageArray = imageArray2;
                    imageArray2[0] = image;
                } else {
                    Image[] imageArray3 = new Image[2];
                    imageArray3[0] = image;
                    imageArray = imageArray3;
                    imageArray3[1] = parentPathIcon;
                }
                Image[] images = imageArray;
                return images;
            }
            if (image == null) {
                imageLoaderThumb.addImageNoDipose(id, ImageLoader.noImage);
            } else {
                imageLoaderThumb.addImageNoDipose(id, image);
            }
        } else {
            imageLoaderThumb.addImage(id, image);
        }
        l.contentImageLoaded(image, true);
        return new Image[]{image};
    }

    public static void releaseContentImage(Object datasource) {
        if (imageLoaderThumb == null) {
            return;
        }
        TOTorrent torrent = DataSourceUtils.getTorrent(datasource);
        if (torrent == null) {
            return;
        }
        String thumbnailUrl = PlatformTorrentUtils.getContentThumbnailUrl(torrent);
        if (thumbnailUrl != null) {
            imageLoaderThumb.releaseImage(thumbnailUrl);
        } else {
            String hash = null;
            try {
                hash = torrent.getHashWrapper().toBase32String();
            }
            catch (TOTorrentException tOTorrentException) {
                // empty catch block
            }
            if (hash == null) {
                return;
            }
            String id = "Thumbnail." + hash + "." + torrent.getSize();
            imageLoaderThumb.releaseImage(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showTorrentAlreadyAdded(String originating_loc, String name) {
        String remember_id = MSG_ALREADY_EXISTS;
        if (RememberedDecisionsManager.getRememberedDecision(remember_id) < 0) {
            MessageBoxShell mb = new MessageBoxShell(32, MSG_ALREADY_EXISTS, new String[]{originating_loc, name, MessageText.getString(MSG_ALREADY_EXISTS_NAME)});
            mb.setRemember(remember_id, false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
            List<MessageBoxShell> list = active_aa_dialogs;
            synchronized (list) {
                active_aa_dialogs.add(mb);
            }
            mb.open(e -> {
                boolean kill_em = RememberedDecisionsManager.getRememberedDecision(remember_id) >= 0;
                List<MessageBoxShell> list = active_aa_dialogs;
                synchronized (list) {
                    active_aa_dialogs.remove(mb);
                    if (kill_em) {
                        Utils.execSWTThread(() -> {
                            for (MessageBoxShell x : active_aa_dialogs) {
                                x.close();
                            }
                        });
                        active_aa_dialogs.clear();
                    }
                }
            });
        } else {
            new MessageSlideShell(Display.getCurrent(), 2, MSG_ALREADY_EXISTS, null, new String[]{originating_loc, name, MessageText.getString(MSG_ALREADY_EXISTS_NAME)}, 3);
        }
    }

    public static interface ContentImageLoadedListener {
        public void contentImageLoaded(Image var1, boolean var2);
    }
}

