/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.Timer;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pifimpl.local.ui.config.ActionParameterImpl;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ColorParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ConfigSectionRepository;
import com.biglybt.pifimpl.local.ui.config.DirectoryParameterImpl;
import com.biglybt.pifimpl.local.ui.config.FileParameterImpl;
import com.biglybt.pifimpl.local.ui.config.FloatParameterImpl;
import com.biglybt.pifimpl.local.ui.config.HyperlinkParameterImpl;
import com.biglybt.pifimpl.local.ui.config.InfoParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntListParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterImplListener;
import com.biglybt.pifimpl.local.ui.config.ParameterTabFolderImpl;
import com.biglybt.pifimpl.local.ui.config.PasswordParameterImpl;
import com.biglybt.pifimpl.local.ui.config.StringListParameterImpl;
import com.biglybt.pifimpl.local.ui.config.StringParameterImpl;
import com.biglybt.pifimpl.local.ui.config.UIParameterImpl;
import com.biglybt.pifimpl.local.ui.config.UITextAreaImpl;
import com.biglybt.ui.config.BaseConfigSection;
import com.biglybt.ui.config.ConfigSectionConnection;
import com.biglybt.ui.config.ConfigSectionConnectionAdvanced;
import com.biglybt.ui.config.ConfigSectionConnectionDNS;
import com.biglybt.ui.config.ConfigSectionConnectionEncryption;
import com.biglybt.ui.config.ConfigSectionFile;
import com.biglybt.ui.config.ConfigSectionFileMove;
import com.biglybt.ui.config.ConfigSectionFilePerformance;
import com.biglybt.ui.config.ConfigSectionFileTorrentsDecoding;
import com.biglybt.ui.config.ConfigSectionLogging;
import com.biglybt.ui.config.ConfigSectionMode;
import com.biglybt.ui.config.ConfigSectionRebuildRunner;
import com.biglybt.ui.config.ConfigSectionSharing;
import com.biglybt.ui.config.ConfigSectionStartShutdown;
import com.biglybt.ui.config.ConfigSectionStats;
import com.biglybt.ui.config.ConfigSectionTracker;
import com.biglybt.ui.config.ConfigSectionTrackerClient;
import com.biglybt.ui.config.ConfigSectionTransfer;
import com.biglybt.ui.config.ConfigSectionTransferAutoSpeedClassic;
import com.biglybt.ui.config.ConfigSectionTransferAutoSpeedSelect;
import com.biglybt.ui.config.ConfigSectionTransferAutoSpeedV2;
import com.biglybt.ui.config.ConfigSectionTransferLAN;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BubbleTextBox;
import com.biglybt.ui.swt.components.LinkLabel;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.config.BooleanSwtParameter;
import com.biglybt.ui.swt.config.ButtonSwtParameter;
import com.biglybt.ui.swt.config.ColorSwtParameter;
import com.biglybt.ui.swt.config.DirectorySwtParameter;
import com.biglybt.ui.swt.config.FileSwtParameter;
import com.biglybt.ui.swt.config.FloatSwtParameter;
import com.biglybt.ui.swt.config.InfoSwtParameter;
import com.biglybt.ui.swt.config.IntListSwtParameter;
import com.biglybt.ui.swt.config.IntRadioListSwtParameter;
import com.biglybt.ui.swt.config.IntSwtParameter;
import com.biglybt.ui.swt.config.LinkSwtParameter;
import com.biglybt.ui.swt.config.PasswordSwtParameter;
import com.biglybt.ui.swt.config.StringAreaSwtParameter;
import com.biglybt.ui.swt.config.StringListSwtParameter;
import com.biglybt.ui.swt.config.StringSwtParameter;
import com.biglybt.ui.swt.config.TextAreaSwtParameter;
import com.biglybt.ui.swt.config.UISWTParameter;
import com.biglybt.ui.swt.config.actionperformer.DualChangeSelectionActionPerformer;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTParameterContext;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.MultiParameterImplListenerSWT;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.utils.FontUtils;
import com.biglybt.ui.swt.views.configsections.BaseConfigSectionSWT;
import com.biglybt.ui.swt.views.configsections.ConfigSectionBackupRestoreSWT;
import com.biglybt.ui.swt.views.configsections.ConfigSectionConnectionProxySWT;
import com.biglybt.ui.swt.views.configsections.ConfigSectionFileTorrentsSWT;
import com.biglybt.ui.swt.views.configsections.ConfigSectionIPFilterSWT;
import com.biglybt.ui.swt.views.configsections.ConfigSectionInterfaceAlertsSWT;
import com.biglybt.ui.swt.views.configsections.ConfigSectionInterfaceColorSWT;
import com.biglybt.ui.swt.views.configsections.ConfigSectionInterfaceDisplaySWT;
import com.biglybt.ui.swt.views.configsections.ConfigSectionInterfaceLanguageSWT;
import com.biglybt.ui.swt.views.configsections.ConfigSectionInterfaceLegacySWT;
import com.biglybt.ui.swt.views.configsections.ConfigSectionInterfacePasswordSWT;
import com.biglybt.ui.swt.views.configsections.ConfigSectionInterfaceSWT;
import com.biglybt.ui.swt.views.configsections.ConfigSectionInterfaceStartSWT;
import com.biglybt.ui.swt.views.configsections.ConfigSectionInterfaceTablesSWT;
import com.biglybt.ui.swt.views.configsections.ConfigSectionInterfaceTagsSWT;
import com.biglybt.ui.swt.views.configsections.ConfigSectionPluginsSWT;
import com.biglybt.ui.swt.views.configsections.ConfigSectionSecuritySWT;
import com.biglybt.ui.swt.views.configsections.ConfigSectionTrackerServerSWT;
import com.biglybt.util.JSONUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ConfigView
implements UISWTViewCoreEventListener,
ConfigSectionRepository.ConfigSectionRepositoryListener {
    private static final LogIDs LOGID = LogIDs.GUI;
    public static final String SELECT_KEY = "ConfigView.select_key";
    public static final String TREEITEMDATA_CONFIGSECTION = "ConfigSectionSWT";
    public static final String TREEITEMDATA_PANEL = "Panel";
    public static final String TREEITEMDATA_ITEM = "ConfigView.TreeItem";
    private static Font groupFont = null;
    final Map<TreeItem, BaseConfigSection> sections = new HashMap<TreeItem, BaseConfigSection>();
    final List<BaseConfigSection> sectionsCreated = new ArrayList<BaseConfigSection>(1);
    Composite cConfig;
    Composite cConfigSection;
    StackLayout layoutConfigSection;
    Label lHeader;
    Label usermodeHint;
    Font headerFont;
    Font filterFoundFont;
    Tree tree;
    ArrayList<BaseConfigSection> pluginSections;
    private Timer filterDelayTimer;
    private String filterText = "";
    private String startSection;
    private UISWTView swtView;
    ConfigSectionRebuildRunner rebuildSectionRunnable = configSection -> {
        boolean bl = Utils.execSWTThread(() -> this.ensureSectionBuilt(this.findTreeItem(configSection.getConfigSectionID()), true));
    };
    private static Comparator<Object> insert_point_comparator = new Comparator<Object>(){

        private String asString(Object o) {
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof Item) {
                return ((Item)o).getText();
            }
            throw new ClassCastException("object is not String or TreeItem: " + (o == null ? o : o.getClass().getName()));
        }

        @Override
        public int compare(Object o1, Object o2) {
            int result = String.CASE_INSENSITIVE_ORDER.compare(this.asString(o1), this.asString(o2));
            return result;
        }
    };

    public static String getSectionContext(Control c) {
        while (c != null) {
            TreeItem item = (TreeItem)c.getData(TREEITEMDATA_ITEM);
            if (item != null) {
                String str = "";
                while (item != null) {
                    str = "->" + item.getText() + str;
                    item = item.getParentItem();
                }
                return String.valueOf(MessageText.getString("ConfigView.title.full")) + str;
            }
            c = c.getParent();
        }
        return null;
    }

    private void initialize(Composite composite) {
        this.cConfig = new Composite(composite, 0);
        GridLayout configLayout = new GridLayout();
        configLayout.marginHeight = 0;
        configLayout.marginWidth = 0;
        this.cConfig.setLayout((Layout)configLayout);
        GridData gridData = new GridData(1808);
        this.cConfig.setLayoutData((Object)gridData);
        Label label = new Label(this.cConfig, 0x1000000);
        Messages.setLanguageText((Widget)label, "view.waiting.core");
        gridData = new GridData(1808);
        label.setLayoutData((Object)gridData);
        CoreFactory.addCoreRunningListener(core -> {
            boolean bl = Utils.execSWTThread(() -> {
                this._initialize(composite instanceof Shell);
                label.dispose();
                composite.layout(true, true);
            });
        });
    }

    private void _initialize(boolean applyClose) {
        try {
            Display d = this.cConfig.getDisplay();
            SashForm form = new SashForm(this.cConfig, 256);
            GridData gridData = new GridData(1808);
            form.setLayoutData((Object)gridData);
            Composite cLeftSide = Utils.createSkinnedComposite((Composite)form, 2048, new GridData(1808));
            FormLayout layout = new FormLayout();
            cLeftSide.setLayout((Layout)layout);
            BubbleTextBox bubbleTextBox = new BubbleTextBox(cLeftSide, 2948);
            Text txtFilter = bubbleTextBox.getTextWidget();
            Composite cFilterArea = bubbleTextBox.getMainWidget();
            txtFilter.addModifyListener(e -> this.filterTree(txtFilter.getText()));
            this.tree = new Tree(cLeftSide, 0);
            FontData[] fontData = this.tree.getFont().getFontData();
            fontData[0].setStyle(1);
            this.filterFoundFont = new Font((Device)d, fontData);
            FormData formData = new FormData();
            formData.bottom = new FormAttachment(100, -5);
            formData.left = new FormAttachment(0, 2);
            formData.right = new FormAttachment(100, -2);
            bubbleTextBox.setMessageAndLayout(MessageText.getString("ConfigView.filter"), formData);
            formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.bottom = new FormAttachment((Control)cFilterArea, -5);
            this.tree.setLayoutData((Object)formData);
            Composite cRightSide = new Composite((Composite)form, 0);
            GridLayout configLayout = new GridLayout();
            configLayout.marginHeight = 3;
            configLayout.marginWidth = 0;
            cRightSide.setLayout((Layout)configLayout);
            Composite cHeader = Utils.createSkinnedComposite(cRightSide, 2048, new GridData(772));
            configLayout = new GridLayout();
            configLayout.marginHeight = 3;
            configLayout.marginWidth = 0;
            configLayout.numColumns = 2;
            configLayout.marginRight = 5;
            cHeader.setLayout((Layout)configLayout);
            cHeader.setBackground(Colors.getSystemColor((Device)d, 26));
            cHeader.setForeground(Colors.getSystemColor((Device)d, 27));
            this.lHeader = new Label(cHeader, 0);
            this.lHeader.setBackground(Colors.getSystemColor((Device)d, 26));
            this.lHeader.setForeground(Colors.getSystemColor((Device)d, 27));
            fontData = this.lHeader.getFont().getFontData();
            fontData[0].setStyle(1);
            int fontHeight = (int)((double)fontData[0].getHeight() * 1.2);
            fontData[0].setHeight(fontHeight);
            this.headerFont = new Font((Device)d, fontData);
            this.lHeader.setFont(this.headerFont);
            gridData = new GridData(36);
            this.lHeader.setLayoutData((Object)gridData);
            this.usermodeHint = new Label(cHeader, 0);
            this.usermodeHint.setBackground(Colors.getSystemColor((Device)d, 26));
            this.usermodeHint.setForeground(Colors.getSystemColor((Device)d, 27));
            gridData = new GridData(644);
            this.usermodeHint.setLayoutData((Object)gridData);
            Menu headerMenu = new Menu((Decorations)cHeader.getShell(), 8);
            MenuItem menuShortCut = new MenuItem(headerMenu, 8);
            Messages.setLanguageText((Widget)menuShortCut, "label.set.shortcut");
            menuShortCut.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String id;
                    TreeItem tree_item = (TreeItem)ConfigView.this.lHeader.getData("TreeItem");
                    if (tree_item != null && (id = (String)tree_item.getData("ID")) != null) {
                        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("config.dialog.shortcut.title", "config.dialog.shortcut.text");
                        entryWindow.setPreenteredText(COConfigurationManager.getStringParameter("config.section.shortcut.key." + id, ""), false);
                        entryWindow.setTextLimit(1);
                        entryWindow.prompt(ew -> {
                            if (!ew.hasSubmittedInput()) {
                                return;
                            }
                            String sReturn = ew.getSubmittedInput();
                            if (sReturn != null) {
                                if ((sReturn = sReturn.trim()).length() > 1) {
                                    sReturn = sReturn.substring(0, 1);
                                }
                                COConfigurationManager.setParameter("config.section.shortcut.key." + id, sReturn);
                                ConfigView.this.updateHeader(tree_item);
                            }
                        });
                    }
                }
            });
            cHeader.setMenu(headerMenu);
            this.lHeader.setMenu(headerMenu);
            this.usermodeHint.setMenu(headerMenu);
            this.cConfigSection = new Composite(cRightSide, 0);
            this.layoutConfigSection = new StackLayout();
            this.cConfigSection.setLayout((Layout)this.layoutConfigSection);
            gridData = new GridData(1808);
            gridData.horizontalIndent = 2;
            this.cConfigSection.setLayoutData((Object)gridData);
            form.setWeights(new int[]{20, 80});
            this.tree.addListener(13, e -> {
                if (!(e.widget instanceof Tree)) {
                    return;
                }
                Tree tree = (Tree)e.widget;
                if (tree.getSelection().length > 0) {
                    this.showSection(tree.getSelection()[0], false, null);
                }
            });
            this.tree.addListener(14, e -> {
                TreeItem item = (TreeItem)e.item;
                if (item != null) {
                    item.setExpanded(!item.getExpanded());
                }
            });
        }
        catch (Exception e2) {
            Logger.log(new LogEvent(LOGID, "Error initializing ConfigView", e2));
            return;
        }
        this.pluginSections = ConfigSectionRepository.getInstance().getList();
        ConfigSectionRepository.getInstance().addListener(this);
        BaseConfigSection[] internalSections = new BaseConfigSection[]{new ConfigSectionMode(), new ConfigSectionStartShutdown(), new ConfigSectionBackupRestoreSWT(), new ConfigSectionConnection(), new ConfigSectionConnectionProxySWT(), new ConfigSectionConnectionAdvanced(), new ConfigSectionConnectionEncryption(), new ConfigSectionConnectionDNS(), new ConfigSectionTransfer(), new ConfigSectionTransferAutoSpeedSelect(), new ConfigSectionTransferAutoSpeedClassic(), new ConfigSectionTransferAutoSpeedV2(), new ConfigSectionTransferLAN(), new ConfigSectionFile(), new ConfigSectionFileMove(), new ConfigSectionFileTorrentsSWT(), new ConfigSectionFileTorrentsDecoding(), new ConfigSectionFilePerformance(), new ConfigSectionInterfaceSWT(), new ConfigSectionInterfaceLanguageSWT(), new ConfigSectionInterfaceStartSWT(), new ConfigSectionInterfaceDisplaySWT(), new ConfigSectionInterfaceTagsSWT(), new ConfigSectionInterfaceTablesSWT(), new ConfigSectionInterfaceColorSWT(), new ConfigSectionInterfaceAlertsSWT(), new ConfigSectionInterfacePasswordSWT(), new ConfigSectionInterfaceLegacySWT(), new ConfigSectionIPFilterSWT(), new ConfigSectionPluginsSWT(), new ConfigSectionStats(), new ConfigSectionTracker(), new ConfigSectionTrackerClient(), new ConfigSectionTrackerServerSWT(), new ConfigSectionSecuritySWT(), new ConfigSectionSharing(), new ConfigSectionLogging()};
        this.pluginSections.addAll(0, Arrays.asList(internalSections));
        for (BaseConfigSection section : this.pluginSections) {
            this.buildSection(section);
        }
        Display d = this.cConfig.getDisplay();
        Listener shortcut_listener = e -> {
            if ((e.stateMask & (SWT.MOD1 | 0x40000)) == 0 && e.keyCode != 0x400000) {
                return;
            }
            char key = e.character;
            if (key <= '\u001a' && key > '\u0000') {
                key = (char)(key + 96);
            }
            if ((e.stateMask & 0x20000) != 0) {
                key = Character.toUpperCase(key);
            }
            if (!Character.isISOControl(key)) {
                for (TreeItem ti : this.sections.keySet()) {
                    String shortcut;
                    String id;
                    if (ti.isDisposed() || (id = (String)ti.getData("ID")) == null || !(shortcut = COConfigurationManager.getStringParameter("config.section.shortcut.key." + id, "")).equals(String.valueOf(key))) continue;
                    this.selectSection(id, true);
                    e.doit = false;
                    break;
                }
            }
        };
        d.addFilter(1, shortcut_listener);
        this.cConfigSection.addDisposeListener(e -> d.removeFilter(1, shortcut_listener));
        if (applyClose) {
            this.initApplyCloseButton();
        } else {
            this.initSaveButton();
        }
        if (this.startSection != null && this.selectSection(this.startSection, false)) {
            return;
        }
        Runnable r = () -> {
            TreeItem selection = this.getLatestSelection();
            TreeItem[] items = new TreeItem[]{selection};
            this.tree.setSelection(items);
            this.showSection(selection, false, null);
        };
        if (Constants.isOSX) {
            Utils.execSWTThreadLater(250, r);
        } else {
            r.run();
        }
    }

    private void buildSection(BaseConfigSection section) {
        section.setRebuildRunner(this.rebuildSectionRunnable);
        String section_key = section.getSectionNameKey();
        String section_name = MessageText.getString(section_key);
        try {
            int position;
            TreeItem treeItemFound;
            String location = section.getParentSectionID();
            TreeItem treeItem = location == null || location.length() == 0 || location.equalsIgnoreCase("root") ? new TreeItem(this.tree, 0) : ((treeItemFound = this.findTreeItem(this.tree, location)) != null ? (location.equalsIgnoreCase("plugins") ? ((position = ConfigView.findInsertPointFor(section_name, treeItemFound)) == -1 ? new TreeItem(treeItemFound, 0) : new TreeItem(treeItemFound, 0, position)) : new TreeItem(treeItemFound, 0)) : new TreeItem(this.tree, 0));
            ScrolledComposite sc = new ScrolledComposite(this.cConfigSection, 768);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            sc.setLayoutData((Object)new GridData(1808));
            ScrollBar verticalBar = sc.getVerticalBar();
            if (verticalBar != null) {
                verticalBar.setIncrement(16);
            }
            sc.addListener(11, event2 -> ConfigView.setupSC((ScrolledComposite)event2.widget));
            Messages.setLanguageText((Widget)treeItem, section_key);
            treeItem.setData(TREEITEMDATA_PANEL, (Object)sc);
            treeItem.setData("ID", (Object)section.getConfigSectionID());
            treeItem.setData(TREEITEMDATA_CONFIGSECTION, (Object)section);
            sc.setData(TREEITEMDATA_ITEM, (Object)treeItem);
            this.sections.put(treeItem, section);
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "ConfigSection plugin '" + section.getConfigSectionID() + "' caused an error", e));
        }
    }

    @Override
    public void sectionAdded(BaseConfigSection section) {
        Utils.execSWTThread(() -> this.buildSection(section));
    }

    @Override
    public void sectionRemoved(BaseConfigSection section) {
        Utils.execSWTThread(() -> {
            for (Map.Entry<TreeItem, BaseConfigSection> entry : this.sections.entrySet()) {
                if (entry.getValue() != section) continue;
                TreeItem treeItem = entry.getKey();
                this.sections.remove(treeItem);
                ScrolledComposite composite = (ScrolledComposite)treeItem.getData(TREEITEMDATA_PANEL);
                if (composite != null && !composite.isDisposed()) {
                    composite.dispose();
                }
                if (treeItem.isDisposed()) break;
                treeItem.dispose();
                break;
            }
        });
    }

    private static void setupSC(ScrolledComposite sc) {
        ScrollBar verticalBar;
        if (sc == null) {
            return;
        }
        Composite c = (Composite)sc.getContent();
        if (c != null) {
            Point size1 = c.computeSize(sc.getClientArea().width, -1);
            Point size = c.computeSize(-1, size1.y);
            sc.setMinSize(size);
        }
        if ((verticalBar = sc.getVerticalBar()) != null) {
            verticalBar.setPageIncrement(sc.getSize().y);
        }
    }

    protected void filterTree(String text) {
        this.filterText = text;
        if (this.filterDelayTimer != null) {
            this.filterDelayTimer.destroy();
        }
        this.filterDelayTimer = new Timer("Filter");
        this.filterDelayTimer.addEvent(SystemTime.getCurrentTime() + 300L, event2 -> {
            this.filterDelayTimer.destroy();
            this.filterDelayTimer = null;
            Utils.execSWTThread(() -> {
                if (this.filterDelayTimer != null) {
                    return;
                }
                if (this.tree == null || this.tree.isDisposed()) {
                    return;
                }
                Shell shell = this.tree.getShell();
                if (shell != null) {
                    shell.setCursor(shell.getDisplay().getSystemCursor(1));
                }
                try {
                    ArrayList<TreeItem> foundItems = new ArrayList<TreeItem>();
                    TreeItem[] items = this.tree.getItems();
                    try {
                        this.tree.setRedraw(false);
                        TreeItem[] treeItemArray = items;
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem item = treeItemArray[n2];
                            item.setExpanded(false);
                            ++n2;
                        }
                        this.filterTree(items, this.filterText, foundItems);
                    }
                    finally {
                        this.tree.setRedraw(true);
                    }
                }
                finally {
                    TreeItem[] selection;
                    if (shell != null) {
                        shell.setCursor(null);
                    }
                    if ((selection = this.tree.getSelection()).length > 0) {
                        this.showSection(selection[0], false, null);
                    }
                }
            });
        });
    }

    protected void filterTree(TreeItem[] items, String text, ArrayList<TreeItem> foundItems) {
        text = text.toLowerCase();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.ensureSectionBuilt(item, false);
            ScrolledComposite composite = (ScrolledComposite)item.getData(TREEITEMDATA_PANEL);
            if (composite != null && !composite.isDisposed()) {
                if (text.length() > 0 && (item.getText().toLowerCase().contains(text) || ConfigView.compositeHasText((Composite)composite, text))) {
                    foundItems.add(item);
                    ConfigView.ensureExpandedTo(item);
                    item.setFont(this.filterFoundFont);
                } else {
                    item.setFont(null);
                }
                this.filterTree(item.getItems(), text, foundItems);
            }
            ++n2;
        }
    }

    private static void ensureExpandedTo(TreeItem item) {
        TreeItem itemParent = item.getParentItem();
        if (itemParent != null) {
            itemParent.setExpanded(true);
            ConfigView.ensureExpandedTo(itemParent);
        }
    }

    private static boolean compositeHasText(Composite composite, String text) {
        Control[] children;
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String item;
            int n3;
            int n4;
            String[] stringArray;
            String[] items;
            Control child = controlArray[n2];
            if (child instanceof Label) {
                if (((Label)child).getText().toLowerCase().contains(text)) {
                    return true;
                }
            } else if (child instanceof Group) {
                if (((Group)child).getText().toLowerCase().contains(text)) {
                    return true;
                }
            } else if (child instanceof Button) {
                if (((Button)child).getText().toLowerCase().contains(text)) {
                    return true;
                }
            } else if (child instanceof org.eclipse.swt.widgets.List) {
                stringArray = items = ((org.eclipse.swt.widgets.List)child).getItems();
                n4 = items.length;
                n3 = 0;
                while (n3 < n4) {
                    item = stringArray[n3];
                    if (item.toLowerCase().contains(text)) {
                        return true;
                    }
                    ++n3;
                }
            } else if (child instanceof Combo) {
                stringArray = items = ((Combo)child).getItems();
                n4 = items.length;
                n3 = 0;
                while (n3 < n4) {
                    item = stringArray[n3];
                    if (item.toLowerCase().contains(text)) {
                        return true;
                    }
                    ++n3;
                }
            } else if (child instanceof Text ? ((Text)child).getText().toLowerCase().contains(text) : child instanceof Spinner && ((Spinner)child).getText().toLowerCase().contains(text)) {
                return true;
            }
            if (child instanceof Composite && ConfigView.compositeHasText((Composite)child, text)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void saveLatestSelection(TreeItem item) {
        String path = "";
        while (item != null) {
            path = String.valueOf(item.getText()) + (path.length() == 0 ? "" : "$" + path);
            item = item.getParentItem();
        }
        COConfigurationManager.setParameter("ConfigView.section.last.selection", path);
    }

    private TreeItem getLatestSelection() {
        if (this.tree == null || this.tree.isDisposed()) {
            return null;
        }
        String path = COConfigurationManager.getStringParameter("ConfigView.section.last.selection", "");
        String[] bits = path.split("\\$");
        TreeItem[] items = this.tree.getItems();
        TreeItem current = null;
        boolean located = false;
        int i = 0;
        while (i < bits.length) {
            String bit = bits[i];
            boolean found = false;
            int j = 0;
            while (j < items.length) {
                if (items[j].getText().equals(bit)) {
                    current = items[j];
                    items = current.getItems();
                    found = true;
                    if (i != bits.length - 1) break;
                    located = true;
                    break;
                }
                ++j;
            }
            if (!found) break;
            ++i;
        }
        TreeItem result = located ? current : this.tree.getItems()[0];
        return result;
    }

    private void showSection(TreeItem section, boolean focus, Map options) {
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (this.showSectionSupport(section, focus, options)) {
            return;
        }
        if (userMode < 2) {
            COConfigurationManager.setParameter("User Mode", ++userMode);
            Utils.execSWTThreadLater(250, () -> this.showSection(section, focus, options));
        }
    }

    private boolean showSectionSupport(TreeItem section, boolean focus, Map options) {
        boolean result = true;
        ConfigView.saveLatestSelection(section);
        ScrolledComposite item = (ScrolledComposite)section.getData(TREEITEMDATA_PANEL);
        if (item != null && this.layoutConfigSection != null && this.cConfigSection != null) {
            String select;
            this.ensureSectionBuilt(section, true);
            this.layoutConfigSection.topControl = item;
            ConfigView.setupSC(item);
            this.cConfigSection.layout();
            this.updateHeader(section);
            if (options != null && (select = (String)options.get("select")) != null) {
                Control hit = this.highlightText2((Composite)item, select);
                if (hit != null) {
                    item.layout(true, true);
                    Utils.execSWTThreadLater(1, () -> {
                        Rectangle itemRect = item.getDisplay().map((Control)hit.getParent(), (Control)item, hit.getBounds());
                        Point origin = item.getOrigin();
                        origin.y = itemRect.y;
                        item.setOrigin(origin);
                    });
                } else {
                    result = false;
                }
            }
            if (focus) {
                this.layoutConfigSection.topControl.traverse(16);
            }
        }
        return result;
    }

    private void highlightText(Composite c, String text) {
        Control[] children;
        Control[] controlArray = children = c.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String item;
            int n3;
            int n4;
            String[] stringArray;
            String[] items;
            Control child = controlArray[n2];
            if (child instanceof Composite) {
                this.highlightText((Composite)child, text);
            }
            if (child instanceof Label) {
                if (((Label)child).getText().toLowerCase().contains(text)) {
                    this.highlightControl(child, text, true);
                }
            } else if (child instanceof Group) {
                if (((Group)child).getText().toLowerCase().contains(text)) {
                    this.highlightControl(child, text, true);
                }
            } else if (child instanceof Button) {
                if (((Button)child).getText().toLowerCase().contains(text)) {
                    this.highlightControl(child, text, true);
                }
            } else if (child instanceof org.eclipse.swt.widgets.List) {
                stringArray = items = ((org.eclipse.swt.widgets.List)child).getItems();
                n4 = items.length;
                n3 = 0;
                while (n3 < n4) {
                    item = stringArray[n3];
                    if (item.toLowerCase().contains(text)) {
                        this.highlightControl(child, text, true);
                        break;
                    }
                    ++n3;
                }
            } else if (child instanceof Combo) {
                stringArray = items = ((Combo)child).getItems();
                n4 = items.length;
                n3 = 0;
                while (n3 < n4) {
                    item = stringArray[n3];
                    if (item.toLowerCase().contains(text)) {
                        this.highlightControl(child, text, true);
                        break;
                    }
                    ++n3;
                }
            } else if (child instanceof Text) {
                if (((Text)child).getText().toLowerCase().contains(text)) {
                    this.highlightControl(child, text, true);
                }
            } else if (child instanceof Spinner && ((Spinner)child).getText().toLowerCase().contains(text)) {
                this.highlightControl(child, text, true);
            }
            ++n2;
        }
    }

    private Control highlightText2(Composite c, String select) {
        Control[] children;
        String cSelectKey = (String)c.getData(SELECT_KEY);
        if (select.equals(cSelectKey)) {
            this.highlightControl((Control)c, "", false);
            return null;
        }
        Control first_control = null;
        Control[] controlArray = children = c.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String select_key;
            Control x;
            Control child = controlArray[n2];
            if (child instanceof Composite && (x = this.highlightText2((Composite)child, select)) != null && first_control == null) {
                first_control = x;
            }
            if (select.equals(select_key = (String)child.getData(SELECT_KEY))) {
                if (first_control == null) {
                    first_control = child;
                }
                this.highlightControl(child, select, false);
            }
            ++n2;
        }
        return first_control;
    }

    private void highlightControl(Control control, String text, boolean type1) {
        control.setFont(this.headerFont);
        if (Constants.isWindows) {
            control.setBackground(Colors.getSystemColor((Device)control.getDisplay(), 29));
            control.setForeground(Colors.getSystemColor((Device)control.getDisplay(), 28));
        } else {
            control.setBackground(Utils.isDarkAppearanceNative() ? Colors.dark_grey : Colors.fadedYellow);
        }
        if (control instanceof Composite) {
            Composite comp2 = (Composite)control;
            Control[] controlArray = comp2.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control kid = controlArray[n2];
                this.highlightControl(kid, text, type1);
                ++n2;
            }
            if (type1) {
                this.highlightText(comp2, text);
            } else {
                this.highlightText2(comp2, text);
            }
        }
    }

    private void ensureSectionBuilt(TreeItem treeSection, boolean recreateIfAlreadyThere) {
        if (treeSection == null) {
            return;
        }
        ScrolledComposite item = (ScrolledComposite)treeSection.getData(TREEITEMDATA_PANEL);
        if (item == null) {
            return;
        }
        BaseConfigSection configSection = (BaseConfigSection)treeSection.getData(TREEITEMDATA_CONFIGSECTION);
        if (configSection == null) {
            return;
        }
        Control previous = item.getContent();
        if (previous instanceof Composite) {
            if (!recreateIfAlreadyThere) {
                return;
            }
            configSection.deleteConfigSection();
            this.sectionsCreated.remove(configSection);
            item.setContent(null);
            Utils.disposeComposite((Composite)previous, true);
        }
        Composite c = new Composite((Composite)item, 0);
        GridData gridData = new GridData(1808);
        c.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        c.setLayout((Layout)layout);
        int minUserMode = configSection.getMinUserMode();
        if (minUserMode > 0 && minUserMode > COConfigurationManager.getIntParameter("User Mode")) {
            ConfigView.buildUnavailableSection(c, COConfigurationManager.getIntParameter("User Mode"), minUserMode);
        } else {
            if (!configSection.isBuilt()) {
                configSection.build();
                configSection.postBuild();
            }
            Parameter[] paramArray = configSection.getParamArray();
            HashMap<ParameterImpl, BaseSwtParameter> mapParamToSwtParam = new HashMap<ParameterImpl, BaseSwtParameter>();
            if (paramArray.length > 0) {
                MultiParameterImplListenerSWT parameterImplListener = new MultiParameterImplListenerSWT(mapParamToSwtParam);
                ConfigView.buildScreen(c, paramArray, mapParamToSwtParam, parameterImplListener);
            }
            if (configSection instanceof BaseConfigSectionSWT) {
                ((BaseConfigSectionSWT)((Object)configSection)).configSectionCreate(c, mapParamToSwtParam);
            }
        }
        if (this.filterText.length() > 0) {
            this.highlightText(c, this.filterText);
        }
        this.sectionsCreated.add(configSection);
        item.setContent((Control)c);
        c.addListener(10, ev -> item.setData("LastScrollTime", (Object)SystemTime.getMonotonousTime()));
    }

    private static void buildUnavailableSection(Composite parent, int userMode, int requiredMode) {
        Label label = new Label(parent, 64);
        label.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 768));
        String[] modeKeys = new String[]{"ConfigView.section.mode.beginner", "ConfigView.section.mode.intermediate", "ConfigView.section.mode.advanced"};
        String param1 = requiredMode < modeKeys.length ? MessageText.getString(modeKeys[requiredMode]) : String.valueOf(requiredMode);
        String param2 = userMode < modeKeys.length ? MessageText.getString(modeKeys[userMode]) : String.valueOf(userMode);
        label.setText(MessageText.getString("ConfigView.notAvailableForMode", new String[]{param1, param2}));
    }

    private void updateHeader(TreeItem section) {
        String id;
        String shortcut;
        if (section == null || this.lHeader == null) {
            return;
        }
        this.lHeader.setData("TreeItem", (Object)section);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        int maxUsermode = 0;
        try {
            BaseConfigSection sect = this.sections.get(section);
            if (sect != null) {
                maxUsermode = sect.getMaxUserMode();
            }
        }
        catch (Error sect) {
            // empty catch block
        }
        String sc_text = (shortcut = COConfigurationManager.getStringParameter("config.section.shortcut.key." + (id = (String)section.getData("ID")), "")).length() > 0 ? "      (Ctrl+" + shortcut.charAt(0) + ")" : "";
        if (userMode < maxUsermode) {
            Messages.setLanguageText((Widget)this.usermodeHint, "ConfigView.higher.mode.available");
        } else {
            this.usermodeHint.setText("");
        }
        String sHeader = section.getText();
        section = section.getParentItem();
        while (section != null) {
            sHeader = String.valueOf(section.getText()) + " : " + sHeader;
            section = section.getParentItem();
        }
        this.lHeader.setText(" " + sHeader.replaceAll("&", "&&") + sc_text);
        this.lHeader.getParent().layout(true, true);
    }

    private static int findInsertPointFor(String name, Object structure) {
        TreeItem[] children;
        if (structure instanceof Tree) {
            children = ((Tree)structure).getItems();
        } else if (structure instanceof TreeItem) {
            children = ((TreeItem)structure).getItems();
        } else {
            return -1;
        }
        if (children.length == 0) {
            return -1;
        }
        int result = Arrays.binarySearch(children, name, insert_point_comparator);
        if (result > 0) {
            return result;
        }
        if ((result = -(result + 1)) == children.length) {
            result = -1;
        }
        return result;
    }

    public TreeItem findTreeItem(String ID) {
        return this.findTreeItem(null, ID);
    }

    private TreeItem findTreeItem(Tree tree, String ID) {
        TreeItem[] items;
        if (tree == null) {
            tree = this.tree;
        }
        if (tree == null) {
            return null;
        }
        TreeItem[] treeItemArray = items = tree.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            String itemID = (String)item.getData("ID");
            if (itemID != null && itemID.equalsIgnoreCase(ID)) {
                return item;
            }
            TreeItem itemFound = ConfigView.findTreeItem(item, ID);
            if (itemFound != null) {
                return itemFound;
            }
            ++n2;
        }
        return null;
    }

    private static TreeItem findTreeItem(TreeItem item, String ID) {
        TreeItem[] subItems;
        if (item == null || item.isDisposed()) {
            return null;
        }
        TreeItem[] treeItemArray = subItems = item.getItems();
        int n = subItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem subItem = treeItemArray[n2];
            String itemID = (String)subItem.getData("ID");
            if (itemID != null && itemID.equalsIgnoreCase(ID)) {
                return subItem;
            }
            TreeItem itemFound = ConfigView.findTreeItem(subItem, ID);
            if (itemFound != null) {
                return itemFound;
            }
            ++n2;
        }
        return null;
    }

    private void initSaveButton() {
        if (this.cConfig == null) {
            return;
        }
        Composite cButtons = new Composite(this.cConfig, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.numColumns = 2;
        cButtons.setLayout((Layout)gridLayout);
        cButtons.setLayoutData((Object)new GridData(768));
        LinkLabel ll = new LinkLabel(cButtons, "label.help", "https://wiki.biglybt.com/");
        GridData gridData = new GridData(768);
        ll.getlabel().setLayoutData((Object)gridData);
        final Button save = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)save, "ConfigView.button.save");
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 80;
        save.setLayoutData((Object)gridData);
        save.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                save.setFocus();
                Control fc = save.getDisplay().getFocusControl();
                if (fc != null) {
                    fc.traverse(16);
                }
                ConfigView.this.save();
            }
        });
    }

    private void initApplyCloseButton() {
        if (this.cConfig == null) {
            return;
        }
        Composite cButtons = new Composite(this.cConfig, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.numColumns = 2;
        cButtons.setLayout((Layout)gridLayout);
        cButtons.setLayoutData((Object)new GridData(128));
        final Button apply = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)apply, "Button.apply");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        apply.setLayoutData((Object)gridData);
        apply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                apply.setFocus();
                ConfigView.this.save();
            }
        });
        Button close = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)close, "Button.close");
        gridData = new GridData(32);
        gridData.widthHint = 80;
        close.setLayoutData((Object)gridData);
        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                apply.setFocus();
                ConfigView.this.save();
                apply.getShell().dispose();
            }
        });
    }

    private Composite getComposite() {
        return this.cConfig;
    }

    private void updateLanguage() {
        if (this.tree == null || this.tree.isDisposed()) {
            return;
        }
        TreeItem[] selection = this.tree.getSelection();
        if (selection.length > 0) {
            this.updateHeader(selection[0]);
        }
        if (this.swtView != null) {
            this.swtView.setTitle(ConfigView.getFullTitle());
        }
    }

    private void delete(boolean forRebuild) {
        this.save();
        for (BaseConfigSection section : this.sectionsCreated) {
            try {
                section.deleteConfigSection();
            }
            catch (Exception e) {
                Debug.out("Error while deleting config section", e);
            }
        }
        this.sectionsCreated.clear();
        if (this.pluginSections != null) {
            this.pluginSections.clear();
        }
        ConfigSectionRepository.getInstance().removeListener(this);
        if (this.tree != null && !this.tree.isDisposed()) {
            TreeItem[] items;
            TreeItem[] treeItemArray = items = this.tree.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                Composite c = (Composite)item.getData(TREEITEMDATA_PANEL);
                Utils.disposeComposite(c);
                item.setData(TREEITEMDATA_PANEL, null);
                item.setData(TREEITEMDATA_CONFIGSECTION, null);
                ++n2;
            }
        }
        Utils.disposeComposite(this.cConfig, !forRebuild);
        Utils.disposeSWTObjects(this.headerFont, this.filterFoundFont);
        this.headerFont = null;
        this.filterFoundFont = null;
    }

    private static String getFullTitle() {
        return MessageText.getString("ConfigView.title.full");
    }

    public boolean selectSection(String id, boolean focus) {
        TreeItem ti;
        int pos;
        if (this.tree == null || this.tree.isDisposed()) {
            return false;
        }
        Map args = null;
        if (id != null && (pos = id.indexOf(123)) != -1) {
            String json_args = id.substring(pos);
            args = JSONUtils.decodeJSON(json_args);
            id = id.substring(0, pos);
        }
        if ((ti = this.findTreeItem(id)) == null) {
            return false;
        }
        this.tree.setSelection(new TreeItem[]{ti});
        this.showSection(ti, focus, args);
        return true;
    }

    public void save() {
        COConfigurationManager.setParameter("updated", 1);
        COConfigurationManager.save();
        if (this.pluginSections != null) {
            for (BaseConfigSection section : this.pluginSections) {
                section.saveConfigSection();
            }
        }
    }

    private void dataSourceChanged(Object newDataSource) {
        if (newDataSource instanceof String) {
            this.startSection = (String)newDataSource;
            Utils.execSWTThread(() -> {
                boolean bl = this.selectSection(this.startSection, false);
            });
        }
    }

    @Override
    public boolean informOfDuplicates(int type) {
        return type == 1;
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(ConfigView.getFullTitle());
                break;
            }
            case 7: {
                this.delete(false);
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.updateLanguage();
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                break;
            }
        }
        return true;
    }

    private static void buildScreen(Composite main_tab, Parameter[] parameters, Map<ParameterImpl, BaseSwtParameter> mapParamToSwtParam, ParameterImplListener parameterImplListener) {
        int userMode = Utils.getUserMode();
        Composite curComposite = main_tab;
        HashMap<ParameterGroupImpl, Composite> group_map = new HashMap<ParameterGroupImpl, Composite>();
        HashMap<ParameterTabFolderImpl, CTabFolder> tab_folder_map = new HashMap<ParameterTabFolderImpl, CTabFolder>();
        HashMap<ParameterGroupImpl, Composite> tab_map = new HashMap<ParameterGroupImpl, Composite>();
        int i = 0;
        while (i < parameters.length) {
            ParameterImpl param = (ParameterImpl)parameters[i];
            if (param.getMinimumRequiredUserMode() <= userMode) {
                BaseSwtParameter swt_param;
                String labelText;
                ParameterGroupImpl pg = param.getGroup();
                if (pg != null && pg.getGroup() != null && group_map.get(pg.getGroup()) == null && tab_folder_map.get(pg.getGroup()) == null) {
                    --i;
                    param = new ParameterImpl(null, null){};
                    pg = pg.getGroup();
                    param.setGroup(pg);
                }
                if (pg == null) {
                    curComposite = main_tab;
                } else {
                    Composite comp2;
                    ParameterTabFolderImpl tab_folder = pg.getTabFolder();
                    if (tab_folder != null) {
                        curComposite = ConfigView.handleTabFolder(userMode, curComposite, group_map, tab_folder_map, tab_map, pg, tab_folder);
                    }
                    if ((comp2 = (Composite)group_map.get(pg)) == null) {
                        String refID;
                        GridLayout layout;
                        int numColumns;
                        Composite composite;
                        boolean nested;
                        ParameterGroupImpl pgParent = pg.getGroup();
                        boolean bl = nested = pgParent != null || tab_folder != null;
                        if (tab_folder == null && (composite = (Composite)group_map.get(pgParent)) != null) {
                            curComposite = composite;
                        }
                        Composite group_parent = nested ? curComposite : main_tab;
                        String resource_name = pg.getGroupTitleKey();
                        boolean use_composite = resource_name == null || tab_folder != null;
                        curComposite = use_composite ? new Composite(group_parent, 0) : Utils.createSkinnedGroup(group_parent, 0);
                        Canvas relatedControl = null;
                        if (!use_composite) {
                            Canvas gap;
                            relatedControl = gap = new Canvas(group_parent, 0);
                            gap.setData("gap", (Object)true);
                            GridData gridData = new GridData();
                            gridData.widthHint = 1;
                            gridData.heightHint = 2;
                            gridData.horizontalSpan = ((GridLayout)group_parent.getLayout()).numColumns;
                            gap.setLayoutData((Object)gridData);
                            Messages.setLanguageText((Widget)curComposite, resource_name);
                            if (groupFont == null) {
                                groupFont = FontUtils.getFontPercentOf(curComposite.getFont(), 1.25f);
                            }
                            curComposite.setFont(groupFont);
                        }
                        if (group_parent.getLayout() instanceof GridLayout) {
                            Control[] children;
                            GridData grid_data = new GridData(768);
                            grid_data.horizontalSpan = 2;
                            if (pg.getMinimumRequiredUserMode() > userMode) {
                                curComposite.setVisible(false);
                                grid_data.widthHint = 0;
                                grid_data.heightHint = 0;
                            }
                            grid_data.horizontalIndent = pg.getIndent() * 20;
                            if (!use_composite && (children = group_parent.getChildren()).length > 3 && children[children.length - 3].getData("gap") == null) {
                                grid_data.verticalIndent = 5;
                            }
                            curComposite.setLayoutData((Object)grid_data);
                        }
                        if ((numColumns = pg.getNumberColumns()) > 0) {
                            layout = new GridLayout();
                            layout.numColumns = numColumns * 2;
                            if (use_composite) {
                                layout.marginHeight = 0;
                                layout.marginWidth = 0;
                            } else {
                                layout.marginTop = 5;
                            }
                            curComposite.setLayout((Layout)layout);
                        } else {
                            layout = new RowLayout();
                            layout.marginLeft = pg.getIndent() * 20;
                            layout.marginRight = 0;
                            layout.spacing = 5;
                            layout.center = true;
                            curComposite.setLayout((Layout)layout);
                        }
                        group_map.put(pg, curComposite);
                        GroupSWTParameter swt_param2 = new GroupSWTParameter(curComposite, pg, (Control)relatedControl);
                        int indent = pg.getIndent();
                        if (indent > 0) {
                            swt_param2.setIndent(indent, param.isIndentFancy());
                        }
                        if ((refID = pg.getReferenceID()) != null) {
                            swt_param2.getMainControl().setData(SELECT_KEY, (Object)refID);
                        }
                        mapParamToSwtParam.put(pg, swt_param2);
                    } else {
                        curComposite = comp2;
                    }
                }
                String label_key = param.getLabelKey();
                if (label_key == null && (labelText = param.getLabelText()) != null) {
                    label_key = "!" + labelText + "!";
                }
                String key = param.getConfigKeyName();
                if (param instanceof HyperlinkParameterImpl) {
                    swt_param = new LinkSwtParameter(curComposite, (HyperlinkParameterImpl)param);
                } else if (param instanceof LabelParameterImpl) {
                    swt_param = new InfoSwtParameter(curComposite, (LabelParameterImpl)param);
                } else if (param instanceof BooleanParameterImpl) {
                    swt_param = new BooleanSwtParameter(curComposite, (BooleanParameterImpl)param);
                } else if (param instanceof IntParameterImpl) {
                    swt_param = new IntSwtParameter(curComposite, (IntParameterImpl)param);
                } else if (param instanceof FloatParameterImpl) {
                    swt_param = new FloatSwtParameter(curComposite, (FloatParameterImpl)param);
                } else if (param instanceof ColorParameterImpl) {
                    swt_param = new ColorSwtParameter(curComposite, (ColorParameterImpl)param);
                } else if (param instanceof StringParameterImpl) {
                    StringParameterImpl s_param = (StringParameterImpl)param;
                    int num_lines = s_param.getMultiLine();
                    swt_param = num_lines <= 1 ? new StringSwtParameter(curComposite, s_param) : new StringAreaSwtParameter(curComposite, s_param);
                } else if (param instanceof InfoParameterImpl) {
                    swt_param = new InfoSwtParameter(curComposite, (InfoParameterImpl)param);
                } else if (param instanceof StringListParameterImpl) {
                    swt_param = new StringListSwtParameter(curComposite, (StringListParameterImpl)param);
                } else if (param instanceof IntListParameterImpl) {
                    IntListParameterImpl il_param = (IntListParameterImpl)param;
                    int listType = il_param.getListType();
                    swt_param = listType == 2 || listType == 1 ? new IntRadioListSwtParameter(curComposite, il_param) : new IntListSwtParameter(curComposite, il_param);
                } else if (param instanceof PasswordParameterImpl) {
                    swt_param = new PasswordSwtParameter(curComposite, (PasswordParameterImpl)param);
                } else if (param instanceof FileParameterImpl) {
                    swt_param = new FileSwtParameter(curComposite, (FileParameterImpl)param);
                } else if (param instanceof DirectoryParameterImpl) {
                    swt_param = new DirectorySwtParameter(curComposite, (DirectoryParameterImpl)param);
                } else if (param instanceof ActionParameterImpl) {
                    ActionParameterImpl _param = (ActionParameterImpl)param;
                    swt_param = _param.getStyle() == 1 ? new ButtonSwtParameter(curComposite, (ActionParameterImpl)param) : new LinkSwtParameter(curComposite, (ActionParameterImpl)param);
                } else if (param instanceof UIParameterImpl) {
                    if (((UIParameterImpl)param).getContext() instanceof UISWTParameterContext) {
                        UISWTParameterContext context2 = (UISWTParameterContext)((UIParameterImpl)param).getContext();
                        Composite internal_composite = new Composite(curComposite, 0);
                        GridData gridData = new GridData(768);
                        gridData.horizontalSpan = param.getLabelKey() == null || param.getLabelText() == null ? 2 : 1;
                        internal_composite.setLayoutData((Object)gridData);
                        boolean initialised_component = true;
                        try {
                            context2.create(internal_composite);
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                            initialised_component = false;
                        }
                        swt_param = initialised_component ? new UISWTParameter((Control)internal_composite, param.getConfigKeyName()) : null;
                    } else {
                        swt_param = null;
                    }
                } else {
                    swt_param = param instanceof UITextAreaImpl ? new TextAreaSwtParameter(curComposite, (UITextAreaImpl)param) : null;
                }
                if (swt_param != null) {
                    String refID;
                    int indent = param.getIndent();
                    if (indent > 0) {
                        swt_param.setIndent(indent, param.isIndentFancy());
                    }
                    if ((refID = param.getReferenceID()) != null) {
                        swt_param.getMainControl().setData(SELECT_KEY, (Object)refID);
                    }
                    mapParamToSwtParam.put(param, swt_param);
                }
            }
            ++i;
        }
        Parameter[] parameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            BaseSwtParameter swtParameter;
            BaseSwtParameter swtParam;
            Parameter parameter = parameterArray[n2];
            ParameterImpl param = (ParameterImpl)parameter;
            param.addImplListener(parameterImplListener);
            if (!param.isEnabled() && (swtParam = mapParamToSwtParam.get(param)) != null) {
                swtParam.setEnabled(false);
            }
            if (!param.isVisible() && (swtParam = mapParamToSwtParam.get(param)) != null) {
                swtParam.setVisible(false);
            }
            ArrayList<BaseSwtParameter> swtParamsToEnable = new ArrayList<BaseSwtParameter>();
            List<Parameter> listEnableOnSelection = param.getEnabledOnSelectionParameters();
            for (Parameter enable_param : listEnableOnSelection) {
                BaseSwtParameter stuff = mapParamToSwtParam.get(enable_param);
                if (stuff == null) continue;
                swtParamsToEnable.add(stuff);
            }
            ArrayList<BaseSwtParameter> swtParamsToDisable = new ArrayList<BaseSwtParameter>();
            List<Parameter> listDisableOnSelection = param.getDisabledOnSelectionParameters();
            for (Parameter disable_param : listDisableOnSelection) {
                BaseSwtParameter swtParameter2 = mapParamToSwtParam.get(disable_param);
                if (swtParameter2 == null) continue;
                swtParamsToDisable.add(swtParameter2);
            }
            if (swtParamsToEnable.size() + swtParamsToDisable.size() > 0 && (swtParameter = mapParamToSwtParam.get(param)) instanceof BooleanSwtParameter) {
                DualChangeSelectionActionPerformer ap = new DualChangeSelectionActionPerformer(swtParamsToEnable.toArray(new BaseSwtParameter[0]), swtParamsToDisable.toArray(new BaseSwtParameter[0]));
                ((BooleanSwtParameter)swtParameter).setAdditionalActionPerformer(ap);
            }
            ++n2;
        }
    }

    private static Composite handleTabFolder(int userMode, Composite current_composite, Map<ParameterGroupImpl, Composite> group_map, Map<ParameterTabFolderImpl, CTabFolder> tab_folder_map, Map<ParameterGroupImpl, Composite> tab_map, ParameterGroupImpl pg, ParameterTabFolderImpl tab_folder) {
        Composite tab_composite;
        GridLayout layout;
        ParameterGroupImpl tab_group = tab_folder.getGroup();
        CTabFolder tf = tab_folder_map.get(tab_folder);
        if (tf == null) {
            String tg_resource;
            Composite tab_parent = current_composite;
            if (tab_group != null && (tg_resource = tab_group.getGroupTitleKey()) != null && (tab_parent = group_map.get(tab_group)) == null) {
                tab_parent = Utils.createSkinnedGroup(current_composite, 0);
                Messages.setLanguageText((Widget)tab_parent, tg_resource);
                if (current_composite.getLayout() instanceof GridLayout) {
                    GridData gridData = new GridData(768);
                    gridData.horizontalSpan = 2;
                    if (tab_group.getMinimumRequiredUserMode() > userMode) {
                        tab_parent.setVisible(false);
                        gridData.widthHint = 0;
                        gridData.heightHint = 0;
                    }
                    tab_parent.setLayoutData((Object)gridData);
                }
                layout = new GridLayout();
                layout.numColumns = tab_group.getNumberColumns() * 2;
                tab_parent.setLayout((Layout)layout);
                group_map.put(tab_group, tab_parent);
            }
            tf = new CTabFolder(tab_parent, 16384);
            tf.setBorderVisible(tab_group == null);
            tf.setTabHeight(20);
            GridData grid_data = new GridData(768);
            grid_data.horizontalSpan = 2;
            if (tab_folder.getMinimumRequiredUserMode() > userMode) {
                tf.setVisible(false);
                grid_data.widthHint = 0;
                grid_data.heightHint = 0;
            }
            tf.setLayoutData((Object)grid_data);
            tab_folder_map.put(tab_folder, tf);
        }
        if ((tab_composite = tab_map.get(pg)) == null) {
            CTabItem tab_item = new CTabItem(tf, 0);
            String tab_name = pg.getGroupTitleKey();
            if (tab_name != null) {
                Messages.setLanguageText((Widget)tab_item, tab_name);
            }
            tab_composite = new Composite((Composite)tf, 0);
            tab_item.setControl((Control)tab_composite);
            layout = new GridLayout();
            layout.numColumns = 2;
            tab_composite.setLayout((Layout)layout);
            GridData grid_data = new GridData(1808);
            if (pg.getMinimumRequiredUserMode() > userMode) {
                tab_composite.setVisible(false);
                grid_data.widthHint = 0;
                grid_data.heightHint = 0;
            }
            tab_composite.setLayoutData((Object)grid_data);
            if (tf.getItemCount() == 1) {
                tf.setSelection(tab_item);
            }
            tab_map.put(pg, tab_composite);
        }
        current_composite = tab_composite;
        return current_composite;
    }

    private static class GroupSWTParameter
    extends UISWTParameter {
        public GroupSWTParameter(Composite current_composite, ParameterGroupImpl pg, Control relatedControl) {
            super((Control)current_composite, pg);
            this.setRelatedControl(relatedControl);
        }
    }
}

