/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.impl.DownloadManagerAdapter;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HTTPUtils;
import com.biglybt.core.util.LinkFileMap;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.util.MenuItemManager;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.SimpleTextEntryWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.MenuFactory;
import com.biglybt.ui.swt.sharing.ShareUtils;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.shells.RevertFileLocationsWindow;
import com.biglybt.ui.swt.views.FilesView;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class FilesViewMenuUtil {
    public static final Object PRIORITY_HIGH = new Object();
    public static final Object PRIORITY_NORMAL = new Object();
    public static final Object PRIORITY_LOW = new Object();
    public static final Object PRIORITY_NUMERIC = new Object();
    public static final Object PRIORITY_NUMERIC_AUTO = new Object();
    public static final Object PRIORITY_SKIPPED = new Object();
    public static final Object PRIORITY_DELETE = new Object();
    private static LinkedList<Object[]> renameQueue = new LinkedList();
    private static boolean renameActive;
    private static final AsyncDispatcher moveCopyDispatcher;

    static {
        moveCopyDispatcher = new AsyncDispatcher("moveCopyFile");
    }

    public static void fillMenu(final TableView<?> tv, String columnName, final Menu menu, final DownloadManager[] manager_list, final com.biglybt.core.disk.DiskManagerFileInfo[][] files_list, final Map<com.biglybt.core.disk.DiskManagerFileInfo, String> structure_map, boolean multi_dl_view, boolean disable_multi_dialog_crud) {
        com.biglybt.pif.ui.menus.MenuItem[] menu_items;
        Shell shell = menu.getShell();
        final ArrayList<com.biglybt.core.disk.DiskManagerFileInfo> all_files = new ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>();
        com.biglybt.core.disk.DiskManagerFileInfo[][] diskManagerFileInfoArray = files_list;
        int n = files_list.length;
        int n2 = 0;
        while (n2 < n) {
            com.biglybt.core.disk.DiskManagerFileInfo[] files = diskManagerFileInfoArray[n2];
            all_files.addAll(Arrays.asList(files));
            ++n2;
        }
        boolean hasSelection = all_files.size() > 0;
        MenuItem itemOpen = null;
        if (!disable_multi_dialog_crud) {
            itemOpen = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemOpen, "FilesView.menu.open");
            Utils.setMenuItemImage(itemOpen, "run");
            menu.setDefaultItem(itemOpen);
            final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
            MenuItem itemExplore = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemExplore, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
            itemExplore.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    int i = all_files.size() - 1;
                    while (i >= 0) {
                        com.biglybt.core.disk.DiskManagerFileInfo info = (com.biglybt.core.disk.DiskManagerFileInfo)all_files.get(i);
                        if (info != null) {
                            ManagerUtils.open(info, use_open_containing_folder);
                        }
                        --i;
                    }
                }
            });
            itemExplore.setEnabled(hasSelection);
            Menu menuBrowse = new Menu((Decorations)menu.getShell(), 4);
            MenuItem itemBrowse = new MenuItem(menu, 64);
            Messages.setLanguageText((Widget)itemBrowse, "MyTorrentsView.menu.browse");
            itemBrowse.setMenu(menuBrowse);
            MenuItem itemBrowsePublic = new MenuItem(menuBrowse, 8);
            itemBrowsePublic.setText(String.valueOf(MessageText.getString("label.public")) + "...");
            itemBrowsePublic.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    int i = all_files.size() - 1;
                    while (i >= 0) {
                        com.biglybt.core.disk.DiskManagerFileInfo info = (com.biglybt.core.disk.DiskManagerFileInfo)all_files.get(i);
                        if (info != null) {
                            ManagerUtils.browse(info, false, true);
                        }
                        --i;
                    }
                }
            });
            MenuItem itemBrowseAnon = new MenuItem(menuBrowse, 8);
            itemBrowseAnon.setText(String.valueOf(MessageText.getString("label.anon")) + "...");
            itemBrowseAnon.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    int i = all_files.size() - 1;
                    while (i >= 0) {
                        com.biglybt.core.disk.DiskManagerFileInfo info = (com.biglybt.core.disk.DiskManagerFileInfo)all_files.get(i);
                        if (info != null) {
                            ManagerUtils.browse(info, true, true);
                        }
                        --i;
                    }
                }
            });
            new MenuItem(menuBrowse, 2);
            MenuItem itemBrowseURL = new MenuItem(menuBrowse, 8);
            Messages.setLanguageText((Widget)itemBrowseURL, "label.copy.url.to.clip");
            itemBrowseURL.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    Utils.getOffOfSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            String url = ManagerUtils.browse((com.biglybt.core.disk.DiskManagerFileInfo)all_files.get(0), true, false);
                            if (url != null) {
                                ClipboardCopy.copyToClipBoard(url);
                            }
                        }
                    });
                }
            });
            itemBrowseURL.setEnabled(all_files.size() == 1);
            if (itemBrowse != null) {
                itemBrowse.setEnabled(hasSelection);
            }
        }
        MenuItem itemRenameOrRetarget = null;
        MenuItem itemRenameOrRetargetBatch = null;
        MenuItem itemRename = null;
        MenuItem itemRetarget = null;
        itemRenameOrRetarget = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRenameOrRetarget, "FilesView.menu.rename");
        itemRenameOrRetarget.setData("rename", (Object)true);
        itemRenameOrRetarget.setData("retarget", (Object)true);
        itemRenameOrRetarget.setData("batch", (Object)false);
        itemRenameOrRetargetBatch = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRenameOrRetargetBatch, "FilesView.menu.rename.batch");
        itemRenameOrRetargetBatch.setData("rename", (Object)true);
        itemRenameOrRetargetBatch.setData("retarget", (Object)true);
        itemRenameOrRetargetBatch.setData("batch", (Object)true);
        itemRename = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRename, "FilesView.menu.rename_only");
        itemRename.setData("rename", (Object)true);
        itemRename.setData("retarget", (Object)false);
        itemRename.setData("batch", (Object)false);
        itemRetarget = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRetarget, "FilesView.menu.retarget");
        itemRetarget.setData("rename", (Object)false);
        itemRetarget.setData("retarget", (Object)true);
        itemRetarget.setData("batch", (Object)false);
        MenuItem itemRecheckFiles = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRecheckFiles, "label.recheck");
        MenuItem itemRevertFiles = new MenuItem(menu, 8);
        itemRevertFiles.setText(String.valueOf(MessageText.getString("MyTorrentsView.menu.revertfiles")) + "...");
        MenuItem itemLocateFiles = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemLocateFiles, "MyTorrentsView.menu.locatefiles");
        MenuItem itemfindMore = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemfindMore, "MyTorrentsView.menu.findmorelikethis");
        MenuItem itemClearLinks = null;
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode > 1) {
            itemClearLinks = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemClearLinks, "FilesView.menu.clear.links");
        }
        final MenuItem itemQuickView = new MenuItem(menu, 32);
        Messages.setLanguageText((Widget)itemQuickView, "MainWindow.menu.quick_view");
        itemQuickView.setEnabled(all_files.size() == 1 && Utils.isQuickViewSupported((com.biglybt.core.disk.DiskManagerFileInfo)all_files.get(0)));
        itemQuickView.setSelection(all_files.size() == 1 && Utils.isQuickViewActive((com.biglybt.core.disk.DiskManagerFileInfo)all_files.get(0)));
        itemQuickView.addListener(13, new Listener(){

            public void handleEvent(Event arg) {
                Utils.setQuickViewActive((com.biglybt.core.disk.DiskManagerFileInfo)all_files.get(0), itemQuickView.getSelection());
            }
        });
        if (manager_list.length == 1) {
            MenuFactory.addAlertsMenu(menu, manager_list[0], files_list[0]);
        }
        MenuItem itemPersonalShare = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemPersonalShare, "MyTorrentsView.menu.create_personal_share");
        MenuItem itemPriority = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemPriority, "FilesView.menu.setpriority");
        Menu menuPriority = new Menu((Decorations)shell, 4);
        itemPriority.setMenu(menuPriority);
        MenuItem itemHigh = new MenuItem(menuPriority, 64);
        itemHigh.setData("Priority", PRIORITY_HIGH);
        Messages.setLanguageText((Widget)itemHigh, "FilesView.menu.setpriority.high");
        MenuItem itemNormal = new MenuItem(menuPriority, 64);
        itemNormal.setData("Priority", PRIORITY_NORMAL);
        Messages.setLanguageText((Widget)itemNormal, "FilesView.menu.setpriority.normal");
        MenuItem itemLow = new MenuItem(menuPriority, 64);
        itemLow.setData("Priority", PRIORITY_LOW);
        Messages.setLanguageText((Widget)itemLow, "FileItem.low");
        MenuItem itemNumeric = new MenuItem(menuPriority, 64);
        itemNumeric.setData("Priority", PRIORITY_NUMERIC);
        Messages.setLanguageText((Widget)itemNumeric, "FilesView.menu.setpriority.numeric");
        MenuItem itemNumericAuto = new MenuItem(menuPriority, 64);
        itemNumericAuto.setData("Priority", PRIORITY_NUMERIC_AUTO);
        Messages.setLanguageText((Widget)itemNumericAuto, "FilesView.menu.setpriority.numeric.auto");
        MenuItem itemSkipped = new MenuItem(menuPriority, 64);
        itemSkipped.setData("Priority", PRIORITY_SKIPPED);
        Messages.setLanguageText((Widget)itemSkipped, "FilesView.menu.setpriority.skipped");
        MenuItem itemDelete = new MenuItem(menuPriority, 64);
        itemDelete.setData("Priority", PRIORITY_DELETE);
        Messages.setLanguageText((Widget)itemDelete, "wizard.multitracker.delete");
        if (all_files.size() == 1) {
            final com.biglybt.core.disk.DiskManagerFileInfo file = (com.biglybt.core.disk.DiskManagerFileInfo)all_files.get(0);
            final MenuItem itemSequential = new MenuItem(menu, 32);
            Messages.setLanguageText((Widget)itemSequential, "menu.sequential.file");
            PEPeerManager pm = file.getDownloadManager().getPeerManager();
            if (pm == null || file.getDownloaded() == file.getLength() || file.isSkipped()) {
                itemSequential.setEnabled(false);
            } else {
                final PiecePicker pp = pm.getPiecePicker();
                int info = pp.getSequentialInfo();
                itemSequential.setSelection(file.getFirstPieceNumber() == info - 1);
                itemSequential.addListener(13, new Listener(){

                    public void handleEvent(Event arg) {
                        if (itemSequential.getSelection()) {
                            pp.setSequentialAscendingFrom(file.getFirstPieceNumber());
                        } else {
                            pp.clearSequential();
                        }
                    }
                });
            }
            MenuItem setThumb = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)setThumb, "menu.set.file.as.thumb");
            final File actual_file = file.getFile(true);
            if (file.getDownloaded() != file.getLength() || actual_file.length() != file.getLength() || !HTTPUtils.isImageFileType(file.getExtension())) {
                setThumb.setEnabled(false);
            } else {
                setThumb.addListener(13, new Listener(){

                    public void handleEvent(Event arg) {
                        try {
                            byte[] thumbnail = FileUtil.readFileAsByteArray(actual_file);
                            String type = HTTPUtils.guessContentTypeFromFileType(file.getExtension());
                            try {
                                TOTorrent torrent = file.getDownloadManager().getTorrent();
                                PlatformTorrentUtils.setContentThumbnail(torrent, thumbnail, type);
                            }
                            catch (Throwable throwable) {}
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
            }
        }
        new MenuItem(menu, 2);
        if (!hasSelection) {
            itemOpen.setEnabled(false);
            itemPriority.setEnabled(false);
            itemRenameOrRetarget.setEnabled(false);
            itemRenameOrRetargetBatch.setEnabled(false);
            itemRename.setEnabled(false);
            itemRetarget.setEnabled(false);
            itemRevertFiles.setEnabled(false);
            itemRecheckFiles.setEnabled(false);
            itemLocateFiles.setEnabled(false);
            itemfindMore.setEnabled(false);
            if (itemClearLinks != null) {
                itemClearLinks.setEnabled(false);
            }
            itemPersonalShare.setEnabled(false);
            return;
        }
        boolean all_persistent = true;
        boolean open = true;
        boolean all_compact = true;
        boolean all_dnd_not_deleted = true;
        boolean all_high_pri = true;
        boolean all_normal_pri = true;
        boolean all_low_pri = true;
        boolean all_complete = true;
        boolean all_pad = true;
        boolean any_relocated = false;
        final ArrayList<com.biglybt.core.disk.DiskManagerFileInfo> files_with_links = new ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>();
        int j = 0;
        while (j < manager_list.length) {
            DownloadManager manager = manager_list[j];
            int dm_file_count = manager.getNumFileInfos();
            if (!manager.isPersistent()) {
                all_persistent = false;
            }
            com.biglybt.core.disk.DiskManagerFileInfo[] files = files_list[j];
            DownloadManagerState dm_state = manager.getDownloadState();
            int[] storage_types = manager.getStorageType(files);
            int i = 0;
            while (i < files.length) {
                File target;
                boolean isCompact;
                com.biglybt.core.disk.DiskManagerFileInfo file_info = files[i];
                TOTorrentFile tf = file_info.getTorrentFile();
                if (tf != null && !tf.isPadFile()) {
                    all_pad = false;
                }
                if (open && file_info.getAccessMode() != 1) {
                    open = false;
                }
                boolean bl = isCompact = storage_types[i] == 2 || storage_types[i] == 4;
                if (all_compact && !isCompact) {
                    all_compact = false;
                }
                if (all_dnd_not_deleted || all_high_pri || all_normal_pri || all_low_pri) {
                    if (file_info.isSkipped()) {
                        all_low_pri = false;
                        all_normal_pri = false;
                        all_high_pri = false;
                        if (isCompact) {
                            all_dnd_not_deleted = false;
                        }
                    } else {
                        all_dnd_not_deleted = false;
                        if (all_high_pri || all_normal_pri || all_low_pri) {
                            int file_pri = file_info.getPriority();
                            if (file_pri == 0) {
                                all_low_pri = false;
                                all_high_pri = false;
                            } else if (file_pri == 1) {
                                all_low_pri = false;
                                all_normal_pri = false;
                            } else if (file_pri == -1) {
                                all_high_pri = false;
                                all_normal_pri = false;
                            } else {
                                all_high_pri = false;
                                all_normal_pri = false;
                                all_low_pri = false;
                            }
                        }
                    }
                }
                File file_link = file_info.getFile(true);
                File file_nolink = file_info.getFile(false);
                if (file_info.getDownloaded() != file_info.getLength() || file_link.length() != file_info.getLength()) {
                    all_complete = false;
                }
                if (dm_file_count > 1 && !file_nolink.getAbsolutePath().equals(file_link.getAbsolutePath())) {
                    files_with_links.add(file_info);
                }
                if ((target = dm_state.getFileLink(file_info.getIndex(), file_nolink)) != null && target != file_nolink && !target.equals(file_nolink)) {
                    any_relocated = true;
                }
                ++i;
            }
            ++j;
        }
        if (all_pad) {
            itemPriority.setEnabled(false);
        }
        if (itemOpen != null) {
            itemOpen.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    int i = 0;
                    while (i < all_files.size()) {
                        com.biglybt.core.disk.DiskManagerFileInfo info = (com.biglybt.core.disk.DiskManagerFileInfo)all_files.get(i);
                        if (info != null && info.getAccessMode() == 1) {
                            Utils.launch(info);
                        }
                        ++i;
                    }
                }
            });
            itemOpen.setEnabled(open);
        }
        itemRenameOrRetarget.setEnabled(all_persistent);
        itemRenameOrRetargetBatch.setEnabled(all_persistent);
        itemRename.setEnabled(all_persistent);
        itemRetarget.setEnabled(all_persistent);
        itemPersonalShare.setEnabled(all_complete && all_files.size() == 1);
        itemSkipped.setEnabled(!all_dnd_not_deleted);
        itemHigh.setEnabled(!all_high_pri);
        itemNormal.setEnabled(!all_normal_pri);
        itemLow.setEnabled(!all_low_pri);
        itemDelete.setEnabled(!all_compact);
        Listener rename_listener = new Listener(){

            public void handleEvent(Event event2) {
                boolean rename_it = (Boolean)event2.widget.getData("rename");
                boolean retarget_it = (Boolean)event2.widget.getData("retarget");
                boolean batch = (Boolean)event2.widget.getData("batch");
                FilesViewMenuUtil.rename(tv, all_files.toArray(new Object[all_files.size()]), structure_map, rename_it, retarget_it, batch);
            }
        };
        itemRenameOrRetargetBatch.addListener(13, rename_listener);
        itemRenameOrRetarget.addListener(13, rename_listener);
        itemRename.addListener(13, rename_listener);
        itemRetarget.addListener(13, rename_listener);
        itemLocateFiles.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                ManagerUtils.locateFiles(manager_list, files_list, menu.getShell());
            }
        });
        itemLocateFiles.setEnabled(true);
        if (ManagerUtils.canFindMoreLikeThis()) {
            itemfindMore.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    ManagerUtils.findMoreLikeThis((com.biglybt.core.disk.DiskManagerFileInfo)all_files.get(0), menu.getShell());
                }
            });
            itemfindMore.setEnabled(all_files.size() == 1);
        }
        itemRecheckFiles.setEnabled(true);
        itemRecheckFiles.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                FilesViewMenuUtil.recheckFiles(all_files);
            }
        });
        itemRevertFiles.setEnabled(any_relocated);
        itemRevertFiles.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                FilesViewMenuUtil.revertFiles(tv, all_files);
            }
        });
        if (itemClearLinks != null) {
            itemClearLinks.setEnabled(files_with_links.size() > 0);
            itemClearLinks.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    for (com.biglybt.core.disk.DiskManagerFileInfo file : files_with_links) {
                        file.setLink(null, true);
                    }
                    FilesViewMenuUtil.invalidateRows(tv, files_with_links);
                }
            });
        }
        itemPersonalShare.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                HashMap<String, String> properties = new HashMap<String, String>();
                if (Utils.setPeronalShare(properties)) {
                    int i = 0;
                    while (i < all_files.size()) {
                        com.biglybt.core.disk.DiskManagerFileInfo file_info = (com.biglybt.core.disk.DiskManagerFileInfo)all_files.get(i);
                        File file = file_info.getFile(true);
                        if (file.isFile()) {
                            ShareUtils.shareFile(file.getAbsolutePath(), properties);
                        } else if (file.isDirectory()) {
                            ShareUtils.shareDir(file.getAbsolutePath(), properties);
                        }
                        ++i;
                    }
                }
            }
        });
        Listener priorityListener = new Listener(){

            public void handleEvent(Event event2) {
                final Object priority = event2.widget.getData("Priority");
                Utils.getOffOfSWTThread(new AERunnable(){

                    @Override
                    public void runSupport() {
                        FilesViewMenuUtil.changePriority(priority, all_files);
                    }
                });
            }
        };
        itemNumeric.addListener(13, priorityListener);
        itemNumericAuto.addListener(13, priorityListener);
        itemHigh.addListener(13, priorityListener);
        itemNormal.addListener(13, priorityListener);
        itemLow.addListener(13, priorityListener);
        itemSkipped.addListener(13, priorityListener);
        itemDelete.addListener(13, priorityListener);
        if (columnName.equals("unopened")) {
            MenuItem toggle = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)toggle, "label.toggle.new.marker");
            toggle.addListener(13, new Listener(){

                public void handleEvent(Event arg) {
                    int i = 0;
                    while (i < all_files.size()) {
                        com.biglybt.core.disk.DiskManagerFileInfo file = (com.biglybt.core.disk.DiskManagerFileInfo)all_files.get(i);
                        DownloadManager dm = file.getDownloadManager();
                        int ff = dm.getDownloadState().getFileFlags(file.getIndex());
                        dm.getDownloadState().setFileFlags(file.getIndex(), ff ^= 1);
                        ++i;
                    }
                }
            });
            new MenuItem(menu, 2);
        }
        if (all_files.size() == 1 && multi_dl_view) {
            DownloadManager dm = ((com.biglybt.core.disk.DiskManagerFileInfo)all_files.get(0)).getDownloadManager();
            if (dm != null) {
                MenuItem show = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)show, "menu.show.download");
                show.addListener(13, e -> dm.requestAttention());
            }
            new MenuItem(menu, 2);
        }
        if ((menu_items = MenuItemManager.getInstance().getAllAsArray("file_context")).length > 0) {
            Object[] fileInfos = new DiskManagerFileInfo[all_files.size()];
            int i = 0;
            while (i < all_files.size()) {
                fileInfos[i] = (DiskManagerFileInfo)PluginCoreUtils.convert(all_files.get(i), false);
                ++i;
            }
            MenuBuildUtils.addPluginMenuItems(menu_items, menu, false, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(fileInfos));
        }
    }

    /*
     * Exception decompiling
     */
    public static void rename(TableView tv, Object[] datasources, Map<com.biglybt.core.disk.DiskManagerFileInfo, String> structure_map, boolean rename_it, boolean retarget_it, boolean batch) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void invalidateRows(TableView tv, List<com.biglybt.core.disk.DiskManagerFileInfo> files) {
        if (tv == null) {
            return;
        }
        HashSet<TableRowCore> done = new HashSet<TableRowCore>();
        TableRowCore[] all_rows = null;
        for (com.biglybt.core.disk.DiskManagerFileInfo file : files) {
            TableRowCore row;
            block16: {
                row = tv.getRow(file);
                if (row == null) {
                    int n;
                    DownloadManager dm = file.getDownloadManager();
                    row = tv.getRow(dm);
                    if (row != null) {
                        TableRowCore[] subrows = row.getSubRowsWithNull();
                        if (subrows != null) {
                            TableRowCore[] tableRowCoreArray = subrows;
                            n = subrows.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TableRowCore sr = tableRowCoreArray[n2];
                                if (sr.getDataSource(true) == file) {
                                    row = sr;
                                    break;
                                }
                                ++n2;
                            }
                        }
                    } else if (file instanceof FilesView.FilesViewTreeNode) {
                        FilesView.FilesViewTreeNode node = (FilesView.FilesViewTreeNode)((Object)file);
                        while ((node = node.getParent()) != null) {
                            TableRowCore[] subrows;
                            row = tv.getRow(node);
                            if (row == null || (subrows = row.getSubRowsWithNull()) == null) continue;
                            TableRowCore[] tableRowCoreArray = subrows;
                            int n3 = subrows.length;
                            n = 0;
                            while (n < n3) {
                                TableRowCore sr = tableRowCoreArray[n];
                                if (sr.getDataSource(true) == file) {
                                    row = sr;
                                    break block16;
                                }
                                ++n;
                            }
                        }
                    } else {
                        if (all_rows == null) {
                            all_rows = tv.getRowsAndSubRows(false);
                        }
                        TableRowCore[] tableRowCoreArray = all_rows;
                        int n4 = all_rows.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            com.biglybt.core.disk.DiskManagerFileInfo f;
                            TableRowCore r = tableRowCoreArray[n5];
                            Object o = r.getDataSource(true);
                            if (o instanceof com.biglybt.core.disk.DiskManagerFileInfo && (f = (com.biglybt.core.disk.DiskManagerFileInfo)o).getDownloadManager() == dm && f.getIndex() == file.getIndex()) {
                                row = r;
                                break;
                            }
                            ++n5;
                        }
                    }
                }
            }
            if (row == null || done.contains(row)) continue;
            done.add(row);
            row.invalidate(true);
            row.refresh(true);
        }
    }

    public static void recheckFiles(List<com.biglybt.core.disk.DiskManagerFileInfo> file_list) {
        if (file_list == null || file_list.size() == 0) {
            return;
        }
        IdentityHashMap<DownloadManager, ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>> mapDMtoDMFI = new IdentityHashMap<DownloadManager, ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>>();
        for (com.biglybt.core.disk.DiskManagerFileInfo file : file_list) {
            DownloadManager dm = file.getDownloadManager();
            ArrayList<com.biglybt.core.disk.DiskManagerFileInfo> listFileInfos = (ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>)mapDMtoDMFI.get(dm);
            if (listFileInfos == null) {
                listFileInfos = new ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>(1);
                mapDMtoDMFI.put(dm, listFileInfos);
            }
            listFileInfos.add(file);
        }
        for (final DownloadManager dm : mapDMtoDMFI.keySet()) {
            boolean was_stopped;
            ArrayList list = (ArrayList)mapDMtoDMFI.get(dm);
            com.biglybt.core.disk.DiskManagerFileInfo[] fileInfos = list.toArray(new com.biglybt.core.disk.DiskManagerFileInfo[0]);
            final boolean was_force = dm.isForceStart();
            final boolean was_paused = dm.isPaused();
            int state = dm.getState();
            boolean bl = was_stopped = state == 70 || state == 65 || state == 100;
            if (!was_stopped) {
                dm.pause(true);
            }
            com.biglybt.core.disk.DiskManagerFileInfo[] diskManagerFileInfoArray = fileInfos;
            int n = fileInfos.length;
            int n2 = 0;
            while (n2 < n) {
                com.biglybt.core.disk.DiskManagerFileInfo file = diskManagerFileInfoArray[n2];
                file.recheck();
                ++n2;
            }
            DownloadManagerAdapter l = new DownloadManagerAdapter(){
                boolean is_ready;

                @Override
                public void stateChanged(DownloadManager manager, int state) {
                    if (state == 100) {
                        if (!was_force) {
                            dm.setForceStart(false);
                        }
                        dm.removeListener(this);
                    } else if (state == 40) {
                        this.is_ready = true;
                    } else if (this.is_ready && (state == 50 || state == 60 || state == 75)) {
                        dm.removeListener(this);
                        if (!was_force) {
                            dm.setForceStart(false);
                        }
                        if (was_paused) {
                            ManagerUtils.asyncPause(dm);
                        } else if (was_stopped) {
                            ManagerUtils.asyncStop(dm, 70);
                        }
                    } else if (this.is_ready && state == 70) {
                        dm.removeListener(this);
                    }
                }
            };
            dm.addListener(l);
            if (was_paused) {
                dm.resume();
            } else {
                dm.stopIt(75, false, false);
            }
            dm.setForceStart(true);
        }
    }

    public static void changePriority(Object type, List<com.biglybt.core.disk.DiskManagerFileInfo> file_list) {
        FilesViewMenuUtil.changePriority(type, file_list, true);
    }

    public static void changePriority(Object type, List<com.biglybt.core.disk.DiskManagerFileInfo> file_list, boolean prompt) {
        if (file_list == null || file_list.size() == 0) {
            return;
        }
        if (type == PRIORITY_NUMERIC) {
            FilesViewMenuUtil.changePriorityManual(file_list);
            return;
        }
        if (type == PRIORITY_NUMERIC_AUTO) {
            FilesViewMenuUtil.changePriorityAuto(file_list);
            return;
        }
        IdentityHashMap<DownloadManager, ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>> mapDMtoDMFI = new IdentityHashMap<DownloadManager, ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>>();
        for (com.biglybt.core.disk.DiskManagerFileInfo file : file_list) {
            DownloadManager dm = file.getDownloadManager();
            ArrayList<com.biglybt.core.disk.DiskManagerFileInfo> listFileInfos = (ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>)mapDMtoDMFI.get(dm);
            if (listFileInfos == null) {
                listFileInfos = new ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>(1);
                mapDMtoDMFI.put(dm, listFileInfos);
            }
            listFileInfos.add(file);
        }
        boolean skipped = type == PRIORITY_SKIPPED || type == PRIORITY_DELETE;
        boolean delete_action = type == PRIORITY_DELETE;
        for (DownloadManager dm : mapDMtoDMFI.keySet()) {
            ArrayList list = (ArrayList)mapDMtoDMFI.get(dm);
            com.biglybt.core.disk.DiskManagerFileInfo[] fileInfos = list.toArray(new com.biglybt.core.disk.DiskManagerFileInfo[0]);
            if (type == PRIORITY_NORMAL) {
                dm.setFilePriorities(fileInfos, 0);
            } else if (type == PRIORITY_HIGH) {
                dm.setFilePriorities(fileInfos, 1);
            } else if (type == PRIORITY_LOW) {
                dm.setFilePriorities(fileInfos, -1);
            }
            boolean paused = FilesViewMenuUtil.setSkipped(dm, fileInfos, skipped, delete_action ? 1 : 0, prompt);
            if (!paused) continue;
            dm.resume();
        }
    }

    public static void setSkipped(List<com.biglybt.core.disk.DiskManagerFileInfo> file_list, boolean skipped, int delete_action, boolean prompt) {
        if (file_list == null || file_list.size() == 0) {
            return;
        }
        IdentityHashMap<DownloadManager, ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>> mapDMtoDMFI = new IdentityHashMap<DownloadManager, ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>>();
        for (com.biglybt.core.disk.DiskManagerFileInfo file : file_list) {
            DownloadManager dm = file.getDownloadManager();
            ArrayList<com.biglybt.core.disk.DiskManagerFileInfo> listFileInfos = (ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>)mapDMtoDMFI.get(dm);
            if (listFileInfos == null) {
                listFileInfos = new ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>(1);
                mapDMtoDMFI.put(dm, listFileInfos);
            }
            listFileInfos.add(file);
        }
        for (DownloadManager dm : mapDMtoDMFI.keySet()) {
            ArrayList list;
            com.biglybt.core.disk.DiskManagerFileInfo[] fileInfos;
            boolean paused = FilesViewMenuUtil.setSkipped(dm, fileInfos = (list = (ArrayList)mapDMtoDMFI.get(dm)).toArray(new com.biglybt.core.disk.DiskManagerFileInfo[0]), skipped, delete_action, prompt);
            if (!paused) continue;
            dm.resume();
        }
    }

    private static void changePriorityManual(final List<com.biglybt.core.disk.DiskManagerFileInfo> file_list) {
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("FilesView.dialog.priority.title", "FilesView.dialog.priority.text");
        entryWindow.prompt(new UIInputReceiverListener(){

            @Override
            public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                if (!entryWindow.hasSubmittedInput()) {
                    return;
                }
                String sReturn = entryWindow.getSubmittedInput();
                if (sReturn == null) {
                    return;
                }
                int priority = 0;
                try {
                    priority = Integer.valueOf(sReturn);
                }
                catch (NumberFormatException er) {
                    Debug.out("Invalid priority: " + sReturn);
                    new MessageBoxShell(33, MessageText.getString("FilePriority.invalid.title"), MessageText.getString("FilePriority.invalid.text", new String[]{sReturn})).open(null);
                    return;
                }
                IdentityHashMap<DownloadManager, ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>> mapDMtoDMFI = new IdentityHashMap<DownloadManager, ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>>();
                for (com.biglybt.core.disk.DiskManagerFileInfo file : file_list) {
                    DownloadManager dm = file.getDownloadManager();
                    ArrayList<com.biglybt.core.disk.DiskManagerFileInfo> listFileInfos = (ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>)mapDMtoDMFI.get(dm);
                    if (listFileInfos == null) {
                        listFileInfos = new ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>(1);
                        mapDMtoDMFI.put(dm, listFileInfos);
                    }
                    listFileInfos.add(file);
                    file.setPriority(priority);
                }
                for (DownloadManager dm : mapDMtoDMFI.keySet()) {
                    ArrayList list;
                    com.biglybt.core.disk.DiskManagerFileInfo[] fileInfos;
                    boolean paused = FilesViewMenuUtil.setSkipped(dm, fileInfos = (list = (ArrayList)mapDMtoDMFI.get(dm)).toArray(new com.biglybt.core.disk.DiskManagerFileInfo[0]), false, 0, true);
                    if (!paused) continue;
                    dm.resume();
                }
            }
        });
    }

    private static void changePriorityAuto(List<com.biglybt.core.disk.DiskManagerFileInfo> file_list) {
        int priority = 0;
        IdentityHashMap<DownloadManager, ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>> mapDMtoDMFI = new IdentityHashMap<DownloadManager, ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>>();
        for (com.biglybt.core.disk.DiskManagerFileInfo diskManagerFileInfo : file_list) {
            DownloadManager dm = diskManagerFileInfo.getDownloadManager();
            ArrayList<com.biglybt.core.disk.DiskManagerFileInfo> listFileInfos = (ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>)mapDMtoDMFI.get(dm);
            if (listFileInfos == null) {
                listFileInfos = new ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>(1);
                mapDMtoDMFI.put(dm, listFileInfos);
            }
            listFileInfos.add(diskManagerFileInfo);
            diskManagerFileInfo.setPriority(priority++);
        }
        for (Map.Entry entry : mapDMtoDMFI.entrySet()) {
            com.biglybt.core.disk.DiskManagerFileInfo[] all_files = ((DownloadManager)entry.getKey()).getDiskManagerFileInfoSet().getFiles();
            ArrayList files = (ArrayList)entry.getValue();
            int next_priority = 0;
            if (all_files.length != files.size()) {
                HashSet<Integer> affected_indexes = new HashSet<Integer>();
                for (com.biglybt.core.disk.DiskManagerFileInfo file : files) {
                    affected_indexes.add(file.getIndex());
                }
                com.biglybt.core.disk.DiskManagerFileInfo[] diskManagerFileInfoArray = all_files;
                int n = all_files.length;
                int n2 = 0;
                while (n2 < n) {
                    com.biglybt.core.disk.DiskManagerFileInfo file;
                    file = diskManagerFileInfoArray[n2];
                    if (!affected_indexes.contains(file.getIndex()) && !file.isSkipped()) {
                        next_priority = Math.max(next_priority, file.getPriority() + 1);
                    }
                    ++n2;
                }
            }
            next_priority += files.size();
            for (com.biglybt.core.disk.DiskManagerFileInfo file : files) {
                file.setPriority(--next_priority);
            }
        }
        for (DownloadManager downloadManager : mapDMtoDMFI.keySet()) {
            ArrayList list;
            com.biglybt.core.disk.DiskManagerFileInfo[] fileInfos;
            boolean paused = FilesViewMenuUtil.setSkipped(downloadManager, fileInfos = (list = (ArrayList)mapDMtoDMFI.get(downloadManager)).toArray(new com.biglybt.core.disk.DiskManagerFileInfo[0]), false, 0, true);
            if (!paused) continue;
            downloadManager.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void askForRenameFilenameAndExec(com.biglybt.core.disk.DiskManagerFileInfo fileInfo2, TableView tv) {
        LinkedList<Object[]> linkedList = renameQueue;
        synchronized (linkedList) {
            renameQueue.add(new Object[]{fileInfo2, tv});
        }
        FilesViewMenuUtil.processRenameQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processRenameQueue() {
        Object[] entry = null;
        LinkedList<Object[]> linkedList = renameQueue;
        synchronized (linkedList) {
            if (!renameActive && !renameQueue.isEmpty()) {
                entry = renameQueue.removeFirst();
                renameActive = true;
            }
        }
        if (entry != null) {
            FilesViewMenuUtil.askForRenameFilenameAndExecSupport((com.biglybt.core.disk.DiskManagerFileInfo)entry[0], (TableView)entry[1]);
        }
    }

    private static void askForRenameFilenameAndExecSupport(final com.biglybt.core.disk.DiskManagerFileInfo fileInfo2, final TableView tv) {
        SimpleTextEntryWindow dialog = new SimpleTextEntryWindow("FilesView.rename.filename.title", "FilesView.rename.filename.text");
        dialog.setParentShell(Utils.findAnyShell());
        dialog.setRememberLocationSize("file.rename.dialog.pos");
        dialog.setEnableSpecialEscapeHandling(true);
        String file_name = fileInfo2.getFile(true).getName();
        dialog.setPreenteredText(file_name, false);
        int pos = file_name.lastIndexOf(46);
        if (pos > 0) {
            String suffix = fileInfo2.getDownloadManager().getDownloadState().getAttribute("incompfilesuffix");
            if (suffix != null && file_name.substring(pos).equals(suffix)) {
                --pos;
                while (pos > 0 && file_name.charAt(pos) != '.') {
                    --pos;
                }
            }
            if (pos > 0) {
                int[] nArray = new int[2];
                nArray[1] = pos;
                dialog.selectPreenteredTextRange(nArray);
            }
        }
        dialog.allowEmptyInput(false);
        dialog.prompt(new UIInputReceiverListener(){
            boolean fired = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void UIInputReceiverClosed(UIInputReceiver receiver) {
                LinkedList linkedList = renameQueue;
                synchronized (linkedList) {
                    if (this.fired) {
                        return;
                    }
                    this.fired = true;
                    renameActive = false;
                    if (!receiver.hasSubmittedInput()) {
                        if (receiver.userHitEscape()) {
                            renameQueue.clear();
                        } else {
                            FilesViewMenuUtil.processRenameQueue();
                        }
                        return;
                    }
                }
                File existing_file = fileInfo2.getFile(true);
                File f_target = new File(existing_file.getParentFile(), receiver.getSubmittedInput());
                final DownloadManager manager = fileInfo2.getDownloadManager();
                final boolean needsUnpause = manager.pause(true);
                FilesViewMenuUtil.moveFile(fileInfo2.getDownloadManager(), fileInfo2, existing_file, f_target, false, new Runnable(){

                    @Override
                    public void run() {
                        if (needsUnpause) {
                            manager.resume();
                        }
                        FilesViewMenuUtil.invalidateRows(tv, Collections.singletonList(fileInfo2));
                        FilesViewMenuUtil.processRenameQueue();
                    }
                });
            }
        });
    }

    private static String askForRetargetedFilename(com.biglybt.core.disk.DiskManagerFileInfo fileInfo2) {
        int flag = Constants.isOSX ? 8192 : 0;
        FileDialog fDialog = new FileDialog(Utils.findAnyShell(), 0x20000 | flag);
        File existing_file = fileInfo2.getFile(true);
        fDialog.setFilterPath(existing_file.getParent());
        fDialog.setFileName(existing_file.getName());
        fDialog.setText(MessageText.getString("FilesView.rename.choose.path"));
        return fDialog.open();
    }

    private static String askForSaveDirectory(com.biglybt.core.disk.DiskManagerFileInfo fileInfo2, String message) {
        Shell anyShell = Utils.findAnyShell();
        Shell shell = new Shell(anyShell.getDisplay(), 8);
        shell.setSize(1, 1);
        shell.open();
        DirectoryDialog dDialog = new DirectoryDialog(shell, 139264);
        File current_dir = fileInfo2.getFile(true).getParentFile();
        if (!current_dir.isDirectory()) {
            current_dir = fileInfo2.getDownloadManager().getSaveLocation();
        }
        dDialog.setFilterPath(current_dir.getPath());
        dDialog.setText(MessageText.getString("FilesView.rename.choose.path.dir"));
        if (message != null) {
            dDialog.setMessage(message);
        }
        String open = dDialog.open();
        shell.close();
        return open;
    }

    private static boolean askCanOverwrite(File file) {
        MessageBoxShell mb = new MessageBoxShell(288, MessageText.getString("FilesView.rename.confirm.delete.title"), MessageText.getString("FilesView.rename.confirm.delete.text", new String[]{file.toString()}));
        mb.setDefaultButtonUsingStyle(32);
        mb.setRememberOnlyIfButton(0);
        mb.setRemember("FilesView.messagebox.rename.id", true, null);
        mb.setLeftImage(8);
        mb.open(null);
        return mb.waitUntilClosed() == 32;
    }

    private static boolean checkRetargetOK(com.biglybt.core.disk.DiskManagerFileInfo info, File target) {
        if (!target.exists()) {
            return true;
        }
        if (info.getTorrentFile().getLength() == target.length()) {
            return true;
        }
        MessageBoxShell mb = new MessageBoxShell(288, MessageText.getString("FilesView.retarget.confirm.title"), MessageText.getString("FilesView.retarget.confirm.text"));
        mb.setDefaultButtonUsingStyle(32);
        mb.setLeftImage(8);
        mb.open(null);
        return mb.waitUntilClosed() == 32;
    }

    private static void moveFile(DownloadManager manager, com.biglybt.core.disk.DiskManagerFileInfo fileInfo2, File source, File target, boolean dont_delete_existing, Runnable done) {
        moveCopyDispatcher.dispatch(() -> FilesViewMenuUtil.moveFileSupport(manager, fileInfo2, source, target, dont_delete_existing, () -> {
            if (done != null) {
                done.run();
            }
        }));
    }

    private static void hardLinkFile(DownloadManager manager, com.biglybt.core.disk.DiskManagerFileInfo file_info, File source, File target, final Runnable done) {
        String failure_msg = null;
        try {
            boolean ok;
            try {
                Files.createLink(target.toPath(), source.toPath());
            }
            catch (Throwable e) {
                failure_msg = MessageText.getString("hardlink.failed.text", new String[]{target.toString(), source.toString(), Debug.getNestedExceptionMessage(e)});
            }
            if (failure_msg == null && !(ok = file_info.setLink(target, true))) {
                target.delete();
                String error = file_info.getLastError();
                if (error == null) {
                    error = MessageText.getString("SpeedView.stats.unknown");
                }
                failure_msg = MessageText.getString("hardlink.failed.text", new String[]{target.toString(), source.toString(), error});
            }
            if (failure_msg != null) {
                new MessageBoxShell(33, MessageText.getString("hardlink.failed.title"), failure_msg).open(new UserPrompterResultListener(){

                    @Override
                    public void prompterClosed(int result) {
                        if (done != null) {
                            done.run();
                        }
                    }
                });
            }
        }
        finally {
            if (failure_msg == null && done != null) {
                done.run();
            }
        }
    }

    private static void copyFile(DownloadManager manager, com.biglybt.core.disk.DiskManagerFileInfo fileInfo2, File source, File target, boolean dont_delete_existing, Runnable done) {
        moveCopyDispatcher.dispatch(() -> FilesViewMenuUtil.copyFileSupport(manager, fileInfo2, source, target, dont_delete_existing, () -> {
            if (done != null) {
                done.run();
            }
        }));
    }

    private static void moveFileSupport(final DownloadManager manager, final com.biglybt.core.disk.DiskManagerFileInfo fileInfo2, final File source, final File target, final boolean dont_delete_existing, final Runnable done) {
        block2: {
            try {
                FileUtil.runAsTask(new CoreOperationTask(){

                    @Override
                    public String getName() {
                        return fileInfo2.getFile(true).getName();
                    }

                    @Override
                    public DownloadManager getDownload() {
                        return manager;
                    }

                    @Override
                    public String[] getAffectedFileSystems() {
                        return FileUtil.getFileStoreNames(source, target);
                    }

                    @Override
                    public CoreOperationTask.ProgressCallback getProgressCallback() {
                        return null;
                    }

                    @Override
                    public void run(CoreOperation operation) {
                        boolean went_async = false;
                        try {
                            boolean ok = fileInfo2.setLink(target, dont_delete_existing);
                            if (!ok) {
                                String msg = MessageText.getString("FilesView.rename.failed.text");
                                String error = fileInfo2.getLastError();
                                if (error != null) {
                                    msg = String.valueOf(msg) + ": " + error;
                                }
                                new MessageBoxShell(33, MessageText.getString("FilesView.rename.failed.title"), msg).open(new UserPrompterResultListener(){

                                    @Override
                                    public void prompterClosed(int result) {
                                        if (done != null) {
                                            done.run();
                                        }
                                    }
                                });
                                went_async = true;
                            }
                        }
                        finally {
                            if (!went_async && done != null) {
                                done.run();
                            }
                        }
                    }
                });
            }
            catch (Throwable e) {
                if (done == null) break block2;
                done.run();
            }
        }
    }

    private static void copyFileSupport(final DownloadManager manager, final com.biglybt.core.disk.DiskManagerFileInfo fileInfo2, final File source, final File target, final boolean dont_delete_existing, final Runnable done) {
        block2: {
            try {
                FileUtil.runAsTask(7, new CoreOperationTask(){

                    @Override
                    public String getName() {
                        return fileInfo2.getFile(true).getName();
                    }

                    @Override
                    public DownloadManager getDownload() {
                        return manager;
                    }

                    @Override
                    public String[] getAffectedFileSystems() {
                        return FileUtil.getFileStoreNames(source, target);
                    }

                    @Override
                    public CoreOperationTask.ProgressCallback getProgressCallback() {
                        return null;
                    }

                    @Override
                    public void run(CoreOperation operation) {
                        boolean went_async = false;
                        try {
                            boolean ok;
                            File source2 = fileInfo2.getFile(true);
                            if (source2.exists()) {
                                FileUtil.copyFile(source2, target);
                            }
                            if (!(ok = fileInfo2.setLink(target, dont_delete_existing))) {
                                String msg = MessageText.getString("FilesView.copy.failed.text");
                                String error = fileInfo2.getLastError();
                                if (error != null) {
                                    msg = String.valueOf(msg) + ": " + error;
                                }
                                new MessageBoxShell(33, MessageText.getString("FilesView.copy.failed.title"), msg).open(new UserPrompterResultListener(){

                                    @Override
                                    public void prompterClosed(int result) {
                                        if (done != null) {
                                            done.run();
                                        }
                                    }
                                });
                                went_async = true;
                            }
                        }
                        finally {
                            if (!went_async && done != null) {
                                done.run();
                            }
                        }
                    }
                });
            }
            catch (Throwable e) {
                if (done == null) break block2;
                done.run();
            }
        }
    }

    private static boolean setSkipped(DownloadManager manager, com.biglybt.core.disk.DiskManagerFileInfo[] infos, boolean skipped, int delete_action, boolean prompt) {
        if (!manager.isPersistent()) {
            int i = 0;
            while (i < infos.length) {
                infos[i].setSkipped(skipped);
                ++i;
            }
            return false;
        }
        int[] existing_storage_types = manager.getStorageType(infos);
        int nbFiles = manager.getDiskManagerFileInfoSet().nbFiles();
        boolean[] setLinear = new boolean[nbFiles];
        boolean[] setCompact = new boolean[nbFiles];
        boolean[] setReorder = new boolean[nbFiles];
        boolean[] setReorderCompact = new boolean[nbFiles];
        int compactCount = 0;
        int linearCount = 0;
        int reorderCount = 0;
        int reorderCompactCount = 0;
        int cfr_ignored_0 = infos.length;
        File save_location = manager.getAbsoluteSaveLocation();
        boolean root_exists = save_location.isDirectory() || infos.length <= 1 && save_location.exists();
        boolean type_has_been_changed = false;
        boolean requires_pausing = false;
        int i = 0;
        while (i < infos.length) {
            int new_storage_type;
            int non_compact_target;
            int compact_target;
            int existing_storage_type = existing_storage_types[i];
            if (existing_storage_type == 2 || existing_storage_type == 1) {
                compact_target = 2;
                non_compact_target = 1;
            } else {
                compact_target = 4;
                non_compact_target = 3;
            }
            if (skipped) {
                File existing_file = infos[i].getFile(true);
                boolean perform_check = root_exists ? true : !FileUtil.isAncestorOf(save_location, existing_file);
                if (perform_check && existing_file.exists()) {
                    if (delete_action == 1) {
                        if (prompt) {
                            boolean wants_to_delete;
                            MessageBoxShell mb = new MessageBoxShell(288, MessageText.getString("FilesView.rename.confirm.delete.title"), MessageText.getString("FilesView.rename.confirm.delete.text", new String[]{existing_file.toString()}));
                            mb.setDefaultButtonUsingStyle(32);
                            mb.setRememberOnlyIfButton(0);
                            mb.setRemember("FilesView.messagebox.delete.id", false, null);
                            mb.setLeftImage(8);
                            mb.open(null);
                            boolean bl = wants_to_delete = mb.waitUntilClosed() == 32;
                            new_storage_type = wants_to_delete ? compact_target : non_compact_target;
                        } else {
                            new_storage_type = compact_target;
                        }
                    } else {
                        new_storage_type = non_compact_target;
                    }
                } else {
                    new_storage_type = delete_action != 0 ? compact_target : non_compact_target;
                }
            } else {
                new_storage_type = non_compact_target;
            }
            boolean has_changed = existing_storage_type != new_storage_type;
            type_has_been_changed |= has_changed;
            if (has_changed) {
                requires_pausing |= new_storage_type == 2 || new_storage_type == 4;
                if (new_storage_type == 2) {
                    setCompact[infos[i].getIndex()] = true;
                    ++compactCount;
                } else if (new_storage_type == 1) {
                    setLinear[infos[i].getIndex()] = true;
                    ++linearCount;
                } else if (new_storage_type == 3) {
                    setReorder[infos[i].getIndex()] = true;
                    ++reorderCount;
                } else if (new_storage_type == 4) {
                    setReorderCompact[infos[i].getIndex()] = true;
                    ++reorderCompactCount;
                }
            }
            ++i;
        }
        boolean ok = true;
        boolean paused = false;
        if (type_has_been_changed) {
            if (requires_pausing) {
                paused = manager.pause(true);
            }
            if (linearCount > 0) {
                ok &= Arrays.equals(setLinear, manager.getDiskManagerFileInfoSet().setStorageTypes(setLinear, 1));
            }
            if (compactCount > 0) {
                ok &= Arrays.equals(setCompact, manager.getDiskManagerFileInfoSet().setStorageTypes(setCompact, 2));
            }
            if (reorderCount > 0) {
                ok &= Arrays.equals(setReorder, manager.getDiskManagerFileInfoSet().setStorageTypes(setReorder, 3));
            }
            if (reorderCompactCount > 0) {
                ok &= Arrays.equals(setReorderCompact, manager.getDiskManagerFileInfoSet().setStorageTypes(setReorderCompact, 4));
            }
        }
        if (ok) {
            boolean[] toChange = new boolean[nbFiles];
            int i2 = 0;
            while (i2 < infos.length) {
                if (infos[i2].isSkipped() != skipped) {
                    toChange[infos[i2].getIndex()] = true;
                }
                ++i2;
            }
            manager.getDiskManagerFileInfoSet().setSkipped(toChange, skipped);
        }
        return paused;
    }

    public static void revertFiles(TableView<?> tv, DownloadManager[] dms) {
        ArrayList<com.biglybt.core.disk.DiskManagerFileInfo> files = new ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>();
        DownloadManager[] downloadManagerArray = dms;
        int n = dms.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager dm = downloadManagerArray[n2];
            com.biglybt.core.disk.DiskManagerFileInfo[] dm_files = dm.getDiskManagerFileInfoSet().getFiles();
            LinkFileMap links = dm.getDownloadState().getFileLinks();
            Iterator<LinkFileMap.Entry> it = links.entryIterator();
            while (it.hasNext()) {
                LinkFileMap.Entry entry = it.next();
                if (entry.getToFile() == null) continue;
                files.add(dm_files[entry.getIndex()]);
            }
            ++n2;
        }
        if (files.size() > 0) {
            FilesViewMenuUtil.revertFiles(tv, files);
        }
    }

    public static void revertFiles(TableView<?> tv, List<com.biglybt.core.disk.DiskManagerFileInfo> files) {
        RevertFileLocationsWindow window = new RevertFileLocationsWindow();
        window.open((ok, hard_link, copy, retain) -> {
            if (ok) {
                FilesViewMenuUtil.revertFiles(tv, files, hard_link, copy, retain);
            }
        });
    }

    private static void revertFiles(TableView<?> tv, List<com.biglybt.core.disk.DiskManagerFileInfo> files, boolean hard_link, boolean copy, boolean retain_names) {
        ArrayList<DownloadManager> paused = new ArrayList<DownloadManager>();
        AESemaphore task_sem = new AESemaphore("tasksem");
        ArrayList<com.biglybt.core.disk.DiskManagerFileInfo> affected_files = new ArrayList<com.biglybt.core.disk.DiskManagerFileInfo>();
        try {
            int i = 0;
            while (i < files.size()) {
                com.biglybt.core.disk.DiskManagerFileInfo file_info = files.get(i);
                if (file_info != null) {
                    File target = file_info.getFile(false);
                    DownloadManager manager = file_info.getDownloadManager();
                    File source = file_info.getDownloadManager().getDownloadState().getFileLink(file_info.getIndex(), target);
                    if (source != null) {
                        if (retain_names) {
                            target = new File(target.getParentFile(), source.getName());
                        }
                        if (source != target && !source.equals(target)) {
                            if (!paused.contains(manager) && manager.pause(true)) {
                                paused.add(manager);
                            }
                            if (target.exists()) {
                                target.delete();
                            }
                            affected_files.add(file_info);
                            if (hard_link) {
                                FilesViewMenuUtil.hardLinkFile(manager, file_info, source, target, () -> task_sem.release());
                            } else if (copy) {
                                FilesViewMenuUtil.copyFile(manager, file_info, source, target, true, () -> task_sem.release());
                            } else {
                                FilesViewMenuUtil.moveFile(manager, file_info, source, target, true, () -> task_sem.release());
                            }
                        }
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            if (affected_files.size() > 0) {
                AEThread2.createAndStartDaemon("FilesViewWaiter", () -> {
                    int i = 0;
                    while (i < affected_files.size()) {
                        task_sem.reserve();
                        ++i;
                    }
                    for (DownloadManager manager : paused) {
                        manager.resume();
                    }
                    FilesViewMenuUtil.invalidateRows(tv, affected_files);
                });
            }
            throw throwable;
        }
        if (affected_files.size() > 0) {
            AEThread2.createAndStartDaemon("FilesViewWaiter", () -> {
                int i = 0;
                while (i < affected_files.size()) {
                    task_sem.reserve();
                    ++i;
                }
                for (DownloadManager manager : paused) {
                    manager.resume();
                }
                FilesViewMenuUtil.invalidateRows(tv, affected_files);
            });
        }
    }

    private static /* synthetic */ void lambda$1(List list, AESemaphore aESemaphore, List list2, TableView tableView) {
        int i = 0;
        while (i < list.size()) {
            aESemaphore.reserve();
            ++i;
        }
        for (DownloadManager manager : list2) {
            manager.resume();
        }
        FilesViewMenuUtil.invalidateRows(tableView, list);
    }
}

