/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.client.TRTrackerScraperResponse;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.HTTPUtils;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.selectedcontent.SelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.DateWindow;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.TorrentUtil;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.debug.UIDebugGenerator;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.views.ViewUtils;
import com.biglybt.ui.swt.views.piece.PieceMapView;
import com.biglybt.util.MapUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class GeneralView
implements ParameterListener,
UISWTViewCoreEventListener,
UIPluginViewToolBarListener {
    public static final String MSGID_PREFIX = "GeneralView";
    private static Color badAvailColor;
    private static Color transferringColor;
    private static boolean showTransferring;
    protected AEMonitor this_mon = new AEMonitor("GeneralView");
    private Display display;
    private DownloadManager manager = null;
    int[] piecesStateCache;
    long piecesStateSkippedMarker;
    boolean piecesStateFileBoundariesDone;
    int loopFactor;
    Composite genComposite;
    Composite gFile;
    Canvas piecesImage;
    Image pImage;
    BufferedLabel piecesPercent;
    Canvas availabilityImage;
    Image aImage;
    BufferedLabel availabilityPercent;
    Group gTransfer;
    BufferedLabel timeElapsed;
    BufferedLabel timeRemaining;
    BufferedLabel download;
    BufferedLabel downloadSpeed;
    BufferedLabel upload;
    BufferedLabel uploadSpeed;
    BufferedLabel totalSpeed;
    BufferedLabel ave_completion;
    BufferedLabel distributedCopies;
    BufferedLabel seeds;
    BufferedLabel peers;
    BufferedLabel completedLbl;
    Group gInfo;
    BufferedLabel fileName;
    BufferedLabel torrentStatus;
    BufferedLabel fileSize;
    BufferedLabel saveIn;
    BufferedLabel hash;
    BufferedLabel pieceNumber;
    BufferedLabel pieceSize;
    Control lblComment;
    BufferedLabel creation_date;
    MenuItem[] date_menus;
    BufferedLabel privateStatus;
    Control user_comment;
    BufferedLabel hashFails;
    BufferedLabel shareRatio;
    Canvas thumbImage;
    Image tImage;
    Image tImageResized;
    String tImageResizedKey = "";
    private int graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
    private boolean piecesImageRefreshNeeded;
    private Composite parent;
    private ScrolledComposite scrolled_comp;
    private UISWTView swtView;
    private boolean viewBuilt = false;

    static {
        COConfigurationManager.addAndFireParameterListener("generalview.avail.bad.colour", n -> {
            badAvailColor = Utils.getConfigColor(n, Colors.maroon);
        });
        COConfigurationManager.addAndFireParameterListener("PeersView.BlockView.Transfer", n -> {
            transferringColor = PieceMapView.getLegendColor(n);
        });
        COConfigurationManager.addAndFireParameterListener("GeneralView.show.transferring", n -> {
            showTransferring = COConfigurationManager.getBooleanParameter(n, false);
        });
    }

    public void dataSourceChanged(Object newDataSource) {
        DownloadManager newManager = ViewUtils.getDownloadManagerFromDataSource(newDataSource, this.manager);
        if (newManager == this.manager) {
            return;
        }
        this.manager = newManager;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                GeneralView.this.swt_refreshInfo();
            }
        });
    }

    public void initialize(Composite composite) {
        this.parent = composite;
        this.scrolled_comp = new ScrolledComposite(composite, 512);
        this.scrolled_comp.setExpandHorizontal(true);
        this.scrolled_comp.setExpandVertical(true);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.scrolled_comp.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        this.scrolled_comp.setLayoutData((Object)gridData);
        this.genComposite = new Canvas((Composite)this.scrolled_comp, 0);
        GridLayout genLayout = new GridLayout();
        genLayout.marginHeight = 0;
        try {
            genLayout.marginTop = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        genLayout.marginWidth = 2;
        genLayout.numColumns = 1;
        this.genComposite.setLayout((Layout)genLayout);
        this.scrolled_comp.setContent((Control)this.genComposite);
        this.scrolled_comp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                GeneralView.this.piecesImageRefreshNeeded = true;
                Utils.updateScrolledComposite(GeneralView.this.scrolled_comp);
            }
        });
        Utils.execSWTThreadLater(0, new AERunnable(){

            @Override
            public void runSupport() {
                GeneralView.this.swt_refreshInfo();
            }
        });
        COConfigurationManager.addParameterListener("Graphics Update", (ParameterListener)this);
    }

    private void swt_refreshInfo() {
        if (this.manager == null || this.parent == null || this.parent.isDisposed()) {
            ViewUtils.setViewRequiresOneDownload(this.genComposite);
            this.viewBuilt = false;
            return;
        }
        this.piecesStateCache = new int[this.manager.getNbPieces()];
        this.piecesStateSkippedMarker = 0L;
        this.piecesStateFileBoundariesDone = false;
        if (!this.viewBuilt) {
            Utils.disposeComposite(this.genComposite, false);
            this.buildView();
            this.viewBuilt = true;
        }
        boolean persistent = this.manager.isPersistent();
        MenuItem[] menuItemArray = this.date_menus;
        int n = this.date_menus.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem mi = menuItemArray[n2];
            mi.setEnabled(persistent);
            ++n2;
        }
        this.updateAvailability();
        this.updatePiecesInfo(true);
        this.loadThumb();
        this.refresh(true);
        Utils.updateScrolledComposite(this.scrolled_comp);
    }

    private void buildView() {
        this.display = this.parent.getDisplay();
        this.gFile = new Composite(this.genComposite, 8);
        GridData gridData = new GridData(768);
        this.gFile.setLayoutData((Object)gridData);
        GridLayout fileLayout = new GridLayout();
        fileLayout.marginHeight = 0;
        fileLayout.marginWidth = 10;
        fileLayout.numColumns = 3;
        this.gFile.setLayout((Layout)fileLayout);
        Label piecesInfo = new Label(this.gFile, 16384);
        Messages.setLanguageText((Widget)piecesInfo, "GeneralView.section.downloaded");
        gridData = new GridData(32);
        piecesInfo.setLayoutData((Object)gridData);
        this.piecesImage = new Canvas(this.gFile, 0x20000000);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        gridData.heightHint = 25;
        this.piecesImage.setLayoutData((Object)gridData);
        Menu piecesMenu = new Menu((Control)this.piecesImage);
        this.piecesImage.setMenu(piecesMenu);
        MenuItem piecesSubItem = new MenuItem(piecesMenu, 64);
        Messages.setLanguageText((Widget)piecesSubItem, "Button.bar.show");
        final Menu piecesSubMenu = new Menu((Decorations)piecesMenu.getShell(), 4);
        piecesSubItem.setMenu(piecesSubMenu);
        piecesSubMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Utils.clearMenu(piecesSubMenu);
                MenuItem xferItem = new MenuItem(piecesSubMenu, 32);
                Messages.setLanguageText((Widget)xferItem, "PeersView.BlockView.Transfer");
                xferItem.addListener(13, ev -> COConfigurationManager.setParameter("GeneralView.show.transferring", !showTransferring));
                xferItem.setSelection(showTransferring);
            }
        });
        this.piecesPercent = new BufferedLabel(this.gFile, 0x20020000);
        gridData = new GridData(128);
        gridData.widthHint = 50;
        this.piecesPercent.setLayoutData(gridData);
        Label availabilityInfo = new Label(this.gFile, 16384);
        Messages.setLanguageText((Widget)availabilityInfo, "GeneralView.section.availability");
        gridData = new GridData(32);
        availabilityInfo.setLayoutData((Object)gridData);
        this.availabilityImage = new Canvas(this.gFile, 0x20000000);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        gridData.heightHint = 25;
        this.availabilityImage.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.availabilityImage, "GeneralView.label.status.pieces_available.tooltip");
        Menu availMenu = new Menu((Control)this.availabilityImage);
        this.availabilityImage.setMenu(availMenu);
        MenuItem availSubItem = new MenuItem(availMenu, 64);
        Messages.setLanguageText((Widget)availSubItem, "GeneralView.avail.bad.color");
        final Menu availSubMenu = new Menu((Decorations)availMenu.getShell(), 4);
        availSubItem.setMenu(availSubMenu);
        availSubMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Utils.clearMenu(availSubMenu);
                MenuItem defItem = new MenuItem(availSubMenu, 16);
                Messages.setLanguageText((Widget)defItem, "label.default");
                defItem.addListener(13, ev -> {
                    if (defItem.getSelection()) {
                        Utils.setConfigColor("generalview.avail.bad.colour", null);
                    }
                });
                MenuItem setItem = new MenuItem(availSubMenu, 16);
                Messages.setLanguageText((Widget)setItem, "label.set");
                setItem.addListener(13, ev -> {
                    RGB res;
                    if (setItem.getSelection() && (res = Utils.showColorDialog((Control)GeneralView.this.availabilityImage, badAvailColor == null ? null : badAvailColor.getRGB())) != null) {
                        Utils.setConfigColor("generalview.avail.bad.colour", ColorCache.getColor((Device)GeneralView.this.availabilityImage.getShell().getDisplay(), res));
                    }
                });
                defItem.setSelection(badAvailColor == null);
                setItem.setSelection(badAvailColor != null);
            }
        });
        this.availabilityPercent = new BufferedLabel(this.gFile, 0x20020000);
        gridData = new GridData(128);
        gridData.widthHint = 50;
        this.availabilityPercent.setLayoutData(gridData);
        Messages.setLanguageText(this.availabilityPercent.getWidget(), "GeneralView.label.status.pieces_available.tooltip");
        this.gTransfer = Utils.createSkinnedGroup(this.genComposite, 8);
        Messages.setLanguageText((Widget)this.gTransfer, "GeneralView.section.transfer");
        gridData = new GridData(768);
        this.gTransfer.setLayoutData((Object)gridData);
        GridLayout layoutTransfer = new GridLayout();
        layoutTransfer.numColumns = 6;
        this.gTransfer.setLayout((Layout)layoutTransfer);
        Label label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.timeelapsed");
        this.timeElapsed = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.timeElapsed.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.remaining");
        this.timeRemaining = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.timeRemaining.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.shareRatio");
        this.shareRatio = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.shareRatio.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.downloaded");
        this.download = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.download.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.downloadspeed");
        this.downloadSpeed = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.downloadSpeed.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.hashfails");
        this.hashFails = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.hashFails.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.uploaded");
        this.upload = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.upload.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.uploadspeed");
        this.uploadSpeed = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.uploadSpeed.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.seeds");
        this.seeds = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.seeds.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.peers");
        this.peers = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.peers.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.completed");
        this.completedLbl = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.completedLbl.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.totalspeed");
        this.totalSpeed = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.totalSpeed.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.swarm_average_completion");
        this.ave_completion = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.ave_completion.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.distributedCopies");
        this.distributedCopies = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.distributedCopies.setLayoutData(gridData);
        this.gInfo = Utils.createSkinnedGroup(this.genComposite, 8);
        Messages.setLanguageText((Widget)this.gInfo, "GeneralView.section.info");
        gridData = new GridData(1808);
        this.gInfo.setLayoutData((Object)gridData);
        GridLayout layoutInfo = new GridLayout(4, true);
        this.gInfo.setLayout((Layout)layoutInfo);
        Composite cInfoLeft = new Composite((Composite)this.gInfo, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        cInfoLeft.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginHeight = 0;
        cInfoLeft.setLayout((Layout)layout);
        Composite cInfoRight = new Composite((Composite)this.gInfo, 0);
        gridData = new GridData(1808);
        cInfoRight.setLayoutData((Object)gridData);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginHeight = 0;
        cInfoRight.setLayout((Layout)layout);
        label = new Label(cInfoLeft, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.filename");
        this.fileName = new BufferedLabel(cInfoLeft, 16384);
        gridData = new GridData(768);
        this.fileName.setLayoutData(gridData);
        label = new Label(cInfoRight, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.status");
        this.torrentStatus = new BufferedLabel(cInfoRight, 0x20004000);
        gridData = new GridData(768);
        this.torrentStatus.setLayoutData(gridData);
        label = new Label(cInfoLeft, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.savein");
        this.saveIn = new BufferedLabel(cInfoLeft, 16384);
        gridData = new GridData(768);
        this.saveIn.setLayoutData(gridData);
        label = new Label(cInfoLeft, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.totalsize");
        this.fileSize = new BufferedLabel(cInfoLeft, 16384);
        gridData = new GridData(768);
        this.fileSize.setLayoutData(gridData);
        label = new Label(cInfoRight, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.numberofpieces");
        this.pieceNumber = new BufferedLabel(cInfoRight, 16384);
        gridData = new GridData(768);
        this.pieceNumber.setLayoutData(gridData);
        label = new Label(cInfoLeft, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.hash");
        this.hash = new BufferedLabel(cInfoLeft, 16384, () -> this.hash.getText().replaceAll(" ", ""));
        Messages.setLanguageText(this.hash.getWidget(), "GeneralView.label.hash.tooltip", true, new String[0]);
        gridData = new GridData(768);
        this.hash.setLayoutData(gridData);
        this.hash.setCursor(this.display.getSystemCursor(21));
        Utils.setLinkForeground(this.hash.getControl());
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                String hash_str = GeneralView.this.hash.getText();
                if (hash_str != null && hash_str.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{hash_str.replaceAll(" ", "")}, new Transfer[]{TextTransfer.getInstance()});
                }
            }

            public void mouseDown(MouseEvent arg0) {
                String hash_str = GeneralView.this.hash.getText();
                if (hash_str != null && hash_str.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{hash_str.replaceAll(" ", "")}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        });
        this.hash.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                String hash_str = GeneralView.this.hash.getText();
                if (hash_str != null && hash_str.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{hash_str.replaceAll(" ", "")}, new Transfer[]{TextTransfer.getInstance()});
                }
            }

            public void mouseDown(MouseEvent arg0) {
                String hash_str = GeneralView.this.hash.getText();
                if (hash_str != null && hash_str.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{hash_str.replaceAll(" ", "")}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        });
        label = new Label(cInfoRight, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.size");
        this.pieceSize = new BufferedLabel(cInfoRight, 16384);
        gridData = new GridData(768);
        this.pieceSize.setLayoutData(gridData);
        SelectionAdapter cd_listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                long millis = GeneralView.this.manager.getTorrentCreationDate() * 1000L;
                if (millis == 0L) {
                    millis = -1L;
                }
                new DateWindow("label.enter.date", millis, new DateWindow.DateReceiver(){

                    @Override
                    public void dateSelected(long millis) {
                        try {
                            TOTorrent torrent = GeneralView.this.manager.getTorrent();
                            torrent.setCreationDate(millis / 1000L);
                            TorrentUtils.writeToFile(torrent);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
            }
        };
        label = new Label(cInfoLeft, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.creationdate");
        Menu cd_menu = new Menu((Decorations)label.getShell(), 8);
        MenuItem mi_cd1 = new MenuItem(cd_menu, 0);
        Messages.setLanguageText((Widget)mi_cd1, "menu.set.date");
        mi_cd1.addSelectionListener((SelectionListener)cd_listener);
        label.setMenu(cd_menu);
        this.creation_date = new BufferedLabel(cInfoLeft, 16384);
        gridData = new GridData(768);
        this.creation_date.setLayoutData(gridData);
        cd_menu = new Menu((Decorations)label.getShell(), 8);
        MenuItem mi_cd2 = new MenuItem(cd_menu, 0);
        Messages.setLanguageText((Widget)mi_cd2, "menu.set.date");
        mi_cd2.addSelectionListener((SelectionListener)cd_listener);
        this.date_menus = new MenuItem[]{mi_cd1, mi_cd2};
        new MenuItem(cd_menu, 2);
        ClipboardCopy.addCopyToClipMenu(cd_menu, new ClipboardCopy.copyToClipProvider(){

            @Override
            public String getText() {
                return GeneralView.this.creation_date.getText();
            }
        });
        this.creation_date.getControl().setMenu(cd_menu);
        label = new Label(cInfoRight, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.private");
        this.privateStatus = new BufferedLabel(cInfoRight, 16384);
        gridData = new GridData(768);
        this.privateStatus.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        Composite cCommentsThumb = new Composite((Composite)this.gInfo, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        cCommentsThumb.setLayoutData((Object)gridData);
        layout = new GridLayout(4, true);
        layout.marginWidth = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginHeight = 0;
        cCommentsThumb.setLayout((Layout)layout);
        Composite cComments = new Composite(cCommentsThumb, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        cComments.setLayoutData((Object)gridData);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginHeight = 0;
        cComments.setLayout((Layout)layout);
        Composite cThumb = new Composite(cCommentsThumb, 0);
        gridData = new GridData(768);
        cThumb.setLayoutData((Object)gridData);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginHeight = 0;
        cThumb.setLayout((Layout)layout);
        Group gThumb = Utils.createSkinnedGroup(cThumb, 0);
        gridData = new GridData(768);
        gThumb.setLayoutData((Object)gridData);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginHeight = 0;
        gThumb.setLayout((Layout)layout);
        Messages.setLanguageText((Widget)gThumb, "label.thumbnail");
        this.thumbImage = new Canvas((Composite)gThumb, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point size = super.computeSize(wHint, hHint, changed);
                size.y = size.x * 9 / 16;
                return size;
            }
        };
        gridData = new GridData(768);
        this.thumbImage.setLayoutData((Object)gridData);
        final Menu thumbMenu = new Menu((Control)this.thumbImage);
        this.thumbImage.setMenu(thumbMenu);
        thumbMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] menuItemArray = thumbMenu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem mi = menuItemArray[n2];
                    mi.dispose();
                    ++n2;
                }
                ArrayList<DiskManagerFileInfo> images = new ArrayList<DiskManagerFileInfo>();
                DiskManagerFileInfo[] diskManagerFileInfoArray = GeneralView.this.manager.getDiskManagerFileInfoSet().getFiles();
                int n3 = diskManagerFileInfoArray.length;
                n = 0;
                while (n < n3) {
                    DiskManagerFileInfo fi = diskManagerFileInfoArray[n];
                    if (HTTPUtils.isImageFileType(fi.getExtension())) {
                        File file;
                        long len = fi.getLength();
                        if (fi.getDownloaded() == len && (file = fi.getFile(true)).exists() && file.length() == len) {
                            images.add(fi);
                        }
                    }
                    ++n;
                }
                Collections.sort(images, new Comparator<DiskManagerFileInfo>(){

                    @Override
                    public int compare(DiskManagerFileInfo o1, DiskManagerFileInfo o2) {
                        long diff = o2.getLength() - o1.getLength();
                        if (diff < 0L) {
                            return -1;
                        }
                        if (diff > 0L) {
                            return 1;
                        }
                        return 0;
                    }
                });
                int rem = 15;
                for (DiskManagerFileInfo fi : images) {
                    MenuItem mi;
                    if (--rem < 0) {
                        mi = new MenuItem(thumbMenu, 8);
                        mi.setText("...");
                        mi.setEnabled(false);
                        break;
                    }
                    mi = new MenuItem(thumbMenu, 8);
                    mi.setText(fi.getTorrentFile().getRelativePath());
                    mi.addListener(13, ev -> GeneralView.this.setThumb(fi.getFile(true)));
                }
                if (thumbMenu.getItemCount() > 0) {
                    new MenuItem(thumbMenu, 2);
                }
                MenuItem mi = new MenuItem(thumbMenu, 8);
                Messages.setLanguageText((Widget)mi, "MyTorrentsView.menu.torrent.set.thumb");
                mi.addListener(13, ev -> GeneralView.this.setThumb());
                mi = new MenuItem(thumbMenu, 2);
                mi = new MenuItem(thumbMenu, 8);
                Messages.setLanguageText((Widget)mi, "Button.clear");
                mi.addListener(13, ev -> GeneralView.this.clearThumb());
            }
        });
        this.thumbImage.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent ev) {
                GeneralView.this.setThumb();
            }
        });
        label = new Label(cComments, 16384);
        gridData = new GridData(2);
        label.setLayoutData((Object)gridData);
        label.setCursor(this.display.getSystemCursor(21));
        Utils.setLinkForeground((Control)label);
        Messages.setLanguageText((Widget)label, "GeneralView.label.user_comment");
        try {
            this.user_comment = new Link(cComments, 16448);
            ((Link)this.user_comment).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Utils.launch(e.text);
                }
            });
        }
        catch (Throwable e) {
            this.user_comment = new Label(cComments, 16448);
        }
        gridData = new GridData(768);
        this.user_comment.setLayoutData((Object)gridData);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            private void editComment() {
                TorrentUtil.promptUserForComment(new DownloadManager[]{GeneralView.this.manager});
            }

            public void mouseDoubleClick(MouseEvent arg0) {
                this.editComment();
            }

            public void mouseDown(MouseEvent arg0) {
                this.editComment();
            }
        });
        label = new Label(cComments, 16384);
        gridData = new GridData(2);
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "GeneralView.label.comment");
        try {
            this.lblComment = new Link(cComments, 16448);
            ((Link)this.lblComment).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Utils.launch(e.text);
                }
            });
        }
        catch (Throwable e) {
            this.lblComment = new Label(cComments, 16448);
        }
        gridData = new GridData(768);
        this.lblComment.setLayoutData((Object)gridData);
        Composite pad1 = new Composite(cComments, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 0;
        pad1.setLayoutData((Object)gridData);
        Composite pad2 = new Composite(cThumb, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        gridData.heightHint = 0;
        pad2.setLayoutData((Object)gridData);
        ClipboardCopy.addCopyToClipMenu(this.lblComment, new ClipboardCopy.copyToClipProvider(){

            @Override
            public String getText() {
                String comment = (String)GeneralView.this.lblComment.getData("comment");
                return comment == null ? "" : comment;
            }
        });
        this.piecesImage.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                if (GeneralView.this.pImage == null || GeneralView.this.pImage.isDisposed()) {
                    return;
                }
                e.gc.drawImage(GeneralView.this.pImage, 0, 0);
            }
        });
        this.availabilityImage.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                if (GeneralView.this.aImage == null || GeneralView.this.aImage.isDisposed()) {
                    return;
                }
                e.gc.drawImage(GeneralView.this.aImage, 0, 0);
            }
        });
        this.thumbImage.addListener(9, new Listener(){

            public void handleEvent(Event ev) {
                int dstWidth;
                int dstHeight;
                if (GeneralView.this.tImage == null || GeneralView.this.tImage.isDisposed()) {
                    return;
                }
                Rectangle cellBounds = GeneralView.this.thumbImage.getBounds();
                Rectangle imgBounds = GeneralView.this.tImage.getBounds();
                if (imgBounds.height > cellBounds.height) {
                    dstHeight = cellBounds.height;
                    dstWidth = imgBounds.width * cellBounds.height / imgBounds.height;
                } else if (imgBounds.width > cellBounds.width) {
                    dstWidth = cellBounds.width;
                    dstHeight = imgBounds.height * cellBounds.width / imgBounds.width;
                } else {
                    dstWidth = imgBounds.width;
                    dstHeight = imgBounds.height;
                }
                int dstX = (cellBounds.width - dstWidth) / 2;
                int dstY = (cellBounds.height - dstHeight) / 2;
                String resizeKey = String.valueOf(imgBounds.width) + ":" + imgBounds.height + ":" + dstWidth + ":" + dstHeight;
                if (GeneralView.this.tImageResized == null || !GeneralView.this.tImageResizedKey.equals(resizeKey)) {
                    if (GeneralView.this.tImageResized != null && !GeneralView.this.tImageResized.isDisposed()) {
                        GeneralView.this.tImageResized.dispose();
                    }
                    GeneralView.this.tImageResized = Utils.getResizedImage(GeneralView.this.tImage, 0, 0, imgBounds.width, imgBounds.height, dstWidth, dstHeight);
                    GeneralView.this.tImageResizedKey = resizeKey;
                }
                ev.gc.drawImage(GeneralView.this.tImageResized, dstX, dstY);
            }
        });
        this.loadThumb();
        this.genComposite.layout();
    }

    public Composite getComposite() {
        return this.genComposite;
    }

    private void loadThumb() {
        if (this.tImage != null && !this.tImage.isDisposed()) {
            this.tImage.dispose();
        }
        if (this.tImageResized != null && !this.tImageResized.isDisposed()) {
            this.tImageResized.dispose();
        }
        this.tImage = null;
        this.tImageResized = null;
        if (!this.thumbImage.isDisposed()) {
            byte[] imageBytes;
            TOTorrent torrent = this.manager.getTorrent();
            if (torrent != null && (imageBytes = PlatformTorrentUtils.getContentThumbnail(torrent)) != null) {
                try {
                    Image image;
                    ByteArrayInputStream bis = new ByteArrayInputStream(imageBytes);
                    this.tImage = image = new Image((Device)Display.getDefault(), (InputStream)bis);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.thumbImage.redraw();
        }
    }

    private void setThumb() {
        FileDialog fDialog = new FileDialog(this.thumbImage.getShell(), 4098);
        fDialog.setText(MessageText.getString("MainWindow.dialog.choose.thumb"));
        fDialog.setFilterPath(this.manager.getSaveLocation().getAbsolutePath());
        String path = fDialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        this.setThumb(file);
    }

    private void setThumb(File file) {
        try {
            byte[] thumbnail = FileUtil.readFileAsByteArray(file);
            String name = file.getName();
            int pos = name.lastIndexOf(".");
            String ext = pos != -1 ? name.substring(pos + 1) : "";
            String type = HTTPUtils.guessContentTypeFromFileType(ext);
            try {
                TOTorrent torrent = this.manager.getTorrent();
                PlatformTorrentUtils.setContentThumbnail(torrent, thumbnail, type);
                this.loadThumb();
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private void clearThumb() {
        try {
            TOTorrent torrent = this.manager.getTorrent();
            PlatformTorrentUtils.setContentThumbnail(torrent, null, "");
            this.loadThumb();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void refresh(boolean force) {
        String source;
        byte[] created_by;
        String completed;
        String remaining;
        if (this.gFile == null || this.gFile.isDisposed() || this.manager == null) {
            return;
        }
        ++this.loopFactor;
        if (force || this.loopFactor % this.graphicsUpdate == 0) {
            this.updateAvailability();
            this.availabilityImage.redraw();
            this.updatePiecesInfo(false);
            this.piecesImage.redraw();
        }
        DiskManager dm = this.manager.getDiskManager();
        String eta = DisplayFormatters.formatETA(this.manager.getStats().getSmoothedETA());
        if (dm != null) {
            long rem = dm.getRemainingExcludingDND();
            String data_rem = DisplayFormatters.formatByteCountToKiBEtc(rem);
            remaining = rem > 0L ? String.valueOf(eta) + (eta.length() == 0 ? "" : " ") + data_rem : (eta.length() == 0 ? data_rem : eta);
        } else {
            remaining = eta;
        }
        this.setTime(this.manager.getStats().getElapsedTime(), remaining);
        TRTrackerScraperResponse hd = this.manager.getTrackerScrapeResponse();
        String seeds_str = String.valueOf(this.manager.getNbSeeds()) + " " + MessageText.getString("GeneralView.label.connected");
        String peers_str = String.valueOf(this.manager.getNbPeers()) + " " + MessageText.getString("GeneralView.label.connected");
        if (hd != null && hd.isValid()) {
            seeds_str = String.valueOf(seeds_str) + " ( " + hd.getSeeds() + " " + MessageText.getString("GeneralView.label.in_swarm") + " )";
            peers_str = String.valueOf(peers_str) + " ( " + hd.getPeers() + " " + MessageText.getString("GeneralView.label.in_swarm") + " )";
            completed = hd.getCompleted() > -1 ? Integer.toString(hd.getCompleted()) : "?";
        } else {
            completed = "?";
        }
        String _shareRatio = "";
        int sr = this.manager.getStats().getShareRatio();
        if (sr == -1) {
            _shareRatio = "\u221e";
        }
        if (sr > 0) {
            String partial = "" + sr % 1000;
            while (partial.length() < 3) {
                partial = "0" + partial;
            }
            _shareRatio = String.valueOf(sr / 1000) + "." + partial;
        }
        DownloadManagerStats stats2 = this.manager.getStats();
        String swarm_speed = String.valueOf(DisplayFormatters.formatByteCountToKiBEtcPerSec(stats2.getTotalAverage())) + " ( " + DisplayFormatters.formatByteCountToKiBEtcPerSec(stats2.getTotalAveragePerPeer()) + " " + MessageText.getString("GeneralView.label.averagespeed") + " )";
        String swarm_completion = "";
        String distributedCopies = "0.000";
        String piecesDoneAndSum = "" + this.manager.getNbPieces();
        PEPeerManager pm = this.manager.getPeerManager();
        if (pm != null) {
            int comp2 = pm.getAverageCompletionInThousandNotation();
            if (comp2 >= 0) {
                swarm_completion = DisplayFormatters.formatPercentFromThousands(comp2);
            }
            piecesDoneAndSum = String.valueOf(pm.getPiecePicker().getNbPiecesDone()) + "/" + piecesDoneAndSum;
            float dc = pm.getPiecePicker().getMinAvailability() - (float)pm.getNbSeeds() - (float)(pm.isSeeding() && stats2.getDownloadCompleted(false) == 1000 ? 1 : 0);
            if (dc < 0.0f) {
                dc = 0.0f;
            }
            distributedCopies = new DecimalFormat("0.000").format(dc);
        }
        int kInB = DisplayFormatters.getKinB();
        this.setStats(DisplayFormatters.formatDownloaded(stats2), DisplayFormatters.formatByteCountToKiBEtc(stats2.getTotalDataBytesSent()), DisplayFormatters.formatByteCountToKiBEtcPerSec(stats2.getDataReceiveRate()), DisplayFormatters.formatByteCountToKiBEtcPerSec(stats2.getDataSendRate()), swarm_speed, "" + this.manager.getStats().getDownloadRateLimitBytesPerSecond() / kInB, "" + this.manager.getStats().getUploadRateLimitBytesPerSecond() / kInB, seeds_str, peers_str, completed, DisplayFormatters.formatHashFails(this.manager), _shareRatio, swarm_completion, distributedCopies);
        TOTorrent torrent_maybe_null = this.manager.getTorrent();
        String creation_date = DisplayFormatters.formatDate(this.manager.getTorrentCreationDate() * 1000L);
        byte[] byArray = created_by = torrent_maybe_null == null ? null : torrent_maybe_null.getCreatedBy();
        if (created_by != null) {
            creation_date = MessageText.getString("GeneralView.torrent_created_on_and_by", new String[]{creation_date, new String(created_by, Constants.DEFAULT_ENCODING_CHARSET)});
        }
        String privateAndSourceStr = MessageText.getString("GeneralView." + (torrent_maybe_null != null && torrent_maybe_null.getPrivate() ? "yes" : "no"));
        if (torrent_maybe_null != null && (source = torrent_maybe_null.getSource()) != null) {
            privateAndSourceStr = String.valueOf(privateAndSourceStr) + ", " + MessageText.getString("wizard.source") + ": " + source;
        }
        this.setInfos(this.manager.getDisplayName(), DisplayFormatters.formatByteCountToKiBEtc(this.manager.getSize()), DisplayFormatters.formatDownloadStatus(this.manager), this.manager.getState() == 100, this.manager.getSaveLocation().toString(), TorrentUtils.nicePrintTorrentHash(torrent_maybe_null), piecesDoneAndSum, this.manager.getPieceLength(), this.manager.getTorrentComment(), creation_date, this.manager.getDownloadState().getUserComment(), privateAndSourceStr);
        if (this.loopFactor == 2) {
            this.getComposite().layout(true);
        }
    }

    public void delete() {
        if (this.aImage != null) {
            this.aImage.dispose();
            this.aImage = null;
        }
        if (this.pImage != null) {
            this.pImage.dispose();
            this.pImage = null;
        }
        if (this.tImage != null) {
            this.tImage.dispose();
            this.tImage = null;
        }
        if (this.tImageResized != null) {
            this.tImageResized.dispose();
            this.tImageResized = null;
        }
        Utils.disposeComposite(this.genComposite);
        this.viewBuilt = false;
        COConfigurationManager.removeParameterListener("Graphics Update", this);
    }

    private String getFullTitle() {
        return MessageText.getString("GeneralView.title.full");
    }

    private void updateAvailability() {
        if (this.manager == null) {
            return;
        }
        try {
            long runningFor;
            DiskManagerPiece[] dmPieces;
            int[] available;
            this.this_mon.enter();
            PEPeerManager pm = this.manager.getPeerManager();
            DiskManager dm = this.manager.getDiskManager();
            if (pm == null) {
                if (this.availabilityPercent.getText().length() > 0) {
                    this.availabilityPercent.setText("");
                }
                available = new int[this.manager.getNbPieces()];
                dmPieces = null;
                runningFor = -1L;
            } else {
                available = pm.getAvailability();
                dmPieces = dm == null ? null : dm.getPieces();
                runningFor = SystemTime.getMonotonousTime() - pm.getTimeStarted(true);
            }
            if (this.display == null || this.display.isDisposed()) {
                return;
            }
            if (this.availabilityImage == null || this.availabilityImage.isDisposed()) {
                return;
            }
            Rectangle bounds = this.availabilityImage.getClientArea();
            int xMax = bounds.width - 2;
            int yMax = bounds.height - 2;
            if (xMax < 10 || yMax < 5) {
                return;
            }
            if (this.aImage != null && !this.aImage.isDisposed()) {
                this.aImage.dispose();
            }
            this.aImage = new Image((Device)this.display, bounds.width, bounds.height);
            GC gcImage = new GC((Drawable)this.aImage);
            try {
                gcImage.setForeground(Colors.grey);
                gcImage.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
                int allMin = 0;
                int allMax = 0;
                int total = 0;
                String sTotal = "000";
                boolean hasBadAvailBlock = false;
                if (available != null) {
                    boolean badAvail;
                    float minAvail = this.manager.getStats().getAvailability();
                    boolean bl = badAvail = badAvailColor != null && runningFor >= 60000L && minAvail >= 0.0f && minAvail < 1.0f;
                    if (badAvail && this.manager.getDownloadState().getFlag(512L)) {
                        badAvail = minAvail == 0.0f;
                    }
                    allMin = available.length == 0 ? 0 : available[0];
                    allMax = available.length == 0 ? 0 : available[0];
                    int nbPieces = available.length;
                    int i = 0;
                    while (i < nbPieces) {
                        int avail = available[i];
                        if (avail < allMin) {
                            allMin = avail;
                        }
                        if (avail > allMax) {
                            allMax = avail;
                        }
                        ++i;
                    }
                    int maxAboveMin = allMax - allMin;
                    if (maxAboveMin == 0 && !badAvail) {
                        gcImage.setBackground(Colors.blues[allMin == 0 ? 0 : 9]);
                        gcImage.fillRectangle(1, 1, xMax, yMax);
                    } else {
                        int i2 = 0;
                        while (i2 < nbPieces) {
                            if (available[i2] > allMin) {
                                ++total;
                            }
                            ++i2;
                        }
                        total = total * 1000 / nbPieces;
                        sTotal = "" + total;
                        if (total < 10) {
                            sTotal = "0" + sTotal;
                        }
                        if (total < 100) {
                            sTotal = "0" + sTotal;
                        }
                        i2 = 0;
                        while (i2 < xMax) {
                            int a1 = (i2 + 1) * nbPieces / xMax;
                            int a0 = i2 * nbPieces / xMax;
                            if (a1 == a0) {
                                ++a1;
                            }
                            if (a1 > nbPieces) {
                                a1 = nbPieces;
                            }
                            int max = 0;
                            int min = available[a0];
                            int Pi = 1000;
                            boolean badAvailBlock = false;
                            int j = a0;
                            while (j < a1) {
                                DiskManagerPiece dmp;
                                int avail = available[j];
                                if (avail > max) {
                                    max = avail;
                                }
                                if (available[j] < min) {
                                    min = avail;
                                }
                                Pi *= avail;
                                Pi /= avail + 1;
                                if (badAvail && dmPieces != null && !(dmp = dmPieces[j]).isDone() && dmp.isNeeded() && avail < 1) {
                                    badAvailBlock = true;
                                    break;
                                }
                                ++j;
                            }
                            if (badAvailBlock) {
                                hasBadAvailBlock = true;
                                gcImage.setBackground(badAvailColor);
                            } else {
                                int index;
                                int pond = Pi;
                                if (max == 0) {
                                    pond = 0;
                                } else {
                                    int PiM = 1000;
                                    int j2 = a0;
                                    while (j2 < a1) {
                                        PiM *= max + 1;
                                        PiM /= max;
                                        ++j2;
                                    }
                                    pond *= PiM;
                                    pond /= 1000;
                                    pond *= max - min;
                                    pond /= 1000;
                                    pond += min;
                                }
                                if (pond <= 0 || allMax == 0) {
                                    index = 0;
                                } else {
                                    index = (pond - allMin) * 8 / maxAboveMin + 1;
                                    if (index > 9) {
                                        index = 9;
                                    }
                                }
                                gcImage.setBackground(Colors.blues[index]);
                            }
                            gcImage.fillRectangle(i2 + 1, 1, 1, yMax);
                            ++i2;
                        }
                    }
                }
                if (this.availabilityPercent == null || this.availabilityPercent.isDisposed()) {
                    return;
                }
                this.availabilityPercent.setForeground((Color)(hasBadAvailBlock ? badAvailColor : null));
                this.availabilityPercent.setText(String.valueOf(allMin) + "." + sTotal);
            }
            finally {
                gcImage.dispose();
            }
            this.availabilityImage.redraw();
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void updatePiecesInfo(boolean bForce) {
        block53: {
            if (this.manager == null) {
                return;
            }
            try {
                boolean update_boundaries;
                boolean update_skipped;
                DiskManager dm;
                this.this_mon.enter();
                if (this.display == null || this.display.isDisposed()) {
                    return;
                }
                if (this.piecesImage == null || this.piecesImage.isDisposed()) {
                    return;
                }
                if (this.piecesImageRefreshNeeded) {
                    bForce = true;
                    this.piecesImageRefreshNeeded = false;
                }
                if ((dm = this.manager.getDiskManager()) == null) {
                    DiskManagerPiece[] pieces = this.manager.getDiskManagerPiecesSnapshot();
                    if (pieces == null || pieces.length == 0) {
                        return;
                    }
                    dm = pieces[0].getManager();
                }
                int nbPieces = this.manager.getNbPieces();
                int[] oldPiecesState = this.piecesStateCache;
                boolean valid = oldPiecesState == null || oldPiecesState.length != nbPieces ? false : !bForce;
                int[] newPiecesState = new int[nbPieces];
                boolean PS_NONE = false;
                boolean PS_DONE = true;
                int PS_SKIPPED = 2;
                int PS_FILE_BOUNDARY = 4;
                int PS_XFERING = 8;
                DiskManagerPiece[] dm_pieces = dm.getPieces();
                PEPeerManager pm = showTransferring ? this.manager.getPeerManager() : null;
                PEPiece[] pm_pieces = pm == null ? null : pm.getPieces();
                int dm_state = dm.getState();
                if (dm_state == 0 || dm_state == 3 || dm_state == 4) {
                    if (!valid) {
                        update_skipped = true;
                        update_boundaries = true;
                    } else {
                        if (this.piecesStateFileBoundariesDone) {
                            update_boundaries = false;
                        } else {
                            this.piecesStateFileBoundariesDone = true;
                            update_boundaries = true;
                        }
                        long marker = dm.getPriorityChangeMarker();
                        if (marker == this.piecesStateSkippedMarker) {
                            update_skipped = false;
                        } else {
                            this.piecesStateSkippedMarker = marker;
                            update_skipped = true;
                        }
                    }
                } else {
                    update_skipped = false;
                    update_boundaries = false;
                }
                int i = 0;
                while (i < nbPieces) {
                    int state;
                    DiskManagerPiece piece = dm_pieces[i];
                    int n = state = piece.isDone() ? 1 : 0;
                    if (pm_pieces != null && state == 0 && pm_pieces[i] != null) {
                        state = 8;
                    }
                    if (update_skipped) {
                        if (piece.isSkipped()) {
                            state |= 2;
                        }
                    } else {
                        state |= oldPiecesState[i] & 2;
                    }
                    if (update_boundaries) {
                        if (piece.spansFiles()) {
                            state |= 4;
                        }
                    } else {
                        state |= oldPiecesState[i] & 4;
                    }
                    newPiecesState[i] = state;
                    if (valid && oldPiecesState[i] != state) {
                        valid = false;
                    }
                    ++i;
                }
                this.piecesStateCache = newPiecesState;
                if (valid) break block53;
                Rectangle bounds = this.piecesImage.getClientArea();
                int xMax = bounds.width - 2;
                int yMax = bounds.height - 2 - 6;
                if (xMax < 10 || yMax < 5) {
                    return;
                }
                int total = this.manager.getStats().getDownloadCompleted(true);
                if (this.pImage != null && !this.pImage.isDisposed()) {
                    this.pImage.dispose();
                }
                this.pImage = new Image((Device)this.display, bounds.width, bounds.height);
                GC gcImage = new GC((Drawable)this.pImage);
                try {
                    gcImage.setForeground(Colors.grey);
                    gcImage.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
                    gcImage.drawLine(1, 6, xMax, 6);
                    if (newPiecesState != null && newPiecesState.length != 0) {
                        int[] boundariesHandled = new int[newPiecesState.length];
                        int i2 = 0;
                        while (i2 < xMax) {
                            int a1 = (i2 + 1) * nbPieces / xMax;
                            int a0 = i2 * nbPieces / xMax;
                            if (a1 == a0) {
                                ++a1;
                            }
                            if (a1 > nbPieces) {
                                a1 = nbPieces;
                            }
                            int nbAvailable = 0;
                            int nbSkipped = 0;
                            int nbXferring = 0;
                            boolean hasFileBoundary = false;
                            int j = a0;
                            while (j < a1) {
                                int ps = newPiecesState[j];
                                if ((ps & 1) != 0) {
                                    ++nbAvailable;
                                }
                                if ((ps & 8) != 0) {
                                    ++nbXferring;
                                }
                                if ((ps & 2) != 0) {
                                    ++nbSkipped;
                                }
                                if ((ps & 4) != 0 && boundariesHandled[j] < 2) {
                                    int n = j;
                                    boundariesHandled[n] = boundariesHandled[n] + 1;
                                    hasFileBoundary = true;
                                }
                                ++j;
                            }
                            if (nbXferring > 0) {
                                gcImage.setBackground(transferringColor);
                                gcImage.fillRectangle(i2 + 1, 7, 1, yMax);
                            } else if (nbAvailable == 0 && nbSkipped > 0) {
                                gcImage.setBackground(Colors.grey);
                                gcImage.fillRectangle(i2 + 1, 7, 1, yMax);
                            } else {
                                int index = nbAvailable * 9 / (a1 - a0);
                                gcImage.setBackground(Colors.blues[index]);
                                gcImage.fillRectangle(i2 + 1, 7, 1, yMax);
                            }
                            if (hasFileBoundary) {
                                gcImage.setBackground(Colors.green);
                                gcImage.fillRectangle(i2 + 1, 7 + yMax - 6, 1, 6);
                            }
                            ++i2;
                        }
                    }
                    int limit = xMax * total / 1000;
                    gcImage.setBackground(Colors.colorProgressBar);
                    gcImage.fillRectangle(1, 1, limit, 5);
                    if (limit < xMax) {
                        gcImage.setBackground(Colors.blues[0]);
                        gcImage.fillRectangle(limit + 1, 1, xMax - limit, 5);
                    }
                }
                finally {
                    gcImage.dispose();
                }
                if (this.piecesPercent != null && !this.piecesPercent.isDisposed()) {
                    this.piecesPercent.setText(DisplayFormatters.formatPercentFromThousands(total));
                }
                if (this.pImage == null || this.pImage.isDisposed()) {
                    return;
                }
                this.piecesImage.redraw();
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    private void setTime(String elapsed, String remaining) {
        this.timeElapsed.setText(elapsed);
        this.timeRemaining.setText(remaining);
    }

    private void setStats(String dl, String ul, String dls, String uls, String ts, String dl_speed, String ul_speed, String s, String p, String completed, String hash_fails, String share_ratio, String ave_comp, String distr_copies) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.download.setText(dl);
        this.downloadSpeed.setText(dls);
        this.upload.setText(ul);
        this.uploadSpeed.setText(uls);
        this.totalSpeed.setText(ts);
        this.ave_completion.setText(ave_comp);
        this.distributedCopies.setText(distr_copies);
        this.seeds.setText(s);
        this.peers.setText(p);
        this.completedLbl.setText(completed);
        this.hashFails.setText(hash_fails);
        this.shareRatio.setText(share_ratio);
    }

    private void setInfos(final String _fileName, final String _fileSize, final String _torrentStatus, final boolean _statusIsError, final String _path, final String _hash, final String _pieceData, final String _pieceLength, final String _comment, final String _creation_date, final String _user_comment, final String isPrivateAndSource) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                GeneralView.this.fileName.setText(_fileName);
                GeneralView.this.fileSize.setText(_fileSize);
                GeneralView.this.torrentStatus.setText(_torrentStatus);
                int pos = _torrentStatus.indexOf("http://");
                if (pos > 0) {
                    GeneralView.this.torrentStatus.setLink(UrlUtils.getURL(_torrentStatus));
                } else {
                    GeneralView.this.torrentStatus.setLink(null);
                }
                GeneralView.this.torrentStatus.setForeground((Color)(_statusIsError ? Colors.red : null));
                GeneralView.this.saveIn.setText(_path);
                GeneralView.this.hash.setText(_hash);
                GeneralView.this.pieceNumber.setText(_pieceData);
                GeneralView.this.pieceSize.setText(_pieceLength);
                GeneralView.this.creation_date.setText(_creation_date);
                GeneralView.this.privateStatus.setText(isPrivateAndSource);
                boolean do_relayout = false;
                do_relayout = GeneralView.setCommentAndFormatLinks(GeneralView.this.lblComment, _comment.length() > 5000 && Constants.isWindowsXP ? _comment.substring(0, 5000) : _comment) | do_relayout;
                do_relayout = GeneralView.setCommentAndFormatLinks(GeneralView.this.user_comment, _user_comment) | do_relayout;
                if (do_relayout) {
                    GeneralView.this.gInfo.layout(true, true);
                    Utils.updateScrolledComposite(GeneralView.this.scrolled_comp);
                }
            }
        });
    }

    private static boolean setCommentAndFormatLinks(Control c, String new_comment) {
        String old_comment = (String)c.getData("comment");
        if (new_comment == null) {
            new_comment = "";
        }
        if (new_comment.equals(old_comment)) {
            return false;
        }
        c.setData("comment", (Object)new_comment);
        if (c instanceof Label) {
            ((Label)c).setText(new_comment);
        } else if (c instanceof Link) {
            String sNewComment = new_comment.replaceAll("([^=\">][\\s]+|^)((?:https?://|chat:)[\\S]+)", "$1<A HREF=\"$2\">$2</A>");
            sNewComment = sNewComment.replaceAll("(href=)(htt[^\\s>]+)", "$1\"$2\"");
            try {
                Pattern p = Pattern.compile("(?i)(<A HREF=[^>]*>)([^<]*</A>)");
                Matcher m = p.matcher(sNewComment);
                boolean result = m.find();
                if (result) {
                    StringBuffer sb = new StringBuffer();
                    while (result) {
                        m.appendReplacement(sb, m.group(1));
                        String str = m.group(2);
                        sb.append(UrlUtils.decode(str));
                        result = m.find();
                    }
                    m.appendTail(sb);
                    sNewComment = sb.toString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ((Link)c).setText(sNewComment);
            c.redraw();
            c.update();
        }
        return true;
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
    }

    private Image obfuscatedImage(Image image) {
        if (this.fileName == null) {
            return image;
        }
        UIDebugGenerator.obfuscateArea(image, (Control)this.fileName.getWidget(), this.manager == null ? "" : UIDebugGenerator.obfuscateDownloadName(this.manager));
        UIDebugGenerator.obfuscateArea(image, (Control)this.saveIn.getWidget(), Debug.secretFileName(this.saveIn.getText()));
        return image;
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = event2.getView();
                this.swtView.setTitle(this.getFullTitle());
                this.swtView.setToolBarListener(this);
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                String id = "DMDetails_General";
                if (this.manager != null) {
                    id = this.manager.getTorrent() != null ? String.valueOf(id) + "." + this.manager.getInternalName() : String.valueOf(id) + ":" + this.manager.getSize();
                    SelectedContentManager.changeCurrentlySelectedContent(id, new SelectedContent[]{new SelectedContent(this.manager)});
                    break;
                }
                SelectedContentManager.changeCurrentlySelectedContent(id, null);
                break;
            }
            case 4: {
                SelectedContentManager.clearCurrentlySelectedContent();
                break;
            }
            case 5: {
                this.refresh(false);
                break;
            }
            case 9: {
                Object data = event2.getData();
                if (!(data instanceof Map)) break;
                this.obfuscatedImage((Image)MapUtils.getMapObject((Map)data, "image", null, Image.class));
            }
        }
        return true;
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        return false;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        Map<String, Long> states = TorrentUtil.calculateToolbarStates(SelectedContentManager.getCurrentlySelectedContent(), null);
        list.putAll(states);
    }
}

