/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagListener;
import com.biglybt.core.tag.Taggable;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.views.PeersViewBase;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.util.DataSourceUtils;
import java.util.HashSet;
import java.util.Map;

public class PeersGeneralView
extends PeersViewBase
implements TagListener {
    private Tag tag;

    public PeersGeneralView() {
        super("AllPeersView", true);
    }

    @Override
    public String getFullTitle() {
        return this.tag == null ? "" : this.tag.getTagName(true);
    }

    @Override
    public TableViewSWT<PEPeer> initYourTableView() {
        this.initYourTableView("AllPeers");
        return this.tv;
    }

    @Override
    public void taggableAdded(Tag tag, Taggable tagged) {
        this.addPeer((PEPeer)tagged);
    }

    @Override
    public void taggableSync(Tag tag) {
        if (this.tv.getRowCount() != tag.getTaggedCount()) {
            HashSet peers_in_table = this.tv.getDataSources();
            HashSet<Taggable> peers_in_tag = new HashSet<Taggable>(tag.getTagged());
            for (PEPeer pEPeer : peers_in_table) {
                if (peers_in_tag.contains(pEPeer)) continue;
                this.removePeer(pEPeer);
            }
            for (PEPeer pEPeer : peers_in_tag) {
                if (peers_in_table.contains(pEPeer)) continue;
                this.addPeer(pEPeer);
            }
        }
    }

    @Override
    public void taggableRemoved(Tag tag, Taggable tagged) {
        this.removePeer((PEPeer)tagged);
    }

    @Override
    public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
        super.tableLifeCycleEventOccurred(tv, eventType, data);
        switch (eventType) {
            case 0: {
                if (this.tag == null) break;
                this.tag.addTagListener(this, true);
                break;
            }
            case 1: {
                if (this.tag == null) break;
                this.tag.removeTagListener(this);
            }
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        Tag[] tags;
        if (event2.getType() == 0 && (tags = DataSourceUtils.getTags(event2.getView().getInitialDataSource())).length > 0) {
            this.tag = tags[0];
        }
        return super.eventOccurred(event2);
    }

    @Override
    protected void updateSelectedContent() {
    }
}

