/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerPeerListener;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.ui.UIPluginViewToolBarListener;
import com.biglybt.ui.common.ToolBarItem;
import com.biglybt.ui.common.table.TableDataSourceChangedListener;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo2;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.views.PeersViewBase;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.util.DataSourceUtils;
import com.biglybt.util.StringCompareUtils;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PeersView
extends PeersViewBase
implements DownloadManagerPeerListener,
TableDataSourceChangedListener,
ViewTitleInfo2,
UIPluginViewToolBarListener {
    public static final String MSGID_PREFIX = "PeersView";
    private DownloadManager manager;
    private Reference<PEPeer> select_peer_pending;
    private TimerEventPeriodic timerPeerCountUI;
    private String textIndicator;
    private long countWentToZeroTime = -1L;

    public PeersView() {
        super(MSGID_PREFIX, false);
    }

    @Override
    public TableViewSWT<PEPeer> initYourTableView() {
        this.manager = null;
        this.tv = this.initYourTableView("Peers");
        this.tv.addTableDataSourceChangedListener(this, false);
        return this.tv;
    }

    @Override
    public void parentDataSourceChanged(Object newParentDataSource) {
        super.parentDataSourceChanged(newParentDataSource);
        if (this.tv != null && !this.tv.isDisposed()) {
            return;
        }
        DownloadManager newManager = DataSourceUtils.getDM(newParentDataSource);
        if (newManager != this.manager) {
            this.manager = newManager;
            this.buildTitleInfoTimer();
        }
    }

    private void buildTitleInfoTimer() {
        if (this.manager == null) {
            if (this.timerPeerCountUI != null) {
                this.timerPeerCountUI.cancel();
                this.timerPeerCountUI = null;
            }
            this.updateTitle(true);
        } else if (this.timerPeerCountUI == null) {
            this.timerPeerCountUI = SimpleTimer.addPeriodicEvent("PeerSumUI", 1000L, e -> this.updateTitle(false));
        }
    }

    private void updateTitle(boolean force) {
        String newTextIndicator;
        PEPeerManager peerManager;
        int count = 0;
        if (this.manager != null && (peerManager = this.manager.getPeerManager()) != null) {
            count = peerManager.getNbPeers() + peerManager.getNbSeeds();
        }
        if (force) {
            if (count == 0) {
                count = -1;
            }
        } else if (count == 0) {
            if (this.countWentToZeroTime == -1L) {
                count = -1;
            } else if (this.countWentToZeroTime == 0L) {
                this.countWentToZeroTime = SystemTime.getMonotonousTime();
            } else if (this.countWentToZeroTime > 0L && SystemTime.getMonotonousTime() - this.countWentToZeroTime > 30000L) {
                count = -1;
            }
        } else {
            this.countWentToZeroTime = 0L;
        }
        String string = newTextIndicator = count == -1 ? null : "" + count;
        if (!StringCompareUtils.equals(this.textIndicator, newTextIndicator)) {
            this.textIndicator = newTextIndicator;
            ViewTitleInfoManager.refreshTitleInfo(this);
        }
    }

    @Override
    public void tableDataSourceChanged(Object newDataSource) {
        DownloadManager newManager = DataSourceUtils.getDM(newDataSource);
        if (newManager == this.manager) {
            return;
        }
        if (this.manager != null) {
            this.manager.removePeerListener(this);
        }
        this.manager = newManager;
        this.buildTitleInfoTimer();
        if (this.tv == null || this.tv.isDisposed()) {
            return;
        }
        this.tv.removeAllTableRows();
        if (this.manager != null) {
            this.manager.addPeerListener(this, false);
            this.addExistingDatasources();
        }
    }

    @Override
    public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
        super.tableLifeCycleEventOccurred(tv, eventType, data);
        switch (eventType) {
            case 0: {
                if (this.manager != null) {
                    this.manager.removePeerListener(this);
                    this.manager.addPeerListener(this, false);
                }
                this.addExistingDatasources();
                break;
            }
            case 1: {
                Object firstDS;
                if (this.manager != null) {
                    this.manager.removePeerListener(this);
                    this.buildTitleInfoTimer();
                }
                this.select_peer_pending = (firstDS = tv.getFirstSelectedDataSource()) instanceof PEPeer ? new WeakReference<PEPeer>((PEPeer)firstDS) : null;
            }
        }
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        PeersView.fillMenu(menu, this.tv, this.shell, this.manager);
        new MenuItem(menu, 2);
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
        if (PeersView.addPeersMenu(this.manager, columnName, menuThisColumn, new PEPeer[0])) {
            new MenuItem(menuThisColumn, 2);
        }
    }

    @Override
    public void peerAdded(PEPeer created) {
        this.tv.addDataSource(created);
    }

    @Override
    public void peerRemoved(PEPeer removed) {
        this.tv.removeDataSource(removed);
    }

    public void selectPeer(PEPeer peer) {
        this.showPeer(peer, 0);
    }

    private void showPeer(final PEPeer peer, final int attempt) {
        if (attempt > 10 || peer == null) {
            return;
        }
        if (this.tv == null) {
            this.select_peer_pending = new WeakReference<PEPeer>(peer);
            return;
        }
        Utils.execSWTThreadLater(attempt == 0 ? 1 : 10, new Runnable(){

            @Override
            public void run() {
                TableRowCore row = PeersView.this.tv.getRow(peer);
                if (row == null) {
                    if (attempt == 0) {
                        PeersView.this.select_peer_pending = new WeakReference<PEPeer>(peer);
                        return;
                    }
                } else {
                    PeersView.this.tv.setSelectedRows(new TableRowCore[]{row});
                    PeersView.this.tv.showRow(row);
                    if (row.isVisible()) {
                        return;
                    }
                }
                PeersView.this.showPeer(peer, attempt + 1);
            }
        });
    }

    @Override
    public void peerManagerWillBeAdded(PEPeerManager peer_manager) {
    }

    @Override
    public void peerManagerAdded(PEPeerManager manager) {
        if (this.getShowLocalPeer()) {
            this.tv.addDataSource(manager.getMyPeer());
        }
    }

    @Override
    public void peerManagerRemoved(PEPeerManager manager) {
        this.tv.removeAllTableRows();
    }

    @Override
    protected void setShowLocalPeer(boolean b) {
        super.setShowLocalPeer(b);
        if (this.manager == null || this.tv == null || this.tv.isDisposed()) {
            return;
        }
        PEPeerManager pm = this.manager.getPeerManager();
        if (pm != null) {
            PEPeer my_peer = pm.getMyPeer();
            if (b) {
                this.tv.addDataSource(my_peer);
            } else {
                this.tv.removeDataSource(my_peer);
            }
        }
    }

    private void addExistingDatasources() {
        PEPeerManager pm;
        if (this.manager == null || this.tv == null || this.tv.isDisposed()) {
            return;
        }
        PEPeer[] dataSources = this.manager.getCurrentPeers();
        if (dataSources != null && dataSources.length > 0) {
            this.tv.addDataSources(dataSources);
        }
        if (this.getShowLocalPeer() && (pm = this.manager.getPeerManager()) != null) {
            this.tv.addDataSource(pm.getMyPeer());
        }
        if (this.select_peer_pending != null) {
            this.showPeer(this.select_peer_pending.get(), 1);
            this.select_peer_pending = null;
        }
    }

    @Override
    protected void updateSelectedContent() {
        Object[] dataSources = this.tv.getSelectedDataSources(true);
        if (dataSources.length == 0) {
            String id = "DMDetails_Peers";
            if (this.manager != null) {
                id = this.manager.getTorrent() != null ? String.valueOf(id) + "." + this.manager.getInternalName() : String.valueOf(id) + ":" + this.manager.getSize();
                SelectedContentManager.changeCurrentlySelectedContent(id, new SelectedContent[]{new SelectedContent(this.manager)});
            } else {
                SelectedContentManager.changeCurrentlySelectedContent(id, null);
            }
        } else {
            ISelectedContent[] sc = new SelectedContent[dataSources.length];
            int i = 0;
            while (i < sc.length) {
                Object ds = dataSources[i];
                sc[i] = ds instanceof PEPiece ? new SelectedContent("peer: " + ((PEPeer)ds).getIp()) : new SelectedContent("peer: " + ds);
                ++i;
            }
            SelectedContentManager.changeCurrentlySelectedContent(this.tv.getTableID(), sc, this.tv);
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        if (event2.getType() == 0) {
            event2.getView().setDestroyOnDeactivate(true);
        } else if (event2.getType() == 7) {
            this.buildTitleInfoTimer();
        }
        return super.eventOccurred(event2);
    }

    @Override
    public void titleInfoLinked(MultipleDocumentInterface mdi, MdiEntry mdiEntry) {
    }

    @Override
    public Object getTitleInfoProperty(int propertyID) {
        if (propertyID == 0) {
            return this.textIndicator;
        }
        return null;
    }

    @Override
    public boolean isActive() {
        if (this.tv == null || !this.tv.isVisible()) {
            return false;
        }
        return !this.tv.getSelectedDataSources().isEmpty();
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        Object ds;
        List<Object> selectedDataSources;
        boolean hasPeer;
        boolean bl = hasPeer = this.tv != null && this.tv.getSelectedRowsSize() > 0;
        if (hasPeer && (selectedDataSources = this.tv.getSelectedDataSources()).size() == 1 && (ds = selectedDataSources.get(0)) instanceof PEPeer && ((PEPeer)ds).isMyPeer()) {
            hasPeer = false;
        }
        list.put("remove", hasPeer ? 1L : 0L);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if (item.getID().equals("remove")) {
            List<Object> selectedDataSources = this.tv.getSelectedDataSources();
            for (Object dataSource : selectedDataSources) {
                PEPeer peer;
                if (!(dataSource instanceof PEPeer) || (peer = (PEPeer)dataSource).isMyPeer()) continue;
                peer.getManager().removePeer(peer, "Peer kicked", 14);
            }
            return true;
        }
        return false;
    }
}

