/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.skin.SWTSkinFactory;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class PieceGraphView
implements UISWTViewCoreEventListener {
    private boolean onePiecePerBlock = false;
    private int BLOCK_FILLSIZE = 21;
    private static final int BLOCK_SPACING = 3;
    private int BLOCK_SIZE = this.BLOCK_FILLSIZE + 3;
    private static final int BLOCKCOLOR_HAVEALL = 0;
    private static final int BLOCKCOLOR_NOHAVE = 1;
    private static final int BLOCKCOLOR_UPLOADING = 2;
    private static final int BLOCKCOLOR_DOWNLOADING = 3;
    private static final int BLOCKCOLOR_NOAVAIL = 4;
    private static final int BLOCKCOLOR_HAVESOME = 5;
    private Color[] blockColors;
    private Canvas canvas;
    private Image img;
    private Image imgHaveAll;
    private Image imgNoHave;
    private DownloadManager dlm;
    private Comparator compFindPEPiece;
    private final SWTSkinProperties properties = SWTSkinFactory.getInstance().getSkinProperties();
    private double[] squareCache;

    private void initialize(Composite parent) {
        this.blockColors = new Color[]{this.properties.getColor("color.pieceview.alldone"), this.properties.getColor("color.pieceview.notdone"), this.properties.getColor("color.pieceview.uploading"), this.properties.getColor("color.pieceview.downloading"), this.properties.getColor("color.pieceview.noavail"), this.properties.getColor("color.pieceview.havesome")};
        this.compFindPEPiece = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                int arg0no = arg0 instanceof PEPiece ? ((PEPiece)arg0).getPieceNumber() : ((Long)arg0).intValue();
                int arg1no = arg1 instanceof PEPiece ? ((PEPiece)arg1).getPieceNumber() : ((Long)arg1).intValue();
                return arg0no - arg1no;
            }
        };
        this.canvas = new Canvas(parent, 262144);
        this.canvas.setLayout((Layout)new FillLayout());
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (PieceGraphView.this.img != null && !PieceGraphView.this.img.isDisposed()) {
                    Rectangle bounds = PieceGraphView.this.img.getBounds();
                    if (bounds.width >= e.width + e.x && bounds.height >= e.height + e.y) {
                        e.gc.drawImage(PieceGraphView.this.img, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
                    }
                } else {
                    e.gc.fillRectangle(e.x, e.y, e.width, e.height);
                }
            }
        });
        this.canvas.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                PieceGraphView.this.calcBlockSize();
            }
        });
        this.canvas.addListener(12, ev -> {
            Image[] imageArray = new Image[]{this.img, this.imgHaveAll, this.imgNoHave};
            int n = imageArray.length;
            int n2 = 0;
            while (n2 < n) {
                Image i = imageArray[n2];
                if (i != null && !i.isDisposed()) {
                    i.dispose();
                }
                ++n2;
            }
            this.imgNoHave = null;
            this.imgHaveAll = null;
            this.img = null;
        });
    }

    private void dataSourceChanged(Object newDataSource) {
        this.dlm = newDataSource instanceof DownloadManager ? (DownloadManager)newDataSource : null;
        this.calcBlockSize();
    }

    private void refresh() {
        this.buildImage();
    }

    private void calcBlockSize() {
        if (!this.onePiecePerBlock) {
            this.buildImage();
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                TOTorrent torrent;
                if (PieceGraphView.this.canvas == null || PieceGraphView.this.canvas.isDisposed()) {
                    return;
                }
                TOTorrent tOTorrent = torrent = PieceGraphView.this.dlm == null ? null : PieceGraphView.this.dlm.getTorrent();
                if (torrent == null) {
                    PieceGraphView.this.BLOCK_SIZE = 24;
                } else {
                    int numCanFit;
                    long numPieces = torrent.getNumberOfPieces();
                    Rectangle bounds = PieceGraphView.this.canvas.getClientArea();
                    PieceGraphView.this.BLOCK_SIZE = (int)Math.sqrt((double)(bounds.width * bounds.height) / (double)numPieces);
                    if (PieceGraphView.this.BLOCK_SIZE <= 0) {
                        PieceGraphView.this.BLOCK_SIZE = 1;
                    }
                    if ((long)(numCanFit = bounds.width / PieceGraphView.this.BLOCK_SIZE * (bounds.height / PieceGraphView.this.BLOCK_SIZE)) < numPieces) {
                        PieceGraphView pieceGraphView = PieceGraphView.this;
                        pieceGraphView.BLOCK_SIZE = pieceGraphView.BLOCK_SIZE - 1;
                    }
                    if (PieceGraphView.this.BLOCK_SIZE < 2) {
                        PieceGraphView.this.BLOCK_SIZE = 2;
                    }
                }
                PieceGraphView.this.BLOCK_FILLSIZE = PieceGraphView.this.BLOCK_SIZE - 3;
                Utils.disposeSWTObjects(PieceGraphView.this.imgHaveAll, PieceGraphView.this.imgNoHave);
                PieceGraphView.this.buildImage();
            }
        });
    }

    private void buildImage() {
        boolean clearImage;
        GC gc;
        if (this.canvas == null || this.canvas.isDisposed()) {
            return;
        }
        Rectangle bounds = this.canvas.getClientArea();
        if (bounds.isEmpty()) {
            return;
        }
        if (this.dlm == null) {
            this.canvas.redraw();
            return;
        }
        PEPeerManager pm = this.dlm.getPeerManager();
        DiskManager dm = this.dlm.getDiskManager();
        if (pm == null || dm == null) {
            this.canvas.redraw();
            return;
        }
        DiskManagerPiece[] dm_pieces = dm.getPieces();
        if (dm_pieces == null || dm_pieces.length == 0) {
            this.canvas.redraw();
            return;
        }
        int numPieces = dm_pieces.length;
        if (this.imgHaveAll == null || this.imgHaveAll.isDisposed()) {
            this.imgHaveAll = new Image((Device)this.canvas.getDisplay(), this.BLOCK_SIZE, this.BLOCK_SIZE);
            gc = new GC((Drawable)this.imgHaveAll);
            try {
                try {
                    gc.setAntialias(1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                gc.setBackground(this.canvas.getBackground());
                gc.fillRectangle(this.imgHaveAll.getBounds());
                gc.setBackground(this.blockColors[0]);
                gc.fillRoundRectangle(1, 1, this.BLOCK_FILLSIZE, this.BLOCK_FILLSIZE, this.BLOCK_FILLSIZE, this.BLOCK_FILLSIZE);
            }
            finally {
                gc.dispose();
            }
        }
        if (this.imgNoHave == null || this.imgNoHave.isDisposed()) {
            this.imgNoHave = new Image((Device)this.canvas.getDisplay(), this.BLOCK_SIZE, this.BLOCK_SIZE);
            gc = new GC((Drawable)this.imgNoHave);
            try {
                try {
                    gc.setAntialias(1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                gc.setBackground(this.canvas.getBackground());
                gc.fillRectangle(this.imgNoHave.getBounds());
                gc.setBackground(this.blockColors[1]);
                gc.fillRoundRectangle(1, 1, this.BLOCK_FILLSIZE, this.BLOCK_FILLSIZE, this.BLOCK_FILLSIZE, this.BLOCK_FILLSIZE);
            }
            finally {
                gc.dispose();
            }
        }
        boolean bl = clearImage = this.img == null || this.img.isDisposed() || this.img.getBounds().width != bounds.width || this.img.getBounds().height != bounds.height;
        if (clearImage) {
            if (this.img != null && !this.img.isDisposed()) {
                this.img.dispose();
            }
            this.img = new Image((Device)this.canvas.getDisplay(), bounds.width, bounds.height);
            this.squareCache = null;
        }
        PEPiece[] currentDLPieces = this.dlm.getCurrentPieces();
        Arrays.sort(currentDLPieces, this.compFindPEPiece);
        ArrayList<Long> currentULPieces = new ArrayList<Long>();
        ArrayList<Long> futureULPieces = new ArrayList<Long>();
        PEPeer[] peers = pm.getPeers().toArray(new PEPeer[0]);
        int i = 0;
        while (i < peers.length) {
            PEPeer peer = peers[i];
            int[] peerRequestedPieces = peer.getIncomingRequestedPieceNumbers();
            if (peerRequestedPieces != null && peerRequestedPieces.length > 0) {
                currentULPieces.add(new Long(peerRequestedPieces[0]));
                int j = 1;
                while (j < peerRequestedPieces.length) {
                    futureULPieces.add(new Long(peerRequestedPieces[j]));
                    ++j;
                }
            }
            Collections.sort(currentULPieces);
            Collections.sort(futureULPieces);
            ++i;
        }
        int iNumCols = bounds.width / this.BLOCK_SIZE;
        int iNumRows = bounds.height / this.BLOCK_SIZE;
        int numSquares = this.onePiecePerBlock ? numPieces : iNumCols * iNumRows;
        double numPiecesPerSquare = (double)numPieces / (double)numSquares;
        if (this.squareCache == null || this.squareCache.length != numSquares) {
            this.squareCache = new double[numSquares];
            Arrays.fill(this.squareCache, -1.0);
        }
        int[] availability = pm.getAvailability();
        int numRedraws = 0;
        GC gc2 = new GC((Drawable)this.img);
        try {
            try {
                int iRow = 0;
                if (clearImage) {
                    gc2.setBackground(this.canvas.getBackground());
                    gc2.fillRectangle(bounds);
                }
                try {
                    gc2.setAdvanced(true);
                    gc2.setAntialias(1);
                    gc2.setInterpolation(2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int iCol = 0;
                int squareNo = 0;
                while (squareNo < numSquares) {
                    int colorIndex;
                    int startNo;
                    int count;
                    if (iCol >= iNumCols) {
                        iCol = 0;
                        ++iRow;
                    }
                    if ((count = (int)((double)(squareNo + 1) * numPiecesPerSquare) - (startNo = (int)((double)squareNo * numPiecesPerSquare))) == 0) {
                        count = 1;
                    }
                    double pctDone = this.getPercentDone(startNo, count, dm_pieces);
                    int iXPos = iCol * this.BLOCK_SIZE;
                    int iYPos = iRow * this.BLOCK_SIZE;
                    if (pctDone == 1.0) {
                        if (this.squareCache[squareNo] != pctDone) {
                            this.squareCache[squareNo] = pctDone;
                            gc2.drawImage(this.imgHaveAll, iXPos, iYPos);
                            if (!clearImage) {
                                ++numRedraws;
                                this.canvas.redraw(iXPos, iYPos, this.BLOCK_SIZE, this.BLOCK_SIZE, false);
                            }
                        }
                    } else if (pctDone == 0.0) {
                        if (this.squareCache[squareNo] != pctDone) {
                            this.squareCache[squareNo] = pctDone;
                            gc2.drawImage(this.imgNoHave, iXPos, iYPos);
                            if (!clearImage) {
                                ++numRedraws;
                                this.canvas.redraw(iXPos, iYPos, this.BLOCK_SIZE, this.BLOCK_SIZE, false);
                            }
                        }
                    } else {
                        boolean isDownloading = false;
                        int i2 = startNo;
                        while (i2 < startNo + count) {
                            if (Arrays.binarySearch(currentDLPieces, new Long(i2), this.compFindPEPiece) >= 0) {
                                isDownloading = true;
                                break;
                            }
                            ++i2;
                        }
                        double val = pctDone + (double)(!isDownloading ? 1 : 0);
                        if (this.squareCache[squareNo] != val) {
                            this.squareCache[squareNo] = val;
                            gc2.drawImage(this.imgNoHave, iXPos, iYPos);
                            int size = (int)((double)this.BLOCK_FILLSIZE * pctDone);
                            if (size == 0) {
                                size = 1;
                            }
                            int q = (int)((double)(this.BLOCK_FILLSIZE - size) / 2.0 + 0.5) + 1;
                            colorIndex = isDownloading ? 3 : 5;
                            gc2.setBackground(this.blockColors[colorIndex]);
                            gc2.fillOval(iXPos + q, iYPos + q, size, size);
                            if (!clearImage) {
                                ++numRedraws;
                                this.canvas.redraw(iXPos, iYPos, this.BLOCK_SIZE, this.BLOCK_SIZE, false);
                            }
                        }
                    }
                    int i3 = startNo;
                    while (i3 < startNo + count) {
                        if (Collections.binarySearch(currentULPieces, new Long(i3)) >= 0) {
                            colorIndex = 2;
                            int size = this.BLOCK_FILLSIZE + 1;
                            gc2.setForeground(this.blockColors[colorIndex]);
                            gc2.drawRoundRectangle(iXPos, iYPos, size, size, size, size);
                            if (!clearImage) {
                                ++numRedraws;
                                this.canvas.redraw(iXPos, iYPos, this.BLOCK_SIZE, this.BLOCK_SIZE, false);
                            }
                            this.squareCache[squareNo] = -1.0;
                            break;
                        }
                        if (Collections.binarySearch(futureULPieces, new Long(i3)) >= 0) {
                            colorIndex = 2;
                            int size = this.BLOCK_FILLSIZE + 1;
                            gc2.setForeground(this.blockColors[colorIndex]);
                            gc2.setLineStyle(3);
                            gc2.drawRoundRectangle(iXPos, iYPos, size, size, size, size);
                            if (!clearImage) {
                                ++numRedraws;
                                this.canvas.redraw(iXPos, iYPos, this.BLOCK_SIZE, this.BLOCK_SIZE, false);
                            }
                            gc2.setLineStyle(1);
                            this.squareCache[squareNo] = -1.0;
                            break;
                        }
                        ++i3;
                    }
                    if (availability != null) {
                        boolean hasNoAvail = false;
                        int i4 = startNo;
                        while (i4 < startNo + count) {
                            if (availability[i4] == 0) {
                                hasNoAvail = true;
                                this.squareCache[squareNo] = -1.0;
                                break;
                            }
                            ++i4;
                        }
                        if (hasNoAvail) {
                            gc2.setForeground(this.blockColors[4]);
                            gc2.drawRectangle(iXPos, iYPos, this.BLOCK_FILLSIZE + 1, this.BLOCK_FILLSIZE + 1);
                            if (!clearImage) {
                                ++numRedraws;
                                this.canvas.redraw(iXPos, iYPos, this.BLOCK_SIZE, this.BLOCK_SIZE, false);
                            }
                        }
                    }
                    ++iCol;
                    ++squareNo;
                }
            }
            catch (Exception e) {
                Debug.out(e);
                gc2.dispose();
            }
        }
        finally {
            gc2.dispose();
        }
    }

    private double getPercentDone(int startNo, int count, DiskManagerPiece[] dm_pieces) {
        int totalComplete = 0;
        int totalBlocks = 0;
        int i = startNo;
        while (i < startNo + count) {
            DiskManagerPiece piece = dm_pieces[i];
            int numBlocks = piece.getNbBlocks();
            totalBlocks += numBlocks;
            totalComplete = piece.isDone() ? (totalComplete += numBlocks) : (totalComplete += piece.getNbWritten());
            ++i;
        }
        return (double)totalComplete / (double)totalBlocks;
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.canvas);
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    private void delete() {
    }
}

