/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerPeerListener;
import com.biglybt.core.download.DownloadManagerPieceListener;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerListener;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.ui.common.table.TableView;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.views.PiecesViewBase;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import java.util.List;
import java.util.Map;

public class PiecesSuperView
extends PiecesViewBase
implements GlobalManagerListener,
DownloadManagerPieceListener,
DownloadManagerPeerListener {
    public static final String VIEW_ID = "AllPiecesView";
    private CopyOnWriteList<PEPeerManager> peer_managers = new CopyOnWriteList();

    public PiecesSuperView() {
        super(VIEW_ID);
    }

    @Override
    protected String getTableID() {
        return "AllPieces";
    }

    @Override
    public TableViewSWT<PEPiece> initYourTableView() {
        return this.initYourTableView("AllPieces");
    }

    @Override
    public void tableLifeCycleEventOccurred(TableView tv, int eventType, Map<String, Object> data) {
        super.tableLifeCycleEventOccurred(tv, eventType, data);
        switch (eventType) {
            case 0: {
                CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                    @Override
                    public void coreRunning(Core core) {
                        PiecesSuperView.this.registerGlobalManagerListener(core);
                    }
                });
                break;
            }
            case 1: {
                this.unregisterListeners();
            }
        }
    }

    private void registerGlobalManagerListener(Core core) {
        core.getGlobalManager().addListener(this);
        this.tv.processDataSourceQueue();
    }

    private void unregisterListeners() {
        try {
            GlobalManager gm = CoreFactory.getSingleton().getGlobalManager();
            gm.removeListener(this);
            for (DownloadManager dm : gm.getDownloadManagers()) {
                this.downloadManagerRemoved(dm);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void downloadManagerAdded(DownloadManager dm) {
        dm.addPieceListener(this, true);
        dm.addPeerListener(this, true);
    }

    @Override
    public void downloadManagerRemoved(DownloadManager dm) {
        dm.removePieceListener(this);
        dm.removePeerListener(this);
    }

    @Override
    protected List<PEPeerManager> getPeerManagers() {
        return this.peer_managers.getList();
    }

    @Override
    public void destroyInitiated() {
    }

    @Override
    public void destroyed() {
    }

    @Override
    public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
    }

    @Override
    public void peerManagerWillBeAdded(PEPeerManager manager) {
    }

    @Override
    public void peerManagerAdded(PEPeerManager manager) {
        this.peer_managers.add(manager);
    }

    @Override
    public void peerManagerRemoved(PEPeerManager manager) {
        this.peer_managers.remove(manager);
    }

    @Override
    public void peerAdded(PEPeer peer) {
    }

    @Override
    public void peerRemoved(PEPeer peer) {
    }

    @Override
    public void pieceAdded(PEPiece created) {
        this.tv.addDataSource(created);
    }

    @Override
    public void pieceRemoved(PEPiece removed) {
        this.tv.removeDataSource(removed);
    }

    @Override
    protected void updateSelectedContent() {
        Object[] dataSources = this.tv.getSelectedDataSources(true);
        ISelectedContent[] sc = new SelectedContent[dataSources.length];
        int i = 0;
        while (i < sc.length) {
            Object ds = dataSources[i];
            sc[i] = ds instanceof PEPiece ? new SelectedContent("piece: " + ((PEPiece)ds).getPieceNumber()) : new SelectedContent("piece: " + ds);
            ++i;
        }
        SelectedContentManager.changeCurrentlySelectedContent(this.tv.getTableID(), sc, this.tv);
    }
}

