/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerPeerListener;
import com.biglybt.core.download.DownloadManagerPieceListener;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.ui.common.table.TableDataSourceChangedListener;
import com.biglybt.ui.selectedcontent.ISelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContent;
import com.biglybt.ui.selectedcontent.SelectedContentManager;
import com.biglybt.ui.swt.views.PiecesViewBase;
import com.biglybt.ui.swt.views.table.TableViewSWT;
import com.biglybt.ui.swt.views.table.impl.TableViewSWT_TabsCommon;
import com.biglybt.util.DataSourceUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PiecesView
extends PiecesViewBase
implements DownloadManagerPeerListener,
DownloadManagerPieceListener,
TableDataSourceChangedListener {
    public static final String MSGID_PREFIX = "PiecesView";
    private DownloadManager manager;

    public PiecesView() {
        super(MSGID_PREFIX);
    }

    @Override
    protected List<PEPeerManager> getPeerManagers() {
        PEPeerManager pm;
        DownloadManager dm = this.manager;
        PEPeerManager pEPeerManager = pm = dm == null ? null : dm.getPeerManager();
        if (pm == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(pm);
    }

    @Override
    protected String getTableID() {
        return "Pieces";
    }

    @Override
    public TableViewSWT<PEPiece> initYourTableView() {
        TableViewSWT<PEPiece> tv = this.initYourTableView("Pieces");
        tv.addTableDataSourceChangedListener(this, true);
        return tv;
    }

    @Override
    public void tableDataSourceChanged(Object newDataSource) {
        DownloadManager newManager = DataSourceUtils.getDM(newDataSource);
        if (newManager == this.manager) {
            return;
        }
        if (this.manager != null) {
            this.manager.removePeerListener(this);
            this.manager.removePieceListener(this);
        }
        this.manager = newManager;
        this.clearUploadingPieces();
        if (this.tv == null || this.tv.isDisposed()) {
            return;
        }
        this.tv.removeAllTableRows();
        if (this.manager != null) {
            this.manager.addPeerListener(this, false);
            this.manager.addPieceListener(this, false);
            this.addExistingDatasources();
        }
    }

    @Override
    protected void updateSelectedContent() {
        Object[] dataSources = this.tv.getSelectedDataSources(true);
        if (dataSources.length == 0) {
            String id = "DMDetails_Pieces";
            DownloadManager manager = this.manager;
            if (manager != null) {
                id = manager.getTorrent() != null ? String.valueOf(id) + "." + manager.getInternalName() : String.valueOf(id) + ":" + manager.getSize();
                SelectedContentManager.changeCurrentlySelectedContent(id, new SelectedContent[]{new SelectedContent(manager)});
            } else {
                SelectedContentManager.changeCurrentlySelectedContent(id, null);
            }
        } else {
            ISelectedContent[] sc = new SelectedContent[dataSources.length];
            int i = 0;
            while (i < sc.length) {
                Object ds = dataSources[i];
                sc[i] = ds instanceof PEPiece ? new SelectedContent("piece: " + ((PEPiece)ds).getPieceNumber()) : new SelectedContent("piece: " + ds);
                ++i;
            }
            SelectedContentManager.changeCurrentlySelectedContent(this.tv.getTableID(), sc, this.tv);
        }
    }

    @Override
    protected void tableViewInitialized() {
    }

    @Override
    protected void tableViewDestroyed() {
        if (this.manager != null) {
            this.manager.removePeerListener(this);
            this.manager.removePieceListener(this);
            this.manager = null;
        }
    }

    @Override
    public void pieceAdded(PEPiece created) {
        this.tv.addDataSource(created);
    }

    @Override
    public void pieceRemoved(PEPiece removed) {
        this.tv.removeDataSource(removed);
    }

    @Override
    public void peerAdded(PEPeer peer) {
    }

    @Override
    public void peerRemoved(PEPeer peer) {
    }

    @Override
    public void peerManagerWillBeAdded(PEPeerManager peer_manager) {
    }

    @Override
    public void peerManagerAdded(PEPeerManager manager) {
    }

    @Override
    public void peerManagerRemoved(PEPeerManager manager) {
        this.tv.removeAllTableRows();
        this.clearUploadingPieces();
    }

    private void addExistingDatasources() {
        TableViewSWT_TabsCommon tabs;
        if (this.manager == null || this.tv == null || this.tv.isDisposed()) {
            return;
        }
        boolean process = false;
        PEPiece[] dataSources = this.manager.getCurrentPieces();
        if (dataSources.length > 0) {
            this.tv.addDataSources(dataSources);
            process = true;
        }
        if (this.updateUploadingPieces(false)) {
            process = true;
        }
        if (process) {
            this.tv.processDataSourceQueue();
        }
        if ((tabs = this.tv.getTabsCommon()) != null) {
            tabs.triggerTabViewsDataSourceChanged(this.tv);
        }
    }
}

