/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStateAttributeListener;
import com.biglybt.core.download.impl.DownloadManagerController;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerSource;
import com.biglybt.core.peer.util.PeerUtils;
import com.biglybt.core.proxy.AEProxySelector;
import com.biglybt.core.proxy.AEProxySelectorFactory;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLGroup;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.HostNameToIPResolver;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.ipc.IPCException;
import com.biglybt.pif.ipc.IPCInterface;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.I2PHelpers;
import com.biglybt.plugin.extseed.ExternalSeedPlugin;
import com.biglybt.plugin.extseed.ExternalSeedReader;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.TextViewerWindow;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.components.LinkLabel;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pifimpl.UISWTViewCoreEventListener;
import com.biglybt.ui.swt.utils.SWTRunnable;
import com.biglybt.ui.swt.views.ViewUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PrivacyView
implements UISWTViewCoreEventListener,
DownloadManagerStateAttributeListener {
    public static final String MSGID_PREFIX = "PrivacyView";
    private static boolean KEEP_VIEW = true;
    private static int MAX_LOOKUP_HISTORY = 16;
    private UISWTView swtView;
    private Composite cMainComposite;
    private ScrolledComposite sc;
    private Composite parent;
    private static final int PL_PUBLIC = 0;
    private static final int PL_MIX = 1;
    private static final int PL_ANONYMOUS = 2;
    private static final int PL_INVALID = 3;
    private int privacy_level;
    private Scale privacy_scale;
    private boolean i2p_install_prompted;
    private Button[] network_buttons;
    private Button[] source_buttons;
    private Button ipfilter_enabled;
    private BufferedLabel peer_info;
    private BufferedLabel torrent_info;
    private BufferedLabel tracker_info;
    private BufferedLabel webseed_info;
    private BufferedLabel vpn_info;
    private BufferedLabel socks_state;
    private BufferedLabel socks_current;
    private BufferedLabel socks_fails;
    private Label socks_more;
    private DownloadManager current_dm;
    private Set<String> enabled_networks = new HashSet<String>();
    private Set<String> enabled_sources = new HashSet<String>();
    private I2PStackItem current_i2p_entry;
    private Group i2p_stack_group;
    private StackLayout stack_layout;

    private String getFullTitle() {
        return MessageText.getString("label.privacy");
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                if (!KEEP_VIEW) break;
                this.swtView.setDestroyOnDeactivate(false);
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.parent = (Composite)event2.getData();
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.cMainComposite);
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                Object ds = event2.getData();
                this.dataSourceChanged(ds);
                break;
            }
            case 3: {
                this.initialize();
                if (this.current_dm != null) break;
                this.dataSourceChanged(this.swtView.getDataSource());
                break;
            }
            case 4: {
                if (KEEP_VIEW) break;
                this.delete();
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    private void delete() {
        Utils.disposeComposite((Composite)this.sc);
        this.dataSourceChanged(null);
    }

    private void refresh() {
        this.updatePeersEtc(this.current_dm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataSourceChanged(Object newDataSource) {
        PrivacyView privacyView = this;
        synchronized (privacyView) {
            DownloadManager new_dm = ViewUtils.getDownloadManagerFromDataSource(newDataSource, this.current_dm);
            if (new_dm == this.current_dm) {
                return;
            }
            final DownloadManager f_old_dm = this.current_dm;
            final DownloadManager f_new_dm = this.current_dm = new_dm;
            Utils.execSWTThread(new SWTRunnable(){

                @Override
                public void runWithDisplay(Display display) {
                    PrivacyView.this.swt_updateFields(f_old_dm, f_new_dm);
                }
            });
        }
    }

    private void initialize() {
        GridData gd;
        if (this.cMainComposite == null || this.cMainComposite.isDisposed()) {
            if (this.parent == null || this.parent.isDisposed()) {
                return;
            }
            this.sc = new ScrolledComposite(this.parent, 512);
            this.sc.setExpandHorizontal(true);
            this.sc.setExpandVertical(true);
            this.sc.getVerticalBar().setIncrement(16);
            Layout parentLayout = this.parent.getLayout();
            if (parentLayout instanceof GridLayout) {
                gd = new GridData(4, 4, true, true);
                this.sc.setLayoutData((Object)gd);
            } else if (parentLayout instanceof FormLayout) {
                this.sc.setLayoutData((Object)Utils.getFilledFormData());
            }
            this.cMainComposite = new Composite((Composite)this.sc, 0);
            this.sc.setContent((Control)this.cMainComposite);
        } else {
            if (KEEP_VIEW) {
                return;
            }
            Utils.disposeComposite(this.cMainComposite, false);
        }
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.cMainComposite.setLayout((Layout)layout);
        Composite overview_comp = new Composite(this.cMainComposite, 0);
        overview_comp.setLayout((Layout)new GridLayout(3, false));
        gd = new GridData(768);
        overview_comp.setLayoutData((Object)gd);
        Label label = new Label(overview_comp, 0);
        label.setText(MessageText.getString("privacy.view.intro"));
        new LinkLabel(overview_comp, "label.read.more", "https://wiki.biglybt.com/w/Privacy_View");
        Composite slider_comp = new Composite(this.cMainComposite, 0);
        layout = new GridLayout(3, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        slider_comp.setLayout((Layout)layout);
        gd = new GridData(768);
        slider_comp.setLayoutData((Object)gd);
        label = new Label(slider_comp, 0);
        label.setText(String.valueOf(MessageText.getString("privacy.view.level")) + ":");
        Composite slider2_comp = new Composite(slider_comp, 0);
        slider2_comp.setLayout((Layout)new GridLayout(6, true));
        gd = new GridData(768);
        slider2_comp.setLayoutData((Object)gd);
        label = new Label(slider2_comp, 0);
        label.setText(MessageText.getString("privacy.view.public.only"));
        label = new Label(slider2_comp, 0);
        label.setText(MessageText.getString("privacy.view.public.anon"));
        label.setAlignment(0x1000000);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label = new Label(slider2_comp, 0);
        label.setText(MessageText.getString("privacy.view.anon.only"));
        label.setAlignment(0x1000000);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label = new Label(slider2_comp, 0);
        label.setText(MessageText.getString("label.invalid"));
        gd = new GridData(768);
        gd.horizontalAlignment = 0x1000008;
        label.setLayoutData((Object)gd);
        this.privacy_scale = new Scale(slider2_comp, 256);
        gd = new GridData(768);
        gd.horizontalSpan = 6;
        this.privacy_scale.setLayoutData((Object)gd);
        this.privacy_scale.setMinimum(0);
        this.privacy_scale.setMaximum(30);
        final boolean[] slider_mouse_down = new boolean[1];
        this.privacy_scale.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                int pos = PrivacyView.this.privacy_scale.getSelection();
                int level = (pos + 5) / 10;
                if (level * 10 != pos) {
                    PrivacyView.this.privacy_scale.setSelection(level * 10);
                }
                PrivacyView.this.setPrivacyLevel(level);
                slider_mouse_down[0] = false;
            }

            public void mouseDown(MouseEvent e) {
                slider_mouse_down[0] = true;
            }
        });
        this.privacy_scale.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                if (!slider_mouse_down[0]) {
                    int pos = PrivacyView.this.privacy_scale.getSelection();
                    int level = (pos + 5) / 10;
                    PrivacyView.this.setPrivacyLevel(level);
                }
            }
        });
        Composite network_comp = new Composite(slider_comp, 0);
        gd = new GridData();
        network_comp.setLayoutData((Object)gd);
        this.network_buttons = new Button[AENetworkClassifier.AT_NETWORKS.length];
        network_comp.setLayout((Layout)new GridLayout(1, false));
        label = new Label(network_comp, 0);
        label.setText(String.valueOf(MessageText.getString("ConfigView.section.connection.group.networks")) + ":");
        int i = 0;
        while (i < this.network_buttons.length) {
            final String nn = AENetworkClassifier.AT_NETWORKS[i];
            String msg_text = "ConfigView.section.connection.networks." + nn;
            Button button = new Button(network_comp, 32);
            Messages.setLanguageText((Widget)button, msg_text);
            this.network_buttons[i] = button;
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = ((Button)e.widget).getSelection();
                    if (PrivacyView.this.current_dm != null) {
                        PrivacyView.this.current_dm.getDownloadState().setNetworkEnabled(nn, selected);
                    }
                }
            });
            GridData gridData = new GridData();
            button.setLayoutData((Object)gridData);
            ++i;
        }
        label = new Label(slider_comp, 0);
        final Composite tracker_webseed_comp = new Composite(slider_comp, 0);
        layout = new GridLayout(2, true);
        layout.marginRight = 1;
        layout.marginLeft = 1;
        layout.marginBottom = 1;
        layout.marginTop = 1;
        tracker_webseed_comp.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        tracker_webseed_comp.setLayoutData((Object)gd);
        tracker_webseed_comp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle client_area = tracker_webseed_comp.getClientArea();
                Rectangle rect = new Rectangle(0, 0, client_area.width - 1, client_area.height - 1);
                e.gc.setAlpha(50);
                e.gc.drawRectangle(rect);
            }
        });
        Composite tracker_comp = new Composite(tracker_webseed_comp, 0);
        gd = new GridData(768);
        tracker_comp.setLayoutData((Object)gd);
        tracker_comp.setLayout((Layout)new GridLayout(2, false));
        label = new Label(tracker_comp, 0);
        label.setText(String.valueOf(MessageText.getString("label.trackers")) + ":");
        this.tracker_info = new BufferedLabel(tracker_comp, 0x20000000);
        gd = new GridData(768);
        this.tracker_info.setLayoutData(gd);
        Composite webseed_comp = new Composite(tracker_webseed_comp, 0);
        gd = new GridData(768);
        webseed_comp.setLayoutData((Object)gd);
        webseed_comp.setLayout((Layout)new GridLayout(2, false));
        label = new Label(webseed_comp, 0);
        label.setText(String.valueOf(MessageText.getString("label.webseeds")) + ":");
        this.webseed_info = new BufferedLabel(webseed_comp, 0x20000000);
        gd = new GridData(768);
        this.webseed_info.setLayoutData(gd);
        Composite peer_comp = new Composite(tracker_webseed_comp, 0);
        gd = new GridData(768);
        peer_comp.setLayoutData((Object)gd);
        peer_comp.setLayout((Layout)new GridLayout(2, false));
        label = new Label(peer_comp, 0);
        label.setText(String.valueOf(MessageText.getString("TableColumn.header.peers")) + ":");
        this.peer_info = new BufferedLabel(peer_comp, 0x20000000);
        gd = new GridData(768);
        this.peer_info.setLayoutData(gd);
        this.i2p_stack_group = Utils.createSkinnedGroup(this.cMainComposite, 0);
        this.i2p_stack_group.setText("I2P");
        this.stack_layout = new StackLayout();
        this.i2p_stack_group.setLayout((Layout)this.stack_layout);
        gd = new GridData(768);
        this.i2p_stack_group.setLayoutData((Object)gd);
        this.current_i2p_entry = new I2PStackItem((Composite)this.i2p_stack_group, null);
        this.stack_layout.topControl = this.current_i2p_entry.getComposite();
        Group bottom_comp = Utils.createSkinnedGroup(this.cMainComposite, 0);
        gd = new GridData(768);
        bottom_comp.setLayoutData((Object)gd);
        bottom_comp.setLayout((Layout)new GridLayout(2, false));
        label = new Label((Composite)bottom_comp, 0);
        label.setText(String.valueOf(MessageText.getString("authenticator.torrent")) + ":");
        Composite torrent_comp = new Composite((Composite)bottom_comp, 0);
        gd = new GridData(768);
        torrent_comp.setLayoutData((Object)gd);
        torrent_comp.setLayout((Layout)this.removeMarginsAndSpacing(new GridLayout(2, false)));
        this.torrent_info = new BufferedLabel(torrent_comp, 0x20000000);
        gd = new GridData(768);
        this.torrent_info.setLayoutData(gd);
        label = new Label((Composite)bottom_comp, 0);
        label.setText(String.valueOf(MessageText.getString("ConfigView.section.connection.group.peersources")) + ":");
        Composite sources_comp = new Composite((Composite)bottom_comp, 0);
        gd = new GridData(768);
        sources_comp.setLayoutData((Object)gd);
        this.source_buttons = new Button[PEPeerSource.PS_SOURCES.length];
        sources_comp.setLayout((Layout)this.removeMargins(new GridLayout(this.source_buttons.length + 1, false)));
        int i2 = 0;
        while (i2 < this.source_buttons.length) {
            final String src = PEPeerSource.PS_SOURCES[i2];
            String msg_text = "ConfigView.section.connection.peersource." + src;
            Button button = new Button(sources_comp, 32);
            Messages.setLanguageText((Widget)button, msg_text);
            this.source_buttons[i2] = button;
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = ((Button)e.widget).getSelection();
                    if (PrivacyView.this.current_dm != null) {
                        PrivacyView.this.current_dm.getDownloadState().setPeerSourceEnabled(src, selected);
                    }
                }
            });
            GridData gridData = new GridData();
            button.setLayoutData((Object)gridData);
            ++i2;
        }
        label = new Label((Composite)bottom_comp, 0);
        label.setText(String.valueOf(MessageText.getString("label.ip.filter")) + ":");
        Composite ipfilter_comp = new Composite((Composite)bottom_comp, 0);
        gd = new GridData(768);
        ipfilter_comp.setLayoutData((Object)gd);
        ipfilter_comp.setLayout((Layout)this.removeMargins(new GridLayout(2, false)));
        this.ipfilter_enabled = new Button(ipfilter_comp, 32);
        this.ipfilter_enabled.setText(MessageText.getString("label.enabled"));
        this.ipfilter_enabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrivacyView.this.current_dm.getDownloadState().setFlag(256L, !PrivacyView.this.ipfilter_enabled.getSelection());
            }
        });
        gd = new GridData(768);
        this.ipfilter_enabled.setLayoutData((Object)gd);
        label = new Label((Composite)bottom_comp, 0);
        label.setText(String.valueOf(MessageText.getString("label.vpn.status")) + ":");
        Composite vpn_comp = new Composite((Composite)bottom_comp, 0);
        gd = new GridData(768);
        vpn_comp.setLayoutData((Object)gd);
        vpn_comp.setLayout((Layout)this.removeMargins(new GridLayout(2, false)));
        this.vpn_info = new BufferedLabel(vpn_comp, 0x20000000);
        gd = new GridData(768);
        this.vpn_info.setLayoutData(gd);
        label = new Label((Composite)bottom_comp, 0);
        label.setText(String.valueOf(MessageText.getString("label.socks.status")) + ":");
        Composite socks_comp = new Composite((Composite)bottom_comp, 0);
        gd = new GridData(768);
        socks_comp.setLayoutData((Object)gd);
        socks_comp.setLayout((Layout)this.removeMargins(new GridLayout(10, false)));
        label = new Label(socks_comp, 0);
        label.setText(String.valueOf(MessageText.getString("label.proxy")) + ":");
        this.socks_state = new BufferedLabel(socks_comp, 0x20000000);
        gd = new GridData();
        gd.widthHint = 120;
        this.socks_state.setLayoutData(gd);
        label = new Label(socks_comp, 0);
        label.setText(String.valueOf(MessageText.getString("PeersView.state")) + ":");
        this.socks_current = new BufferedLabel(socks_comp, 0x20000000);
        gd = new GridData();
        gd.widthHint = 120;
        this.socks_current.setLayoutData(gd);
        label = new Label(socks_comp, 0);
        label.setText(String.valueOf(MessageText.getString("label.fails")) + ":");
        this.socks_fails = new BufferedLabel(socks_comp, 0x20000000);
        gd = new GridData();
        gd.widthHint = 120;
        this.socks_fails.setLayoutData(gd);
        label = new Label(socks_comp, 0);
        gd = new GridData(768);
        gd.horizontalAlignment = 32;
        this.socks_more = new Label(socks_comp, 0);
        this.socks_more.setText(String.valueOf(MessageText.getString("label.more")) + "...");
        this.socks_more.setLayoutData((Object)gd);
        this.socks_more.setCursor(this.socks_more.getDisplay().getSystemCursor(21));
        Utils.setLinkForeground((Control)this.socks_more);
        this.socks_more.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                PrivacyView.this.showSOCKSInfo();
            }

            public void mouseUp(MouseEvent arg0) {
                PrivacyView.this.showSOCKSInfo();
            }
        });
        this.sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = PrivacyView.this.sc.getClientArea();
                Point size = PrivacyView.this.cMainComposite.computeSize(r.width, -1);
                PrivacyView.this.sc.setMinSize(size);
            }
        });
        this.swt_updateFields(null, this.current_dm);
        this.updatePeersEtc(this.current_dm);
        this.updateVPNSocks();
        Rectangle r = this.sc.getClientArea();
        Point size = this.cMainComposite.computeSize(r.width, -1);
        this.sc.setMinSize(size);
        Utils.relayout((Control)this.cMainComposite);
    }

    private static void injectResult(Download download, final int[] result) {
        int total;
        DownloadScrapeResult scrape = download.getAggregatedScrapeResult();
        if (scrape.getResponseType() == 1 && (total = scrape.getNonSeedCount() + scrape.getSeedCount()) >= result[0] + result[1]) {
            return;
        }
        download.setScrapeResult(new DownloadScrapeResult(){

            @Override
            public Download getDownload() {
                return null;
            }

            @Override
            public int getResponseType() {
                return 1;
            }

            @Override
            public int getSeedCount() {
                return result[0];
            }

            @Override
            public int getNonSeedCount() {
                return result[1];
            }

            @Override
            public long getScrapeStartTime() {
                return SystemTime.getCurrentTime();
            }

            @Override
            public void setNextScrapeStartTime(long nextScrapeStartTime) {
            }

            @Override
            public long getNextScrapeStartTime() {
                return 0L;
            }

            @Override
            public String getStatus() {
                return "OK";
            }

            @Override
            public URL getURL() {
                try {
                    return new URL("dht:");
                }
                catch (Throwable e) {
                    return null;
                }
            }
        });
    }

    private void setPrivacyLevel(final int level) {
        if (level != this.privacy_level) {
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    if (level == PrivacyView.this.privacy_level) {
                        return;
                    }
                    PrivacyView.this.privacy_level = level;
                    DownloadManager dm = PrivacyView.this.current_dm;
                    if (dm == null) {
                        return;
                    }
                    DownloadManagerState state = dm.getDownloadState();
                    String[] new_nets = level == 0 ? new String[]{"Public"} : (level == 1 ? AENetworkClassifier.AT_NETWORKS : (level == 2 ? AENetworkClassifier.AT_NON_PUBLIC : new String[]{}));
                    state.setNetworks(new_nets);
                    if (level != 0 && !I2PHelpers.isI2PInstalled() && !PrivacyView.this.i2p_install_prompted) {
                        PrivacyView.this.i2p_install_prompted = true;
                        I2PHelpers.installI2PHelper(null, null, new Runnable(){

                            @Override
                            public void run() {
                                Utils.execSWTThread(new AERunnable(){

                                    @Override
                                    public void runSupport() {
                                        PrivacyView.this.current_i2p_entry.updateState();
                                    }
                                });
                            }
                        });
                    }
                }
            });
        }
    }

    private void swt_updateFields(DownloadManager old_dm, DownloadManager new_dm) {
        DownloadManagerState state;
        TOTorrent torrent;
        if (this.cMainComposite == null || this.cMainComposite.isDisposed()) {
            return;
        }
        byte[] hash = null;
        if (new_dm != null && (torrent = new_dm.getTorrent()) != null) {
            try {
                hash = torrent.getHash();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.current_i2p_entry.reset(hash);
        if (old_dm != null) {
            state = old_dm.getDownloadState();
            state.removeListener(this, "networks", 1);
            state.removeListener(this, "peersources", 1);
            state.removeListener(this, "flags", 1);
        }
        if (new_dm != null) {
            state = new_dm.getDownloadState();
            state.addListener(this, "networks", 1);
            state.addListener(this, "peersources", 1);
            state.addListener(this, "flags", 1);
            this.setupNetworksAndSources(new_dm);
            this.setupTorrentTracker(new_dm);
        } else {
            this.setupNetworksAndSources(null);
            this.setupTorrentTracker(null);
        }
    }

    private void setupNetworksAndSources(final DownloadManager dm) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                PrivacyView.this.enabled_networks.clear();
                PrivacyView.this.enabled_sources.clear();
                if (PrivacyView.this.network_buttons == null || PrivacyView.this.network_buttons[0].isDisposed()) {
                    return;
                }
                DownloadManagerState state = null;
                String[] networks = null;
                String[] sources = null;
                if (dm != null) {
                    state = dm.getDownloadState();
                    networks = state.getNetworks();
                    sources = state.getPeerSources();
                }
                PrivacyView.this.privacy_scale.setEnabled(networks != null);
                if (networks != null) {
                    PrivacyView.this.enabled_networks.addAll(Arrays.asList(networks));
                    int pl = PrivacyView.this.enabled_networks.contains("Public") ? (PrivacyView.this.enabled_networks.size() == 1 ? 0 : 1) : (PrivacyView.this.enabled_networks.size() == 0 ? 3 : 2);
                    PrivacyView.this.privacy_level = pl;
                    PrivacyView.this.privacy_scale.setSelection(pl * 10);
                }
                int i = 0;
                while (i < AENetworkClassifier.AT_NETWORKS.length) {
                    String net = AENetworkClassifier.AT_NETWORKS[i];
                    PrivacyView.this.network_buttons[i].setEnabled(networks != null);
                    PrivacyView.this.network_buttons[i].setSelection(PrivacyView.this.enabled_networks.contains(net));
                    ++i;
                }
                if (sources != null) {
                    PrivacyView.this.enabled_sources.addAll(Arrays.asList(sources));
                }
                i = 0;
                while (i < PEPeerSource.PS_SOURCES.length) {
                    String source = PEPeerSource.PS_SOURCES[i];
                    PrivacyView.this.source_buttons[i].setEnabled(sources != null && state.isPeerSourcePermitted(source));
                    PrivacyView.this.source_buttons[i].setSelection(PrivacyView.this.enabled_sources.contains(source));
                    ++i;
                }
                if (state != null) {
                    PrivacyView.this.ipfilter_enabled.setEnabled(true);
                    PrivacyView.this.ipfilter_enabled.setSelection(!state.getFlag(256L));
                } else {
                    PrivacyView.this.ipfilter_enabled.setEnabled(false);
                }
                PrivacyView.this.setupTorrentTracker(dm);
            }
        });
    }

    private void setupTorrentTracker(final DownloadManager dm) {
        Utils.execSWTThread(new AERunnable(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void runSupport() {
                ExternalSeedReader[] seeds;
                int n;
                int n2;
                Object[] objectArray;
                TOTorrentAnnounceURLSet[] sets;
                TOTorrent torrent;
                if (PrivacyView.this.torrent_info == null || PrivacyView.this.torrent_info.isDisposed()) {
                    return;
                }
                TOTorrent tOTorrent = torrent = dm == null ? null : dm.getTorrent();
                if (torrent == null) {
                    PrivacyView.this.torrent_info.setText("");
                    PrivacyView.this.tracker_info.setText("");
                    PrivacyView.this.webseed_info.setText("");
                    return;
                }
                boolean private_torrent = torrent.getPrivate();
                PrivacyView.this.torrent_info.setText(MessageText.getString(private_torrent ? "label.private" : "subs.prop.is_public"));
                boolean decentralised = false;
                HashSet<String> tracker_nets = new HashSet<String>();
                URL announce_url = torrent.getAnnounceURL();
                if (announce_url != null) {
                    if (TorrentUtils.isDecentralised(announce_url)) {
                        decentralised = true;
                    } else {
                        String net = AENetworkClassifier.categoriseAddress(announce_url.getHost());
                        tracker_nets.add(net);
                    }
                }
                TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
                TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = sets = group.getAnnounceURLSets();
                int n3 = sets.length;
                int n4 = 0;
                while (n4 < n3) {
                    TOTorrentAnnounceURLSet set = tOTorrentAnnounceURLSetArray[n4];
                    URL[] urls = set.getAnnounceURLs();
                    objectArray = urls;
                    n2 = urls.length;
                    n = 0;
                    while (n < n2) {
                        URL uRL = objectArray[n];
                        if (TorrentUtils.isDecentralised(uRL)) {
                            decentralised = true;
                        } else {
                            String net = AENetworkClassifier.categoriseAddress(uRL.getHost());
                            tracker_nets.add(net);
                        }
                        ++n;
                    }
                    ++n4;
                }
                boolean tracker_source_enabled = PrivacyView.this.enabled_sources.contains("Tracker");
                boolean dht_source_enabled = PrivacyView.this.enabled_sources.contains("DHT");
                String tracker_str = "";
                tracker_str = MessageText.getString("label.decentralised");
                String disabled_str = MessageText.getString("label.disabled");
                String net_string = "";
                if (dht_source_enabled && !private_torrent) {
                    objectArray = new String[]{"Public", "I2P"};
                    n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        Object object = objectArray[n];
                        if (PrivacyView.this.enabled_networks.contains(object)) {
                            net_string = String.valueOf(net_string) + (net_string.length() == 0 ? "" : ", ") + (String)object;
                        }
                        ++n;
                    }
                }
                tracker_str = net_string.length() == 0 ? String.valueOf(tracker_str) + " (" + disabled_str + ")" : String.valueOf(tracker_str) + " [" + net_string + "]";
                for (String string : tracker_nets) {
                    void var13_21;
                    if (!tracker_source_enabled || !PrivacyView.this.enabled_networks.contains(string)) {
                        String string2 = String.valueOf(string) + " (" + disabled_str + ")";
                    }
                    tracker_str = String.valueOf(tracker_str) + (tracker_str.length() == 0 ? "" : ", ") + (String)var13_21;
                }
                PrivacyView.this.tracker_info.setText(tracker_str);
                HashSet<String> hashSet = new HashSet<String>();
                ExternalSeedPlugin esp = DownloadManagerController.getExternalSeedPlugin();
                if (esp != null && (seeds = esp.getManualWebSeeds(PluginCoreUtils.wrap(torrent))) != null) {
                    ExternalSeedReader[] externalSeedReaderArray = seeds;
                    int n5 = seeds.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ExternalSeedReader seed = externalSeedReaderArray[n6];
                        URL u = seed.getURL();
                        String net = AENetworkClassifier.categoriseAddress(u.getHost());
                        hashSet.add(net);
                        ++n6;
                    }
                }
                String webseeds_str = "";
                if (hashSet.isEmpty()) {
                    webseeds_str = MessageText.getString("label.none");
                } else {
                    for (String net : hashSet) {
                        if (!PrivacyView.this.enabled_networks.contains(net)) {
                            net = String.valueOf(net) + " (" + disabled_str + ")";
                        }
                        webseeds_str = String.valueOf(webseeds_str) + (webseeds_str.length() == 0 ? "" : ", ") + net;
                    }
                }
                PrivacyView.this.webseed_info.setText(webseeds_str);
            }
        });
    }

    private void updatePeersEtc(final DownloadManager dm) {
        final PEPeerManager pm = dm != null ? dm.getPeerManager() : null;
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                if (PrivacyView.this.peer_info == null || PrivacyView.this.peer_info.isDisposed()) {
                    return;
                }
                if (pm == null) {
                    PrivacyView.this.peer_info.setText(dm == null ? "" : MessageText.getString("privacy.view.dl.not.running"));
                } else {
                    AEProxySelector proxy_selector = AEProxySelectorFactory.getSelector();
                    Proxy proxy = proxy_selector.getActiveProxy();
                    boolean socks_bad_incoming = false;
                    List<PEPeer> peers = pm.getPeers();
                    String[] all_nets = AENetworkClassifier.AT_NETWORKS;
                    int[] counts = new int[all_nets.length];
                    int incoming = 0;
                    int outgoing = 0;
                    int outgoing_connected = 0;
                    for (PEPeer peer : peers) {
                        String net = PeerUtils.getNetwork(peer);
                        int i = 0;
                        while (i < all_nets.length) {
                            if (all_nets[i] == net) {
                                int n = i;
                                counts[n] = counts[n] + 1;
                                break;
                            }
                            ++i;
                        }
                        boolean is_incoming = peer.isIncoming();
                        if (is_incoming) {
                            ++incoming;
                        } else {
                            ++outgoing;
                            if (peer.getPeerState() == 30) {
                                ++outgoing_connected;
                            }
                        }
                        if (proxy == null || !is_incoming || peer.isLANLocal()) continue;
                        try {
                            if (InetAddress.getByAddress(HostNameToIPResolver.hostAddressToBytes(peer.getIp())).isLoopbackAddress()) {
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        socks_bad_incoming = true;
                        break;
                    }
                    String str = "";
                    int i = 0;
                    while (i < all_nets.length) {
                        int num = counts[i];
                        if (num > 0) {
                            str = String.valueOf(str) + (str.length() == 0 ? "" : ", ") + all_nets[i] + "=" + num;
                        }
                        ++i;
                    }
                    str = str.length() == 0 ? MessageText.getString("privacy.view.no.peers") : String.valueOf(str) + ", " + MessageText.getString("label.incoming") + "=" + incoming + ", " + MessageText.getString("label.outgoing") + "=" + outgoing_connected + "/" + outgoing;
                    if (socks_bad_incoming) {
                        str = String.valueOf(str) + " (" + MessageText.getString("privacy.view.non.local.peer") + ")";
                    }
                    PrivacyView.this.peer_info.setText(str);
                }
                PrivacyView.this.updateVPNSocks();
            }
        });
    }

    private void updateVPNSocks() {
        AEProxySelector proxy_selector = AEProxySelectorFactory.getSelector();
        Proxy proxy = proxy_selector.getActiveProxy();
        this.socks_more.setEnabled(proxy != null);
        if (Constants.isOSX) {
            this.socks_more.setForeground(proxy == null ? Colors.light_grey : Colors.blue);
        }
        this.socks_state.setText(proxy == null ? MessageText.getString("label.inactive") : ((InetSocketAddress)proxy.address()).getHostName());
        if (proxy == null) {
            this.socks_current.setText("");
            this.socks_fails.setText("");
        } else {
            long last_con = proxy_selector.getLastConnectionTime();
            long last_fail = proxy_selector.getLastFailTime();
            int total_cons = proxy_selector.getConnectionCount();
            int total_fails = proxy_selector.getFailCount();
            long now = SystemTime.getMonotonousTime();
            long con_ago = now - last_con;
            long fail_ago = now - last_fail;
            String state_str = last_fail < 0L ? "PeerManager.status.ok" : (fail_ago > 60000L ? (con_ago < fail_ago ? "PeerManager.status.ok" : "SpeedView.stats.unknown") : "ManagerItem.error");
            this.socks_current.setText(String.valueOf(MessageText.getString(state_str)) + ", con=" + total_cons);
            long fail_ago_secs = fail_ago / 1000L;
            if (fail_ago_secs == 0L) {
                fail_ago_secs = 1L;
            }
            this.socks_fails.setText(last_fail < 0L ? "" : String.valueOf(DisplayFormatters.formatETA(fail_ago_secs, false)) + " " + MessageText.getString("label.ago") + ", tot=" + total_fails);
        }
        String info = NetworkAdmin.getSingleton().getBindStatus();
        String[] lines = info.split("\n");
        this.vpn_info.setText(lines.length == 0 ? "" : lines[0].trim());
    }

    @Override
    public void attributeEventOccurred(DownloadManager download, String attribute, int event_type) {
        this.setupNetworksAndSources(download);
    }

    private void showSOCKSInfo() {
        AEProxySelector proxy_selector = AEProxySelectorFactory.getSelector();
        String info = proxy_selector.getInfo();
        TextViewerWindow viewer = new TextViewerWindow(MessageText.getString("proxy.info.title"), null, info, false);
    }

    private GridLayout removeMarginsAndSpacing(GridLayout layout) {
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    private GridLayout removeMargins(GridLayout layout) {
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    private class I2PStackItem {
        private Composite i2p_group;
        private Composite i2p_lookup_comp;
        private Button i2p_install_button;
        private Button i2p_lookup_button;
        private Label i2p_options_link;
        private BufferedLabel i2p_result_summary;
        private Text i2p_result_list;
        private byte[] current_hash;
        private boolean lookup_performed;
        private boolean lookup_active;
        private long last_used = SystemTime.getMonotonousTime();

        I2PStackItem(Composite parent, byte[] hash) {
            this.current_hash = hash;
            this.i2p_group = new Composite(parent, 0);
            GridData gd = new GridData(768);
            this.i2p_group.setLayoutData((Object)gd);
            this.i2p_group.setLayout((Layout)new GridLayout(4, false));
            this.i2p_group.setData("item", (Object)this);
            Label label = new Label(this.i2p_group, 0);
            label.setText(MessageText.getString("privacy.view.lookup.info"));
            gd = new GridData();
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
            label = new Label(this.i2p_group, 0);
            label.setText(String.valueOf(MessageText.getString("label.lookup.status")) + ":");
            this.i2p_result_summary = new BufferedLabel(this.i2p_group, 0x20000000);
            gd = new GridData(768);
            this.i2p_result_summary.setLayoutData(gd);
            Composite i2p_button_comp = new Composite(this.i2p_group, 0);
            i2p_button_comp.setLayout((Layout)new GridLayout(2, false));
            gd = new GridData(1040);
            i2p_button_comp.setLayoutData((Object)gd);
            label = new Label(i2p_button_comp, 0);
            label.setText(MessageText.getString("GeneralView.section.availability"));
            this.i2p_install_button = new Button(i2p_button_comp, 8);
            this.i2p_install_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event2) {
                    boolean[] result = new boolean[1];
                    I2PHelpers.installI2PHelper(null, result, new Runnable(){

                        @Override
                        public void run() {
                            Utils.execSWTThread(new Runnable(){

                                @Override
                                public void run() {
                                    PrivacyView.this.current_i2p_entry.updateState();
                                }
                            });
                        }
                    });
                }
            });
            gd = new GridData();
            gd.widthHint = 300;
            gd.heightHint = 150;
            this.i2p_lookup_comp = Utils.createSkinnedComposite(this.i2p_group, 2048, gd);
            this.i2p_lookup_comp.setBackground(Utils.isDarkAppearanceNative() ? null : Colors.white);
            this.i2p_result_list = new Text(this.i2p_group, 526920);
            gd = new GridData(1808);
            gd.horizontalSpan = 2;
            this.i2p_result_list.setLayoutData((Object)gd);
            this.i2p_result_list.setEditable(false);
            label = new Label(i2p_button_comp, 0);
            label.setText(MessageText.getString("button.lookup.peers"));
            this.i2p_lookup_button = new Button(i2p_button_comp, 8);
            this.i2p_lookup_button.setText(MessageText.getString("button.search.dht"));
            this.i2p_lookup_button.addSelectionListener((SelectionListener)new SelectionAdapter(){
                private int search_count;

                public void widgetSelected(SelectionEvent event2) {
                    Utils.disposeComposite(I2PStackItem.this.i2p_lookup_comp, false);
                    I2PStackItem.this.i2p_result_summary.setText("");
                    I2PStackItem.this.i2p_result_list.setText("");
                    PluginInterface i2p_pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azneti2phelper", true);
                    if (i2p_pi != null) {
                        IPCInterface ipc = i2p_pi.getIPC();
                        HashMap<String, Object> options = new HashMap<String, Object>();
                        options.put("server_id", "Scraper");
                        options.put("server_id_transient", true);
                        options.put("ui_composite", I2PStackItem.this.i2p_lookup_comp);
                        final byte[] hash = I2PStackItem.this.current_hash;
                        ++this.search_count;
                        final int search_id = this.search_count;
                        IPCInterface callback = new IPCInterface(){
                            final int[] result = new int[]{-1, -1};

                            @Override
                            public Object invoke(String methodName, final Object[] params) throws IPCException {
                                if (search_id != search_count) {
                                    return null;
                                }
                                if (methodName.equals("statusUpdate")) {
                                    final int status = (Integer)params[0];
                                    if (status != 9 && status != 4) {
                                        Utils.execSWTThread(new Runnable(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            @Override
                                            public void run() {
                                                if (I2PStackItem.this.i2p_group.isDisposed() || !Arrays.equals(hash, I2PStackItem.this.current_hash)) {
                                                    return;
                                                }
                                                I2PStackItem.this.setLookupActive(false);
                                                int[] nArray = result;
                                                synchronized (result) {
                                                    if (result[0] != -1) {
                                                        try {
                                                            Download d = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getDownloadManager().getDownload(hash);
                                                            if (d != null) {
                                                                PrivacyView.injectResult(d, result);
                                                            }
                                                        }
                                                        catch (Throwable throwable) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    // ** MonitorExit[var1_1] (shouldn't be in output)
                                                    if (I2PStackItem.this.i2p_result_list.getText().length() == 0 && status != 8) {
                                                        I2PStackItem.this.i2p_result_summary.setText(MessageText.getString("label.no.peers.found"));
                                                    }
                                                    return;
                                                }
                                            }
                                        });
                                    }
                                    if (params.length == 4) {
                                        Utils.execSWTThread(new Runnable(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            @Override
                                            public void run() {
                                                if (I2PStackItem.this.i2p_group.isDisposed() || !Arrays.equals(hash, I2PStackItem.this.current_hash)) {
                                                    return;
                                                }
                                                int seeds = (Integer)params[1];
                                                int leechers = (Integer)params[2];
                                                int peers = (Integer)params[3];
                                                int[] nArray = result;
                                                synchronized (result) {
                                                    result[0] = seeds;
                                                    result[1] = leechers;
                                                    // ** MonitorExit[var4_4] (shouldn't be in output)
                                                    I2PStackItem.this.i2p_result_summary.setText(MessageText.getString("privacy.view.lookup.msg", new String[]{String.valueOf(seeds), String.valueOf(leechers), String.valueOf(peers)}));
                                                    return;
                                                }
                                            }
                                        });
                                    }
                                } else if (methodName.equals("msgUpdate")) {
                                    Utils.execSWTThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (I2PStackItem.this.i2p_group.isDisposed() || !Arrays.equals(hash, I2PStackItem.this.current_hash)) {
                                                return;
                                            }
                                            String msg = (String)params[0];
                                            I2PStackItem.this.i2p_result_summary.setText(msg);
                                        }
                                    });
                                } else if (methodName.equals("peerFound")) {
                                    Utils.execSWTThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (I2PStackItem.this.i2p_group.isDisposed() || !Arrays.equals(hash, I2PStackItem.this.current_hash)) {
                                                return;
                                            }
                                            String host = (String)params[0];
                                            int peer_type = (Integer)params[1];
                                            I2PStackItem.this.i2p_result_list.append(String.valueOf(host) + "\r\n");
                                        }
                                    });
                                }
                                return null;
                            }

                            @Override
                            public boolean canInvoke(String methodName, Object[] params) {
                                return true;
                            }
                        };
                        I2PStackItem.this.setLookupActive(true);
                        I2PStackItem.this.i2p_result_summary.setText(MessageText.getString("label.searching"));
                        try {
                            ipc.invoke("lookupTorrent", new Object[]{"", hash, options, callback});
                        }
                        catch (Throwable e) {
                            I2PStackItem.this.setLookupActive(false);
                            e.printStackTrace();
                        }
                    }
                }
            });
            Label i2p_options_info = new Label(i2p_button_comp, 64);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            gd.widthHint = 150;
            i2p_options_info.setLayoutData((Object)gd);
            i2p_options_info.setText(MessageText.getString("privacy.view.check.bw.info"));
            if (!COConfigurationManager.getBooleanParameter("privacy.view.check.bw.clicked", false)) {
                FontData fontData = i2p_options_info.getFont().getFontData()[0];
                final Font bold_font = new Font((Device)i2p_options_info.getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 1));
                i2p_options_info.setFont(bold_font);
                i2p_options_info.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        bold_font.dispose();
                    }
                });
            }
            this.i2p_options_link = new Label(i2p_button_comp, 0);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.i2p_options_link.setLayoutData((Object)gd);
            this.i2p_options_link.setText(MessageText.getString("privacy.view.check.bw"));
            this.i2p_options_link.setCursor(this.i2p_options_link.getDisplay().getSystemCursor(21));
            Utils.setLinkForeground((Control)this.i2p_options_link);
            this.i2p_options_link.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    this.openOptions();
                }

                public void mouseUp(MouseEvent arg0) {
                    this.openOptions();
                }

                private void openOptions() {
                    COConfigurationManager.setParameter("privacy.view.check.bw.clicked", true);
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (uif != null) {
                        uif.getMDI().showEntryByID("ConfigView", "azi2phelper.name");
                    }
                }
            });
            this.updateState();
            Utils.makeButtonsEqualWidth(Arrays.asList(this.i2p_install_button, this.i2p_lookup_button));
            label = new Label(i2p_button_comp, 0);
            gd = new GridData(1808);
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
        }

        private Composite getComposite() {
            return this.i2p_group;
        }

        private void setLookupActive(boolean active) {
            this.lookup_active = active;
            if (active) {
                this.lookup_performed = true;
            }
            this.i2p_lookup_button.setEnabled(!active);
        }

        private void reset(byte[] hash) {
            Control[] kids;
            if (Arrays.equals(hash, this.current_hash)) {
                this.updateState();
                return;
            }
            if (hash != null) {
                Control[] controlArray = kids = PrivacyView.this.i2p_stack_group.getChildren();
                int n = kids.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    I2PStackItem item = (I2PStackItem)c.getData("item");
                    if (item != null && Arrays.equals(item.current_hash, hash)) {
                        PrivacyView.this.current_i2p_entry = item;
                        ((PrivacyView)PrivacyView.this).stack_layout.topControl = c;
                        PrivacyView.this.i2p_stack_group.layout(true, true);
                        item.updateState();
                        return;
                    }
                    ++n2;
                }
            }
            if (this.lookup_performed) {
                kids = PrivacyView.this.i2p_stack_group.getChildren();
                long oldest_time = SystemTime.getMonotonousTime();
                Control oldest_comp = null;
                int num = 0;
                Control[] controlArray = kids;
                int n = kids.length;
                int n3 = 0;
                while (n3 < n) {
                    Control c = controlArray[n3];
                    I2PStackItem item = (I2PStackItem)c.getData("item");
                    if (item != null) {
                        ++num;
                        if (item.last_used < oldest_time) {
                            oldest_time = item.last_used;
                            oldest_comp = c;
                        }
                    }
                    ++n3;
                }
                if (num > MAX_LOOKUP_HISTORY) {
                    oldest_comp.dispose();
                }
                PrivacyView.this.current_i2p_entry = new I2PStackItem((Composite)PrivacyView.this.i2p_stack_group, hash);
                ((PrivacyView)PrivacyView.this).stack_layout.topControl = PrivacyView.this.current_i2p_entry.getComposite();
                PrivacyView.this.i2p_stack_group.layout(true, true);
            } else {
                this.current_hash = hash;
                this.updateState();
                Utils.disposeComposite(this.i2p_lookup_comp, false);
                this.i2p_result_summary.setText("");
                this.i2p_result_list.setText("");
            }
        }

        private void updateState() {
            this.last_used = SystemTime.getMonotonousTime();
            boolean i2p_installed = I2PHelpers.isI2PInstalled();
            this.i2p_install_button.setText(MessageText.getString(i2p_installed ? "devices.installed" : "privacy.view.install.i2p"));
            this.i2p_install_button.setEnabled(!i2p_installed);
            this.i2p_lookup_button.setEnabled(i2p_installed && this.current_hash != null && !this.lookup_active);
            this.i2p_options_link.setEnabled(i2p_installed);
        }
    }
}

