/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.views;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.DataSourceResolver;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.IMainWindow;
import com.biglybt.ui.swt.mdi.BaseMDI;
import com.biglybt.ui.swt.mdi.BaseMdiEntry;
import com.biglybt.ui.swt.shells.PopOutManager;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.views.stats.StatsView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class QuickLinksView {
    private static final String CONFIG_KEY = "quicklinks.config";
    private static SWTSkinObject skinObject;
    private static ToolBar toolBar;
    private static List<QuickLinkItem> qlItems;

    static {
        qlItems = new ArrayList<QuickLinkItem>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(BaseMDI mdi, SWTSkinObject so) {
        skinObject = so;
        Composite parent = (Composite)so.getControl();
        GridLayout layout = new GridLayout();
        layout.marginTop = 1;
        layout.marginBottom = 1;
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        parent.setLayout((Layout)layout);
        toolBar = new ToolBar(parent, 0x800000);
        toolBar.addListener(12, ev -> {
            toolBar = null;
            qlItems.clear();
        });
        GridData gridData = new GridData(1808);
        toolBar.setLayoutData((Object)gridData);
        toolBar.addListener(35, ev -> {
            Menu menu = new Menu((Control)toolBar);
            toolBar.setMenu(menu);
            if (toolBar.getItemCount() > 0) {
                menu.addListener(22, e -> {
                    Point loc = toolBar.toControl(toolBar.getDisplay().getCursorLocation());
                    toolBar.setData("current_qli", (Object)toolBar.getItem(loc));
                });
                Menu popMenu = new Menu((Decorations)menu.getShell(), 4);
                MenuItem popItem = new MenuItem(menu, 64);
                Messages.setLanguageText((Widget)popItem, "label.pop.out");
                popItem.setMenu(popMenu);
                MenuItem itemPopIndependent = new MenuItem(popMenu, 8);
                Messages.setLanguageText((Widget)itemPopIndependent, "menu.independent");
                MenuItem itemPopOnTop = new MenuItem(popMenu, 8);
                Messages.setLanguageText((Widget)itemPopOnTop, "menu.on.top");
                Listener popListener = e -> {
                    ToolItem ti = (ToolItem)toolBar.getData("current_qli");
                    if (ti != null) {
                        MenuItem mi = (MenuItem)e.widget;
                        boolean onTop = mi == itemPopOnTop;
                        QuickLinkItem qli = (QuickLinkItem)ti.getData("qli");
                        if (qli != null) {
                            qli.popOut(mdi, onTop ? PopOutManager.OPT_MAP_ON_TOP : PopOutManager.OPT_MAP_NONE);
                        }
                    }
                };
                itemPopIndependent.addListener(13, popListener);
                itemPopOnTop.addListener(13, popListener);
                MenuItem itemRemove = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)itemRemove, "Button.remove");
                Utils.setMenuItemImage(itemRemove, "delete");
                itemRemove.addListener(13, e -> {
                    ToolItem ti = (ToolItem)toolBar.getData("current_qli");
                    if (ti != null) {
                        QuickLinkItem qli = (QuickLinkItem)ti.getData("qli");
                        if (qli != null) {
                            List<QuickLinkItem> list = qlItems;
                            synchronized (list) {
                                qlItems.remove(qli);
                                QuickLinksView.saveConfig();
                            }
                        }
                        ti.dispose();
                        if (toolBar.getItemCount() == 0) {
                            QuickLinksView.setVisible(false);
                        } else {
                            QuickLinksView.relayout();
                        }
                    }
                });
                new MenuItem(menu, 2);
            }
            MenuItem itemReset = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemReset, "Button.reset");
            itemReset.addListener(13, e -> {
                List<QuickLinkItem> list = qlItems;
                synchronized (list) {
                    qlItems.clear();
                    COConfigurationManager.removeParameter(CONFIG_KEY);
                    ToolItem[] toolItemArray = toolBar.getItems();
                    int n = toolItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ToolItem ti = toolItemArray[n2];
                        ti.dispose();
                        ++n2;
                    }
                    QuickLinksView.addDefaults(mdi);
                }
                QuickLinksView.relayout();
            });
            MenuItem itemHide = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemHide, "Button.bar.hide");
            itemHide.addListener(13, e -> QuickLinksView.setVisible(false));
        });
        toolBar.addListener(8, ev -> {
            QuickLinkItem qli;
            Point loc;
            ToolItem ti;
            if (toolBar.getItemCount() > 0 && (ti = toolBar.getItem(loc = toolBar.toControl(toolBar.getDisplay().getCursorLocation()))) != null && (qli = (QuickLinkItem)ti.getData("qli")) != null) {
                qli.popOut(mdi, PopOutManager.OPT_MAP_ON_TOP);
            }
        });
        List<QuickLinkItem> list = qlItems;
        synchronized (list) {
            Map config = COConfigurationManager.getMapParameter(CONFIG_KEY, null);
            if (config == null) {
                QuickLinksView.addDefaults(mdi);
            } else {
                config = BDecoder.decodeStrings(BEncoder.cloneMap(config));
                try {
                    List items = (List)config.get("items");
                    if (items != null) {
                        for (Map item : items) {
                            QuickLinksView.addItem(mdi, toolBar, item);
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        if (!COConfigurationManager.getBooleanParameter("quick-links.visible", true)) {
            QuickLinksView.setVisible(false);
        }
    }

    private static void addDefaults(BaseMDI mdi) {
        QuickLinksView.addDefaultItem(mdi, toolBar, "Library", "image.sidebar.library", "library.name");
        QuickLinksView.addDefaultItem(mdi, toolBar, StatsView.VIEW_ID, "image.sidebar.stats", "Stats.title.full");
        QuickLinksView.addDefaultItem(mdi, toolBar, "ConfigView", "image.sidebar.cog", "ConfigView.title.full");
    }

    public static void setVisible(boolean visible) {
        UIFunctionsSWT uiFunctions;
        if (visible) {
            COConfigurationManager.setParameter("IconBar.enabled", true);
        }
        if ((uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null) {
            IMainWindow mainWindow = uiFunctions.getMainWindow();
            mainWindow.setVisible(8, visible);
        }
    }

    public static boolean canAddItem(BaseMDI mdi, BaseMdiEntry entry) {
        if (toolBar == null || skinObject == null || skinObject.isDisposed()) {
            return false;
        }
        String id = entry.getViewID();
        return mdi.canShowEntryByID(id);
    }

    public static void addItem(BaseMDI mdi, BaseMdiEntry entry) {
        Utils.execSWTThread(() -> {
            if (toolBar == null || skinObject == null || skinObject.isDisposed()) {
                return;
            }
            String id = entry.getViewID();
            String titleID = entry.getTitleID();
            if (titleID == null || titleID.isEmpty() || titleID.startsWith("!")) {
                titleID = entry.getTitle();
            }
            if (mdi.canShowEntryByID(id)) {
                Map<String, Object> ds_map = null;
                Object ds = entry.getDataSource();
                if (ds != null && ds != DataSourceResolver.DEFAULT_DATASOURCE) {
                    ds_map = DataSourceResolver.exportDataSource(ds);
                }
                QuickLinkItem qli = new QuickLinkItem(entry.getViewID(), entry.getImageLeftID(), titleID, ds_map);
                List<QuickLinkItem> list = qlItems;
                synchronized (list) {
                    qlItems.add(qli);
                    QuickLinksView.saveConfig();
                }
                QuickLinksView.addItem(mdi, toolBar, qli);
                QuickLinksView.setVisible(true);
                QuickLinksView.relayout();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDefaultItem(BaseMDI mdi, ToolBar toolBar, String mdi_id, String image_id, String tt_id) {
        QuickLinkItem qli = new QuickLinkItem(mdi_id, image_id, tt_id, null);
        List<QuickLinkItem> list = qlItems;
        synchronized (list) {
            qlItems.add(qli);
        }
        QuickLinksView.addItem(mdi, toolBar, qli);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addItem(BaseMDI mdi, ToolBar toolBar, Map<String, Object> map) {
        QuickLinkItem qli = new QuickLinkItem(map);
        if (qli != null) {
            List<QuickLinkItem> list = qlItems;
            synchronized (list) {
                qlItems.add(qli);
            }
            QuickLinksView.addItem(mdi, toolBar, qli);
        }
    }

    private static void addItem(BaseMDI mdi, ToolBar toolBar, QuickLinkItem qli) {
        String tt_id = qli.tt_id;
        ToolItem item = new ToolItem(toolBar, 8);
        if (MessageText.keyExists(tt_id)) {
            Messages.setLanguageTooltip((Widget)item, tt_id);
        } else {
            Utils.setTT(item, tt_id);
        }
        ImageLoader imageLoader = ImageLoader.getInstance();
        Image image = imageLoader.getImage(qli.image_id);
        Image resized = imageLoader.resizeImageIfLarger(image, new Point(15, 15));
        if (resized == null) {
            item.setImage(image);
        } else {
            Rectangle resized_bounds = resized.getBounds();
            Device device = resized.getDevice();
            Image base = Utils.createAlphaImage(device, 15, 15, (byte)0);
            Image centred = Utils.blitImage(device, resized, resized_bounds, base, new Point(0, (15 - resized_bounds.height) / 2));
            base.dispose();
            resized.dispose();
            item.setImage(centred);
            item.addListener(12, ev -> centred.dispose());
        }
        item.addListener(13, ev -> qli.show(mdi));
        item.setData("qli", (Object)qli);
    }

    private static void relayout() {
        skinObject.relayout();
        Utils.relayoutUp((Composite)toolBar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveConfig() {
        List<QuickLinkItem> list = qlItems;
        synchronized (list) {
            HashMap config = new HashMap();
            ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
            config.put("items", items);
            for (QuickLinkItem item : qlItems) {
                items.add(item.export());
            }
            COConfigurationManager.setParameter(CONFIG_KEY, config);
            COConfigurationManager.save();
        }
    }

    private static class QuickLinkItem {
        final String mdi_id;
        final String image_id;
        final String tt_id;
        final Map<String, Object> ds_map;
        long last_show = -1L;
        long last_pop = -1L;

        QuickLinkItem(String _mdi_id, String _image_id, String _tt_id, Map<String, Object> _ds_map) {
            this.mdi_id = _mdi_id;
            this.image_id = _image_id;
            this.tt_id = _tt_id;
            this.ds_map = _ds_map;
        }

        QuickLinkItem(Map<String, Object> map) {
            this.mdi_id = (String)map.get("mdi");
            this.image_id = (String)map.get("image");
            this.tt_id = (String)map.get("tt");
            this.ds_map = (Map)map.get("ds");
        }

        Map<String, Object> export() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("mdi", this.mdi_id);
            map.put("image", this.image_id);
            map.put("tt", this.tt_id);
            if (this.ds_map != null) {
                map.put("ds", this.ds_map);
            }
            return map;
        }

        void show(BaseMDI mdi) {
            long now = SystemTime.getMonotonousTime();
            if (this.last_pop >= 0L && now - this.last_pop < 2500L) {
                return;
            }
            this.last_show = now;
            Utils.execSWTThreadLater(500, () -> {
                long nownow = SystemTime.getMonotonousTime();
                if (this.last_pop > 0L && nownow - this.last_pop < 2500L) {
                    return;
                }
                this.last_show = nownow;
                if (this.ds_map == null) {
                    mdi.showEntryByID(this.mdi_id, null);
                } else {
                    Object ds = DataSourceResolver.importDataSource(this.ds_map);
                    mdi.showEntryByID(this.mdi_id, ds);
                }
            });
        }

        void popOut(BaseMDI mdi, Map<String, Object> options) {
            long now = SystemTime.getMonotonousTime();
            if (this.last_pop >= 0L && now - this.last_pop < 500L) {
                return;
            }
            this.last_pop = now;
            if (this.ds_map == null) {
                mdi.popoutEntryByID(this.mdi_id, null, options);
            } else {
                Object ds = DataSourceResolver.importDataSource(this.ds_map);
                mdi.popoutEntryByID(this.mdi_id, ds, options);
            }
        }
    }
}

